/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.GenericCloseListener;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http2.Constants;
import org.glassfish.grizzly.http2.DraftVersion;
import org.glassfish.grizzly.http2.EncoderUtils;
import org.glassfish.grizzly.http2.Http2BaseFilter;
import org.glassfish.grizzly.http2.Http2ConnectionException;
import org.glassfish.grizzly.http2.Http2ConnectionOutputSink;
import org.glassfish.grizzly.http2.Http2Request;
import org.glassfish.grizzly.http2.Http2State;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.Http2StreamState;
import org.glassfish.grizzly.http2.compression.HeadersDecoder;
import org.glassfish.grizzly.http2.compression.HeadersEncoder;
import org.glassfish.grizzly.http2.frames.ContinuationFrame;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.frames.GoAwayFrame;
import org.glassfish.grizzly.http2.frames.HeaderBlockFragment;
import org.glassfish.grizzly.http2.frames.HeadersFrame;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.frames.PushPromiseFrame;
import org.glassfish.grizzly.http2.frames.RstStreamFrame;
import org.glassfish.grizzly.http2.frames.SettingsFrame;
import org.glassfish.grizzly.http2.frames.WindowUpdateFrame;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.Holder;
import org.glassfish.grizzly.utils.NullaryFunction;

public abstract class Http2Connection {
    private static final Logger LOGGER = Grizzly.logger(Http2Connection.class);
    private static final Level LOGGER_LEVEL = Level.INFO;
    private final boolean isServer;
    private final Connection<?> connection;
    Http2State http2State;
    private HeadersDecoder headersDecoder;
    private HeadersEncoder headersEncoder;
    private final ReentrantLock deflaterLock = new ReentrantLock();
    private int lastPeerStreamId;
    private int lastLocalStreamId;
    private final ReentrantLock newClientStreamLock = new ReentrantLock();
    private volatile FilterChain http2StreamChain;
    private volatile FilterChain http2ConnectionChain;
    private final Map<Integer, Http2Stream> streamsMap = DataStructures.getConcurrentMap();
    final List<Http2Stream> streamsToFlushInput = new ArrayList<Http2Stream>();
    protected final List<Http2Frame> tmpHeaderFramesList = new ArrayList<Http2Frame>(2);
    private final Object sessionLock = new Object();
    private CloseType closeFlag;
    private int peerStreamWindowSize = this.getDefaultStreamWindowSize();
    private volatile int localStreamWindowSize = this.getDefaultStreamWindowSize();
    private volatile int localConnectionWindowSize = this.getDefaultConnectionWindowSize();
    private volatile int localMaxConcurrentStreams = this.getDefaultMaxConcurrentStreams();
    private int peerMaxConcurrentStreams = this.getDefaultMaxConcurrentStreams();
    private final StreamBuilder streamBuilder = new StreamBuilder();
    private final Http2ConnectionOutputSink outputSink;
    private volatile boolean isPrefaceReceived;
    private volatile boolean isPrefaceSent;
    private final Holder<?> addressHolder;
    final Http2BaseFilter handlerFilter;
    private final int localMaxFramePayloadSize;
    private int peerMaxFramePayloadSize = this.getSpecDefaultFramePayloadSize();
    private boolean isFirstInFrame = true;
    private final AtomicInteger unackedReadBytes = new AtomicInteger();

    public static Http2Connection get(Connection connection) {
        Http2State http2State = Http2State.get(connection);
        return http2State != null ? http2State.getHttp2Connection() : null;
    }

    static void bind(Connection connection, Http2Connection http2Connection) {
        Http2State.obtain(connection).setHttp2Connection(http2Connection);
    }

    public Http2Connection(final Connection<?> connection, boolean isServer, Http2BaseFilter handlerFilter) {
        this.connection = connection;
        this.isServer = isServer;
        this.handlerFilter = handlerFilter;
        int customMaxFramePayloadSz = handlerFilter.getLocalMaxFramePayloadSize() > 0 ? handlerFilter.getLocalMaxFramePayloadSize() : -1;
        int n = this.localMaxFramePayloadSize = customMaxFramePayloadSz >= this.getSpecMinFramePayloadSize() && customMaxFramePayloadSz <= this.getSpecMaxFramePayloadSize() ? customMaxFramePayloadSz : this.getSpecDefaultFramePayloadSize();
        if (isServer) {
            this.lastLocalStreamId = 0;
            this.lastPeerStreamId = -1;
        } else {
            this.lastLocalStreamId = -1;
            this.lastPeerStreamId = 0;
        }
        this.addressHolder = Holder.lazyHolder(new NullaryFunction<Object>(){

            @Override
            public Object evaluate() {
                return connection.getPeerAddress();
            }
        });
        connection.addCloseListener(new ConnectionCloseListener());
        this.outputSink = this.newOutputSink();
    }

    public abstract DraftVersion getVersion();

    protected abstract Http2ConnectionOutputSink newOutputSink();

    protected abstract int getSpecDefaultFramePayloadSize();

    protected abstract int getSpecMinFramePayloadSize();

    protected abstract int getSpecMaxFramePayloadSize();

    public abstract int getFrameHeaderSize();

    public abstract void serializeHttp2FrameHeader(Http2Frame var1, Buffer var2);

    public abstract Http2Frame parseHttp2FrameHeader(Buffer var1) throws Http2ConnectionException;

    public abstract int getDefaultConnectionWindowSize();

    public abstract int getDefaultStreamWindowSize();

    public abstract int getDefaultMaxConcurrentStreams();

    protected abstract boolean isFrameReady(Buffer var1);

    protected abstract int getFrameSize(Buffer var1);

    protected Http2Stream newStream(HttpRequestPacket request, int streamId, int refStreamId, int priority, Http2StreamState initialState) {
        return new Http2Stream(this, request, streamId, refStreamId, priority, initialState);
    }

    protected Http2Stream newUpgradeStream(HttpRequestPacket request, int priority, Http2StreamState initialState) {
        return new Http2Stream(this, request, priority, initialState);
    }

    protected void checkFrameSequenceSemantics(Http2Frame frame) throws Http2ConnectionException {
        int frameType = frame.getType();
        if (this.isFirstInFrame) {
            if (frameType != 4) {
                if (LOGGER.isLoggable(LOGGER_LEVEL)) {
                    LOGGER.log(LOGGER_LEVEL, "First in frame should be a SettingsFrame (preface)", frame);
                }
                throw new Http2ConnectionException(ErrorCode.PROTOCOL_ERROR);
            }
            this.isPrefaceReceived = true;
            this.handlerFilter.onPrefaceReceived(this);
            Http2State.get(this.connection).setOpen();
            this.isFirstInFrame = false;
        }
        if (this.isParsingHeaders()) {
            if (frameType != 9) {
                if (LOGGER.isLoggable(LOGGER_LEVEL)) {
                    LOGGER.log(LOGGER_LEVEL, "ContinuationFrame is expected, but {0} came", frame);
                }
                throw new Http2ConnectionException(ErrorCode.PROTOCOL_ERROR);
            }
        } else if (frameType == 9) {
            if (LOGGER.isLoggable(LOGGER_LEVEL)) {
                LOGGER.log(LOGGER_LEVEL, "ContinuationFrame is not expected");
            }
            throw new Http2ConnectionException(ErrorCode.PROTOCOL_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onOversizedFrame(Buffer buffer) throws Http2ConnectionException {
        block6: {
            int oldPos = buffer.position();
            try {
                Http2Frame oversizedFrame = this.parseHttp2FrameHeader(buffer);
                int streamId = oversizedFrame.getStreamId();
                if (streamId > 0) {
                    Http2Stream stream = this.getStream(streamId);
                    if (stream != null) {
                        stream.inputBuffer.close(Constants.FRAME_TOO_LARGE_TERMINATION);
                        this.sendRstFrame(ErrorCode.FRAME_SIZE_ERROR, streamId);
                    } else {
                        this.sendRstFrame(ErrorCode.STREAM_CLOSED, streamId);
                    }
                    break block6;
                }
                throw new Http2ConnectionException(ErrorCode.FRAME_SIZE_ERROR);
            }
            finally {
                buffer.position(oldPos);
            }
        }
    }

    boolean isParsingHeaders() {
        return this.headersDecoder != null && this.headersDecoder.isProcessingHeaders();
    }

    public final int getLocalMaxFramePayloadSize() {
        return this.localMaxFramePayloadSize;
    }

    public int getPeerMaxFramePayloadSize() {
        return this.peerMaxFramePayloadSize;
    }

    protected void setPeerMaxFramePayloadSize(int peerMaxFramePayloadSize) throws Http2ConnectionException {
        if (peerMaxFramePayloadSize < this.getSpecMinFramePayloadSize() || peerMaxFramePayloadSize > this.getSpecMaxFramePayloadSize()) {
            throw new Http2ConnectionException(ErrorCode.FRAME_SIZE_ERROR);
        }
        this.peerMaxFramePayloadSize = peerMaxFramePayloadSize;
    }

    boolean canWrite() {
        return this.outputSink.canWrite();
    }

    void notifyCanWrite(WriteHandler writeHandler) {
        this.outputSink.notifyCanWrite(writeHandler);
    }

    public int getLocalStreamWindowSize() {
        return this.localStreamWindowSize;
    }

    public void setLocalStreamWindowSize(int localStreamWindowSize) {
        this.localStreamWindowSize = localStreamWindowSize;
    }

    public int getPeerStreamWindowSize() {
        return this.peerStreamWindowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPeerStreamWindowSize(int peerStreamWindowSize) {
        Object object = this.sessionLock;
        synchronized (object) {
            int delta = peerStreamWindowSize - this.peerStreamWindowSize;
            this.peerStreamWindowSize = peerStreamWindowSize;
            for (Http2Stream stream : this.streamsMap.values()) {
                try {
                    stream.getOutputSink().onPeerWindowUpdate(delta);
                }
                catch (Http2StreamException e) {
                    if (LOGGER.isLoggable(LOGGER_LEVEL)) {
                        LOGGER.log(LOGGER_LEVEL, "SpdyStreamException occurred on stream=" + stream + " during stream window update", e);
                    }
                    this.sendRstFrame(e.getErrorCode(), e.getStreamId());
                }
            }
        }
    }

    public int getLocalConnectionWindowSize() {
        return this.localConnectionWindowSize;
    }

    public void setLocalConnectionWindowSize(int localConnectionWindowSize) {
        this.localConnectionWindowSize = localConnectionWindowSize;
    }

    public int getAvailablePeerConnectionWindowSize() {
        return this.outputSink.getAvailablePeerConnectionWindowSize();
    }

    public int getLocalMaxConcurrentStreams() {
        return this.localMaxConcurrentStreams;
    }

    public void setLocalMaxConcurrentStreams(int localMaxConcurrentStreams) {
        this.localMaxConcurrentStreams = localMaxConcurrentStreams;
    }

    public int getPeerMaxConcurrentStreams() {
        return this.peerMaxConcurrentStreams;
    }

    void setPeerMaxConcurrentStreams(int peerMaxConcurrentStreams) {
        this.peerMaxConcurrentStreams = peerMaxConcurrentStreams;
    }

    public int getNextLocalStreamId() {
        this.lastLocalStreamId += 2;
        return this.lastLocalStreamId;
    }

    public StreamBuilder getStreamBuilder() {
        return this.streamBuilder;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public MemoryManager getMemoryManager() {
        return this.connection.getMemoryManager();
    }

    public boolean isServer() {
        return this.isServer;
    }

    public boolean isLocallyInitiatedStream(int streamId) {
        assert (streamId > 0);
        return this.isServer() ^ streamId % 2 != 0;
    }

    Http2State getHttp2State() {
        return this.http2State;
    }

    boolean isHttp2InputEnabled() {
        return this.isPrefaceReceived;
    }

    boolean isHttp2OutputEnabled() {
        return this.isPrefaceSent;
    }

    public Http2Stream getStream(int streamId) {
        return this.streamsMap.get(streamId);
    }

    protected Http2ConnectionOutputSink getOutputSink() {
        return this.outputSink;
    }

    public void goAway(ErrorCode errorCode) {
        GoAwayFrame goAwayFrame = this.setGoAwayLocally(errorCode);
        if (goAwayFrame != null) {
            this.outputSink.writeDownStream(goAwayFrame);
        }
    }

    GoAwayFrame setGoAwayLocally(ErrorCode errorCode) {
        int lastPeerStreamIdLocal = this.close();
        if (lastPeerStreamIdLocal == -1) {
            return null;
        }
        return GoAwayFrame.builder().lastStreamId(lastPeerStreamIdLocal).errorCode(errorCode).build();
    }

    protected void sendWindowUpdate(int streamId, int delta) {
        this.outputSink.writeDownStream(((WindowUpdateFrame.WindowUpdateFrameBuilder)WindowUpdateFrame.builder().streamId(streamId)).windowSizeIncrement(delta).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendPreface() {
        if (!this.isPrefaceSent) {
            Object object = this.sessionLock;
            synchronized (object) {
                if (!this.isPrefaceSent) {
                    if (this.isServer) {
                        this.sendServerPreface();
                    } else {
                        this.sendClientPreface();
                    }
                    this.isPrefaceSent = true;
                    if (!this.isServer) {
                        this.ackConsumedData(this.getStream(0), 0);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected void sendServerPreface() {
        SettingsFrame settingsFrame = this.prepareSettings().build();
        if (LOGGER.isLoggable(LOGGER_LEVEL)) {
            LOGGER.log(LOGGER_LEVEL, "Tx: server preface (the settings frame).Connection={0}, settingsFrame={1}", new Object[]{this.connection, settingsFrame});
        }
        this.connection.write(settingsFrame.toBuffer(this));
    }

    protected void sendClientPreface() {
        HttpRequestPacket request = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().method(Method.PRI).uri("*").protocol(Protocol.HTTP_2_0)).build();
        Buffer priPayload = Buffers.wrap(this.connection.getMemoryManager(), Http2BaseFilter.PRI_PAYLOAD);
        SettingsFrame settingsFrame = this.prepareSettings().build();
        Buffer settingsBuffer = settingsFrame.toBuffer(this);
        Buffer payload = Buffers.appendBuffers(this.connection.getMemoryManager(), priPayload, settingsBuffer);
        HttpContent content = ((HttpContent.Builder)HttpContent.builder(request).content(payload)).build();
        if (LOGGER.isLoggable(LOGGER_LEVEL)) {
            LOGGER.log(LOGGER_LEVEL, "Tx: client preface including the settings frame. Connection={0}, settingsFrame={1}", new Object[]{this.connection, settingsFrame});
        }
        this.connection.write(content);
    }

    protected void sendRstFrame(ErrorCode errorCode, int streamId) {
        this.outputSink.writeDownStream(((RstStreamFrame.RstStreamFrameBuilder)RstStreamFrame.builder().errorCode(errorCode).streamId(streamId)).build());
    }

    HeadersDecoder getHeadersDecoder() {
        if (this.headersDecoder == null) {
            this.headersDecoder = new HeadersDecoder(this.getMemoryManager(), 4096, 4096);
        }
        return this.headersDecoder;
    }

    ReentrantLock getDeflaterLock() {
        return this.deflaterLock;
    }

    HeadersEncoder getHeadersEncoder() {
        if (this.headersEncoder == null) {
            this.headersEncoder = new HeadersEncoder(this.getMemoryManager(), 4096);
        }
        return this.headersEncoder;
    }

    protected List<Http2Frame> encodeHttpHeaderAsHeaderFrames(FilterChainContext ctx, HttpHeader httpHeader, int streamId, boolean isLast, List<Http2Frame> toList) throws IOException {
        Buffer compressedHeaders = !httpHeader.isRequest() ? EncoderUtils.encodeResponseHeaders(this, (HttpResponsePacket)httpHeader) : EncoderUtils.encodeRequestHeaders(this, (HttpRequestPacket)httpHeader);
        List<Http2Frame> headerFrames = this.bufferToHeaderFrames(streamId, compressedHeaders, isLast, toList);
        this.handlerFilter.onHttpHeadersEncoded(httpHeader, ctx);
        return headerFrames;
    }

    protected List<Http2Frame> encodeHttpRequestAsPushPromiseFrames(FilterChainContext ctx, HttpRequestPacket httpRequest, int streamId, int promisedStreamId, List<Http2Frame> toList) throws IOException {
        List<Http2Frame> headerFrames = this.bufferToPushPromiseFrames(streamId, promisedStreamId, EncoderUtils.encodeRequestHeaders(this, httpRequest), toList);
        this.handlerFilter.onHttpHeadersEncoded(httpRequest, ctx);
        return headerFrames;
    }

    private List<Http2Frame> bufferToHeaderFrames(int streamId, Buffer compressedHeaders, boolean isEos, List<Http2Frame> toList) {
        HeadersFrame.HeadersFrameBuilder builder = ((HeadersFrame.HeadersFrameBuilder)HeadersFrame.builder().streamId(streamId)).endStream(isEos);
        return this.completeHeadersProviderFrameSerialization(builder, streamId, compressedHeaders, toList);
    }

    private List<Http2Frame> bufferToPushPromiseFrames(int streamId, int promisedStreamId, Buffer compressedHeaders, List<Http2Frame> toList) {
        PushPromiseFrame.PushPromiseFrameBuilder builder = ((PushPromiseFrame.PushPromiseFrameBuilder)PushPromiseFrame.builder().streamId(streamId)).promisedStreamId(promisedStreamId);
        return this.completeHeadersProviderFrameSerialization(builder, streamId, compressedHeaders, toList);
    }

    private List<Http2Frame> completeHeadersProviderFrameSerialization(HeaderBlockFragment.HeaderBlockFragmentBuilder builder, int streamId, Buffer compressedHeaders, List<Http2Frame> toList) {
        assert (this.deflaterLock.isHeldByCurrentThread());
        if (toList == null) {
            toList = this.tmpHeaderFramesList;
        }
        if (compressedHeaders.remaining() <= this.peerMaxFramePayloadSize) {
            toList.add(((Http2Frame.Http2FrameBuilder)((HeaderBlockFragment.HeaderBlockFragmentBuilder)builder.endHeaders(true)).compressedHeaders(compressedHeaders)).build());
            return toList;
        }
        Buffer remainder = compressedHeaders.split(compressedHeaders.position() + this.peerMaxFramePayloadSize);
        toList.add(((Http2Frame.Http2FrameBuilder)((HeaderBlockFragment.HeaderBlockFragmentBuilder)builder.endHeaders(false)).compressedHeaders(compressedHeaders)).build());
        assert (remainder != null);
        do {
            Buffer buffer;
            remainder = (buffer = remainder).remaining() <= this.peerMaxFramePayloadSize ? null : buffer.split(buffer.position() + this.peerMaxFramePayloadSize);
            toList.add(((ContinuationFrame.ContinuationFrameBuilder)((ContinuationFrame.ContinuationFrameBuilder)((ContinuationFrame.ContinuationFrameBuilder)ContinuationFrame.builder().streamId(streamId)).endHeaders(remainder == null)).compressedHeaders(buffer)).build());
        } while (remainder != null);
        return toList;
    }

    public ReentrantLock getNewClientStreamLock() {
        return this.newClientStreamLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Http2Stream acceptStream(HttpRequestPacket request, int streamId, int refStreamId, int priority, Http2StreamState initState) throws Http2ConnectionException {
        Http2Stream stream = this.newStream(request, streamId, refStreamId, priority, initState);
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.isClosed()) {
                return null;
            }
            if (this.streamsMap.size() >= this.getLocalMaxConcurrentStreams()) {
                throw new Http2ConnectionException(ErrorCode.REFUSED_STREAM);
            }
            this.streamsMap.put(streamId, stream);
            this.lastPeerStreamId = streamId;
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Http2Stream openStream(HttpRequestPacket request, int streamId, int refStreamId, int priority, Http2StreamState initState) throws Http2StreamException {
        Http2Stream stream = this.newStream(request, streamId, refStreamId, priority, initState);
        Object object = this.sessionLock;
        synchronized (object) {
            Http2Stream mainStream;
            if (this.isClosed()) {
                throw new Http2StreamException(streamId, ErrorCode.REFUSED_STREAM, "Session is closed");
            }
            if (this.streamsMap.size() >= this.getLocalMaxConcurrentStreams()) {
                throw new Http2StreamException(streamId, ErrorCode.REFUSED_STREAM);
            }
            if (refStreamId > 0 && (mainStream = this.getStream(refStreamId)) == null) {
                throw new Http2StreamException(streamId, ErrorCode.REFUSED_STREAM, "The parent stream does not exist");
            }
            this.streamsMap.put(streamId, stream);
            this.lastLocalStreamId = streamId;
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Http2Stream acceptUpgradeStream(HttpRequestPacket request, int priority, boolean fin) throws Http2StreamException {
        request.setExpectContent(!fin);
        Http2Stream stream = this.newUpgradeStream(request, priority, Http2StreamState.IDLE);
        stream.onRcvHeaders(fin);
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new Http2StreamException(1, ErrorCode.REFUSED_STREAM, "Session is closed");
            }
            this.streamsMap.put(1, stream);
            this.lastLocalStreamId = 1;
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Http2Stream openUpgradeStream(HttpRequestPacket request, int priority) throws Http2StreamException {
        Http2Stream stream = this.newUpgradeStream(request, priority, Http2StreamState.OPEN);
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new Http2StreamException(1, ErrorCode.REFUSED_STREAM, "Session is closed");
            }
            this.streamsMap.put(1, stream);
            this.lastLocalStreamId = 1;
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setupFilterChains(FilterChainContext context, boolean isUpStream) {
        if (this.http2ConnectionChain == null) {
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.http2ConnectionChain == null) {
                    if (isUpStream) {
                        this.http2StreamChain = (FilterChain)context.getFilterChain().subList(context.getFilterIdx(), context.getEndIdx());
                        this.http2ConnectionChain = (FilterChain)context.getFilterChain().subList(context.getStartIdx(), context.getFilterIdx());
                    } else {
                        this.http2StreamChain = (FilterChain)context.getFilterChain().subList(context.getFilterIdx(), context.getFilterChain().size());
                        this.http2ConnectionChain = (FilterChain)context.getFilterChain().subList(context.getEndIdx() + 1, context.getFilterIdx());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    FilterChain getHttp2StreamChain() {
        return this.http2StreamChain;
    }

    FilterChain getHttp2ConnectionChain() {
        return this.http2ConnectionChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int close() {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.isClosed()) {
                return -1;
            }
            this.closeFlag = CloseType.LOCALLY;
            return this.lastPeerStreamId > 0 ? this.lastPeerStreamId : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setGoAwayByPeer(int lastGoodStreamId) {
        Object object = this.sessionLock;
        synchronized (object) {
            this.closeFlag = CloseType.REMOTELY;
        }
    }

    Object getSessionLock() {
        return this.sessionLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterStream(Http2Stream spdyStream) {
        boolean isCloseSession;
        this.streamsMap.remove(spdyStream.getId());
        Object object = this.sessionLock;
        synchronized (object) {
            isCloseSession = this.isClosed() && this.streamsMap.isEmpty();
        }
        if (isCloseSession) {
            this.closeSession();
        }
    }

    private void closeSession() {
        this.connection.closeSilently();
        this.outputSink.close();
    }

    private boolean isClosed() {
        return this.closeFlag != null;
    }

    void sendMessageUpstreamWithParseNotify(Http2Stream stream, HttpContent httpContent) {
        FilterChainContext upstreamContext = this.http2StreamChain.obtainFilterChainContext(this.connection, stream);
        HttpContext httpContext = httpContent.getHttpHeader().getProcessingState().getHttpContext();
        httpContext.attach(upstreamContext);
        this.handlerFilter.onHttpContentParsed(httpContent, upstreamContext);
        HttpHeader header = httpContent.getHttpHeader();
        if (httpContent.isLast()) {
            this.handlerFilter.onHttpPacketParsed(header, upstreamContext);
        }
        if (header.isSkipRemainder()) {
            return;
        }
        this.sendMessageUpstream(stream, httpContent, upstreamContext);
    }

    void sendMessageUpstream(Http2Stream stream, HttpPacket message) {
        FilterChainContext upstreamContext = this.http2StreamChain.obtainFilterChainContext(this.connection, stream);
        HttpContext httpContext = message.getHttpHeader().getProcessingState().getHttpContext();
        httpContext.attach(upstreamContext);
        this.sendMessageUpstream(stream, message, upstreamContext);
    }

    private void sendMessageUpstream(final Http2Stream stream, HttpPacket message, FilterChainContext upstreamContext) {
        upstreamContext.getInternalContext().setIoEvent(IOEvent.READ);
        upstreamContext.getInternalContext().addLifeCycleListener(new IOEventLifeCycleListener.Adapter(){

            @Override
            public void onReregister(Context context) throws IOException {
                stream.inputBuffer.onReadEventComplete();
            }

            @Override
            public void onComplete(Context context, Object data) throws IOException {
                stream.inputBuffer.onReadEventComplete();
            }
        });
        upstreamContext.setMessage(message);
        upstreamContext.setAddressHolder(this.addressHolder);
        ProcessorExecutor.execute(upstreamContext.getInternalContext());
    }

    protected SettingsFrame.SettingsFrameBuilder prepareSettings() {
        return this.prepareSettings(null);
    }

    protected SettingsFrame.SettingsFrameBuilder prepareSettings(SettingsFrame.SettingsFrameBuilder builder) {
        if (builder == null) {
            builder = SettingsFrame.builder();
        }
        if (this.getLocalMaxConcurrentStreams() != this.getDefaultMaxConcurrentStreams()) {
            builder.setting(3, this.getLocalMaxConcurrentStreams());
        }
        if (this.getLocalStreamWindowSize() != this.getDefaultStreamWindowSize()) {
            builder.setting(4, this.getLocalStreamWindowSize());
        }
        return builder;
    }

    void ackConsumedData(int sz) {
        this.ackConsumedData(null, sz);
    }

    void ackConsumedData(Http2Stream stream, int sz) {
        int currentUnackedBytes = this.unackedReadBytes.addAndGet(sz);
        if (this.isPrefaceSent) {
            int windowSize = this.getLocalConnectionWindowSize();
            if (currentUnackedBytes > windowSize / 3 && this.unackedReadBytes.compareAndSet(currentUnackedBytes, 0)) {
                this.sendWindowUpdate(0, currentUnackedBytes);
            }
            if (stream != null) {
                int streamUnackedBytes = Http2Stream.unackedReadBytesUpdater.addAndGet(stream, sz);
                int streamWindowSize = stream.getLocalWindowSize();
                if (streamUnackedBytes > 0 && streamUnackedBytes > streamWindowSize / 2 && Http2Stream.unackedReadBytesUpdater.compareAndSet(stream, streamUnackedBytes, 0)) {
                    this.sendWindowUpdate(stream.getId(), streamUnackedBytes);
                }
            }
        }
    }

    private final class ConnectionCloseListener
    implements GenericCloseListener {
        private ConnectionCloseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClosed(Closeable closeable, CloseType type2) throws IOException {
            boolean isClosing;
            Object object = Http2Connection.this.sessionLock;
            synchronized (object) {
                boolean bl = isClosing = !Http2Connection.this.isClosed();
                if (isClosing) {
                    Http2Connection.this.closeFlag = type2;
                }
            }
            if (isClosing) {
                for (Http2Stream stream : Http2Connection.this.streamsMap.values()) {
                    stream.closedRemotely();
                }
            }
        }
    }

    public final class RegularStreamBuilder
    extends HttpHeader.Builder<RegularStreamBuilder> {
        private int priority;
        private boolean isFin;
        private Method method;
        private String methodString;
        private String uri;
        private String query;
        private String host;

        public RegularStreamBuilder method(Method method) {
            this.method = method;
            this.methodString = null;
            return this;
        }

        public RegularStreamBuilder method(String methodString) {
            this.methodString = methodString;
            this.method = null;
            return this;
        }

        public RegularStreamBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public RegularStreamBuilder query(String query) {
            this.query = query;
            return this;
        }

        public RegularStreamBuilder host(String host) {
            this.host = host;
            return this;
        }

        public RegularStreamBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public RegularStreamBuilder fin(boolean fin) {
            this.isFin = fin;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Http2Stream open() throws Http2StreamException {
            HttpRequestPacket request = this.build();
            Http2Connection.this.newClientStreamLock.lock();
            try {
                Http2Stream stream = Http2Connection.this.openStream(request, Http2Connection.this.getNextLocalStreamId(), 0, this.priority, Http2StreamState.IDLE);
                Http2Connection.this.connection.write(request);
                Http2Stream http2Stream = stream;
                return http2Stream;
            }
            finally {
                Http2Connection.this.newClientStreamLock.unlock();
            }
        }

        @Override
        public HttpRequestPacket build() {
            Http2Request request = (Http2Request)super.build();
            if (this.method != null) {
                request.setMethod(this.method);
            }
            if (this.methodString != null) {
                request.setMethod(this.methodString);
            }
            if (this.uri != null) {
                request.setRequestURI(this.uri);
            }
            if (this.query != null) {
                request.setQueryString(this.query);
            }
            if (this.host != null) {
                request.addHeader(Header.Host, this.host);
            }
            request.setExpectContent(!this.isFin);
            return request;
        }

        @Override
        protected HttpHeader create() {
            Http2Request request = Http2Request.create();
            request.setSecure(true);
            return request;
        }
    }

    public final class PushStreamBuilder
    extends HttpHeader.Builder<PushStreamBuilder> {
        private int associatedToStreamId;
        private int priority;
        private boolean isFin;
        private String uri;
        private String query;

        public PushStreamBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public PushStreamBuilder query(String query) {
            this.query = query;
            return this;
        }

        public PushStreamBuilder associatedToStreamId(int associatedToStreamId) {
            this.associatedToStreamId = associatedToStreamId;
            return this;
        }

        public PushStreamBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public PushStreamBuilder fin(boolean fin) {
            this.isFin = fin;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Http2Stream open() throws Http2StreamException {
            HttpRequestPacket request = this.build();
            Http2Connection.this.newClientStreamLock.lock();
            try {
                Http2Stream stream = Http2Connection.this.openStream(request, Http2Connection.this.getNextLocalStreamId(), this.associatedToStreamId, this.priority, Http2StreamState.IDLE);
                Http2Connection.this.connection.write(request.getResponse());
                Http2Stream http2Stream = stream;
                return http2Stream;
            }
            finally {
                Http2Connection.this.newClientStreamLock.unlock();
            }
        }

        @Override
        public HttpRequestPacket build() {
            Http2Request request = (Http2Request)super.build();
            if (this.uri != null) {
                request.setRequestURI(this.uri);
            }
            if (this.query != null) {
                request.setQueryString(this.query);
            }
            request.setExpectContent(!this.isFin);
            return request;
        }

        @Override
        protected HttpHeader create() {
            Http2Request request = Http2Request.create();
            HttpResponsePacket packet = request.getResponse();
            packet.setSecure(true);
            return request;
        }
    }

    public final class StreamBuilder {
        private StreamBuilder() {
        }

        public RegularStreamBuilder regular() {
            return new RegularStreamBuilder();
        }

        public PushStreamBuilder push() {
            return new PushStreamBuilder();
        }
    }
}

