/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2FrameCodec;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.frames.DataFrame;
import org.glassfish.grizzly.http2.frames.Http2Frame;

public abstract class Http2ConnectionOutputSink {
    protected final Http2Connection http2Connection;

    public Http2ConnectionOutputSink(Http2Connection session) {
        this.http2Connection = session;
    }

    public void close() {
    }

    protected Http2FrameCodec frameCodec() {
        return this.http2Connection.handlerFilter.frameCodec;
    }

    protected void writeDownStream(Http2Frame frame) {
        this.writeDownStream(frame, null);
    }

    protected void writeDownStream(Http2Frame frame, CompletionHandler<WriteResult> completionHandler) {
        this.http2Connection.getHttp2ConnectionChain().write(this.http2Connection.getConnection(), null, (Object)this.frameCodec().serializeAndRecycle(this.http2Connection, frame), completionHandler, (MessageCloner)null);
    }

    protected void writeDownStream(List<Http2Frame> frames) {
        this.writeDownStream(frames, null);
    }

    protected void writeDownStream(List<Http2Frame> frames, CompletionHandler<WriteResult> completionHandler) {
        this.http2Connection.getHttp2ConnectionChain().write(this.http2Connection.getConnection(), null, (Object)this.frameCodec().serializeAndRecycle(this.http2Connection, frames), completionHandler, (MessageCloner)null);
    }

    protected <K> void writeDownStream(K anyMessage, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner) {
        Object msg = anyMessage instanceof List ? this.frameCodec().serializeAndRecycle(this.http2Connection, (List)anyMessage) : (anyMessage instanceof Http2Frame ? this.frameCodec().serializeAndRecycle(this.http2Connection, (Http2Frame)anyMessage) : anyMessage);
        this.http2Connection.getHttp2ConnectionChain().write(this.http2Connection.getConnection(), null, msg, completionHandler, messageCloner);
    }

    protected void writeDataDownStream(Http2Stream stream, List<Http2Frame> headerFrames, Buffer data, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner, boolean isLast) {
        Object msg;
        if (data == null) {
            this.writeDownStream(headerFrames, completionHandler, messageCloner);
            return;
        }
        DataFrame dataFrame = ((DataFrame.DataFrameBuilder)DataFrame.builder().streamId(stream.getId())).data(data).endStream(isLast).build();
        if (headerFrames != null && !headerFrames.isEmpty()) {
            headerFrames.add(dataFrame);
            msg = headerFrames;
        } else {
            msg = dataFrame;
        }
        this.writeDownStream(msg, completionHandler, messageCloner);
    }

    protected abstract void onPeerWindowUpdate(int var1) throws Http2StreamException;

    protected abstract boolean canWrite();

    protected abstract void notifyCanWrite(WriteHandler var1);

    protected abstract int getAvailablePeerConnectionWindowSize();
}

