/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

public class HeaderField {
    String name;
    String value;

    public static HeaderField of(String name) {
        return new HeaderField(name);
    }

    public static HeaderField of(String name, String value) {
        return new HeaderField(name, value);
    }

    public static DynamicHeaderField dynamic() {
        return new DynamicHeaderField();
    }

    HeaderField() {
    }

    HeaderField(String name) {
        this(name, null);
    }

    HeaderField(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return this.name;
        }
        return this.name + ": " + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeaderField)) {
            return false;
        }
        HeaderField that = (HeaderField)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public static final class DynamicHeaderField
    extends HeaderField {
        DynamicHeaderField() {
        }

        public void set(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public void reset() {
            this.name = null;
            this.value = null;
        }
    }
}

