/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.javamail.annotation.handler;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MailSessionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbInterceptorContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentsContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptors;
import javax.mail.MailSessionDefinition;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=MailSessionDefinition.class)
public class MailSessionDefinitionHandler
extends AbstractResourceHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MailSessionDefinitionHandler.class);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        MailSessionDefinition mailSessionDefnAn = (MailSessionDefinition)ainfo.getAnnotation();
        return this.processAnnotation(mailSessionDefnAn, ainfo, rcContexts);
    }

    protected HandlerProcessingResult processAnnotation(MailSessionDefinition mailSessionDefnAn, AnnotationInfo aiInfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        Class annotatedClass = (Class)aiInfo.getAnnotatedElement();
        Annotation[] annotations = annotatedClass.getAnnotations();
        boolean warClass = this.isAWebComponentClass(annotations);
        boolean ejbClass = this.isAEjbComponentClass(annotations);
        for (ResourceContainerContext context : rcContexts) {
            MailSessionDescriptor desc;
            if (!this.canProcessAnnotation(annotatedClass, ejbClass, warClass, context)) {
                return this.getDefaultProcessedResult();
            }
            Set<ResourceDescriptor> mailSessionDescs = context.getResourceDescriptors(JavaEEResourceType.MSD);
            if (this.isDefinitionAlreadyPresent(mailSessionDescs, desc = this.createDescriptor(mailSessionDefnAn))) {
                this.merge(mailSessionDescs, mailSessionDefnAn);
                continue;
            }
            mailSessionDescs.add(desc);
        }
        return this.getDefaultProcessedResult();
    }

    private boolean canProcessAnnotation(Class annotatedClass, boolean ejbClass, boolean warClass, ResourceContainerContext context) {
        if (ejbClass) {
            if (!(context instanceof EjbBundleContext || context instanceof EjbContext || context instanceof EjbInterceptorContext)) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Ignoring @MailSessionDefinition annotation processing as the class isan EJB class and context is not one of EJBContext");
                }
                return false;
            }
        } else if (context instanceof EjbBundleContext) {
            EjbBundleContext ejbContext = (EjbBundleContext)context;
            EjbBundleDescriptor ejbBundleDescriptor = ejbContext.getDescriptor();
            EjbDescriptor[] ejbDescriptor = ejbBundleDescriptor.getEjbByClassName(annotatedClass.getName());
            if (ejbDescriptor == null || ejbDescriptor.length == 0) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Ignoring @MailSessionDefinition annotation processing as the class [ " + annotatedClass + " ] is" + "not an EJB class and the context is EJBContext");
                }
                return false;
            }
        } else if (warClass) {
            if (!(context instanceof WebBundleContext || context instanceof WebComponentsContext || context instanceof WebComponentContext)) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Ignoring @MailSessionDefinition annotation processing as the class isan Web class and context is not one of WebContext");
                }
                return false;
            }
        } else if (context instanceof WebBundleContext) {
            WebBundleContext webBundleContext = (WebBundleContext)context;
            WebBundleDescriptor webBundleDescriptor = webBundleContext.getDescriptor();
            Collection<RootDeploymentDescriptor> extDesc = webBundleDescriptor.getExtensionsDescriptors();
            for (RootDeploymentDescriptor desc : extDesc) {
                Method[] methods;
                if (!(desc instanceof EjbBundleDescriptor)) continue;
                EjbBundleDescriptor ejbBundleDesc = (EjbBundleDescriptor)desc;
                EjbDescriptor[] ejbDescs = ejbBundleDesc.getEjbByClassName(annotatedClass.getName());
                if (ejbDescs != null && ejbDescs.length > 0) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Ignoring @MailSessionDefinition annotation processing as the class [ " + annotatedClass + " ] is" + "not an Web class and the context is WebContext");
                    }
                    return false;
                }
                if (ejbBundleDesc.getInterceptorByClassName(annotatedClass.getName()) != null) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Ignoring @MailSessionDefinition annotation processing as the class [ " + annotatedClass + " ] is" + "not an Web class and the context is WebContext");
                    }
                    return false;
                }
                for (Method method : methods = annotatedClass.getDeclaredMethods()) {
                    Annotation[] annotations;
                    for (Annotation annotation : annotations = method.getAnnotations()) {
                        if (!annotation.annotationType().equals(AroundInvoke.class) && !annotation.annotationType().equals(AroundTimeout.class) && !annotation.annotationType().equals(Interceptors.class)) continue;
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.log(Level.FINEST, "Ignoring @MailSessionDefinition annotation processing as the class [ " + annotatedClass + " ] is" + "not an Web class, an interceptor and the context is WebContext");
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private MailSessionDescriptor createDescriptor(MailSessionDefinition defn) {
        MailSessionDescriptor desc = new MailSessionDescriptor();
        desc.setMetadataSource(MetadataSource.ANNOTATION);
        desc.setName(defn.name());
        if (defn.description() != null && !defn.description().equals("")) {
            desc.setDescription(defn.description());
        }
        if (defn.storeProtocol() != null && !defn.storeProtocol().equals("")) {
            desc.setStoreProtocol(defn.storeProtocol());
        }
        if (defn.transportProtocol() != null && !defn.transportProtocol().equals("")) {
            desc.setTransportProtocol(defn.transportProtocol());
        }
        if (defn.host() != null && !defn.host().equals("")) {
            desc.setHost(defn.host());
        }
        if (defn.user() != null && !defn.user().equals("")) {
            desc.setUser(defn.user());
        }
        if (defn.password() != null) {
            desc.setPassword(defn.password());
        }
        if (defn.from() != null && !defn.from().equals("")) {
            desc.setFrom(defn.from());
        }
        if (defn.properties() != null) {
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length > 0) {
                for (String property : defnProperties) {
                    int index = property.indexOf("=");
                    if (index <= -1 || index == 0 || index >= property.length() - 1) continue;
                    String name = property.substring(0, index);
                    String value = property.substring(index + 1);
                    properties.put(name, value);
                }
            }
        }
        return desc;
    }

    private boolean isDefinitionAlreadyPresent(Set<ResourceDescriptor> mailSessionDescs, MailSessionDescriptor mailSessionDesc) {
        boolean result = false;
        for (ResourceDescriptor msDesc : mailSessionDescs) {
            if (!msDesc.equals(mailSessionDesc)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void merge(Set<ResourceDescriptor> mailSessionDescs, MailSessionDefinition mailSessionDefn) {
        for (ResourceDescriptor orgDesc : mailSessionDescs) {
            MailSessionDescriptor desc = (MailSessionDescriptor)orgDesc;
            if (!desc.getName().equals(mailSessionDefn.name())) continue;
            if (desc.getDescription() == null && mailSessionDefn.description() != null && !mailSessionDefn.description().equals("")) {
                desc.setDescription(mailSessionDefn.description());
            }
            if (desc.getStoreProtocol() == null) {
                desc.setStoreProtocol(mailSessionDefn.storeProtocol());
            }
            if (desc.getTransportProtocol() == null) {
                desc.setTransportProtocol(mailSessionDefn.transportProtocol());
            }
            if (desc.getHost() == null) {
                desc.setHost(mailSessionDefn.host());
            }
            if (desc.getUser() == null && mailSessionDefn.user() != null && !mailSessionDefn.user().equals("")) {
                desc.setUser(mailSessionDefn.user());
            }
            if (desc.getPassword() == null && mailSessionDefn.password() != null) {
                desc.setPassword(mailSessionDefn.password());
            }
            if (desc.getFrom() == null) {
                desc.setFrom(mailSessionDefn.from());
            }
            Properties properties = desc.getProperties();
            String[] defnProperties = mailSessionDefn.properties();
            if (defnProperties.length <= 0) break;
            for (String property : defnProperties) {
                int index = property.indexOf("=");
                if (index <= -1 || index == 0 || index >= property.length() - 1) continue;
                String name = property.substring(0, index);
                String value = property.substring(index + 1);
                if (properties.get(name) != null) continue;
                properties.put(name, value);
            }
        }
    }
}

