/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import org.glassfish.web.deployment.descriptor.MultipartConfigDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultipartConfigNode
extends DeploymentDescriptorNode<MultipartConfigDescriptor> {
    private MultipartConfigDescriptor descriptor;

    @Override
    public MultipartConfigDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new MultipartConfigDescriptor();
        }
        return this.descriptor;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("location", "setLocation");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("max-file-size".equals(element.getQName())) {
            this.descriptor.setMaxFileSize(Long.valueOf(value));
        } else if ("max-request-size".equals(element.getQName())) {
            this.descriptor.setMaxRequestSize(Long.valueOf(value));
        } else if ("file-size-threshold".equals(element.getQName())) {
            this.descriptor.setFileSizeThreshold(Integer.valueOf(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, MultipartConfigDescriptor descriptor) {
        Element myNode = MultipartConfigNode.appendChild(parent, nodeName);
        MultipartConfigNode.appendTextChild((Node)myNode, "location", descriptor.getLocation());
        if (descriptor.getMaxFileSize() != null) {
            MultipartConfigNode.appendTextChild((Node)myNode, "max-file-size", descriptor.getMaxFileSize().toString());
        }
        if (descriptor.getMaxRequestSize() != null) {
            MultipartConfigNode.appendTextChild((Node)myNode, "max-request-size", descriptor.getMaxRequestSize().toString());
        }
        if (descriptor.getFileSizeThreshold() != null) {
            MultipartConfigNode.appendTextChild((Node)myNode, "file-size-threshold", descriptor.getFileSizeThreshold().toString());
        }
        return myNode;
    }
}

