/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.ejb;

import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.interceptor.InvocationContext;
import org.glassfish.weld.ejb.BusinessInterfaceDescriptorImpl;
import org.jboss.weld.ejb.SessionBeanInterceptor;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;

public class EjbDescriptorImpl<T>
implements EjbDescriptor<T> {
    private com.sun.enterprise.deployment.EjbDescriptor ejbDesc;

    public EjbDescriptorImpl(com.sun.enterprise.deployment.EjbDescriptor ejbDescriptor) {
        this.ejbDesc = ejbDescriptor;
        if (this.ejbDesc.getType().equals("Session") || this.ejbDesc.getType().equals("Message-driven")) {
            EjbInterceptor systemLevelCDIInterceptor = this.createSystemLevelCDIInterceptor();
            this.ejbDesc.addFrameworkInterceptor(systemLevelCDIInterceptor);
        }
    }

    @Override
    public String getEjbName() {
        return this.ejbDesc.getName();
    }

    public com.sun.enterprise.deployment.EjbDescriptor getEjbDescriptor() {
        return this.ejbDesc;
    }

    @Override
    public Class<T> getBeanClass() {
        Class<?> beanClassType = null;
        try {
            beanClassType = this.ejbDesc.getEjbBundleDescriptor().getClassLoader().loadClass(this.ejbDesc.getEjbClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return beanClassType;
    }

    @Override
    public Collection<BusinessInterfaceDescriptor<?>> getLocalBusinessInterfaces() {
        HashSet localBusIntfs = new HashSet();
        if (this.ejbDesc.getType().equals("Session")) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)this.ejbDesc;
            Set<String> localNames = sessionDesc.getLocalBusinessClassNames();
            if (sessionDesc.isLocalBean()) {
                localNames.add(sessionDesc.getEjbClassName());
            }
            for (String local : localNames) {
                try {
                    Class<?> localClass = sessionDesc.getEjbBundleDescriptor().getClassLoader().loadClass(local);
                    BusinessInterfaceDescriptorImpl busIntfDesc = new BusinessInterfaceDescriptorImpl(localClass);
                    localBusIntfs.add(busIntfDesc);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return localBusIntfs;
    }

    @Override
    public Collection<Method> getRemoveMethods() {
        EjbSessionDescriptor sessionDesc;
        HashSet<Method> removeMethods = new HashSet<Method>();
        if (this.ejbDesc.getType().equals("Session") && (sessionDesc = (EjbSessionDescriptor)this.ejbDesc).isStateful() && sessionDesc.hasRemoveMethods()) {
            for (MethodDescriptor mDesc : sessionDesc.getRemoveMethodDescriptors()) {
                Method m = mDesc.getMethod(this.ejbDesc);
                if (m == null) {
                    throw new IllegalStateException("Can't resolve remove method " + mDesc + " For EJB " + sessionDesc.getName());
                }
                removeMethods.add(m);
            }
        }
        return removeMethods;
    }

    @Override
    public boolean isStateless() {
        return this.ejbDesc.getType().equals("Session") && ((EjbSessionDescriptor)this.ejbDesc).isStateless();
    }

    @Override
    public boolean isSingleton() {
        return this.ejbDesc.getType().equals("Session") && ((EjbSessionDescriptor)this.ejbDesc).isSingleton();
    }

    @Override
    public boolean isStateful() {
        return this.ejbDesc.getType().equals("Session") && ((EjbSessionDescriptor)this.ejbDesc).isStateful();
    }

    @Override
    public boolean isMessageDriven() {
        return this.ejbDesc.getType().equals("Message-driven");
    }

    @Override
    public boolean isPassivationCapable() {
        EjbSessionDescriptor ejbSessionDescriptor;
        return this.ejbDesc instanceof EjbSessionDescriptor && (ejbSessionDescriptor = (EjbSessionDescriptor)this.ejbDesc).isStateful() && ejbSessionDescriptor.isPassivationCapable();
    }

    private EjbInterceptor createSystemLevelCDIInterceptor() {
        EjbInterceptor interceptor = new EjbInterceptor();
        Class<SessionBeanInterceptor> interceptorClass = SessionBeanInterceptor.class;
        String interceptorName = interceptorClass.getName();
        interceptor.setInterceptorClass(interceptorClass);
        try {
            Method aroundInvokeMethod = interceptorClass.getMethod("aroundInvoke", InvocationContext.class);
            if (aroundInvokeMethod != null) {
                LifecycleCallbackDescriptor aroundInvokeDesc = new LifecycleCallbackDescriptor();
                aroundInvokeDesc.setLifecycleCallbackClass(interceptorName);
                aroundInvokeDesc.setLifecycleCallbackMethod(aroundInvokeMethod.getName());
                interceptor.addAroundInvokeDescriptor(aroundInvokeDesc);
                LifecycleCallbackDescriptor aroundTimeoutDesc = new LifecycleCallbackDescriptor();
                aroundTimeoutDesc.setLifecycleCallbackClass(interceptorName);
                aroundTimeoutDesc.setLifecycleCallbackMethod(aroundInvokeMethod.getName());
                interceptor.addAroundTimeoutDescriptor(aroundTimeoutDesc);
                LifecycleCallbackDescriptor postConstructDesc = new LifecycleCallbackDescriptor();
                postConstructDesc.setLifecycleCallbackClass(interceptorName);
                postConstructDesc.setLifecycleCallbackMethod(aroundInvokeMethod.getName());
                interceptor.addPostConstructDescriptor(postConstructDesc);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("Cannot find weld EJB interceptor aroundInvoke method");
        }
        return interceptor;
    }

    @Override
    public Collection<BusinessInterfaceDescriptor<?>> getRemoteBusinessInterfaces() {
        HashSet remoteBusIntfs = new HashSet();
        if (this.ejbDesc.getType().equals("Session")) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)this.ejbDesc;
            Set<String> remoteNames = sessionDesc.getRemoteBusinessClassNames();
            if (sessionDesc.isLocalBean()) {
                remoteNames.add(sessionDesc.getEjbClassName());
            }
            for (String remote : remoteNames) {
                try {
                    Class<?> remoteClass = sessionDesc.getEjbBundleDescriptor().getClassLoader().loadClass(remote);
                    BusinessInterfaceDescriptorImpl busIntfDesc = new BusinessInterfaceDescriptorImpl(remoteClass);
                    remoteBusIntfs.add(busIntfDesc);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return remoteBusIntfs;
    }

    public String toString() {
        return this.ejbDesc.getEjbClassName();
    }
}

