/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.enterprise.container.common.spi.JCDIService;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import javax.inject.Scope;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.Rank;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.WeldDeployer;
import org.glassfish.weld.connector.WeldUtils;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;
import org.jboss.weld.manager.api.WeldManager;
import org.jvnet.hk2.annotations.Service;

@Service
@Rank(value=10)
public class JCDIServiceImpl
implements JCDIService {
    private static final HashSet<String> validScopes = new HashSet();
    private static final HashSet<String> excludedScopes;
    @Inject
    private WeldDeployer weldDeployer;
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationManager;
    private Logger logger = Logger.getLogger(JCDIServiceImpl.class.getName());

    @Override
    public boolean isCurrentModuleJCDIEnabled() {
        BundleDescriptor bundle2 = null;
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv == null) {
            return false;
        }
        JndiNameEnvironment componentEnv = this.compEnvManager.getJndiNameEnvironment(((ComponentInvocation)inv).getComponentId());
        if (componentEnv != null) {
            if (componentEnv instanceof BundleDescriptor) {
                bundle2 = (BundleDescriptor)((Object)componentEnv);
            } else if (componentEnv instanceof com.sun.enterprise.deployment.EjbDescriptor) {
                bundle2 = ((com.sun.enterprise.deployment.EjbDescriptor)componentEnv).getEjbBundleDescriptor();
            }
        }
        return bundle2 != null ? this.isJCDIEnabled(bundle2) : false;
    }

    @Override
    public boolean isJCDIEnabled(BundleDescriptor bundle2) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle2.getModuleDescriptor().getDescriptor();
        return this.weldDeployer.is299Enabled(topLevelBundleDesc);
    }

    @Override
    public boolean isCDIScoped(Class<?> clazz) {
        return WeldUtils.hasValidAnnotation(clazz, validScopes, excludedScopes);
    }

    @Override
    public void setELResolver(ServletContext servletContext) throws NamingException {
        InitialContext context = new InitialContext();
        BeanManager beanManager = (BeanManager)context.lookup("java:comp/BeanManager");
        if (beanManager != null) {
            servletContext.setAttribute("org.glassfish.jsp.beanManagerELResolver", beanManager.getELResolver());
        }
    }

    @Override
    public <T> JCDIService.JCDIInjectionContext<T> createJCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejb, T instance) {
        return this._createJCDIInjectionContext(ejb, instance);
    }

    @Override
    public <T> JCDIService.JCDIInjectionContext<T> createJCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejb) {
        return this._createJCDIInjectionContext(ejb, null);
    }

    private <T> JCDIService.JCDIInjectionContext<T> _createJCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejb, T instance) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)ejb.getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.getBDAForBeanClass(topLevelBundleDesc, ejb.getEjbClassName());
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(ejb.getEjbBundleDescriptor().getApplication());
        BeanManagerImpl weldManager = bootstrap.getManager(bda);
        EjbDescriptor ejbDesc = weldManager.getEjbDescriptor(ejb.getName());
        Bean bean = weldManager.getBean(ejbDesc);
        InjectionTarget it = weldManager.createInjectionTarget(ejbDesc);
        WeldCreationalContext cc = weldManager.createCreationalContext(bean);
        T beanInstance = instance;
        if (beanInstance == null) {
            beanInstance = it.produce(cc);
        }
        return new JCDIInjectionContextImpl<T>(it, cc, beanInstance);
    }

    private BeanDeploymentArchive getBDAForBeanClass(BundleDescriptor bundleDesc, String beanClassName) {
        BeanDeploymentArchive topLevelBDA;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AS-CDI-00043", new Object[]{bundleDesc.getModuleName(), beanClassName});
        }
        if ((topLevelBDA = this.weldDeployer.getBeanDeploymentArchiveForBundle(bundleDesc)).getBeanClasses().contains(beanClassName)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00044", new Object[]{topLevelBDA.getId(), beanClassName});
            }
            return topLevelBDA;
        }
        for (BeanDeploymentArchive bda : topLevelBDA.getBeanDeploymentArchives()) {
            if (!bda.getBeanClasses().contains(beanClassName)) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00045", new Object[]{bda.getId(), beanClassName});
            }
            return bda;
        }
        return topLevelBDA;
    }

    @Override
    public <T> void injectEJBInstance(JCDIService.JCDIInjectionContext<T> injectionCtx) {
        JCDIInjectionContextImpl injectionCtxImpl = (JCDIInjectionContextImpl)injectionCtx;
        injectionCtxImpl.it.inject(injectionCtxImpl.instance, injectionCtxImpl.cc);
    }

    @Override
    public <T> JCDIService.JCDIInjectionContext<T> createManagedObject(Class<T> managedClass, BundleDescriptor bundle2) {
        return this.createManagedObject(managedClass, bundle2, true);
    }

    @Override
    public void injectManagedObject(Object managedObject, BundleDescriptor bundle2) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle2.getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.weldDeployer.getBeanDeploymentArchiveForBundle(topLevelBundleDesc);
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(bundle2.getApplication());
        BeanManagerImpl beanManager = bootstrap.getManager(bda);
        AnnotatedType<?> annotatedType = beanManager.createAnnotatedType(managedObject.getClass());
        InjectionTarget<?> it = beanManager.createInjectionTarget(annotatedType);
        CreationalContext cc = beanManager.createCreationalContext(null);
        it.inject(managedObject, cc);
    }

    @Override
    public <T> T createInterceptorInstance(Class<T> interceptorClass, BundleDescriptor bundle2) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle2.getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.weldDeployer.getBeanDeploymentArchiveForBundle(topLevelBundleDesc);
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(bundle2.getApplication());
        BeanManagerImpl beanManager = bootstrap.getManager(bda);
        CreationalContext cc = beanManager.createCreationalContext(null);
        AnnotatedType<T> annotatedType = beanManager.createAnnotatedType(interceptorClass);
        WeldInjectionTarget it = ((WeldManager)beanManager).getInjectionTargetFactory(annotatedType).createInterceptorInjectionTarget();
        Object interceptorInstance = it.produce(cc);
        it.inject(interceptorInstance, cc);
        return interceptorInstance;
    }

    @Override
    public <T> JCDIService.JCDIInjectionContext<T> createManagedObject(Class<T> managedClass, BundleDescriptor bundle2, boolean invokePostConstruct) {
        InjectionTarget<Object> it;
        Object managedObject = null;
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle2.getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.weldDeployer.getBeanDeploymentArchiveForBundle(topLevelBundleDesc);
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(bundle2.getApplication());
        BeanManagerImpl beanManager = bootstrap.getManager(bda);
        AnnotatedType<T> annotatedType = beanManager.createAnnotatedType(managedClass);
        if (!invokePostConstruct) {
            annotatedType = new NoPostConstructPreDestroyAnnotatedType<T>(annotatedType);
        }
        if ((it = ((BeanDeploymentArchiveImpl)bda).getInjectionTarget(annotatedType)) == null) {
            it = beanManager.createInjectionTarget(annotatedType);
        }
        CreationalContext cc = beanManager.createCreationalContext(null);
        managedObject = it.produce(cc);
        it.inject(managedObject, cc);
        if (invokePostConstruct) {
            it.postConstruct(managedObject);
        }
        return new JCDIInjectionContextImpl<Object>(it, cc, managedObject);
    }

    static {
        validScopes.add(Scope.class.getName());
        validScopes.add(NormalScope.class.getName());
        validScopes.add(RequestScoped.class.getName());
        validScopes.add(SessionScoped.class.getName());
        validScopes.add(ApplicationScoped.class.getName());
        validScopes.add(ConversationScoped.class.getName());
        excludedScopes = new HashSet();
        excludedScopes.add(Dependent.class.getName());
    }

    private static class JCDIInjectionContextImpl<T>
    implements JCDIService.JCDIInjectionContext<T> {
        InjectionTarget it;
        CreationalContext cc;
        T instance;

        JCDIInjectionContextImpl(InjectionTarget it, CreationalContext cc, T i) {
            this.it = it;
            this.cc = cc;
            this.instance = i;
        }

        @Override
        public T getInstance() {
            return this.instance;
        }

        @Override
        public void cleanup(boolean callPreDestroy) {
            if (callPreDestroy) {
                this.it.preDestroy(this.instance);
            }
            this.it.dispose(this.instance);
            this.cc.release();
        }
    }

    private static class NoPostConstructPreDestroyAnnotatedType<X>
    implements AnnotatedType<X> {
        private final AnnotatedType<X> delegate;

        private NoPostConstructPreDestroyAnnotatedType(AnnotatedType<X> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Type getBaseType() {
            return this.delegate.getBaseType();
        }

        @Override
        public Set<Type> getTypeClosure() {
            return this.delegate.getTypeClosure();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return this.delegate.getAnnotation(annotationType);
        }

        @Override
        public Set<Annotation> getAnnotations() {
            return this.delegate.getAnnotations();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.delegate.isAnnotationPresent(annotationType);
        }

        @Override
        public Class<X> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public Set<AnnotatedConstructor<X>> getConstructors() {
            return this.delegate.getConstructors();
        }

        @Override
        public Set<AnnotatedMethod<? super X>> getMethods() {
            HashSet<AnnotatedMethod<X>> retVal = new HashSet<AnnotatedMethod<X>>();
            for (AnnotatedMethod<X> m : this.delegate.getMethods()) {
                if (m.isAnnotationPresent(PostConstruct.class) || m.isAnnotationPresent(PreDestroy.class)) continue;
                retVal.add(m);
            }
            return retVal;
        }

        @Override
        public Set<AnnotatedField<? super X>> getFields() {
            return this.delegate.getFields();
        }
    }
}

