/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.logging.MetadataLogger;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;

public class AnnotatedTypeValidator {
    private AnnotatedTypeValidator() {
    }

    public static void validateAnnotated(Annotated annotated) {
        AnnotatedTypeValidator.checkNotNull(annotated.getAnnotations(), "getAnnotations()", annotated);
        AnnotatedTypeValidator.checkNotNull(annotated.getBaseType(), "getBaseType()", annotated);
        AnnotatedTypeValidator.checkNotNull(annotated.getTypeClosure(), "getTypeClosure()", annotated);
    }

    public static void validateAnnotatedParameter(AnnotatedParameter<?> parameter) {
        AnnotatedTypeValidator.validateAnnotated(parameter);
        if (parameter.getPosition() < 0) {
            throw MetadataLogger.LOG.invalidParameterPosition(parameter.getPosition(), parameter);
        }
        AnnotatedTypeValidator.checkNotNull(parameter.getDeclaringCallable(), "getDeclaringCallable()", parameter);
    }

    public static void validateAnnotatedMember(AnnotatedMember<?> member) {
        AnnotatedTypeValidator.validateAnnotated(member);
        AnnotatedTypeValidator.checkNotNull(member.getJavaMember(), "getJavaMember()", member);
        AnnotatedTypeValidator.checkNotNull(member.getDeclaringType(), "getDeclaringType()", member);
    }

    public static void validateAnnotatedType(AnnotatedType<?> type2) {
        AnnotatedTypeValidator.validateAnnotated(type2);
        AnnotatedTypeValidator.checkNotNull(type2.getJavaClass(), "getJavaClass()", type2);
        AnnotatedTypeValidator.checkNotNull(type2.getFields(), "getFields()", type2);
        AnnotatedTypeValidator.checkNotNull(type2.getConstructors(), "getConstructors()", type2);
        AnnotatedTypeValidator.checkNotNull(type2.getMethods(), "getMethods()", type2);
        AnnotatedTypeValidator.checkSensibility(type2);
    }

    private static void checkNotNull(Object expression, String methodName, Object target) {
        if (expression == null) {
            throw MetadataLogger.LOG.metadataSourceReturnedNull(methodName, target);
        }
    }

    private static void checkSensibility(AnnotatedType<?> type2) {
        if (type2.getConstructors().isEmpty() && !type2.getJavaClass().isInterface()) {
            MetadataLogger.LOG.noConstructor(type2);
        }
        HashSet hierarchy = new HashSet();
        for (Class<?> clazz = type2.getJavaClass(); clazz != null; clazz = clazz.getSuperclass()) {
            hierarchy.add(clazz);
            WeldCollections.addAll(hierarchy, clazz.getInterfaces());
        }
        AnnotatedTypeValidator.checkMembersBelongToHierarchy(type2.getConstructors(), hierarchy, type2);
        AnnotatedTypeValidator.checkMembersBelongToHierarchy(type2.getMethods(), hierarchy, type2);
        AnnotatedTypeValidator.checkMembersBelongToHierarchy(type2.getFields(), hierarchy, type2);
    }

    private static void checkMembersBelongToHierarchy(Iterable<? extends AnnotatedMember<?>> members, Set<Class<?>> hierarchy, AnnotatedType<?> type2) {
        for (AnnotatedMember<?> member : members) {
            if (hierarchy.contains(member.getJavaMember().getDeclaringClass())) continue;
            MetadataLogger.LOG.notInHierarchy(member.getJavaMember().getName(), member.toString(), type2.getJavaClass().getName(), type2.toString(), Formats.formatAsStackTraceElement(member.getJavaMember()));
        }
    }
}

