/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.resolution.CovariantTypes;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.reflection.GenericArrayTypeImpl;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;
import org.jboss.weld.util.reflection.Reflections;

public class Types {
    public static final Function<Type, Class<?>> TYPE_TO_CLASS_FUNCTION = new Function<Type, Class<?>>(){

        @Override
        public Class<?> apply(Type input) {
            return Reflections.getRawType(input);
        }
    };

    private Types() {
    }

    public static Type boxedType(Type type2) {
        if (type2 instanceof Class) {
            return Types.boxedClass((Class)type2);
        }
        return type2;
    }

    public static Class<?> boxedClass(Class<?> type2) {
        if (!type2.isPrimitive()) {
            return type2;
        }
        if (type2.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type2.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type2.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type2.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type2.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type2.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type2.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type2.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type2.equals(Void.TYPE)) {
            return Void.class;
        }
        return type2;
    }

    public static String getTypeId(Type type2) {
        if (type2 instanceof Class) {
            return ((Class)Reflections.cast(type2)).getName();
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type2;
            StringBuilder builder = new StringBuilder(Types.getTypeId(pt.getRawType()));
            builder.append("<");
            for (int i = 0; i < pt.getActualTypeArguments().length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(Types.getTypeId(pt.getActualTypeArguments()[i]));
            }
            builder.append(">");
            return builder.toString();
        }
        if (type2 instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type2;
            StringBuilder builder = new StringBuilder(Types.getTypeId(arrayType.getGenericComponentType()));
            builder.append("[]");
            return builder.toString();
        }
        throw new IllegalArgumentException("Cannot create type id for " + type2.toString());
    }

    public static Type getCanonicalType(Class<?> clazz) {
        Type resolvedComponentType;
        Class<?> componentType;
        if (clazz.isArray() && (componentType = clazz.getComponentType()) != (resolvedComponentType = Types.getCanonicalType(componentType))) {
            return new GenericArrayTypeImpl(resolvedComponentType);
        }
        if (clazz.getTypeParameters().length > 0) {
            Type[] actualTypeParameters = clazz.getTypeParameters();
            return new ParameterizedTypeImpl((Type)clazz, actualTypeParameters, (Type)clazz.getDeclaringClass());
        }
        return clazz;
    }

    public static Type getCanonicalType(Type type2) {
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            return Types.getCanonicalType(clazz);
        }
        return type2;
    }

    public static boolean containsUnresolvedTypeVariableOrWildcard(Type type2) {
        if ((type2 = Types.getCanonicalType(type2)) instanceof TypeVariable || type2 instanceof WildcardType) {
            return true;
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            for (Type t : parameterizedType.getActualTypeArguments()) {
                if (!Types.containsUnresolvedTypeVariableOrWildcard(t)) continue;
                return true;
            }
        }
        if (type2 instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type2;
            return Types.containsUnresolvedTypeVariableOrWildcard(genericArrayType.getGenericComponentType());
        }
        return false;
    }

    public static boolean containsTypeVariable(Type type2) {
        if ((type2 = Types.getCanonicalType(type2)) instanceof TypeVariable) {
            return true;
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            for (Type t : parameterizedType.getActualTypeArguments()) {
                if (!Types.containsTypeVariable(t)) continue;
                return true;
            }
        }
        if (type2 instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type2;
            return Types.containsTypeVariable(genericArrayType.getGenericComponentType());
        }
        return false;
    }

    public static Set<Class<?>> getRawTypes(Set<Type> types) {
        return ImmutableSet.copyOf(Iterables.transform(types, TYPE_TO_CLASS_FUNCTION));
    }

    public static Class<?>[] getRawTypes(Type[] types) {
        if (types.length == 0) {
            return Arrays2.EMPTY_CLASS_ARRAY;
        }
        Class[] result = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = TYPE_TO_CLASS_FUNCTION.apply(types[i]);
        }
        return result;
    }

    public static <C extends Class<?>> Map<String, C> buildClassNameMap(Iterable<C> set) {
        HashMap<String, Class> loadedStereotypes = new HashMap<String, Class>();
        for (Class javaClass : set) {
            loadedStereotypes.put(javaClass.getName(), javaClass);
        }
        return loadedStereotypes;
    }

    public static boolean isActualType(Type type2) {
        return type2 instanceof Class || type2 instanceof ParameterizedType || type2 instanceof GenericArrayType;
    }

    public static boolean isArray(Type type2) {
        return type2 instanceof GenericArrayType || type2 instanceof Class && ((Class)type2).isArray();
    }

    public static Type getArrayComponentType(Type type2) {
        Class clazz;
        if (type2 instanceof GenericArrayType) {
            return ((GenericArrayType)GenericArrayType.class.cast(type2)).getGenericComponentType();
        }
        if (type2 instanceof Class && (clazz = (Class)type2).isArray()) {
            return clazz.getComponentType();
        }
        throw new IllegalArgumentException("Not an array type " + type2);
    }

    public static boolean isArrayOfUnboundedTypeVariablesOrObjects(Type[] types) {
        for (Type type2 : types) {
            Type[] bounds;
            if (Object.class.equals((Object)type2) || type2 instanceof TypeVariable && ((bounds = ((TypeVariable)type2).getBounds()) == null || bounds.length == 0 || bounds.length == 1 && Object.class.equals((Object)bounds[0]))) continue;
            return false;
        }
        return true;
    }

    public static boolean isRawGenericType(Type type2) {
        if (!(type2 instanceof Class)) {
            return false;
        }
        Class clazz = (Class)type2;
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return Types.isRawGenericType(componentType);
        }
        return clazz.getTypeParameters().length > 0;
    }

    public static boolean isIllegalBeanType(Type beanType) {
        boolean result = false;
        if (beanType instanceof TypeVariable) {
            result = true;
        } else if (beanType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)beanType;
            for (Type typeArgument : parameterizedType.getActualTypeArguments()) {
                if (typeArgument instanceof TypeVariable || !(typeArgument instanceof WildcardType) && !Types.isIllegalBeanType(typeArgument)) continue;
                result = true;
                break;
            }
        } else if (beanType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)beanType;
            result = Types.isIllegalBeanType(arrayType.getGenericComponentType());
        }
        return result;
    }

    public static boolean isMoreSpecific(Type type1, Type type2) {
        if (type1.equals(type2)) {
            return false;
        }
        return CovariantTypes.isAssignableFrom(type2, type1);
    }
}

