/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.internal.diagnostics.DiagnosticsLogFile;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class Diagnostics {
    public static final String PREFIX = "hazelcast.diagnostics";
    public static final HazelcastProperty METRICS_LEVEL = new HazelcastProperty("hazelcast.diagnostics.metric.level", ProbeLevel.MANDATORY.name()).setDeprecatedName("hazelcast.performance.metric.level");
    public static final HazelcastProperty ENABLED = new HazelcastProperty("hazelcast.diagnostics.enabled", false).setDeprecatedName("hazelcast.performance.monitoring.enabled");
    public static final HazelcastProperty MAX_ROLLED_FILE_SIZE_MB = new HazelcastProperty("hazelcast.diagnostics.max.rolled.file.size.mb", 10).setDeprecatedName("hazelcast.performance.monitor.max.rolled.file.size.mb");
    public static final HazelcastProperty MAX_ROLLED_FILE_COUNT = new HazelcastProperty("hazelcast.diagnostics.max.rolled.file.count", 10).setDeprecatedName("hazelcast.performance.monitor.max.rolled.file.count");
    public static final HazelcastProperty HUMAN_FRIENDLY_FORMAT = new HazelcastProperty("hazelcast.diagnostics.human.friendly.format", true).setDeprecatedName("hazelcast.performance.monitor.human.friendly.format");
    public static final HazelcastProperty DIRECTORY = new HazelcastProperty("hazelcast.diagnostics.directory", "" + System.getProperty("user.dir"));
    final boolean singleLine;
    final HazelcastProperties properties;
    final String directory;
    DiagnosticsLogFile diagnosticsLogFile;
    final AtomicReference<DiagnosticsPlugin[]> staticTasks = new AtomicReference<DiagnosticsPlugin[]>(new DiagnosticsPlugin[0]);
    final ILogger logger;
    final String fileName;
    private final boolean enabled;
    private ScheduledExecutorService scheduler;
    private final HazelcastThreadGroup hzThreadGroup;

    public Diagnostics(String fileName, ILogger logger2, HazelcastThreadGroup hzThreadGroup, HazelcastProperties properties) {
        this.fileName = fileName;
        this.hzThreadGroup = hzThreadGroup;
        this.logger = logger2;
        this.properties = properties;
        this.enabled = properties.getBoolean(ENABLED);
        this.directory = properties.getString(DIRECTORY);
        this.singleLine = !properties.getBoolean(HUMAN_FRIENDLY_FORMAT);
    }

    public void register(DiagnosticsPlugin plugin) {
        Preconditions.checkNotNull(plugin, "plugin can't be null");
        if (!this.enabled) {
            return;
        }
        long periodMillis = plugin.getPeriodMillis();
        if (periodMillis < -1L) {
            throw new IllegalArgumentException(plugin + " can't return a periodMillis smaller than -1");
        }
        this.logger.finest(plugin.getClass().toString() + " is " + (periodMillis == 0L ? "disabled" : "enabled"));
        if (periodMillis == 0L) {
            return;
        }
        plugin.onStart();
        if (periodMillis > 0L) {
            this.scheduler.scheduleAtFixedRate(new WritePluginTask(plugin), 0L, periodMillis, TimeUnit.MILLISECONDS);
        } else {
            this.addStaticPlugin(plugin);
        }
    }

    private void addStaticPlugin(DiagnosticsPlugin plugin) {
        DiagnosticsPlugin[] newPlugins;
        DiagnosticsPlugin[] oldPlugins;
        do {
            oldPlugins = this.staticTasks.get();
            newPlugins = new DiagnosticsPlugin[oldPlugins.length + 1];
            System.arraycopy(oldPlugins, 0, newPlugins, 0, oldPlugins.length);
            newPlugins[oldPlugins.length] = plugin;
        } while (!this.staticTasks.compareAndSet(oldPlugins, newPlugins));
    }

    public void start() {
        if (!this.enabled) {
            this.logger.finest("Diagnostics is enabled");
            return;
        }
        this.diagnosticsLogFile = new DiagnosticsLogFile(this);
        this.scheduler = new ScheduledThreadPoolExecutor(1, new DiagnosticSchedulerThreadFactory());
        this.logger.info("Diagnostics started");
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    private class DiagnosticSchedulerThreadFactory
    implements ThreadFactory {
        private DiagnosticSchedulerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable target) {
            return new Thread(Diagnostics.this.hzThreadGroup.getInternalThreadGroup(), target, Diagnostics.this.hzThreadGroup.getThreadNamePrefix("DiagnosticsSchedulerThread"));
        }
    }

    private class WritePluginTask
    implements Runnable {
        private final DiagnosticsPlugin plugin;

        WritePluginTask(DiagnosticsPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public void run() {
            try {
                Diagnostics.this.diagnosticsLogFile.write(this.plugin);
            }
            catch (Throwable t) {
                Diagnostics.this.logger.severe(t);
            }
        }
    }
}

