/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.core.ClientType;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.MD5Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public final class PhoneHome {
    private static final int TIMEOUT = 1000;
    private static final int A_INTERVAL = 5;
    private static final int B_INTERVAL = 10;
    private static final int C_INTERVAL = 20;
    private static final int D_INTERVAL = 40;
    private static final int E_INTERVAL = 60;
    private static final int F_INTERVAL = 100;
    private static final int G_INTERVAL = 150;
    private static final int H_INTERVAL = 300;
    private static final int J_INTERVAL = 600;
    private static final String BASE_PHONE_HOME_URL = "http://phonehome.hazelcast.com/ping";

    public void check(final Node hazelcastNode, final String version, final boolean isEnterprise) {
        ILogger logger2 = hazelcastNode.getLogger(PhoneHome.class);
        if (!hazelcastNode.getProperties().getBoolean(GroupProperty.VERSION_CHECK_ENABLED)) {
            logger2.warning(GroupProperty.VERSION_CHECK_ENABLED.getName() + " property is deprecated. Please use " + GroupProperty.PHONE_HOME_ENABLED.getName() + " instead to disable phone home.");
            return;
        }
        if (!hazelcastNode.getProperties().getBoolean(GroupProperty.PHONE_HOME_ENABLED)) {
            return;
        }
        try {
            hazelcastNode.nodeEngine.getExecutionService().scheduleWithRepetition(new Runnable(){

                @Override
                public void run() {
                    PhoneHome.this.phoneHome(hazelcastNode, version, isEnterprise);
                }
            }, 0L, 1L, TimeUnit.DAYS);
        }
        catch (RejectedExecutionException e) {
            logger2.warning("Could not schedule phone home! Most probably Hazelcast is failed to start.");
        }
    }

    public void shutdown() {
    }

    public String convertToLetter(int size) {
        String letter = size < 5 ? "A" : (size < 10 ? "B" : (size < 20 ? "C" : (size < 40 ? "D" : (size < 60 ? "E" : (size < 100 ? "F" : (size < 150 ? "G" : (size < 300 ? "H" : (size < 600 ? "J" : "I"))))))));
        return letter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> phoneHome(Node hazelcastNode, String version, boolean isEnterprise) {
        InputStream is;
        String downloadId;
        block6: {
            downloadId = "source";
            is = null;
            try {
                is = this.getClass().getClassLoader().getResourceAsStream("hazelcast-download.properties");
                if (is == null) break block6;
                Properties properties = new Properties();
                properties.load(is);
                downloadId = properties.getProperty("hazelcastDownloadId");
            }
            catch (IOException ignored) {
                try {
                    EmptyStatement.ignore(ignored);
                }
                catch (Throwable throwable) {
                    IOUtil.closeResource(is);
                    throw throwable;
                }
                IOUtil.closeResource(is);
            }
        }
        IOUtil.closeResource(is);
        NativeMemoryConfig memoryConfig = hazelcastNode.getConfig().getNativeMemoryConfig();
        ClusterServiceImpl clusterService = hazelcastNode.getClusterService();
        long totalNativeMemorySize = (long)clusterService.getSize(MemberSelectors.DATA_MEMBER_SELECTOR) * memoryConfig.getSize().bytes();
        String nativeMemoryParameter = isEnterprise ? Long.toString(MemoryUnit.BYTES.toGigaBytes(totalNativeMemorySize)) : "0";
        Map<ClientType, Integer> clusterClientStats = hazelcastNode.clientEngine.getConnectedClientStats();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
        Long clusterUpTime = clusterService.getClusterClock().getClusterUpTime();
        PhoneHomeParameterCreator parameterCreator = new PhoneHomeParameterCreator();
        parameterCreator.addParam("version", version);
        parameterCreator.addParam("m", hazelcastNode.getLocalMember().getUuid());
        parameterCreator.addParam("e", Boolean.toString(isEnterprise));
        parameterCreator.addParam("l", MD5Util.toMD5String(hazelcastNode.getConfig().getLicenseKey()));
        parameterCreator.addParam("p", downloadId);
        parameterCreator.addParam("c", clusterService.getClusterId());
        parameterCreator.addParam("crsz", this.convertToLetter(clusterService.getMembers().size()));
        parameterCreator.addParam("cssz", this.convertToLetter(hazelcastNode.clientEngine.getClientEndpointCount()));
        parameterCreator.addParam("hdgb", nativeMemoryParameter);
        parameterCreator.addParam("ccpp", Integer.toString(clusterClientStats.get((Object)ClientType.CPP)));
        parameterCreator.addParam("cdn", Integer.toString(clusterClientStats.get((Object)ClientType.CSHARP)));
        parameterCreator.addParam("cjv", Integer.toString(clusterClientStats.get((Object)ClientType.JAVA)));
        parameterCreator.addParam("cuptm", Long.toString(clusterUpTime));
        parameterCreator.addParam("nuptm", Long.toString(runtimeMxBean.getUptime()));
        parameterCreator.addParam("jvmn", runtimeMxBean.getVmName());
        parameterCreator.addParam("jvmv", System.getProperty("java.version"));
        try {
            parameterCreator.addParam("osn", osMxBean.getName());
            parameterCreator.addParam("osa", osMxBean.getArch());
            parameterCreator.addParam("osv", osMxBean.getVersion());
        }
        catch (SecurityException e) {
            parameterCreator.addParam("osn", "N/A");
            parameterCreator.addParam("osa", "N/A");
            parameterCreator.addParam("osv", "N/A");
        }
        String urlStr = BASE_PHONE_HOME_URL + parameterCreator.build();
        this.fetchWebService(urlStr);
        return parameterCreator.getParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchWebService(String urlStr) {
        BufferedInputStream in = null;
        try {
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/5.0");
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(2000);
            in = new BufferedInputStream(conn.getInputStream());
            IOUtil.closeResource(in);
        }
        catch (IOException ignored) {
            EmptyStatement.ignore(ignored);
        }
        finally {
            IOUtil.closeResource(in);
        }
    }

    private static class PhoneHomeParameterCreator {
        private final StringBuilder builder;
        private final Map<String, String> parameters = new HashMap<String, String>();
        private boolean hasParameterBefore;

        public PhoneHomeParameterCreator() {
            this.builder = new StringBuilder();
            this.builder.append("?");
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public PhoneHomeParameterCreator addParam(String key, String value) {
            if (this.hasParameterBefore) {
                this.builder.append("&");
            } else {
                this.hasParameterBefore = true;
            }
            try {
                this.builder.append(key).append("=").append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                ExceptionUtil.rethrow(e);
            }
            this.parameters.put(key, value);
            return this;
        }

        public String build() {
            return this.builder.toString();
        }
    }
}

