/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.IController;
import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.context.impl.JobContextImpl;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.DecisionControllerImpl;
import com.ibm.jbatch.container.impl.ExecutionElementControllerFactory;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.jsl.ExecutionElement;
import com.ibm.jbatch.container.jsl.IllegalTransitionException;
import com.ibm.jbatch.container.jsl.Transition;
import com.ibm.jbatch.container.jsl.TransitionElement;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.End;
import com.ibm.jbatch.jsl.model.Fail;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.jsl.model.Stop;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

public class ExecutionTransitioner {
    private static final String CLASSNAME = ExecutionTransitioner.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private RuntimeJobExecution jobExecution;
    private long rootJobExecutionId;
    private ModelNavigator<?> modelNavigator;
    private volatile IExecutionElementController currentStoppableElementController;
    private IExecutionElementController previousElementController;
    private ExecutionElement currentExecutionElement = null;
    private ExecutionElement previousExecutionElement = null;
    private JobContextImpl jobContext;
    private BlockingQueue<PartitionDataWrapper> analyzerQueue = null;
    private List<Long> stepExecIds;

    public ExecutionTransitioner(RuntimeJobExecution jobExecution, long rootJobExecutionId, ModelNavigator<?> modelNavigator) {
        this.jobExecution = jobExecution;
        this.rootJobExecutionId = rootJobExecutionId;
        this.modelNavigator = modelNavigator;
        this.jobContext = jobExecution.getJobContext();
    }

    public ExecutionTransitioner(RuntimeJobExecution jobExecution, long rootJobExecutionId, ModelNavigator<JSLJob> jobNavigator, BlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this.jobExecution = jobExecution;
        this.rootJobExecutionId = rootJobExecutionId;
        this.modelNavigator = jobNavigator;
        this.jobContext = jobExecution.getJobContext();
        this.analyzerQueue = analyzerQueue;
    }

    public ExecutionStatus doExecutionLoop() {
        Transition nextTransition;
        String methodName = "doExecutionLoop";
        try {
            this.currentExecutionElement = this.modelNavigator.getFirstExecutionElement(this.jobExecution.getRestartOn());
        }
        catch (IllegalTransitionException e) {
            String errorMsg = "Could not transition to first execution element within job.";
            logger.warning(errorMsg);
            throw new IllegalArgumentException(errorMsg, e);
        }
        logger.fine("First execution element = " + this.currentExecutionElement.getId());
        while (true) {
            IExecutionElementController currentElementController;
            if (this.jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                logger.fine("doExecutionLoop Exiting execution loop as job is now in stopping state.");
                return new ExecutionStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
            }
            this.currentStoppableElementController = currentElementController = this.getNextElementController();
            ExecutionStatus status = currentElementController.execute();
            if ((this.currentExecutionElement instanceof Split || this.currentExecutionElement instanceof Flow) && !status.getExtendedBatchStatus().equals((Object)ExtendedBatchStatus.NORMAL_COMPLETION)) {
                logger.fine("Breaking out of loop with return status = " + status.getExtendedBatchStatus().name());
                return status;
            }
            if (this.jobContext.getBatchStatus().equals((Object)BatchStatus.FAILED)) {
                String errorMsg = "Sub-execution returned its own BatchStatus of FAILED.  Deal with this by throwing exception to the next layer.";
                logger.warning(errorMsg);
                throw new BatchContainerRuntimeException(errorMsg);
            }
            this.currentStoppableElementController = null;
            logger.fine("Done executing element=" + this.currentExecutionElement.getId() + ", exitStatus=" + status.getExitStatus());
            if (this.jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                logger.fine("doExecutionLoop Exiting as job has been stopped");
                return new ExecutionStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
            }
            nextTransition = null;
            try {
                nextTransition = this.modelNavigator.getNextTransition(this.currentExecutionElement, status);
            }
            catch (IllegalTransitionException e) {
                String errorMsg = "Problem transitioning to next execution element.";
                logger.warning(errorMsg);
                throw new BatchContainerRuntimeException(errorMsg, e);
            }
            if (nextTransition.isFinishedTransitioning()) {
                logger.fine("doExecutionLoopNo next execution element, and no transition element found either.  Looks like we're done and ready for COMPLETED state.");
                this.stepExecIds = currentElementController.getLastRunStepExecutions();
                return new ExecutionStatus(ExtendedBatchStatus.NORMAL_COMPLETION, status.getExitStatus());
            }
            if (nextTransition.noTransitionElementMatchedAfterException()) {
                return new ExecutionStatus(ExtendedBatchStatus.EXCEPTION_THROWN, status.getExitStatus());
            }
            if (nextTransition.getNextExecutionElement() == null) break;
            this.previousExecutionElement = this.currentExecutionElement;
            this.previousElementController = currentElementController;
            this.currentExecutionElement = nextTransition.getNextExecutionElement();
        }
        if (nextTransition.getTransitionElement() != null) {
            ExecutionStatus terminatingStatus = this.handleTerminatingTransitionElement(nextTransition.getTransitionElement());
            logger.finer("doExecutionLoop , Breaking out of execution loop after processing terminating transition element.");
            return terminatingStatus;
        }
        throw new IllegalStateException("Not sure how we'd end up in this state...aborting rather than looping.");
    }

    private IExecutionElementController getNextElementController() {
        IExecutionElementController elementController = null;
        if (this.currentExecutionElement instanceof Decision) {
            Decision decision = (Decision)this.currentExecutionElement;
            DecisionControllerImpl decisionController = elementController = ExecutionElementControllerFactory.getDecisionController(this.jobExecution, decision);
            decisionController.setPreviousStepExecutions(this.previousExecutionElement, this.previousElementController);
        } else if (this.currentExecutionElement instanceof Flow) {
            Flow flow = (Flow)this.currentExecutionElement;
            elementController = ExecutionElementControllerFactory.getFlowController(this.jobExecution, flow, this.rootJobExecutionId);
        } else if (this.currentExecutionElement instanceof Split) {
            Split split = (Split)this.currentExecutionElement;
            elementController = ExecutionElementControllerFactory.getSplitController(this.jobExecution, split, this.rootJobExecutionId);
        } else if (this.currentExecutionElement instanceof Step) {
            Step step = (Step)this.currentExecutionElement;
            StepContextImpl stepContext = new StepContextImpl(step.getId());
            elementController = ExecutionElementControllerFactory.getStepController(this.jobExecution, step, stepContext, this.rootJobExecutionId, this.analyzerQueue);
        }
        logger.fine("Next execution element controller = " + elementController);
        return elementController;
    }

    private ExecutionStatus handleTerminatingTransitionElement(TransitionElement transitionElement) {
        ExecutionStatus retVal;
        logger.fine("Found terminating transition element (stop, end, or fail).");
        if (transitionElement instanceof Stop) {
            Stop stopElement = (Stop)transitionElement;
            String restartOn = stopElement.getRestart();
            String exitStatusFromJSL = stopElement.getExitStatus();
            logger.fine("Next transition element is a <stop> : " + transitionElement + " with restartOn=" + restartOn + " , and JSL exit status = " + exitStatusFromJSL);
            retVal = new ExecutionStatus(ExtendedBatchStatus.JSL_STOP);
            if (exitStatusFromJSL != null) {
                this.jobContext.setExitStatus(exitStatusFromJSL);
                retVal.setExitStatus(exitStatusFromJSL);
            }
            if (restartOn != null) {
                this.jobContext.setRestartOn(restartOn);
                retVal.setRestartOn(restartOn);
            }
        } else if (transitionElement instanceof End) {
            End endElement = (End)transitionElement;
            String exitStatusFromJSL = endElement.getExitStatus();
            logger.fine("Next transition element is an <end> : " + transitionElement + " with JSL exit status = " + exitStatusFromJSL);
            retVal = new ExecutionStatus(ExtendedBatchStatus.JSL_END);
            if (exitStatusFromJSL != null) {
                this.jobContext.setExitStatus(exitStatusFromJSL);
                retVal.setExitStatus(exitStatusFromJSL);
            }
        } else if (transitionElement instanceof Fail) {
            Fail failElement = (Fail)transitionElement;
            String exitStatusFromJSL = failElement.getExitStatus();
            logger.fine("Next transition element is a <fail> : " + transitionElement + " with JSL exit status = " + exitStatusFromJSL);
            retVal = new ExecutionStatus(ExtendedBatchStatus.JSL_FAIL);
            if (exitStatusFromJSL != null) {
                this.jobContext.setExitStatus(exitStatusFromJSL);
                retVal.setExitStatus(exitStatusFromJSL);
            }
        } else {
            throw new IllegalStateException("Not sure how we'd get here...aborting.");
        }
        return retVal;
    }

    public IController getCurrentStoppableElementController() {
        return this.currentStoppableElementController;
    }

    public List<Long> getStepExecIds() {
        return this.stepExecIds;
    }
}

