/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.AbstractConnectorResourceDescriptor;
import com.sun.enterprise.deployment.AdministeredObjectDefinitionDescriptor;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.CommonResourceValidator;
import com.sun.enterprise.deployment.ConnectionFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.JMSDestinationDefinitionDescriptor;
import com.sun.enterprise.deployment.MailSessionDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import com.sun.enterprise.deployment.util.ComponentValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.EnvEntriesValidator;
import com.sun.enterprise.deployment.util.ManagedBeanVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.DescriptorVisitor;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="application_deploy")
public class ApplicationValidator
extends ComponentValidator
implements ApplicationVisitor,
ManagedBeanVisitor {
    private HashMap<String, CommonResourceValidator> allResourceDescriptors = new HashMap();
    private HashMap<String, Vector> validNameSpaceDetails = new HashMap();
    private final String APPCLIENT_KEYS = "APPCLIENT_KEYS";
    private final String EJBBUNDLE_KEYS = "EJBBUNDLE_KEYS";
    private final String APP_KEYS = "APP_KEYS";
    private final String WEBBUNDLE_KEYS = "WEBBUNDLE_KEYS";
    private final String EJB_KEYS = "EJB_KEYS";
    private final String CONNECTOR_KEYS = "CONNECTOR_KEYS";
    final String JNDI_COMP = "java:comp";
    final String JNDI_MODULE = "java:module";
    final String JNDI_APP = "java:app";
    private boolean allUniqueResource = true;
    String inValidJndiName = "";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationValidator.class);
    @LogMessageInfo(message="Application validation failed for application: {0}, jndi-name: {1}, resource adapter name: {2} is wrong.", level="SEVERE", cause="For embedded resource adapter, its name should begin with '#' symbol", action="Remove application name before the '#' symbol in the resource adapter name.", comment="For the method validateResourceDescriptor of com.sun.enterprise.deployment.util.ApplicationValidator")
    private static final String RESOURCE_ADAPTER_NAME_INVALID = "AS-DEPLOYMENT-00020";

    @Override
    public void accept(BundleDescriptor descriptor) {
        if (descriptor instanceof Application) {
            Application application = (Application)descriptor;
            this.accept(application);
            if (!this.validateResourceDescriptor(application)) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "DEP0001:Application validation fails for given application: {0}", new Object[]{application.getAppName()});
                throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.util.application.fail", "Application validation fails for given application {0} for jndi-name {1}", application.getAppName(), this.inValidJndiName));
            }
            this.validateEnvEntries(application);
            for (BundleDescriptor ebd : application.getBundleDescriptorsOfType(DOLUtils.ejbType())) {
                ebd.visit(this.getSubDescriptorVisitor(ebd));
            }
            for (BundleDescriptor wbd : application.getBundleDescriptorsOfType(DOLUtils.warType())) {
                if (wbd == null) continue;
                wbd.visit(this.getSubDescriptorVisitor(wbd));
            }
            for (BundleDescriptor cd : application.getBundleDescriptorsOfType(DOLUtils.rarType())) {
                cd.visit(this.getSubDescriptorVisitor(cd));
            }
            for (BundleDescriptor acd : application.getBundleDescriptorsOfType(DOLUtils.carType())) {
                acd.visit(this.getSubDescriptorVisitor(acd));
            }
            for (InjectionCapable injectable : application.getInjectableResources(application)) {
                this.accept(injectable);
            }
            super.accept(descriptor);
        } else {
            super.accept(descriptor);
        }
    }

    @Override
    public void accept(Application application) {
        this.application = application;
        if (application.getBundleDescriptors().size() == 0) {
            throw new IllegalArgumentException("Application [" + application.getRegistrationName() + "] contains no valid components");
        }
        ArrayList<ModuleDescriptor<BundleDescriptor>> conflicted = new ArrayList<ModuleDescriptor<BundleDescriptor>>();
        Set<ModuleDescriptor<BundleDescriptor>> modules = application.getModules();
        for (ModuleDescriptor<BundleDescriptor> module : modules) {
            if (conflicted.contains(module)) continue;
            boolean foundConflictedModule = false;
            for (ModuleDescriptor<BundleDescriptor> module2 : modules) {
                if (conflicted.contains(module2) || module.equals(module2) || !module.getModuleName().equals(module2.getModuleName())) continue;
                conflicted.add(module2);
                foundConflictedModule = true;
            }
            if (!foundConflictedModule) continue;
            conflicted.add(module);
        }
        for (ModuleDescriptor<BundleDescriptor> cModule : conflicted) {
            cModule.setModuleName(cModule.getModuleName() + cModule.getModuleType().toString());
        }
    }

    public void accept(EjbBundleDescriptor bundleDescriptor) {
        this.bundleDescriptor = bundleDescriptor;
        this.application = bundleDescriptor.getApplication();
        super.accept(bundleDescriptor);
        String rlm = this.application.getRealm();
        if (rlm != null) {
            for (EjbDescriptor ejbDescriptor : bundleDescriptor.getEjbs()) {
                for (EjbIORConfigurationDescriptor desc : ejbDescriptor.getIORConfigurationDescriptors()) {
                    desc.setRealmName(rlm);
                }
            }
        }
    }

    @Override
    public void accept(ManagedBeanDescriptor managedBean) {
        this.bundleDescriptor = managedBean.getBundle();
        this.application = this.bundleDescriptor.getApplication();
        for (EjbReference aRef : managedBean.getEjbReferenceDescriptors()) {
            this.accept(aRef);
        }
        for (Object next : managedBean.getResourceReferenceDescriptors()) {
            this.accept((ResourceReferenceDescriptor)next);
        }
        for (Object next : managedBean.getResourceEnvReferenceDescriptors()) {
            this.accept((ResourceEnvReferenceDescriptor)next);
        }
        for (Object next : managedBean.getMessageDestinationReferenceDescriptors()) {
            this.accept((MessageDestinationReferencer)next);
        }
        Set serviceRefs = managedBean.getServiceReferenceDescriptors();
        Iterator itr = serviceRefs.iterator();
        while (itr.hasNext()) {
            this.accept((ServiceReferenceDescriptor)itr.next());
        }
    }

    @Override
    protected Collection<EjbDescriptor> getEjbDescriptors() {
        if (this.application != null) {
            return this.application.getEjbDescriptors();
        }
        return new HashSet<EjbDescriptor>();
    }

    @Override
    protected Application getApplication() {
        return this.application;
    }

    @Override
    protected BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    @Override
    public DescriptorVisitor getSubDescriptorVisitor(Descriptor subDescriptor) {
        if (subDescriptor instanceof BundleDescriptor) {
            return ((BundleDescriptor)subDescriptor).getBundleVisitor();
        }
        return super.getSubDescriptorVisitor(subDescriptor);
    }

    public boolean validateResourceDescriptor(Application application) {
        String APP_LEVEL = "AppLevel:";
        String EJBBUNDLE_LEVEL = "EBDLevel:";
        String EJB_LEVEL = "EJBLevel:";
        String APPCLIENTBUNDLE_LEVEL = "ACDevel:";
        String APPCLIENT_LEVEL = "ACLevel:";
        String WEBBUNDLE_LEVEL = "WBDLevel:";
        Set<EnvironmentProperty> environmentProperties = application.getEnvironmentProperties();
        for (EnvironmentProperty environmentProperty : environmentProperties) {
            String jndiName = environmentProperty.getName();
            if (environmentProperty.hasLookupName()) {
                jndiName = environmentProperty.getLookupName();
            } else if (environmentProperty.getMappedName().length() > 0) {
                jndiName = environmentProperty.getMappedName();
            }
            if (!jndiName.startsWith("java:comp") && !jndiName.startsWith("java:module")) continue;
            this.inValidJndiName = jndiName;
            return false;
        }
        Application commonResourceBundleDescriptor = application;
        Vector<String> appLevel = new Vector<String>();
        if (commonResourceBundleDescriptor != null) {
            Set<ResourceDescriptor> resourceDescriptors = commonResourceBundleDescriptor.getAllResourcesDescriptors();
            if (this.findExistingDescriptors(resourceDescriptors, "AppLevel:" + commonResourceBundleDescriptor.getName())) {
                return false;
            }
            appLevel.add("AppLevel:" + commonResourceBundleDescriptor.getName());
            this.validNameSpaceDetails.put("APP_KEYS", appLevel);
        }
        Set<ApplicationClientDescriptor> appClientDescs = application.getBundleDescriptors(ApplicationClientDescriptor.class);
        Vector<String> appClientLevel = new Vector<String>();
        for (ApplicationClientDescriptor acd : appClientDescs) {
            Set<ResourceDescriptor> resourceDescriptors = acd.getAllResourcesDescriptors(ApplicationClientDescriptor.class);
            if (this.findExistingDescriptors(resourceDescriptors, "ACDevel:" + acd.getName())) {
                return false;
            }
            appClientLevel.add("ACDevel:" + acd.getName());
        }
        this.validNameSpaceDetails.put("APPCLIENT_KEYS", appClientLevel);
        Set<ConnectorDescriptor> connectorDescs = application.getBundleDescriptors(ConnectorDescriptor.class);
        Vector<String> cdLevel = new Vector<String>();
        for (ConnectorDescriptor cd : connectorDescs) {
            Set<ResourceDescriptor> resourceDescriptors = cd.getAllResourcesDescriptors(ApplicationClientDescriptor.class);
            if (this.findExistingDescriptors(resourceDescriptors, "ACLevel:" + cd.getName())) {
                return false;
            }
            cdLevel.add("ACLevel:" + cd.getName());
        }
        this.validNameSpaceDetails.put("CONNECTOR_KEYS", cdLevel);
        Set<EjbBundleDescriptor> ejbBundleDescs = application.getBundleDescriptors(EjbBundleDescriptor.class);
        Vector<String> ebdLevel = new Vector<String>();
        Vector<String> edLevel = new Vector<String>();
        for (EjbBundleDescriptor ebd : ejbBundleDescs) {
            Set<ResourceDescriptor> resourceDescriptors = ebd.getAllResourcesDescriptors();
            if (this.findExistingDescriptors(resourceDescriptors, "EBDLevel:" + ebd.getName())) {
                return false;
            }
            ebdLevel.add("EBDLevel:" + ebd.getName());
            Set<? extends EjbDescriptor> ejbDescriptors = ebd.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                resourceDescriptors = ejbDescriptor.getAllResourcesDescriptors();
                if (this.findExistingDescriptors(resourceDescriptors, "EJBLevel:" + ebd.getName() + "#" + ejbDescriptor.getName())) {
                    return false;
                }
                edLevel.add("EJBLevel:" + ebd.getName() + "#" + ejbDescriptor.getName());
            }
        }
        this.validNameSpaceDetails.put("EJBBUNDLE_KEYS", ebdLevel);
        this.validNameSpaceDetails.put("EJB_KEYS", edLevel);
        Set<WebBundleDescriptor> webBundleDescs = application.getBundleDescriptors(WebBundleDescriptor.class);
        Vector<String> wbdLevel = new Vector<String>();
        for (WebBundleDescriptor wbd : webBundleDescs) {
            Set<ResourceDescriptor> resourceDescriptors = wbd.getAllResourcesDescriptors();
            if (this.findExistingDescriptors(resourceDescriptors, "WBDLevel:" + wbd.getName())) {
                return false;
            }
            wbdLevel.add("WBDLevel:" + wbd.getName());
        }
        this.validNameSpaceDetails.put("WEBBUNDLE_KEYS", wbdLevel);
        for (CommonResourceValidator rv : this.allResourceDescriptors.values()) {
            AbstractConnectorResourceDescriptor abstractConnectorResourceDescriptor;
            Descriptor desc = rv.getDescriptor();
            if (!(desc instanceof AbstractConnectorResourceDescriptor) || (abstractConnectorResourceDescriptor = (AbstractConnectorResourceDescriptor)desc).getResourceAdapter() == null) continue;
            int poundIndex = abstractConnectorResourceDescriptor.getResourceAdapter().indexOf("#");
            if (poundIndex == 0) {
                abstractConnectorResourceDescriptor.setResourceAdapter(application.getName() + abstractConnectorResourceDescriptor.getResourceAdapter());
                continue;
            }
            if (poundIndex < 0 || poundIndex <= 0) continue;
            deplLogger.log(Level.SEVERE, RESOURCE_ADAPTER_NAME_INVALID, new Object[]{application.getAppName(), abstractConnectorResourceDescriptor.getName(), abstractConnectorResourceDescriptor.getResourceAdapter()});
            return false;
        }
        if (this.allUniqueResource) {
            return this.compareDescriptors();
        }
        return this.allUniqueResource;
    }

    private void validateEnvEntries(Application application) {
        EnvEntriesValidator envValidator = new EnvEntriesValidator();
        envValidator.validateEnvEntries(application);
        Set<ApplicationClientDescriptor> appClientDescs = application.getBundleDescriptors(ApplicationClientDescriptor.class);
        for (ApplicationClientDescriptor acd : appClientDescs) {
            envValidator.validateEnvEntries(acd);
        }
        Set<EjbBundleDescriptor> ejbBundleDescs = application.getBundleDescriptors(EjbBundleDescriptor.class);
        for (EjbBundleDescriptor ebd : ejbBundleDescs) {
            Set<? extends EjbDescriptor> ejbDescriptors = ebd.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                envValidator.validateEnvEntries(ejbDescriptor);
            }
        }
        Set<WebBundleDescriptor> webBundleDescs = application.getBundleDescriptors(WebBundleDescriptor.class);
        for (WebBundleDescriptor wbd : webBundleDescs) {
            envValidator.validateEnvEntries(wbd);
        }
    }

    private boolean findExistingDescriptors(Set<ResourceDescriptor> descriptors, String scope) {
        for (ResourceDescriptor descriptor : descriptors) {
            if (!this.isExistsDescriptor(descriptor.getName(), descriptor, scope)) continue;
            return true;
        }
        return false;
    }

    private boolean isExistsDescriptor(String name, ResourceDescriptor descriptor, String scope) {
        if (descriptor != null) {
            CommonResourceValidator commonResourceValidator = this.allResourceDescriptors.get(name);
            if (commonResourceValidator != null) {
                Vector vectorScope;
                Descriptor existingDescriptor = commonResourceValidator.getDescriptor();
                if (descriptor instanceof MailSessionDescriptor && existingDescriptor instanceof MailSessionDescriptor) {
                    if (!descriptor.equals(existingDescriptor)) {
                        this.allUniqueResource = false;
                        return true;
                    }
                    if (existingDescriptor != descriptor) {
                        DOLUtils.getDefaultLogger().log(Level.SEVERE, "DEP0001:Application validation fails for given application: {0}", new Object[]{descriptor.getName()});
                    }
                } else if (descriptor instanceof DataSourceDefinitionDescriptor && existingDescriptor instanceof DataSourceDefinitionDescriptor) {
                    if (!descriptor.equals(existingDescriptor)) {
                        this.allUniqueResource = false;
                        return true;
                    }
                    if (existingDescriptor != descriptor) {
                        DOLUtils.getDefaultLogger().log(Level.SEVERE, "DEP0002:Duplicate descriptor found for given jndi-name: {0}", new Object[]{descriptor.getName()});
                    }
                } else if (descriptor instanceof ConnectionFactoryDefinitionDescriptor && existingDescriptor instanceof ConnectionFactoryDefinitionDescriptor) {
                    if (!descriptor.equals(existingDescriptor)) {
                        this.allUniqueResource = false;
                        return true;
                    }
                    if (existingDescriptor != descriptor) {
                        DOLUtils.getDefaultLogger().log(Level.SEVERE, "DEP0002:Duplicate descriptor found for given jndi-name: {0}", new Object[]{descriptor.getName()});
                    }
                } else if (descriptor instanceof AdministeredObjectDefinitionDescriptor && existingDescriptor instanceof AdministeredObjectDefinitionDescriptor) {
                    if (!descriptor.equals(existingDescriptor)) {
                        this.allUniqueResource = false;
                        return true;
                    }
                    if (existingDescriptor != descriptor) {
                        DOLUtils.getDefaultLogger().log(Level.SEVERE, "DEP0002:Duplicate descriptor found for given jndi-name: {0}", new Object[]{descriptor.getName()});
                    }
                }
                if ((vectorScope = commonResourceValidator.getScope()) != null) {
                    vectorScope.add(scope);
                }
                commonResourceValidator.setScope(vectorScope);
                this.allResourceDescriptors.put(name, commonResourceValidator);
            } else {
                Vector<String> vectorScope = new Vector<String>();
                vectorScope.add(scope);
                this.allResourceDescriptors.put(name, new CommonResourceValidator(descriptor, name, vectorScope));
            }
        }
        return false;
    }

    private boolean compareDescriptors() {
        Vector appVectorName = this.validNameSpaceDetails.get("APP_KEYS");
        Vector ebdVectorName = this.validNameSpaceDetails.get("EJBBUNDLE_KEYS");
        for (String key : this.allResourceDescriptors.keySet()) {
            int j;
            String scope;
            int i;
            CommonResourceValidator commonResourceValidator = this.allResourceDescriptors.get(key);
            Vector scopeVector = commonResourceValidator.getScope();
            String jndiName = commonResourceValidator.getJndiName();
            if (jndiName.contains("java:comp")) {
                for (i = 0; i < scopeVector.size(); ++i) {
                    scope = (String)scopeVector.get(i);
                    for (j = 0; j < appVectorName.size(); ++j) {
                        if (!scope.equals(appVectorName.get(j))) continue;
                        this.inValidJndiName = jndiName;
                        DOLUtils.getDefaultLogger().log(Level.SEVERE, "DEP0005:Deployment failed due to the invalid scope defined for jndi-name: {0}", new Object[]{jndiName});
                        return false;
                    }
                    for (j = 0; j < ebdVectorName.size(); ++j) {
                        if (!scope.equals(ebdVectorName.get(j))) continue;
                        this.inValidJndiName = jndiName;
                        DOLUtils.getDefaultLogger().log(Level.SEVERE, "DEP0005:Deployment failed due to the invalid scope defined for jndi-name: {0}", new Object[]{jndiName});
                        return false;
                    }
                }
            }
            if (jndiName.contains("java:module")) {
                for (i = 0; i < scopeVector.size(); ++i) {
                    scope = (String)scopeVector.get(i);
                    for (j = 0; j < appVectorName.size(); ++j) {
                        if (!scope.equals(appVectorName.get(j))) continue;
                        this.inValidJndiName = jndiName;
                        DOLUtils.getDefaultLogger().log(Level.SEVERE, "DEP0005:Deployment failed due to the invalid scope defined for jndi-name: {0}", new Object[]{jndiName});
                        return false;
                    }
                }
            }
            if (scopeVector.size() <= 1) continue;
            if (jndiName.contains("java:comp")) {
                if (this.compareVectorForComp(scopeVector, jndiName)) continue;
                return false;
            }
            if (jndiName.contains("java:module")) {
                if (this.compareVectorForModule(scopeVector, jndiName)) continue;
                return false;
            }
            if (jndiName.contains("java:app")) {
                if (this.compareVectorForApp(scopeVector, jndiName)) continue;
                return false;
            }
            try {
                InitialContext ic;
                Object lookup;
                boolean selfDefining = commonResourceValidator.getDescriptor() instanceof JMSDestinationDefinitionDescriptor || commonResourceValidator.getDescriptor() instanceof DataSourceDefinitionDescriptor;
                if (selfDefining || (lookup = (ic = new InitialContext()).lookup(jndiName)) == null) continue;
                return false;
            }
            catch (NamingException e) {
                this.inValidJndiName = jndiName;
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "DEP0003:Lookup failed for given jndi-name: {0}", new Object[]{jndiName});
            }
        }
        return true;
    }

    private boolean compareVectorForApp(Vector myVector, String jndiName) {
        for (int j = 0; j < myVector.size(); ++j) {
            String firstElement = (String)myVector.get(j);
            if (firstElement.contains("#")) {
                firstElement = firstElement.substring(0, firstElement.indexOf("#"));
            }
            for (int i = j + 1; i < myVector.size(); ++i) {
                String otherElements = (String)myVector.get(i);
                if (otherElements.contains("#")) {
                    otherElements = otherElements.substring(0, otherElements.indexOf("#"));
                }
                if (!firstElement.equals(otherElements)) continue;
                this.inValidJndiName = jndiName;
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "DEP0004:Deployment failed due to the conflict occur for jndi-name: {0} for application: {1}", new Object[]{jndiName, this.application.getAppName()});
            }
        }
        return true;
    }

    private boolean compareVectorForModule(Vector myVector, String jndiName) {
        if (!this.compareVectorForApp(myVector, jndiName)) {
            return false;
        }
        for (int j = 0; j < myVector.size(); ++j) {
            String firstElement = (String)myVector.firstElement();
            if (firstElement.contains("#")) {
                firstElement = firstElement.substring(firstElement.indexOf("#") + 1, firstElement.length());
            }
            if (firstElement.contains("#")) {
                firstElement = firstElement.substring(0, firstElement.indexOf("#"));
            }
            for (int i = j + 1; i < myVector.size(); ++i) {
                String otherElements = (String)myVector.get(i);
                if (otherElements.contains("#")) {
                    otherElements = otherElements.substring(otherElements.indexOf("#") + 1, otherElements.length());
                }
                if (otherElements.contains("#")) {
                    otherElements = otherElements.substring(0, otherElements.indexOf("#"));
                }
                if (!firstElement.equals(otherElements)) continue;
                this.inValidJndiName = jndiName;
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.util.application.invalid.namespace", new Object[]{jndiName, this.application.getAppName()});
            }
        }
        return true;
    }

    private boolean compareVectorForComp(Vector myVector, String jndiName) {
        if (!this.compareVectorForModule(myVector, jndiName)) {
            return false;
        }
        for (int j = 0; j < myVector.size(); ++j) {
            String firstElement = (String)myVector.firstElement();
            if (firstElement.contains("#")) {
                firstElement = firstElement.substring(firstElement.lastIndexOf("#") + 1, firstElement.length());
            }
            if (firstElement.contains("#")) {
                firstElement = firstElement.substring(firstElement.lastIndexOf("#") + 1, firstElement.length());
            }
            for (int i = j + 1; i < myVector.size(); ++i) {
                String otherElements = (String)myVector.get(i);
                if (otherElements.contains("#")) {
                    otherElements = otherElements.substring(otherElements.lastIndexOf("#") + 1, otherElements.length());
                }
                if (otherElements.contains("#")) {
                    otherElements = otherElements.substring(otherElements.lastIndexOf("#") + 1, otherElements.length());
                }
                if (!firstElement.equals(otherElements)) continue;
                this.inValidJndiName = jndiName;
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.util.application.invalid.namespace", new Object[]{jndiName, this.application.getAppName()});
                return false;
            }
        }
        return true;
    }
}

