/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor.stats;

import com.sun.enterprise.v3.services.impl.monitor.stats.ThreadPoolStatsProvider;
import java.util.ArrayList;
import java.util.Set;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="thread-pool-mon", group="monitoring")
@ManagedObject
@Description(value="Thread Pool Statistics")
public class ThreadPoolStatsProviderGlobal
extends ThreadPoolStatsProvider {
    public ThreadPoolStatsProviderGlobal(String name) {
        super(name);
    }

    @Override
    @ManagedAttribute(id="currentthreadcount")
    @Description(value="Provides the number of request processing threads currently in the listener thread pool")
    public CountStatistic getCurrentThreadCount() {
        this.countThreadsInThreadPools();
        return this.currentThreadCount;
    }

    @Override
    @ManagedAttribute(id="currentthreadsbusy")
    @Description(value="Provides the number of request processing threads currently in use in the listener thread pool serving requests.")
    public CountStatistic getCurrentThreadsBusy() {
        this.countThreadsInThreadPools();
        return this.currentThreadsBusy;
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:setMaxThreadsEvent")
    public void setMaxThreadsEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="maxNumberOfThreads") int maxNumberOfThreads) {
        this.maxThreadsCount.setCount(maxNumberOfThreads);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:setCoreThreadsEvent")
    public void setCoreThreadsEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="coreNumberOfThreads") int coreNumberOfThreads) {
        this.coreThreadsCount.setCount(coreNumberOfThreads);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:threadReturnedToPoolEvent")
    public void threadReturnedToPoolEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="threadId") long threadId) {
        this.totalExecutedTasksCount.increment();
    }

    private void countThreadsInThreadPools() {
        this.currentThreadCount.setCount(0L);
        this.currentThreadsBusy.setCount(0L);
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        ArrayList<String> alreadyCounted = new ArrayList<String>();
        block0: for (Thread thread : threads) {
            String threadName = thread.getName();
            for (String threadPoolName : threadPoolNames) {
                if (!thread.isAlive() || !threadName.contains(threadPoolName + "(") || alreadyCounted.contains(threadName)) continue;
                alreadyCounted.add(threadName);
                this.currentThreadCount.increment();
                if (thread.getState() != Thread.State.RUNNABLE) continue block0;
                this.currentThreadsBusy.increment();
                continue block0;
            }
        }
    }
}

