/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.micro.services;

import com.sun.enterprise.deployment.Application;
import fish.payara.appserver.micro.services.CDIEventListener;
import fish.payara.appserver.micro.services.PayaraClusterListener;
import fish.payara.appserver.micro.services.PayaraClusteredCDIEvent;
import fish.payara.appserver.micro.services.PayaraInternalEvent;
import fish.payara.appserver.micro.services.command.AsAdminCallable;
import fish.payara.appserver.micro.services.command.ClusterCommandResult;
import fish.payara.appserver.micro.services.data.ApplicationDescriptor;
import fish.payara.appserver.micro.services.data.InstanceDescriptor;
import fish.payara.nucleus.cluster.PayaraCluster;
import fish.payara.nucleus.eventbus.ClusterMessage;
import fish.payara.nucleus.eventbus.MessageReceiver;
import fish.payara.nucleus.events.HazelcastEvents;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-instance")
@RunLevel(value=10)
public class PayaraInstance
implements EventListener,
MessageReceiver {
    public static final String INSTANCE_STORE_NAME = "payara.instance.store";
    public static final String INTERNAL_EVENTS_NAME = "payara.micro.cluster.event";
    public static final String CDI_EVENTS_NAME = "payara.micro.cdi.event";
    public static final String APPLICATIONS_STORE_NAME = "payara.micro.applications.store";
    private static final org.jboss.logging.Logger logger = org.jboss.logging.Logger.getLogger(PayaraInstance.class);
    @Inject
    private PayaraCluster cluster;
    @Inject
    private ServerContext context;
    @Inject
    private Events events;
    @Inject
    private CommandRunner commandRunner;
    private HashSet<PayaraClusterListener> myListeners;
    private HashSet<CDIEventListener> myCDIListeners;
    private String myCurrentID;
    private String instanceName;
    private InstanceDescriptor me;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private HazelcastCore hazelcast;

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        this.me.setInstanceName(instanceName);
    }

    public <T extends Serializable> Map<String, Future<T>> runCallable(Collection<String> memberUUIDS, Callable<T> callable) {
        return this.cluster.getExecService().runCallable(memberUUIDS, callable);
    }

    public <T extends Serializable> Map<String, Future<T>> runCallable(Callable<T> callable) {
        return this.cluster.getExecService().runCallable(callable);
    }

    public ClusterCommandResult executeLocalAsAdmin(String command, String ... parameters) {
        return new ClusterCommandResult(this.commandRunner.run(command, parameters));
    }

    public Map<String, Future<ClusterCommandResult>> executeClusteredASAdmin(String command, String ... parameters) {
        AsAdminCallable callable = new AsAdminCallable(command, parameters);
        Map<String, Future<ClusterCommandResult>> result = this.cluster.getExecService().runCallable(callable);
        return result;
    }

    public Map<String, Future<ClusterCommandResult>> executeClusteredASAdmin(Collection<String> memberGUIDs, String command, String ... parameters) {
        AsAdminCallable callable = new AsAdminCallable(command, parameters);
        Map<String, Future<ClusterCommandResult>> result = this.cluster.getExecService().runCallable(memberGUIDs, callable);
        return result;
    }

    public void receiveMessage(ClusterMessage msg) {
        block9: {
            block8: {
                if (!(msg.getPayload() instanceof PayaraInternalEvent)) break block8;
                PayaraInternalEvent pie = (PayaraInternalEvent)PayaraInternalEvent.class.cast(msg.getPayload());
                switch (pie.getMessageType()) {
                    case ADDED: {
                        for (PayaraClusterListener myListener : this.myListeners) {
                            myListener.memberAdded(pie.getId());
                        }
                        break block9;
                    }
                    case REMOVED: {
                        for (PayaraClusterListener myListener : this.myListeners) {
                            myListener.memberRemoved(pie.getId());
                        }
                        break;
                    }
                }
                break block9;
            }
            if (msg.getPayload() instanceof PayaraClusteredCDIEvent) {
                PayaraClusteredCDIEvent cast = (PayaraClusteredCDIEvent)PayaraClusteredCDIEvent.class.cast(msg.getPayload());
                for (CDIEventListener myListener : this.myCDIListeners) {
                    if (!cast.isLoopBack() && cast.getInstanceDescriptor().getMemberUUID().equals(this.myCurrentID)) continue;
                    myListener.eventReceived(cast);
                }
            }
        }
    }

    @PostConstruct
    void postConstruct() {
        this.events.register(this);
        this.myListeners = new HashSet(1);
        this.myCDIListeners = new HashSet(1);
        this.initialiseInstanceDescriptor();
    }

    @Override
    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            PayaraInternalEvent pie = new PayaraInternalEvent(PayaraInternalEvent.MESSAGE.ADDED, this.me);
            ClusterMessage<PayaraInternalEvent> message = new ClusterMessage<PayaraInternalEvent>(pie);
            this.cluster.getEventBus().publish(INTERNAL_EVENTS_NAME, message);
        } else if (event.is(Deployment.APPLICATION_LOADED)) {
            if (event.hook() != null && event.hook() instanceof ApplicationInfo) {
                ApplicationInfo applicationInfo = (ApplicationInfo)event.hook();
                this.me.addApplication(applicationInfo);
                this.cluster.getClusteredStore().set(INSTANCE_STORE_NAME, (Serializable)((Object)this.myCurrentID), this.me);
            }
        } else if (event.is(Deployment.APPLICATION_PREPARED)) {
            if (event.hook() != null && event.hook() instanceof DeploymentContext) {
                DeploymentContext deploymentContext = (DeploymentContext)event.hook();
                Application app = deploymentContext.getModuleMetaData(Application.class);
                Long appID = (Long)this.cluster.getClusteredStore().get(APPLICATIONS_STORE_NAME, (Serializable)((Object)app.getName()));
                if (appID != null) {
                    app.setUniqueId(appID);
                } else {
                    this.cluster.getClusteredStore().set(APPLICATIONS_STORE_NAME, (Serializable)((Object)app.getName()), new Long(app.getUniqueId()));
                }
            }
        } else if (event.is(Deployment.APPLICATION_UNLOADED)) {
            if (event.hook() != null && event.hook() instanceof ApplicationInfo) {
                ApplicationInfo applicationInfo = (ApplicationInfo)event.hook();
                this.me.removeApplication(applicationInfo);
                this.cluster.getClusteredStore().set(INSTANCE_STORE_NAME, (Serializable)((Object)this.myCurrentID), this.me);
            }
        } else if (event.is(EventTypes.PREPARE_SHUTDOWN)) {
            PayaraInternalEvent pie = new PayaraInternalEvent(PayaraInternalEvent.MESSAGE.REMOVED, this.me);
            ClusterMessage<PayaraInternalEvent> message = new ClusterMessage<PayaraInternalEvent>(pie);
            this.cluster.getClusteredStore().remove(INSTANCE_STORE_NAME, (Serializable)((Object)this.myCurrentID));
            this.cluster.getEventBus().publish(INTERNAL_EVENTS_NAME, message);
        }
        if (event.is(HazelcastEvents.HAZELCAST_BOOTSTRAP_COMPLETE)) {
            this.initialiseInstanceDescriptor();
        }
    }

    public Set<InstanceDescriptor> getClusteredPayaras() {
        Set<String> members = this.cluster.getClusterMembers();
        HashSet<InstanceDescriptor> result = new HashSet<InstanceDescriptor>(members.size());
        for (String member : members) {
            InstanceDescriptor id = (InstanceDescriptor)this.cluster.getClusteredStore().get(INSTANCE_STORE_NAME, (Serializable)((Object)member));
            if (id == null) continue;
            result.add(id);
        }
        return result;
    }

    public void pubishCDIEvent(PayaraClusteredCDIEvent event) {
        if (event.getInstanceDescriptor() == null) {
            event.setInstanceDescriptor(this.me);
        }
        ClusterMessage<PayaraClusteredCDIEvent> message = new ClusterMessage<PayaraClusteredCDIEvent>(event);
        this.cluster.getEventBus().publish(CDI_EVENTS_NAME, message);
    }

    public void removeBootstrapListenr(PayaraClusterListener listener) {
        this.myListeners.remove(listener);
    }

    public void addBootstrapListener(PayaraClusterListener listener) {
        this.myListeners.add(listener);
    }

    public void removeCDIListenr(CDIEventListener listener) {
        this.myCDIListeners.remove(listener);
    }

    public void addCDIListener(CDIEventListener listener) {
        this.myCDIListeners.add(listener);
    }

    public InstanceDescriptor getLocalDescriptor() {
        return this.me;
    }

    public InstanceDescriptor getDescriptor(String member) {
        InstanceDescriptor result = null;
        if (this.cluster.isEnabled()) {
            result = (InstanceDescriptor)this.cluster.getClusteredStore().get(INSTANCE_STORE_NAME, (Serializable)((Object)member));
        }
        return result;
    }

    private void initialiseInstanceDescriptor() {
        boolean liteMember = false;
        int hazelcastPort = 5900;
        if (this.hazelcast.isEnabled()) {
            this.instanceName = this.hazelcast.getInstance().getCluster().getLocalMember().getStringAttribute("GLASSFISH-INSTANCE");
            this.myCurrentID = this.hazelcast.getInstance().getCluster().getLocalMember().getUuid();
            liteMember = this.hazelcast.getInstance().getCluster().getLocalMember().isLiteMember();
            hazelcastPort = this.hazelcast.getInstance().getCluster().getLocalMember().getSocketAddress().getPort();
        }
        String instanceType = this.environment.getRuntimeType().toString();
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ArrayList<Integer> sslPorts = new ArrayList<Integer>();
        int adminPort = 0;
        for (NetworkListener networkListener : this.context.getConfigBean().getConfig().getNetworkConfig().getNetworkListeners().getNetworkListener()) {
            if (!Boolean.parseBoolean(networkListener.getEnabled())) continue;
            if (networkListener.findProtocol().getSecurityEnabled().equals("false")) {
                if (networkListener.getName().equals(this.context.getConfigBean().getConfig().getAdminListener().getName())) {
                    if (instanceType.equals("MICRO")) {
                        ports.add(Integer.parseInt(networkListener.getPort()));
                    }
                    adminPort = Integer.parseInt(networkListener.getPort());
                    continue;
                }
                ports.add(Integer.parseInt(networkListener.getPort()));
                continue;
            }
            if (!networkListener.findProtocol().getSecurityEnabled().equals("true")) continue;
            if (networkListener.getName().equals(this.context.getConfigBean().getConfig().getAdminListener().getName())) {
                if (instanceType.equals("MICRO")) {
                    ports.add(Integer.parseInt(networkListener.getPort()));
                }
                adminPort = Integer.parseInt(networkListener.getPort());
                continue;
            }
            sslPorts.add(Integer.parseInt(networkListener.getPort()));
        }
        try {
            Collection<Object> deployedApplications = new ArrayList();
            if (this.me != null) {
                deployedApplications = this.me.getDeployedApplications();
            }
            this.me = new InstanceDescriptor(this.myCurrentID);
            this.me.setInstanceName(this.instanceName);
            Iterator<Object> i$ = ports.iterator();
            while (i$.hasNext()) {
                int n = (Integer)i$.next();
                this.me.addHttpPort(n);
            }
            i$ = sslPorts.iterator();
            while (i$.hasNext()) {
                int n = (Integer)i$.next();
                this.me.addHttpsPort(n);
            }
            this.me.setAdminPort(adminPort);
            this.me.setHazelcastPort(hazelcastPort);
            this.me.setLiteMember(liteMember);
            this.me.setInstanceType(instanceType);
            if (!deployedApplications.isEmpty()) {
                for (ApplicationDescriptor applicationDescriptor : deployedApplications) {
                    this.me.addApplication(applicationDescriptor);
                }
            }
            if (this.cluster.isEnabled()) {
                this.cluster.getEventBus().addMessageReceiver(INTERNAL_EVENTS_NAME, this);
                this.cluster.getEventBus().addMessageReceiver(CDI_EVENTS_NAME, this);
                this.cluster.getClusteredStore().set(INSTANCE_STORE_NAME, (Serializable)((Object)this.myCurrentID), this.me);
            }
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(PayaraInstance.class.getName()).log(Level.SEVERE, "Could not find local hostname", ex);
        }
    }

    public boolean isClustered() {
        return this.cluster.isEnabled();
    }
}

