/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.micro.services.data;

import fish.payara.appserver.micro.services.data.ApplicationDescriptor;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.glassfish.internal.data.ApplicationInfo;

public class InstanceDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String memberUUID;
    private String instanceName;
    private List<Integer> httpPorts;
    private List<Integer> httpsPorts;
    private InetAddress hostName = InetAddress.getLocalHost();
    private Map<String, ApplicationDescriptor> deployedApplications;
    private boolean liteMember;
    private String instanceType;
    private int hazelcastPort;
    private int adminPort;

    public InstanceDescriptor(String UUID2) throws UnknownHostException {
        this.memberUUID = UUID2;
        this.httpPorts = new ArrayList<Integer>();
        this.httpsPorts = new ArrayList<Integer>();
    }

    public void addApplication(ApplicationInfo info) {
        if (this.deployedApplications == null) {
            this.deployedApplications = new HashMap<String, ApplicationDescriptor>(3);
        }
        ApplicationDescriptor ad = new ApplicationDescriptor(info);
        this.deployedApplications.put(ad.getName(), ad);
    }

    public void addApplication(ApplicationDescriptor descriptor) {
        if (this.deployedApplications == null) {
            this.deployedApplications = new HashMap<String, ApplicationDescriptor>(3);
        }
        this.deployedApplications.put(descriptor.getName(), descriptor);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getMemberUUID() {
        return this.memberUUID;
    }

    public List<Integer> getHttpPorts() {
        return this.httpPorts;
    }

    public void addHttpPort(int httpPort) {
        this.httpPorts.add(httpPort);
    }

    public String toString() {
        return "InstanceDescriptor{memberUUID=" + this.memberUUID + ", httpPorts=" + this.httpPorts + ", httpsPorts=" + this.httpsPorts + ", hostName=" + this.hostName + ", deployedApplications=" + this.deployedApplications + '}';
    }

    public InetAddress getHostName() {
        return this.hostName;
    }

    public void setHostName(InetAddress hostName) {
        this.hostName = hostName;
    }

    public Collection<ApplicationDescriptor> getDeployedApplications() {
        if (this.deployedApplications == null) {
            return new HashSet<ApplicationDescriptor>();
        }
        return this.deployedApplications.values();
    }

    public List<Integer> getHttpsPorts() {
        return this.httpsPorts;
    }

    public void addHttpsPort(int httpsPort) {
        this.httpsPorts.add(httpsPort);
    }

    public void removeApplication(ApplicationInfo applicationInfo) {
        if (this.deployedApplications == null) {
            this.deployedApplications = new HashMap<String, ApplicationDescriptor>(3);
        }
        this.deployedApplications.remove(applicationInfo.getName());
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (InstanceDescriptor.class.isInstance(obj)) {
            InstanceDescriptor descriptor = (InstanceDescriptor)obj;
            result = this.memberUUID.equals(descriptor.memberUUID);
        }
        return result;
    }

    public int hashCode() {
        return this.memberUUID.hashCode();
    }

    public boolean isLiteMember() {
        return this.liteMember;
    }

    public void setLiteMember(boolean isLiteMember) {
        this.liteMember = isLiteMember;
    }

    public boolean isMicroInstance() {
        return this.instanceType.equals("MICRO");
    }

    public boolean isPayaraInstance() {
        return this.instanceType.equals("DAS") || this.instanceType.equals("INSTANCE");
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setHazelcastPort(int hazelcastPort) {
        this.hazelcastPort = hazelcastPort;
    }

    public int getHazelcastPort() {
        return this.hazelcastPort;
    }

    public void setAdminPort(int adminPort) {
        this.adminPort = adminPort;
    }

    public int getAdminPort() {
        return this.adminPort;
    }
}

