/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.timer.hazelcast;

import com.hazelcast.core.IMap;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBTimerSchedule;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import fish.payara.ejb.timer.hazelcast.HZTimer;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.TimerConfig;
import javax.transaction.TransactionManager;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.ScheduledTimerDescriptor;

public class HazelcastTimerStore
extends EJBTimerService {
    private static final String EJB_TIMER_CACHE_NAME = "HZEjbTmerCache";
    private static final String EJB_TIMER_CONTAINER_CACHE_NAME = "HZEjbTmerContainerCache";
    private static final String EJB_TIMER_APPLICAION_CACHE_NAME = "HZEjbTmerApplicationCache";
    private final IMap pkCache;
    private final IMap containerCache;
    private final IMap applicationCache;
    private final String serverName;
    private static final Logger logger = LogDomains.getLogger(HazelcastTimerStore.class, "javax.enterprise.system.container.ejb");

    static void init(HazelcastCore core) {
        try {
            EJBTimerService.setEJBTimerService(new HazelcastTimerStore(core));
        }
        catch (Exception ex) {
            Logger.getLogger(HazelcastTimerStore.class.getName()).log(Level.WARNING, "Problem when initialising Timer Store", ex);
        }
    }

    public HazelcastTimerStore(HazelcastCore core) throws Exception {
        this.pkCache = core.getInstance().getMap(EJB_TIMER_CACHE_NAME);
        this.containerCache = core.getInstance().getMap(EJB_TIMER_CONTAINER_CACHE_NAME);
        this.applicationCache = core.getInstance().getMap(EJB_TIMER_APPLICAION_CACHE_NAME);
        this.ownerIdOfThisServer_ = this.serverName = core.getInstance().getCluster().getLocalMember().getStringAttribute("GLASSFISH-INSTANCE");
        this.domainName_ = core.getInstance().getConfig().getGroupConfig().getName();
    }

    private void removeTimers(Set<TimerPrimaryKey> timerIdsToRemove) {
        for (TimerPrimaryKey timerPrimaryKey : timerIdsToRemove) {
            this.removeTimer((HZTimer)this.pkCache.get(timerPrimaryKey));
        }
    }

    @Override
    protected void _createTimer(TimerPrimaryKey timerId, long containerId, long applicationId, Object timedObjectPrimaryKey, String server_name, Date initialExpiration, long intervalDuration, EJBTimerSchedule schedule, TimerConfig timerConfig) throws Exception {
        if (timerConfig.isPersistent()) {
            boolean localTx;
            this.pkCache.put(timerId, new HZTimer(timerId, containerId, applicationId, timedObjectPrimaryKey, this.serverName, this.ownerIdOfThisServer_, initialExpiration, intervalDuration, schedule, timerConfig));
            HashSet<TimerPrimaryKey> keysForContainer = (HashSet<TimerPrimaryKey>)this.containerCache.get(containerId);
            if (keysForContainer == null) {
                keysForContainer = new HashSet<TimerPrimaryKey>();
            }
            keysForContainer.add(timerId);
            this.containerCache.put(containerId, keysForContainer);
            HashSet<TimerPrimaryKey> keysForApp = (HashSet<TimerPrimaryKey>)this.applicationCache.get(applicationId);
            if (keysForApp == null) {
                keysForApp = new HashSet<TimerPrimaryKey>();
            }
            keysForApp.add(timerId);
            this.applicationCache.put(applicationId, keysForApp);
            JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
            boolean bl = localTx = tm.getTransaction() == null;
            if (localTx) {
                tm.begin();
            }
            this.addTimerSynchronization(null, timerId.getTimerId(), initialExpiration, containerId, this.ownerIdOfThisServer_, true);
            if (localTx) {
                tm.commit();
            }
        } else {
            this.addTimerSynchronization(null, timerId.getTimerId(), initialExpiration, containerId, this.ownerIdOfThisServer_, false);
        }
    }

    @Override
    public void destroyAllTimers(long applicationId) {
        Set timerIds = (Set)this.applicationCache.get(applicationId);
        if (timerIds == null || timerIds.isEmpty()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "No timers to be deleted for id: " + applicationId);
            }
            return;
        }
        for (TimerPrimaryKey timerId : timerIds) {
            this.pkCache.remove(timerId);
        }
        logger.log(Level.INFO, "Destroyed {0} timers for application {1}", new Object[]{timerIds.size(), applicationId});
        timerIds.clear();
        this.applicationCache.remove(applicationId);
    }

    @Override
    public void destroyTimers(long containerId) {
        Set timerIds = (Set)this.containerCache.get(containerId);
        if (timerIds == null || timerIds.isEmpty()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "No timers to be deleted for id: " + containerId);
            }
            return;
        }
        logger.log(Level.INFO, "Destroyed {0} timers for container {1}", new Object[]{timerIds.size(), containerId});
        timerIds.clear();
        this.applicationCache.put(containerId, timerIds);
    }

    @Override
    protected void cancelTimer(TimerPrimaryKey timerId) throws FinderException, Exception {
        HZTimer timer;
        if (!this.cancelNonPersistentTimer(timerId) && (timer = (HZTimer)this.pkCache.get(timerId)) != null) {
            boolean localTx;
            JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
            boolean bl = localTx = tm.getTransaction() == null;
            if (localTx) {
                tm.begin();
            }
            EJBTimerService.getEJBTimerService().cancelTimerSynchronization(null, timerId, timer.getContainerId(), timer.getOwnerId());
            if (localTx) {
                tm.commit();
            }
        }
    }

    @Override
    protected Serializable getInfo(TimerPrimaryKey timerId) throws FinderException {
        if (!super.isPersistent(timerId)) {
            return super.getInfo(timerId);
        }
        HZTimer timer = (HZTimer)this.pkCache.get(timerId);
        if (timer == null) {
            throw new FinderException("Unable to find timer " + timerId);
        }
        return timer.getTimerConfig().getInfo();
    }

    @Override
    protected Date getNextTimeout(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt != null) {
            return this._getNextTimeout(rt);
        }
        HZTimer timer = this.getPersistentTimer(timerId);
        Date initialExpiration = timer.getInitialExpiration();
        long intervalDuration = timer.getIntervalDuration();
        EJBTimerSchedule ts = timer.getSchedule();
        Date nextTimeout = null;
        nextTimeout = ts != null ? this.getNextScheduledTimeout(ts) : (intervalDuration > 0L ? this.calcNextFixedRateExpiration(initialExpiration, intervalDuration) : initialExpiration);
        return nextTimeout;
    }

    @Override
    protected void cancelTimersByKey(long containerId, Object primaryKey) {
        Collection timers = (Collection)this.containerCache.get(containerId);
        if (timers != null) {
            HashSet<HZTimer> timersToCancel = new HashSet<HZTimer>();
            for (TimerPrimaryKey timer : timers) {
                HZTimer hzTimer = (HZTimer)this.pkCache.get(primaryKey);
                if (hzTimer == null || !hzTimer.getTimedObjectPk().equals(primaryKey)) continue;
                timersToCancel.add(hzTimer);
            }
            for (HZTimer hZTimer : timersToCancel) {
                this.removeTimer(hZTimer);
            }
        }
    }

    @Override
    public void createSchedules(long containerId, long applicationId, Map<MethodDescriptor, List<ScheduledTimerDescriptor>> methodDescriptorSchedules, String server_name) {
        JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
        try {
            tm.begin();
            Collection keys = (Collection)this.containerCache.get(containerId);
            if (keys == null || keys.isEmpty()) {
                this.createSchedules(containerId, applicationId, methodDescriptorSchedules, null, server_name, false, true);
            }
            tm.commit();
        }
        catch (Exception e) {
            this.recoverAndCreateSchedulesError(e, tm);
        }
    }

    @Override
    public void createSchedulesOnServer(EjbDescriptor ejbDescriptor, String server_name) {
        HashMap<MethodDescriptor, List<ScheduledTimerDescriptor>> schedules = new HashMap<MethodDescriptor, List<ScheduledTimerDescriptor>>();
        for (ScheduledTimerDescriptor schd : ejbDescriptor.getScheduledTimerDescriptors()) {
            ArrayList<ScheduledTimerDescriptor> list;
            MethodDescriptor method = schd.getTimeoutMethod();
            if (method == null || !schd.getPersistent()) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "... processing " + method);
            }
            if ((list = (ArrayList<ScheduledTimerDescriptor>)schedules.get(method)) == null) {
                list = new ArrayList<ScheduledTimerDescriptor>();
                schedules.put(method, list);
            }
            list.add(schd);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "EJBTimerService - creating schedules for " + ejbDescriptor.getUniqueId());
        }
        this.createSchedules(ejbDescriptor.getUniqueId(), ejbDescriptor.getApplication().getUniqueId(), schedules, server_name);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "EJBTimerService - finished processing schedules for BEAN ID: " + ejbDescriptor.getUniqueId());
        }
    }

    @Override
    protected void expungeTimer(TimerPrimaryKey timerId, boolean removeTimerBean) {
        HZTimer timer = (HZTimer)this.pkCache.get(timerId);
        if (timer != null) {
            this.removeTimer(timer);
        }
        super.expungeTimer(timerId, removeTimerBean);
    }

    @Override
    protected Collection<TimerPrimaryKey> getTimerIds(Collection<Long> containerIds) {
        Collection<TimerPrimaryKey> result = super.getTimerIds(containerIds);
        for (Long containerId : containerIds) {
            Collection colKeys = (Collection)this.containerCache.get(containerId);
            if (colKeys == null) continue;
            result.addAll(colKeys);
        }
        return result;
    }

    @Override
    protected Collection<TimerPrimaryKey> getTimerIds(long containerId, Object timedObjectPrimaryKey) {
        HashSet<TimerPrimaryKey> timerIdsForTimedObject = new HashSet<TimerPrimaryKey>();
        if (timedObjectPrimaryKey == null) {
            Collection contKeys = (Collection)this.containerCache.get(containerId);
            if (contKeys != null) {
                timerIdsForTimedObject.addAll(contKeys);
            }
        } else {
            Collection timersForTimedObject = (Collection)this.containerCache.get(containerId);
            if (timersForTimedObject != null) {
                for (TimerPrimaryKey timer : timersForTimedObject) {
                    HZTimer hzTimer = (HZTimer)this.pkCache.get(timer);
                    if (hzTimer == null || !hzTimer.getTimedObjectPk().equals(timedObjectPrimaryKey)) continue;
                    timerIdsForTimedObject.add(timer);
                }
            }
        }
        timerIdsForTimedObject.addAll(super.getTimerIds(containerId, null));
        return timerIdsForTimedObject;
    }

    @Override
    protected EJBTimerSchedule getTimerSchedule(TimerPrimaryKey timerId) throws FinderException {
        EJBTimerSchedule ts = null;
        if (!super.isPersistent(timerId)) {
            ts = super.getTimerSchedule(timerId);
        } else {
            HZTimer timer = this.getPersistentTimer(timerId);
            ts = timer.getSchedule();
        }
        return ts;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    protected boolean isCancelledByAnotherInstance(RuntimeTimerState timerState) {
        if (timerState.isPersistent() && !this.isDas) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "For Timer :" + timerState.getTimerId() + ": check the database to ensure that the timer is still " + " valid, before delivering the ejbTimeout call");
            }
            if (!this.checkForTimerValidity(timerState.getTimerId())) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isPersistent(TimerPrimaryKey timerId) throws FinderException {
        if (!super.isPersistent(timerId)) {
            return false;
        }
        this.getPersistentTimer(timerId);
        return true;
    }

    @Override
    protected boolean isValidTimerForThisServer(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
        HZTimer timer;
        boolean result = true;
        if (timerState.isPersistent() && ((timer = (HZTimer)this.pkCache.get(timerId)) == null || !timer.getMemberName().equals(this.serverName))) {
            result = false;
        }
        return result;
    }

    @Override
    public String[] listTimers(String[] serverIds) {
        String[] result = new String[serverIds.length];
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (Object timer : this.pkCache.values()) {
            HZTimer hzTimer = (HZTimer)timer;
            String serverName = hzTimer.getMemberName();
            Long val = (Long)counts.get(serverName);
            if (val == null) {
                val = new Long(0L);
            }
            counts.put(serverName, new Long(val.intValue() + 1));
        }
        for (int i = 0; i < serverIds.length; ++i) {
            Long count = (Long)counts.get(serverIds[i]);
            result[i] = count != null ? ((Long)counts.get(serverIds[i])).toString() : "0";
        }
        return result;
    }

    @Override
    public int migrateTimers(String fromOwnerId) {
        String ownerIdOfThisServer = this.getOwnerIdOfThisServer();
        if (fromOwnerId.equals(ownerIdOfThisServer)) {
            logger.log(Level.WARNING, "Attempt to migrate timers from an active server instance " + ownerIdOfThisServer);
            throw new IllegalStateException("Attempt to migrate timers from  an active server instance " + ownerIdOfThisServer);
        }
        logger.log(Level.INFO, "Beginning timer migration process from owner " + fromOwnerId + " to " + ownerIdOfThisServer);
        JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
        HashMap<TimerPrimaryKey, HZTimer> toRestore = new HashMap<TimerPrimaryKey, HZTimer>();
        int totalTimersMigrated = 0;
        for (TimerPrimaryKey pk : this.pkCache.keySet()) {
            HZTimer hZTimer = (HZTimer)this.pkCache.get(pk);
            if (!hZTimer.getOwnerId().equals(fromOwnerId)) continue;
            toRestore.put(pk, hZTimer);
            hZTimer.setOwnerId(ownerIdOfThisServer);
            hZTimer.setMemberName(this.serverName);
        }
        for (TimerPrimaryKey pk : toRestore.keySet()) {
            this.pkCache.put(pk, toRestore.get(pk));
            ++totalTimersMigrated;
        }
        if (totalTimersMigrated > 0) {
            boolean success = false;
            try {
                logger.log(Level.INFO, "Timer migration phase 1 complete. Changed ownership of " + toRestore.size() + " timers.  Now reactivating timers...");
                this._notifyContainers(toRestore.values());
                tm.begin();
                this._restoreTimers(toRestore.values());
                success = true;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "timer restoration error", e);
                EJBException ejbEx = this.createEJBException(e);
                throw ejbEx;
            }
            finally {
                block13: {
                    try {
                        tm.commit();
                    }
                    catch (Exception re) {
                        logger.log(Level.FINE, "timer migration error", re);
                        if (!success) break block13;
                        EJBException ejbEx = this.createEJBException(re);
                        throw ejbEx;
                    }
                }
            }
        }
        logger.log(Level.INFO, fromOwnerId + " has 0 timers in need " + "of migration");
        return totalTimersMigrated;
    }

    @Override
    protected Map<TimerPrimaryKey, Method> recoverAndCreateSchedules(long containerId, long applicationId, Map<Method, List<ScheduledTimerDescriptor>> schedules, boolean deploy) {
        Set<HZTimer> timers;
        HashMap<TimerPrimaryKey, Method> result = new HashMap<TimerPrimaryKey, Method>();
        HashSet<HZTimer> activeTimers = new HashSet<HZTimer>();
        Collection containerKeys = (Collection)this.containerCache.get(containerId);
        HashSet<TimerPrimaryKey> deadKeys = new HashSet<TimerPrimaryKey>();
        if (containerKeys != null) {
            for (TimerPrimaryKey containerKey : containerKeys) {
                HZTimer timer = (HZTimer)this.pkCache.get(containerKey);
                if (timer != null && timer.getMemberName().equals(this.serverName)) {
                    activeTimers.add(timer);
                    continue;
                }
                if (timer != null) continue;
                deadKeys.add(containerKey);
            }
            if (!deadKeys.isEmpty()) {
                logger.info("Cleaning out " + deadKeys.size() + " dead timer ids from Container Cache ");
                for (TimerPrimaryKey deadKey : deadKeys) {
                    containerKeys.remove(deadKey);
                }
                this.containerCache.put(containerId, containerKeys);
            }
        } else if (containerKeys == null && !deploy) {
            deploy = true;
        }
        if ((timers = this._restoreTimers((Set<HZTimer>)activeTimers)).size() > 0) {
            logger.log(Level.FINE, "Found " + timers.size() + " persistent timers for containerId: " + containerId);
        }
        boolean schedulesExist = schedules.size() > 0;
        for (HZTimer timer : timers) {
            EJBTimerSchedule ts = timer.getSchedule();
            if (ts == null || !ts.isAutomatic() || !schedulesExist) continue;
            for (Map.Entry<Method, List<ScheduledTimerDescriptor>> entry : schedules.entrySet()) {
                Method m = entry.getKey();
                if (!m.getName().equals(ts.getTimerMethodName()) || m.getParameterTypes().length != ts.getMethodParamCount()) continue;
                result.put(new TimerPrimaryKey(timer.getKey().getTimerId()), m);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "@@@ FOUND existing schedule: " + ts.getScheduleAsString() + " FOR method: " + m);
                }
                schedules.remove(m);
            }
        }
        try {
            if (!schedules.isEmpty()) {
                this.createSchedules(containerId, applicationId, schedules, result, this.serverName, true, deploy && this.isDas);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(HazelcastTimerStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    @Override
    protected boolean redeliverTimeout(RuntimeTimerState timerState) {
        return (long)timerState.getNumFailedDeliveries() < this.getMaxRedeliveries();
    }

    @Override
    protected void resetLastExpiration(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
        if (timerState.isPersistent()) {
            HZTimer timer = (HZTimer)this.pkCache.get(timerId);
            if (null == timer) {
                return;
            }
            Date now = new Date();
            timer.setLastExpiration(now);
            this.pkCache.put(timer.getKey(), timer);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Setting last expiration  for periodic timer " + timerState + " to " + now);
            }
        }
    }

    @Override
    protected void resetEJBTimers(String target) {
        if (target == null) {
            logger.log(Level.INFO, "==> Restoring Timers ... ");
            if (this.restoreEJBTimers()) {
                logger.log(Level.INFO, "<== ... Timers Restored.");
            }
        }
    }

    @Override
    protected boolean stopOnFailure() {
        return false;
    }

    @Override
    protected boolean timerExists(TimerPrimaryKey timerId) {
        HZTimer timer;
        boolean exists = super.timerExists(timerId);
        if (!exists && (timer = (HZTimer)this.pkCache.get(timerId)) != null) {
            exists = true;
        }
        return exists;
    }

    @Override
    protected void stopTimers(long containerId) {
        super.stopTimers(containerId);
        this.stopTimers((Set)this.containerCache.get(containerId));
    }

    private HZTimer getPersistentTimer(TimerPrimaryKey timerId) throws FinderException {
        HZTimer result = (HZTimer)this.pkCache.get(timerId);
        if (result == null) {
            throw new FinderException("Unable to find timer " + timerId);
        }
        return result;
    }

    private void removeTimer(HZTimer timer) {
        this.pkCache.remove(timer.getKey());
        Collection keys = (Collection)this.applicationCache.get(timer.getApplicationId());
        if (keys != null) {
            keys.remove(timer.getKey());
            this.applicationCache.put(timer.getApplicationId(), keys);
        }
        if ((keys = (Collection)this.containerCache.get(timer.getContainerId())) != null) {
            keys.remove(timer.getKey());
            this.containerCache.put(timer.getContainerId(), keys);
        }
    }

    private void recoverAndCreateSchedulesError(Exception e, TransactionManager tm) {
        logger.log(Level.WARNING, "Timer restore or schedule creation error", e);
        try {
            tm.rollback();
        }
        catch (Exception re) {
            logger.log(Level.FINE, "Timer restore or schedule creation rollback error", re);
        }
        EJBException ejbEx = this.createEJBException(e);
        throw ejbEx;
    }

    private boolean checkForTimerValidity(TimerPrimaryKey timerId) {
        boolean result = false;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(HazelcastTimerStore.class.getClassLoader());
        HZTimer timer = (HZTimer)this.pkCache.get(timerId);
        if (timer != null && timer.getMemberName().equals(this.serverName)) {
            result = true;
        }
        Thread.currentThread().setContextClassLoader(cl);
        return result;
    }

    private void _notifyContainers(Collection<HZTimer> timers) {
        for (HZTimer timer : timers) {
            EJBTimerSchedule ts = timer.getSchedule();
            if (ts == null || !ts.isAutomatic()) continue;
            this.addToSchedules(timer.getContainerId(), timer.getKey(), ts);
        }
    }

    private void restoreTimers() throws Exception {
        if (this.totalTimedObjectsInitialized_ == 0L) {
            return;
        }
        this._restoreTimers(this.findActiveTimersOwnedByThisServer());
    }

    private Collection<HZTimer> _restoreTimers(Collection<HZTimer> timersEligibleForRestoration) {
        HashMap<RuntimeTimerState, Date> timersToRestore = new HashMap<RuntimeTimerState, Date>();
        HashSet<TimerPrimaryKey> timerIdsToRemove = new HashSet<TimerPrimaryKey>();
        HashSet<HZTimer> result = new HashSet<HZTimer>();
        for (HZTimer timer : timersEligibleForRestoration) {
            TimerPrimaryKey timerId = timer.getKey();
            if (this.getTimerState(timerId) != null) {
                logger.log(Level.FINE, "@@@ Timer already restored: " + timer);
                result.add(timer);
                continue;
            }
            long containerId = timer.getContainerId();
            BaseContainer container = this.getContainer(containerId);
            if (container != null) {
                long appid = timer.getApplicationId();
                if (appid == 0L) {
                    timer.setApplicationId(container.getApplicationId());
                }
                Date initialExpiration = timer.getInitialExpiration();
                Object timedObjectPrimaryKey = null;
                if (container.getContainerType() == BaseContainer.ContainerType.ENTITY) {
                    timedObjectPrimaryKey = timer.getTimedObjectPk();
                }
                RuntimeTimerState timerState = new RuntimeTimerState(timerId, initialExpiration, timer.getIntervalDuration(), container, timedObjectPrimaryKey, timer.getSchedule(), null, true);
                this.timerCache_.addTimer(timerId, timerState);
                Date expirationTime = initialExpiration;
                Date now = new Date();
                if (timerState.isPeriodic()) {
                    Date lastExpiration = timer.getLastExpiration();
                    EJBTimerSchedule ts = timer.getSchedule();
                    if (lastExpiration == null && now.after(initialExpiration)) {
                        if (!timerState.isExpired()) {
                            logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer " + timerState + ". Timer expirations should " + " have been delivered starting at " + initialExpiration);
                        }
                    } else if (lastExpiration != null && (ts != null && ts.getNextTimeout(lastExpiration).getTimeInMillis() < now.getTime() || ts == null && now.getTime() - lastExpiration.getTime() > timer.getIntervalDuration())) {
                        logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer " + timerState + ".  Last timer expiration " + "occurred at " + lastExpiration);
                    } else {
                        expirationTime = this.calcNextFixedRateExpiration(timerState);
                    }
                } else if (now.after(initialExpiration)) {
                    logger.log(Level.INFO, "Rescheduling missed expiration for single-action timer " + timerState + ". Timer expiration should " + " have been delivered at " + initialExpiration);
                }
                if (expirationTime == null) {
                    logger.log(Level.INFO, "Removing schedule-based timer " + timerState + " that will never expire again");
                    timerIdsToRemove.add(timerId);
                    continue;
                }
                timersToRestore.put(timerState, expirationTime);
                result.add(timer);
                continue;
            }
            logger.log(Level.FINE, "Skipping timer " + timerId + " for container that is not up: " + containerId);
        }
        if (timerIdsToRemove.size() > 0) {
            for (HZTimer timer : result) {
            }
            this.removeTimers(timerIdsToRemove);
        }
        for (Map.Entry next : timersToRestore.entrySet()) {
            RuntimeTimerState nextTimer = (RuntimeTimerState)next.getKey();
            TimerPrimaryKey timerId = nextTimer.getTimerId();
            Date expiration = (Date)next.getValue();
            this.scheduleTask(timerId, expiration);
            logger.log(Level.FINE, "EJBTimerService.restoreTimers(), scheduling timer " + nextTimer);
        }
        logger.log(Level.FINE, "DONE EJBTimerService.restoreTimers()");
        return result;
    }

    private Set<HZTimer> _restoreTimers(Set<HZTimer> timersEligibleForRestoration) {
        HashMap<RuntimeTimerState, Date> timersToRestore = new HashMap<RuntimeTimerState, Date>();
        HashSet<TimerPrimaryKey> timerIdsToRemove = new HashSet<TimerPrimaryKey>();
        HashSet<HZTimer> result = new HashSet<HZTimer>();
        for (HZTimer timer : timersEligibleForRestoration) {
            TimerPrimaryKey timerId = timer.getKey();
            if (this.getTimerState(timerId) != null) {
                logger.log(Level.FINE, "@@@ Timer already restored: " + timer);
                result.add(timer);
                continue;
            }
            long containerId = timer.getContainerId();
            BaseContainer container = this.getContainer(containerId);
            if (container != null) {
                long appid = timer.getApplicationId();
                if (appid == 0L) {
                    timer.setApplicationId(container.getApplicationId());
                }
                Date initialExpiration = timer.getInitialExpiration();
                Object timedObjectPrimaryKey = null;
                if (container.getContainerType() == BaseContainer.ContainerType.ENTITY) {
                    timedObjectPrimaryKey = timer.getTimedObjectPk();
                }
                RuntimeTimerState timerState = new RuntimeTimerState(timerId, initialExpiration, timer.getIntervalDuration(), container, timedObjectPrimaryKey, timer.getSchedule(), null, true);
                this.timerCache_.addTimer(timerId, timerState);
                Date expirationTime = initialExpiration;
                Date now = new Date();
                if (timerState.isPeriodic()) {
                    Date lastExpiration = timer.getLastExpiration();
                    EJBTimerSchedule ts = timer.getSchedule();
                    if (lastExpiration == null && now.after(initialExpiration)) {
                        if (!timerState.isExpired()) {
                            logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer " + timerState + ". Timer expirations should " + " have been delivered starting at " + initialExpiration);
                        }
                    } else if (lastExpiration != null && (ts != null && ts.getNextTimeout(lastExpiration).getTimeInMillis() < now.getTime() || ts == null && now.getTime() - lastExpiration.getTime() > timer.getIntervalDuration())) {
                        logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer " + timerState + ".  Last timer expiration " + "occurred at " + lastExpiration);
                    } else {
                        expirationTime = this.calcNextFixedRateExpiration(timerState);
                    }
                } else if (now.after(initialExpiration)) {
                    logger.log(Level.INFO, "Rescheduling missed expiration for single-action timer " + timerState + ". Timer expiration should " + " have been delivered at " + initialExpiration);
                }
                if (expirationTime == null) {
                    logger.log(Level.INFO, "Removing schedule-based timer " + timerState + " that will never expire again");
                    timerIdsToRemove.add(timerId);
                    continue;
                }
                timersToRestore.put(timerState, expirationTime);
                result.add(timer);
                continue;
            }
            logger.log(Level.FINE, "Skipping timer " + timerId + " for container that is not up: " + containerId);
        }
        if (timerIdsToRemove.size() > 0) {
            this.removeTimers(timerIdsToRemove);
        }
        for (Map.Entry next : timersToRestore.entrySet()) {
            RuntimeTimerState nextTimer = (RuntimeTimerState)next.getKey();
            TimerPrimaryKey timerId = nextTimer.getTimerId();
            Date expiration = (Date)next.getValue();
            this.scheduleTask(timerId, expiration);
            logger.log(Level.FINE, "EJBTimerService.restoreTimers(), scheduling timer " + nextTimer);
        }
        logger.log(Level.FINE, "DONE EJBTimerService.restoreTimers()");
        return result;
    }

    private Collection<HZTimer> findActiveTimersOwnedByThisServer() {
        HashSet<HZTimer> result = new HashSet<HZTimer>();
        for (HZTimer timer : this.pkCache.values()) {
            if (!timer.getMemberName().equals(this.serverName)) continue;
            result.add(timer);
        }
        return result;
    }

    private boolean restoreEJBTimers() {
        boolean rc = false;
        try {
            if (this.totalTimedObjectsInitialized_ > 0L) {
                this.restoreTimers();
                rc = true;
            } else {
                int s = this.findActiveTimersOwnedByThisServer().size();
                if (s > 0) {
                    logger.log(Level.INFO, "[" + s + "] EJB Timers owned by this server will be restored when timeout beans are loaded");
                } else {
                    logger.log(Level.INFO, "There are no EJB Timers owned by this server");
                }
                rc = true;
            }
        }
        catch (Exception ex) {
            EJBTimerService.setEJBTimerService(null);
            logger.log(Level.WARNING, "ejb.timer_service_init_error", ex);
        }
        return rc;
    }
}

