/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.enterprise.server.logging;

import com.sun.common.util.logging.GFLogRecord;
import com.sun.enterprise.server.logging.ExcludeFieldsSupport;
import com.sun.enterprise.server.logging.FormatterDelegate;
import com.sun.enterprise.server.logging.LogEvent;
import com.sun.enterprise.server.logging.LogEventBroadcaster;
import com.sun.enterprise.server.logging.LogEventImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.api.VersionInfo;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={JSONLogFormatter.class, Formatter.class})
@PerLookup
public class JSONLogFormatter
extends Formatter
implements LogEventBroadcaster {
    private static final String RECORD_NUMBER = "RecordNumber";
    private static final String METHOD_NAME = "MethodName";
    private static final String CLASS_NAME = "ClassName";
    private final ServiceLocator habitat = Globals.getDefaultBaseServiceLocator();
    private HashMap loggerResourceBundleTable;
    private LogManager logManager;
    private final Date date = new Date();
    private static boolean LOG_SOURCE_IN_KEY_VALUE;
    private static boolean RECORD_NUMBER_IN_KEY_VALUE;
    private FormatterDelegate _delegate = null;
    private long recordNumber = 0L;
    private String recordDateFormat;
    private static final String LINE_SEPARATOR;
    private static final String TIMESTAMP_KEY = "_Timestamp";
    private static final String LOG_LEVEL_KEY = "_Level";
    private static final String PRODUCT_ID_KEY = "_Version";
    private static final String LOGGER_NAME_KEY = "_LoggerName";
    private static final String EXCEPTION_KEY = "_Exception";
    private static final String STACK_TRACE_KEY = "_StackTrace";
    private static final String THREAD_ID_KEY = "_ThreadID";
    private static final String THREAD_NAME_KEY = "_ThreadName";
    private static final String USER_ID_KEY = "_UserId";
    private static final String ECID_KEY = "_ECId";
    private static final String LEVEL_VALUE_KEY = "_LevelValue";
    private static final String TIME_MILLIS_KEY = "_TimeMillis";
    private static final String MESSAGE_ID_KEY = "_MessageID";
    private static final String LOG_MESSAGE_KEY = "_LogMessage";
    private static final String RFC3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final ExcludeFieldsSupport excludeFieldsSupport = new ExcludeFieldsSupport();
    private LogEventBroadcaster logEventBroadcasterDelegate;
    private String productId = "";

    public JSONLogFormatter() {
        this.loggerResourceBundleTable = new HashMap();
        this.logManager = LogManager.getLogManager();
    }

    public JSONLogFormatter(FormatterDelegate delegate) {
        this();
        this._delegate = delegate;
    }

    public void setDelegate(FormatterDelegate delegate) {
        this._delegate = delegate;
    }

    @Override
    public String format(LogRecord record) {
        return this.jsonLogFormat(record);
    }

    @Override
    public String formatMessage(LogRecord record) {
        return this.jsonLogFormat(record);
    }

    protected String getProductId() {
        if (this.habitat != null) {
            VersionInfo version = this.habitat.getService(VersionInfo.class, new Annotation[0]);
            if (this.productId.isEmpty() && version != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(version.getAbbreviatedProductName());
                builder.append(' ');
                builder.append(version.getVersionPrefix());
                builder.append(version.getMajorVersion());
                builder.append('.');
                builder.append(version.getMinorVersion());
                this.productId = builder.toString();
            }
        }
        return this.productId;
    }

    private String jsonLogFormat(LogRecord record) {
        try {
            JSONObject eventObject;
            LogEventImpl logEvent;
            block71: {
                String logMessage;
                String messageId;
                String ecid;
                String userId;
                logEvent = new LogEventImpl();
                eventObject = new JSONObject();
                SimpleDateFormat dateFormatter = null != this.getRecordDateFormat() ? new SimpleDateFormat(this.getRecordDateFormat()) : new SimpleDateFormat(RFC3339_DATE_FORMAT);
                this.date.setTime(record.getMillis());
                String timestampValue = dateFormatter.format(this.date);
                logEvent.setTimestamp(timestampValue);
                eventObject.put(TIMESTAMP_KEY, timestampValue);
                Level eventLevel = record.getLevel();
                logEvent.setLevel(eventLevel.getName());
                eventObject.put(LOG_LEVEL_KEY, String.valueOf(eventLevel));
                this.productId = this.getProductId();
                logEvent.setComponentId(this.productId);
                eventObject.put(PRODUCT_ID_KEY, this.productId);
                String loggerName = record.getLoggerName();
                if (null == loggerName) {
                    loggerName = "";
                }
                logEvent.setLogger(loggerName);
                eventObject.put(LOGGER_NAME_KEY, loggerName);
                if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.TID)) {
                    int threadId = record.getThreadID();
                    logEvent.setThreadId(threadId);
                    eventObject.put(THREAD_ID_KEY, String.valueOf(threadId));
                    String threadName = record instanceof GFLogRecord ? ((GFLogRecord)record).getThreadName() : Thread.currentThread().getName();
                    logEvent.setThreadName(threadName);
                    eventObject.put(THREAD_NAME_KEY, threadName);
                }
                if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.USERID) && null != (userId = logEvent.getUser()) && !userId.isEmpty()) {
                    eventObject.put(USER_ID_KEY, userId);
                }
                if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.ECID) && null != (ecid = logEvent.getECId()) && !ecid.isEmpty()) {
                    eventObject.put(ECID_KEY, ecid);
                }
                if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.TIME_MILLIS)) {
                    Long timestamp = record.getMillis();
                    logEvent.setTimeMillis(timestamp);
                    eventObject.put(TIME_MILLIS_KEY, String.valueOf(timestamp));
                }
                Level level = record.getLevel();
                if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.LEVEL_VALUE)) {
                    int levelValue = level.intValue();
                    logEvent.setLevelValue(levelValue);
                    eventObject.put(LEVEL_VALUE_KEY, String.valueOf(levelValue));
                }
                if ((messageId = JSONLogFormatter.getMessageId(record)) != null && !messageId.isEmpty()) {
                    logEvent.setMessageId(messageId);
                    eventObject.put(MESSAGE_ID_KEY, messageId);
                }
                if (LOG_SOURCE_IN_KEY_VALUE || level.intValue() <= Level.FINE.intValue()) {
                    String sourceMethodName;
                    String sourceClassName = record.getSourceClassName();
                    if (null != sourceClassName && !sourceClassName.isEmpty()) {
                        logEvent.getSupplementalAttributes().put(CLASS_NAME, sourceClassName);
                        eventObject.put(CLASS_NAME, sourceClassName);
                    }
                    if (null != (sourceMethodName = record.getSourceMethodName()) && !sourceMethodName.isEmpty()) {
                        logEvent.getSupplementalAttributes().put(METHOD_NAME, sourceMethodName);
                        eventObject.put(METHOD_NAME, sourceMethodName);
                    }
                }
                if (RECORD_NUMBER_IN_KEY_VALUE) {
                    ++this.recordNumber;
                    logEvent.getSupplementalAttributes().put(RECORD_NUMBER, this.recordNumber);
                    eventObject.put(RECORD_NUMBER, String.valueOf(this.recordNumber));
                }
                if (null != this._delegate) {
                    this._delegate.format(new StringBuilder().append(eventObject.toString()), level);
                }
                if (null == (logMessage = record.getMessage()) || logMessage.trim().equals("")) {
                    Throwable throwable = record.getThrown();
                    if (null != throwable) {
                        try (StringWriter stringWriter = new StringWriter();
                             PrintWriter printWriter = new PrintWriter(stringWriter);){
                            JSONObject traceObject = new JSONObject();
                            throwable.printStackTrace(printWriter);
                            logMessage = stringWriter.toString();
                            traceObject.put(EXCEPTION_KEY, throwable.getMessage());
                            traceObject.put(STACK_TRACE_KEY, logMessage);
                            logEvent.setMessage(logMessage);
                            eventObject.put(LOG_MESSAGE_KEY, traceObject);
                        }
                    }
                } else {
                    if (logMessage.contains("{0") && logMessage.contains("}") && null != record.getParameters()) {
                        logMessage = MessageFormat.format(logMessage, record.getParameters());
                    } else {
                        ResourceBundle bundle2 = this.getResourceBundle(record.getLoggerName());
                        if (null != bundle2) {
                            try {
                                logMessage = MessageFormat.format(bundle2.getString(logMessage), record.getParameters());
                            }
                            catch (MissingResourceException stringWriter) {
                                // empty catch block
                            }
                        }
                    }
                    StringBuilder logMessageBuilder = new StringBuilder();
                    logMessageBuilder.append(logMessage);
                    Throwable throwable = JSONLogFormatter.getThrowable(record);
                    if (null != throwable) {
                        try (StringWriter stringWriter = new StringWriter();
                             PrintWriter printWriter = new PrintWriter(stringWriter);){
                            JSONObject traceObject = new JSONObject();
                            throwable.printStackTrace(printWriter);
                            logMessage = stringWriter.toString();
                            traceObject.put(EXCEPTION_KEY, logMessageBuilder.toString());
                            traceObject.put(STACK_TRACE_KEY, logMessage);
                            logEvent.setMessage(logMessage);
                            eventObject.put(LOG_MESSAGE_KEY, traceObject);
                            break block71;
                        }
                    }
                    logMessage = logMessageBuilder.toString();
                    logEvent.setMessage(logMessage);
                    eventObject.put(LOG_MESSAGE_KEY, logMessage);
                }
            }
            this.informLogEventListeners(logEvent);
            return eventObject.toString() + LINE_SEPARATOR;
        }
        catch (Exception ex) {
            new ErrorManager().error("Error in formatting Logrecord", ex, 5);
            return "";
        }
    }

    static String getMessageId(LogRecord record) {
        ResourceBundle bundle2;
        String message = record.getMessage();
        if (null != message && !message.isEmpty() && null != (bundle2 = record.getResourceBundle()) && bundle2.containsKey(message) && !bundle2.getString(message).isEmpty()) {
            return message;
        }
        return null;
    }

    static Throwable getThrowable(LogRecord record) {
        return record.getThrown();
    }

    private synchronized ResourceBundle getResourceBundle(String loggerName) {
        if (loggerName == null) {
            return null;
        }
        ResourceBundle bundle2 = (ResourceBundle)this.loggerResourceBundleTable.get(loggerName);
        Logger logger2 = this.logManager.getLogger(loggerName);
        if (null == bundle2 && null != logger2) {
            bundle2 = logger2.getResourceBundle();
            this.loggerResourceBundleTable.put(loggerName, bundle2);
        }
        return bundle2;
    }

    public String getRecordDateFormat() {
        return this.recordDateFormat;
    }

    public void setRecordDateFormat(String recordDateFormat) {
        this.recordDateFormat = recordDateFormat;
    }

    LogEventBroadcaster getLogEventBroadcaster() {
        return this.logEventBroadcasterDelegate;
    }

    void setLogEventBroadcaster(LogEventBroadcaster logEventBroadcaster) {
        this.logEventBroadcasterDelegate = logEventBroadcaster;
    }

    @Override
    public void informLogEventListeners(LogEvent logEvent) {
        if (this.logEventBroadcasterDelegate != null) {
            this.logEventBroadcasterDelegate.informLogEventListeners(logEvent);
        }
    }

    void setExcludeFields(String excludeFields) {
        this.excludeFieldsSupport.setExcludeFields(excludeFields);
    }

    static {
        String recordCount;
        LOG_SOURCE_IN_KEY_VALUE = false;
        RECORD_NUMBER_IN_KEY_VALUE = false;
        String logSource = System.getProperty("com.sun.aas.logging.keyvalue.logsource");
        if (logSource != null && logSource.equals("true")) {
            LOG_SOURCE_IN_KEY_VALUE = true;
        }
        if ((recordCount = System.getProperty("com.sun.aas.logging.keyvalue.recordnumber")) != null && recordCount.equals("true")) {
            RECORD_NUMBER_IN_KEY_VALUE = true;
        }
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

