/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jbatch.persistence.rdbms;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchConfig;
import fish.payara.jbatch.persistence.rdbms.DB2JDBCConstants;
import fish.payara.jbatch.persistence.rdbms.JBatchJDBCPersistenceManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DB2PersistenceManager
extends JBatchJDBCPersistenceManager
implements DB2JDBCConstants {
    private static final String CLASSNAME = JBatchJDBCPersistenceManager.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IBatchConfig batchConfig = null;
    protected Map<String, String> createDB2Strings;

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.config("Entering CLASSNAME.init(), batchConfig =" + batchConfig);
        this.batchConfig = batchConfig;
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
        try {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
            throw new BatchContainerServiceException(e);
        }
        this.tableNames = this.getSharedTableMap(batchConfig);
        try {
            this.queryStrings = this.getSharedQueryMap(batchConfig);
        }
        catch (SQLException e1) {
            throw new BatchContainerServiceException(e1);
        }
        this.createDB2Strings = this.setCreateDB2StringsMap(batchConfig);
        logger.config("JNDI name = " + this.jndiName);
        if (this.jndiName == null || this.jndiName.equals("")) {
            throw new BatchContainerServiceException("JNDI name is not defined.");
        }
        try {
            if (!this.isDB2SchemaValid()) {
                this.setDefaultSchema();
            }
            this.checkDB2Tables();
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new BatchContainerServiceException(e);
        }
        logger.config("Exiting CLASSNAME.init()");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDB2SchemaValid() throws SQLException {
        ResultSet rs;
        Connection conn;
        boolean result;
        block7: {
            boolean bl;
            block6: {
                result = false;
                conn = null;
                DatabaseMetaData dbmd = null;
                rs = null;
                logger.entering(CLASSNAME, "isDB2SchemaValid");
                try {
                    conn = this.getConnectionToDefaultSchema();
                    dbmd = conn.getMetaData();
                    rs = dbmd.getSchemas();
                    while (rs.next()) {
                        String schemaname = rs.getString("TABLE_SCHEM");
                        if (!this.schema.equalsIgnoreCase(schemaname)) continue;
                        logger.exiting(CLASSNAME, "isSchemaValid", true);
                        bl = true;
                        break block6;
                    }
                    break block7;
                }
                catch (SQLException e) {
                    try {
                        logger.severe(e.getLocalizedMessage());
                        throw e;
                    }
                    catch (Throwable throwable) {
                        this.cleanupConnection(conn, rs, null);
                        throw throwable;
                    }
                }
            }
            this.cleanupConnection(conn, rs, null);
            return bl;
        }
        this.cleanupConnection(conn, rs, null);
        logger.exiting(CLASSNAME, "isDB2SchemaValid", false);
        return result;
    }

    private void checkDB2Tables() throws SQLException {
        logger.entering(CLASSNAME, "checkDB2Tables");
        this.createDB2TableNotExists((String)this.tableNames.get("CHECKPOINT_TABLE_KEY"), this.createDB2Strings.get("DB2__CREATE_TABLE_CHECKPOINTDATA"));
        this.createDB2TableNotExists((String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY"), this.createDB2Strings.get("DB2_CREATE_TABLE_JOBINSTANCEDATA"));
        this.createDB2TableNotExists((String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY"), this.createDB2Strings.get("DB2_CREATE_TABLE_EXECUTIONINSTANCEDATA"));
        this.createDB2TableNotExists((String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY"), this.createDB2Strings.get("DB2_CREATE_TABLE_STEPINSTANCEDATA"));
        this.createDB2TableNotExists((String)this.tableNames.get("JOB_STATUS_TABLE_KEY"), this.createDB2Strings.get("DB2_CREATE_TABLE_JOBSTATUS"));
        this.createDB2TableNotExists((String)this.tableNames.get("STEP_STATUS_TABLE_KEY"), this.createDB2Strings.get("DB2_CREATE_TABLE_STEPSTATUS"));
        logger.exiting(CLASSNAME, "checkDB2Tables");
    }

    protected void createDB2TableNotExists(String tableName, String createTableStatement) throws SQLException {
        logger.entering(CLASSNAME, "createDB2TableNotExists", new Object[]{tableName, createTableStatement});
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement(1004, 1007);
            String query = "select name from sysibm.systables where name ='" + tableName.toUpperCase() + "'" + "and type = 'T'";
            rs = stmt.executeQuery(query);
            int rowcount = this.getTableRowCount(rs);
            if (rowcount == 0 && !rs.next()) {
                logger.log(Level.INFO, tableName + " table does not exists. Trying to create it.");
                ps = conn.prepareStatement(createTableStatement);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                logger.severe(e.getLocalizedMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, ps);
                throw throwable;
            }
        }
        this.cleanupConnection(conn, rs, ps);
        logger.exiting(CLASSNAME, "createDB2TableNotExists");
    }

    protected Map<String, String> setCreateDB2StringsMap(IBatchConfig batchConfig) {
        this.createDB2Strings = new HashMap<String, String>();
        this.createDB2Strings.put("DB2__CREATE_TABLE_CHECKPOINTDATA", "CREATE TABLE " + (String)this.tableNames.get("CHECKPOINT_TABLE_KEY") + " (id VARCHAR(512),obj BLOB)");
        this.createDB2Strings.put("DB2_CREATE_TABLE_JOBINSTANCEDATA", "CREATE TABLE " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT JOBINSTANCE_PK PRIMARY KEY,name VARCHAR(512), apptag VARCHAR(512))");
        this.createDB2Strings.put("DB2_CREATE_TABLE_EXECUTIONINSTANCEDATA", "CREATE TABLE " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " (jobexecid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT JOBEXECUTION_PK PRIMARY KEY," + "jobinstanceid BIGINT," + "createtime\tTIMESTAMP," + "starttime\tTIMESTAMP," + "endtime\tTIMESTAMP," + "updatetime\tTIMESTAMP," + "parameters\tBLOB," + "batchstatus VARCHAR(512)," + "exitstatus\t\tVARCHAR(512)," + "CONSTRAINT JOBINST_JOBEXEC_FK FOREIGN KEY (jobinstanceid) REFERENCES " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid))");
        this.createDB2Strings.put("DB2_CREATE_TABLE_STEPINSTANCEDATA", "CREATE TABLE " + (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " (stepexecid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT STEPEXECUTION_PK PRIMARY KEY," + "jobexecid\tBIGINT," + "batchstatus VARCHAR(512)," + "exitstatus\tVARCHAR(512)," + "stepname\tVARCHAR(512)," + "readcount\tINTEGER," + "writecount\tINTEGER," + "commitcount INTEGER," + "rollbackcount INTEGER," + "readskipcount\tINTEGER," + "processskipcount INTEGER," + "filtercount INTEGER," + "writeskipcount\tINTEGER," + "startTime TIMESTAMP," + "endTime TIMESTAMP," + "persistentData\tBLOB," + "CONSTRAINT JOBEXEC_STEPEXEC_FK FOREIGN KEY (jobexecid) REFERENCES " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " (jobexecid))");
        this.createDB2Strings.put("DB2_CREATE_TABLE_JOBSTATUS", "CREATE TABLE " + (String)this.tableNames.get("JOB_STATUS_TABLE_KEY") + " (id BIGINT CONSTRAINT JOBSTATUS_PK PRIMARY KEY NOT NULL,obj BLOB," + "CONSTRAINT JOBSTATUS_JOBINST_FK FOREIGN KEY (id) REFERENCES " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid) ON DELETE CASCADE)");
        this.createDB2Strings.put("DB2_CREATE_TABLE_STEPSTATUS", "CREATE TABLE " + (String)this.tableNames.get("STEP_STATUS_TABLE_KEY") + "(id BIGINT CONSTRAINT STEPSTATUS_PK PRIMARY KEY NOT NULL," + "obj BLOB," + "CONSTRAINT STEPSTATUS_STEPEXEC_FK FOREIGN KEY (id) REFERENCES " + (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " (stepexecid) ON DELETE CASCADE)");
        this.createDB2Strings.put("chk_index", "CREATE INDEX CHK_INDEX ON " + (String)this.tableNames.get("CHECKPOINT_TABLE_KEY") + "(id)");
        return this.createDB2Strings;
    }
}

