/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jbatch.persistence.rdbms;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchConfig;
import fish.payara.jbatch.persistence.rdbms.JBatchJDBCPersistenceManager;
import fish.payara.jbatch.persistence.rdbms.SQLServerJDBCConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class SQLServerPersistenceManager
extends JBatchJDBCPersistenceManager
implements SQLServerJDBCConstants {
    private static final String CLASSNAME = SQLServerPersistenceManager.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASSNAME);
    protected Map<String, String> SQLServerCreateStrings;
    protected Map<String, String> schemaTableNames;

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        LOGGER.entering(CLASSNAME, "init", batchConfig);
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
        if (null == this.jndiName || this.jndiName.isEmpty()) {
            throw new BatchContainerServiceException("JNDI name is not defined.");
        }
        try {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            LOGGER.log(Level.SEVERE, "Lookup failed for JNDI name: {0}. One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.", this.jndiName);
            throw new BatchContainerServiceException(e);
        }
        this.tableNames = this.getSharedTableMap(batchConfig);
        this.schemaTableNames = this.getSharedSchemaTableMap(batchConfig);
        try {
            this.queryStrings = this.getSQLServerSharedQueryMap(batchConfig);
        }
        catch (SQLException e1) {
            throw new BatchContainerServiceException(e1);
        }
        this.SQLServerCreateStrings = this.setCreateSQLServerStringsMap(batchConfig);
        LOGGER.log(Level.CONFIG, "JNDI name = {0}", this.jndiName);
        try {
            if (!this.isSQLServerSchemaValid()) {
                this.setDefaultSchema();
            }
            this.checkSQLServerTables();
        }
        catch (SQLException e) {
            LOGGER.severe(e.getLocalizedMessage());
            throw new BatchContainerServiceException(e);
        }
        LOGGER.exiting(CLASSNAME, "init");
    }

    private boolean isSQLServerSchemaValid() throws SQLException {
        LOGGER.entering(CLASSNAME, "isSQLServerSchemaValid");
        boolean result = false;
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnectionToDefaultSchema();
            ps = conn.prepareStatement("SELECT schema_name FROM information_schema.schemata WHERE schema_name LIKE ?");
            ps.setString(1, this.schema);
            rs = ps.executeQuery();
            if (rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.severe(e.getLocalizedMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, ps);
                throw throwable;
            }
        }
        this.cleanupConnection(conn, rs, ps);
        LOGGER.exiting(CLASSNAME, "isSQLServerSchemaValid", result);
        return result;
    }

    private void checkSQLServerTables() throws SQLException {
        LOGGER.entering(CLASSNAME, "checkSQLServerTables");
        this.createSQLServerTableIfNotExists((String)this.tableNames.get("CHECKPOINT_TABLE_KEY"), this.SQLServerCreateStrings.get("SQLSERVER_CREATE_TABLE_CHECKPOINTDATA"));
        this.createSQLServerTableIfNotExists((String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY"), this.SQLServerCreateStrings.get("SQLSERVER_CREATE_TABLE_JOBINSTANCEDATA"));
        this.createSQLServerTableIfNotExists((String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY"), this.SQLServerCreateStrings.get("SQLSERVER_CREATE_TABLE_EXECUTIONINSTANCEDATA"));
        this.createSQLServerTableIfNotExists((String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY"), this.SQLServerCreateStrings.get("SQLSERVER_CREATE_TABLE_STEPINSTANCEDATA"));
        this.createSQLServerTableIfNotExists((String)this.tableNames.get("JOB_STATUS_TABLE_KEY"), this.SQLServerCreateStrings.get("SQLSERVER_CREATE_TABLE_JOBSTATUS"));
        this.createSQLServerTableIfNotExists((String)this.tableNames.get("STEP_STATUS_TABLE_KEY"), this.SQLServerCreateStrings.get("SQLSERVER_CREATE_TABLE_STEPSTATUS"));
        LOGGER.exiting(CLASSNAME, "checkSQLServerTables");
    }

    protected void createSQLServerTableIfNotExists(String tableName, String createTableStatement) throws SQLException {
        LOGGER.entering(CLASSNAME, "createSQLServerTableIfNotExists", new Object[]{tableName, createTableStatement});
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement("SELECT table_schema, table_name FROM information_schema.tables WHERE table_schema LIKE ? AND table_name LIKE ?", 1004, 1007);
            ps.setString(1, this.schema);
            ps.setString(2, tableName);
            ResultSet rs = ps.executeQuery();
            int rowcount = this.getTableRowCount(rs);
            if (rowcount == 0 && !rs.next()) {
                LOGGER.log(Level.INFO, "{0} table does not exists. Trying to create it.", tableName);
                ps = conn.prepareStatement(createTableStatement);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.severe(e.getLocalizedMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, ps);
                throw throwable;
            }
        }
        this.cleanupConnection(conn, ps);
        LOGGER.exiting(CLASSNAME, "createSQLServerTableIfNotExists");
    }

    protected Map<String, String> getSharedSchemaTableMap(IBatchConfig batchConfig) {
        String prefix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.prefix", "");
        String suffix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.suffix", "");
        String schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        String schemaPrefix = schema == null || schema.isEmpty() ? "" : schema + ".";
        HashMap<String, String> result = new HashMap<String, String>(6);
        result.put("JOB_INSTANCE_TABLE_KEY", schemaPrefix + prefix + "JOBINSTANCEDATA" + suffix);
        result.put("EXECUTION_INSTANCE_TABLE_KEY", schemaPrefix + prefix + "EXECUTIONINSTANCEDATA" + suffix);
        result.put("STEP_EXECUTION_INSTANCE_TABLE_KEY", schemaPrefix + prefix + "STEPEXECUTIONINSTANCEDATA" + suffix);
        result.put("JOB_STATUS_TABLE_KEY", schemaPrefix + prefix + "JOBSTATUS" + suffix);
        result.put("STEP_STATUS_TABLE_KEY", schemaPrefix + prefix + "STEPSTATUS" + suffix);
        result.put("CHECKPOINT_TABLE_KEY", schemaPrefix + prefix + "CHECKPOINTDATA" + suffix);
        return result;
    }

    @Override
    protected void setSchemaOnConnection(Connection connection) {
    }

    protected Map<String, String> setCreateSQLServerStringsMap(IBatchConfig batchConfig) {
        this.SQLServerCreateStrings = new HashMap<String, String>();
        this.SQLServerCreateStrings.put("SQLSERVER_CREATE_TABLE_CHECKPOINTDATA", "CREATE TABLE " + this.schemaTableNames.get("CHECKPOINT_TABLE_KEY") + "(" + "id VARCHAR(512)," + "obj VARBINARY(MAX))");
        this.SQLServerCreateStrings.put("SQLSERVER_CREATE_TABLE_JOBINSTANCEDATA", "CREATE TABLE " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + "(" + "jobinstanceid BIGINT NOT NULL PRIMARY KEY IDENTITY(1,1)," + "name VARCHAR(512)," + "apptag VARCHAR(512))");
        this.SQLServerCreateStrings.put("SQLSERVER_CREATE_TABLE_EXECUTIONINSTANCEDATA", "CREATE TABLE " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(" + "jobexecid BIGINT NOT NULL PRIMARY KEY IDENTITY(1,1)," + "jobinstanceid BIGINT," + "createtime DATETIME," + "starttime DATETIME," + "endtime DATETIME," + "updatetime DATETIME," + "parameters VARBINARY(MAX)," + "batchstatus VARCHAR(512)," + "exitstatus VARCHAR(512)," + "CONSTRAINT JOBINST_JOBEXEC_FK FOREIGN KEY (jobinstanceid) REFERENCES " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + "(jobinstanceid))");
        this.SQLServerCreateStrings.put("SQLSERVER_CREATE_TABLE_STEPINSTANCEDATA", "CREATE TABLE " + this.schemaTableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(" + "stepexecid BIGINT NOT NULL PRIMARY KEY IDENTITY(1,1)," + "jobexecid BIGINT," + "batchstatus VARCHAR(512)," + "exitstatus VARCHAR(512)," + "stepname VARCHAR(512)," + "readcount INT," + "writecount INT," + "commitcount INT," + "rollbackcount INT," + "readskipcount INT," + "processskipcount INT," + "filtercount INT," + "writeskipcount INT," + "startTime DATETIME," + "endTime DATETIME," + "persistentData VARBINARY(MAX)," + "CONSTRAINT JOBEXEC_STEPEXEC_FK FOREIGN KEY (jobexecid) REFERENCES " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid))");
        this.SQLServerCreateStrings.put("SQLSERVER_CREATE_TABLE_JOBSTATUS", "CREATE TABLE " + this.schemaTableNames.get("JOB_STATUS_TABLE_KEY") + "(" + "id BIGINT NOT NULL PRIMARY KEY," + "obj VARBINARY(MAX)," + "CONSTRAINT JOBSTATUS_JOBINST_FK FOREIGN KEY (id) REFERENCES " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid) ON DELETE CASCADE)");
        this.SQLServerCreateStrings.put("SQLSERVER_CREATE_TABLE_STEPSTATUS", "CREATE TABLE " + this.schemaTableNames.get("STEP_STATUS_TABLE_KEY") + "(" + "id BIGINT NOT NULL PRIMARY KEY," + "obj VARBINARY(MAX)," + "CONSTRAINT STEPSTATUS_STEPEXEC_FK FOREIGN KEY (id) REFERENCES " + this.schemaTableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(stepexecid) ON DELETE CASCADE)");
        return this.SQLServerCreateStrings;
    }

    protected Map<String, String> getSQLServerSharedQueryMap(IBatchConfig batchConfig) throws SQLException {
        String schemaPrefix = batchConfig.getDatabaseConfigurationBean().getSchema();
        if (schemaPrefix != null && !schemaPrefix.isEmpty()) {
            schemaPrefix = schemaPrefix + ".";
        }
        this.queryStrings = new HashMap();
        this.queryStrings.put("Q_SET_SCHEMA", "SET SCHEMA ?");
        this.queryStrings.put("SELECT_CHECKPOINTDATA", "select id, obj from " + this.schemaTableNames.get("CHECKPOINT_TABLE_KEY") + " where id = ?");
        this.queryStrings.put("INSERT_CHECKPOINTDATA", "insert into " + this.schemaTableNames.get("CHECKPOINT_TABLE_KEY") + " values(?, ?)");
        this.queryStrings.put("UPDATE_CHECKPOINTDATA", "update " + this.schemaTableNames.get("CHECKPOINT_TABLE_KEY") + " set obj = ? where id = ?");
        this.queryStrings.put("JOBOPERATOR_GET_JOB_INSTANCE_COUNT", "select count(jobinstanceid) as jobinstancecount from " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name = ? and apptag = ?");
        this.queryStrings.put("SELECT_JOBINSTANCEDATA_COUNT", "select count(jobinstanceid) as jobinstancecount from " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name = ?");
        this.queryStrings.put("JOBOPERATOR_GET_JOB_INSTANCE_IDS", "select jobinstanceid from " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name = ? and apptag = ? order by jobinstanceid desc");
        this.queryStrings.put("SELECT_JOBINSTANCEDATA_IDS", "select jobinstanceid from " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name = ? order by jobinstanceid desc");
        this.queryStrings.put("JOB_OPERATOR_GET_EXTERNAL_JOB_INSTANCE_DATA", "select distinct jobinstanceid, name from " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name ");
        this.queryStrings.put("JOB_OPERATOR_QUERY_JOB_EXECUTION_TIMESTAMP", "select createtime, endtime, updatetime, starttime from " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_QUERY_JOB_EXECUTION_BATCH_STATUS", "select batchstatus from " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_QUERY_JOB_EXECUTION_EXIT_STATUS", "select exitstatus from " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_QUERY_JOB_EXECUTION_JOB_ID", "select jobinstanceid from " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("GET_PARAMETERS", "select parameters from " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("MOST_RECENT_STEPS_FOR_JOB", "select A.* from " + this.schemaTableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " as A inner join " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " as B on A.jobexecid = B.jobexecid where B.jobinstanceid = ? order by A.stepexecid desc");
        this.queryStrings.put("STEP_EXECUTIONS_FOR_JOB_EXECUTION", "select * from " + this.schemaTableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("STEP_EXECUTIONS_BY_STEP_ID", "select * from " + this.schemaTableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " where stepexecid = ?");
        this.queryStrings.put("UPDATE_BATCH_STATUS_ONLY", "update " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " set batchstatus = ?, updatetime = ? where jobexecid = ?");
        this.queryStrings.put("UPDATE_FINAL_STATUS_AND_TIMESTAMP", "update " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " set batchstatus = ?, exitstatus = ?, endtime = ?, updatetime = ? where jobexecid = ?");
        this.queryStrings.put("MARK_JOB_STARTED", "update " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " set batchstatus = ?, starttime = ?, updatetime = ? where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_GET_JOB_EXECUTION", "select A.jobexecid, A.createtime, A.starttime, A.endtime, A.updatetime, A.parameters, A.jobinstanceid, A.batchstatus, A.exitstatus, B.name from " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " as A inner join " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " as B on A.jobinstanceid = B.jobinstanceid where jobexecid = ?");
        this.queryStrings.put("JOB_OPERATOR_GET_JOB_EXECUTIONS", "select A.jobexecid, A.jobinstanceid, A.createtime, A.starttime, A.endtime, A.updatetime, A.parameters, A.batchstatus, A.exitstatus, B.name from " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " as A inner join " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " as B ON A.jobinstanceid = B.jobinstanceid where A.jobinstanceid = ?");
        this.queryStrings.put("JOB_OPERATOR_GET_RUNNING_EXECUTIONS", "SELECT A.jobexecid FROM " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " B ON A.jobinstanceid = B.jobinstanceid WHERE A.batchstatus IN (?,?,?) AND B.name = ?");
        this.queryStrings.put("SELECT_JOBINSTANCEDATA_APPTAG", "select apptag from " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " where jobinstanceid = ?");
        this.queryStrings.put("DELETE_JOBS", "DELETE FROM " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " WHERE apptag = ?");
        String deleteJobExecutions = "DELETE FROM " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " " + "WHERE jobexecid IN (" + "SELECT B.jobexecid FROM " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B " + "ON A.jobinstanceid = B.jobinstanceid " + "WHERE A.apptag = ?)";
        this.queryStrings.put("DELETE_JOB_EXECUTIONS", deleteJobExecutions);
        String deleteStepExecutions = "DELETE FROM " + this.schemaTableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " " + "WHERE stepexecid IN (" + "SELECT C.stepexecid FROM " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B " + "ON A.jobinstanceid = B.jobinstanceid INNER JOIN " + this.schemaTableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " C " + "ON B.jobexecid = C.jobexecid " + "WHERE A.apptag = ?)";
        this.queryStrings.put("DELETE_STEP_EXECUTIONS", deleteStepExecutions);
        this.queryStrings.put("GET_JOB_STATUS_FROM_EXECUTIONS", "select A.obj from " + this.schemaTableNames.get("JOB_STATUS_TABLE_KEY") + " as A inner join " + "" + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " as B on A.id = B.jobinstanceid where B.jobexecid = ?");
        this.queryStrings.put("JOB_INSTANCE_ID_BY_EXECUTION_ID", "select jobinstanceid from " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " where jobexecid = ?");
        this.queryStrings.put("CREATE_SUB_JOB_INSTANCE", "INSERT INTO " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " (name, apptag) VALUES(?, ?)");
        this.queryStrings.put("CREATE_JOB_INSTANCE", "INSERT INTO " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " (name, apptag) VALUES(?, ?)");
        this.queryStrings.put("CREATE_JOB_EXECUTION_ENTRY", "INSERT INTO " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " (jobinstanceid, createtime, updatetime, batchstatus, parameters) VALUES(?, ?, ?, ?, ?)");
        this.queryStrings.put("CREATE_STEP_EXECUTION", "INSERT INTO " + this.schemaTableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " (jobexecid, batchstatus, exitstatus, stepname, readcount," + "writecount, commitcount, rollbackcount, readskipcount, processskipcount, filtercount, writeskipcount, starttime," + "endtime, persistentdata) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.queryStrings.put("UPDATE_WITH_FINAL_PARTITION_STEP_EXECUTION", "select SUM(STEPEX.readcount) readcount, SUM(STEPEX.writecount) writecount, SUM(STEPEX.commitcount) commitcount,  SUM(STEPEX.rollbackcount) rollbackcount, SUM(STEPEX.readskipcount) readskipcount, SUM(STEPEX.processskipcount) processskipcount, SUM(STEPEX.filtercount) filtercount, SUM(STEPEX.writeSkipCount) writeSkipCount from " + this.schemaTableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " STEPEX inner join " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " JOBEX" + " on STEPEX.jobexecid = JOBEX.jobexecid" + " where JOBEX.jobinstanceid IN" + " (select jobinstanceid from " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " where name like ?)");
        this.queryStrings.put("UPDATE_STEP_EXECUTION_WITH_METRICS", "UPDATE " + this.schemaTableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " SET batchstatus = ?, exitstatus = ?, stepname = ?,  readcount = ?," + "writecount = ?, commitcount = ?, rollbackcount = ?, readskipcount = ?, processskipcount = ?, filtercount = ?, writeskipcount = ?," + " starttime = ?, endtime = ?, persistentdata = ? WHERE stepexecid = ?");
        this.queryStrings.put("CREATE_JOBSTATUS", "INSERT INTO " + this.schemaTableNames.get("JOB_STATUS_TABLE_KEY") + " (id, obj) VALUES(?, ?)");
        this.queryStrings.put("GET_JOB_STATUS", "SELECT obj FROM " + this.schemaTableNames.get("JOB_STATUS_TABLE_KEY") + " WHERE id = ?");
        this.queryStrings.put("UPDATE_JOBSTATUS", "UPDATE " + this.schemaTableNames.get("JOB_STATUS_TABLE_KEY") + " SET obj = ? WHERE id = ?");
        this.queryStrings.put("CREATE_STEP_STATUS", "INSERT INTO " + this.schemaTableNames.get("STEP_STATUS_TABLE_KEY") + " (id, obj) VALUES(?, ?)");
        this.queryStrings.put("GET_STEP_STATUS", "SELECT obj FROM " + this.schemaTableNames.get("STEP_STATUS_TABLE_KEY") + " WHERE id IN (" + "SELECT B.stepexecid FROM " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.schemaTableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " B ON A.jobexecid = B.jobexecid " + "WHERE A.jobinstanceid = ? and B.stepname = ?)");
        this.queryStrings.put("UPDATE_STEP_STATUS", "UPDATE " + this.schemaTableNames.get("STEP_STATUS_TABLE_KEY") + " SET obj = ? WHERE id = ?");
        this.queryStrings.put("GET_TAGNAME", "SELECT A.apptag FROM " + this.schemaTableNames.get("JOB_INSTANCE_TABLE_KEY") + " A INNER JOIN " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B ON A.jobinstanceid = B.jobinstanceid" + " WHERE B.jobexecid = ?");
        this.queryStrings.put("GET_MOST_RECENT_EXECUTION_ID", "SELECT jobexecid FROM " + this.schemaTableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " WHERE jobinstanceid = ? ORDER BY createtime DESC");
        return this.queryStrings;
    }
}

