/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFishException;

public class GAVConvertor {
    private static final Logger logger = Logger.getLogger("PayaraMicro");

    public Map.Entry<String, URL> getArtefactMapEntry(String GAV, List<URL> repositoryURLs) throws GlassFishException {
        Map<String, String> GAVMap = this.splitGAV(GAV);
        AbstractMap.SimpleEntry<String, URL> artefactMapEntry = null;
        try {
            String relativeURLString = this.constructRelativeURLString(GAVMap);
            URL artefactURL = this.findArtefactURL(repositoryURLs, relativeURLString);
            artefactMapEntry = new AbstractMap.SimpleEntry<String, URL>(GAVMap.get("artefactId"), artefactURL);
        }
        catch (MalformedURLException ex) {
            logger.log(Level.WARNING, "Error converting GAV to URL: {0}", GAV);
        }
        if (artefactMapEntry == null) {
            throw new GlassFishException("Error getting artefact URL for GAV: " + GAVMap.get("groupId") + ", " + GAVMap.get("artefactId") + ", " + GAVMap.get("versionNumber"));
        }
        return artefactMapEntry;
    }

    private Map<String, String> splitGAV(String GAV) throws GlassFishException {
        String[] splitGAV = GAV.split(",|:");
        HashMap<String, String> GAVMap = new HashMap<String, String>();
        try {
            GAVMap.put("groupId", splitGAV[0].replace('.', '/'));
            GAVMap.put("artefactId", splitGAV[1]);
            GAVMap.put("versionNumber", splitGAV[2]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new GlassFishException("Error converting String \"" + GAV + "\" to GAV, make sure it takes the form of " + "groupId,artifactId,version");
        }
        return GAVMap;
    }

    private String constructRelativeURLString(Map<String, String> GAVMap) throws MalformedURLException {
        String artefactFileName = GAVMap.get("artefactId") + "-" + GAVMap.get("versionNumber");
        String relativeURLString = GAVMap.get("groupId") + "/" + GAVMap.get("artefactId") + "/" + GAVMap.get("versionNumber") + "/" + artefactFileName;
        return relativeURLString;
    }

    private URL findArtefactURL(List<URL> repositoryURLs, String relativeURLString) throws GlassFishException {
        String[] archiveTypes = new String[]{".jar", ".war", ".ear"};
        boolean validURLFound = false;
        URL artefactURL = null;
        for (URL repositoryURL : repositoryURLs) {
            for (String archiveType : archiveTypes) {
                try {
                    artefactURL = new URL(repositoryURL, relativeURLString + archiveType);
                    HttpURLConnection httpConnection = (HttpURLConnection)artefactURL.openConnection();
                    httpConnection.setRequestMethod("HEAD");
                    if (httpConnection.getResponseCode() == 200) {
                        validURLFound = true;
                        break;
                    }
                    logger.log(Level.FINE, "Artefact not found at URL: {0}", artefactURL.toString());
                }
                catch (MalformedURLException ex) {
                    Object[] errorParameters = new String[]{repositoryURL.toString(), relativeURLString, archiveType};
                    logger.log(Level.WARNING, "Error creating URL from repository URL, {0}, relative URL, {1}, and archive type, {2}", errorParameters);
                }
                catch (ProtocolException ex) {
                    logger.log(Level.WARNING, "Error setting request method to \"HEAD\"");
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "Error getting HTTP connection response code");
                }
            }
            if (!validURLFound) continue;
            break;
        }
        if (!validURLFound) {
            throw new GlassFishException("No artefact can be found for relative URL: " + relativeURLString);
        }
        return artefactURL;
    }
}

