/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.cdi;

import fish.payara.appserver.micro.services.CDIEventListener;
import fish.payara.appserver.micro.services.PayaraClusteredCDIEvent;
import fish.payara.micro.PayaraMicroRuntime;
import fish.payara.micro.cdi.Inbound;
import fish.payara.micro.cdi.Outbound;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;

@ApplicationScoped
public class ClusteredCDIEventBus
implements CDIEventListener {
    @Inject
    PayaraMicroRuntime runtime;
    @Inject
    BeanManager bm;
    @Inject
    @Inbound
    Event<Serializable> clusterEvent;
    ClassLoader capturedClassLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventReceived(PayaraClusteredCDIEvent event) {
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.capturedClassLoader);
            Serializable eventPayload = event.getPayload();
            this.clusterEvent.fire(eventPayload);
        }
        catch (IOException | ClassNotFoundException ex) {
            Logger.getLogger(ClusteredCDIEventBus.class.getName()).log(Level.FINE, "Received event which could not be deserialized", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }

    public void initialize() {
        Logger.getLogger(ClusteredCDIEventBus.class.getName()).log(Level.INFO, "Clustered CDI Event bus initialized");
    }

    void onOutboundEvent(@Observes @Outbound Serializable event) {
        try {
            PayaraClusteredCDIEvent clusteredEvent = new PayaraClusteredCDIEvent(this.runtime.getLocalDescriptor(), event);
            this.runtime.publishCDIEvent(clusteredEvent);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @PostConstruct
    void postConstruct() {
        this.runtime.addCDIEventListener(this);
        this.capturedClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @PreDestroy
    void preDestroy() {
        this.runtime.removeCDIEventListener(this);
    }
}

