/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck;

import fish.payara.nucleus.healthcheck.HealthCheckExecutionOptions;
import fish.payara.nucleus.healthcheck.HealthCheckTask;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-core")
@RunLevel(value=10)
public class HealthCheckService
implements EventListener {
    private static final Logger logger = Logger.getLogger(HealthCheckService.class.getCanonicalName());
    private static final String PREFIX = "healthcheck-service-";
    @Inject
    @Named(value="default-instance-name")
    @Optional
    HealthCheckServiceConfiguration configuration;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private Events events;
    @Inject
    ServerContext server;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private ScheduledExecutorService executor;
    private final Map<String, HealthCheckTask> registeredTasks = new HashMap<String, HealthCheckTask>();
    private boolean enabled;

    @Override
    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            this.executor.shutdownNow();
        } else if (event.is(EventTypes.SERVER_READY)) {
            this.bootstrapHealthCheck();
        }
    }

    public void registerCheck(String name, BaseHealthCheck check) {
        this.registeredTasks.put(name, new HealthCheckTask(name, check));
    }

    @PostConstruct
    void postConstruct() {
        if (this.configuration != null && Boolean.parseBoolean(this.configuration.getEnabled())) {
            this.enabled = true;
            this.bootstrapHealthCheck();
        }
    }

    public void bootstrapHealthCheck() {
        HealthCheckServiceConfiguration configuration = this.habitat.getService(HealthCheckServiceConfiguration.class, new Annotation[0]);
        if (configuration != null) {
            this.executor = Executors.newScheduledThreadPool(configuration.getCheckerList().size(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, HealthCheckService.PREFIX + HealthCheckService.this.threadNumber.getAndIncrement());
                }
            });
            this.events.register(this);
            if (this.enabled) {
                logger.info("Payara Health Check Service Started.");
                this.executeTasks();
            }
        }
    }

    private void executeTasks() {
        for (HealthCheckTask registeredTask : this.registeredTasks.values()) {
            logger.info("Scheduling Health Check for task: " + registeredTask.getName());
            if (!((HealthCheckExecutionOptions)registeredTask.getCheck().getOptions()).isEnabled()) continue;
            this.executor.scheduleAtFixedRate(registeredTask, 0L, ((HealthCheckExecutionOptions)registeredTask.getCheck().getOptions()).getTime(), ((HealthCheckExecutionOptions)registeredTask.getCheck().getOptions()).getUnit());
        }
    }

    public void setEnabled(Boolean enabled) {
        if (this.enabled && !enabled.booleanValue()) {
            this.enabled = false;
            this.shutdownHealthCheck();
        } else if (!this.enabled && enabled.booleanValue()) {
            this.enabled = true;
            this.bootstrapHealthCheck();
        } else if (this.enabled && enabled.booleanValue()) {
            this.shutdownHealthCheck();
            this.bootstrapHealthCheck();
        }
    }

    public void reboot() {
        this.shutdownHealthCheck();
        if (this.configuration == null) {
            this.configuration = this.server.getConfigBean().getConfig().getExtensionByType(HealthCheckServiceConfiguration.class);
        }
        if (Boolean.valueOf(this.configuration.getEnabled()).booleanValue()) {
            this.bootstrapHealthCheck();
        }
    }

    public void shutdownHealthCheck() {
        if (this.executor != null) {
            this.executor.shutdown();
            Logger.getLogger(HealthCheckService.class.getName()).log(Level.INFO, "Payara Health Check Service is shutdown.");
        }
    }

    public BaseHealthCheck getCheck(String serviceName) {
        return this.registeredTasks.get(serviceName).getCheck();
    }

    public HealthCheckServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HealthCheckServiceConfiguration configuration) {
        this.configuration = configuration;
    }
}

