/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import java.beans.PropertyVetoException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="healthcheck-configure")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.configure")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="healthcheck-configure", description="Enables/Disables Health Check Service")})
public class HealthCheckConfigurer
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(HealthCheckConfigurer.class);
    @Inject
    ServerEnvironment server;
    @Inject
    protected Logger logger;
    @Inject
    HealthCheckService service;
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    protected Target targetUtil;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server-config")
    protected String target;
    @Param(name="enabled", optional=false)
    private Boolean enabled;

    @Override
    public void execute(AdminCommandContext context) {
        Config config;
        HealthCheckServiceConfiguration healthCheckServiceConfiguration;
        final ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if ((healthCheckServiceConfiguration = (config = this.targetUtil.getConfig(this.target)).getExtensionByType(HealthCheckServiceConfiguration.class)) != null) {
            try {
                ConfigSupport.apply(new SingleConfigCode<HealthCheckServiceConfiguration>(){

                    @Override
                    public Object run(HealthCheckServiceConfiguration healthCheckServiceConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        if (HealthCheckConfigurer.this.enabled != null) {
                            healthCheckServiceConfigurationProxy.enabled(HealthCheckConfigurer.this.enabled.toString());
                        }
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return healthCheckServiceConfigurationProxy;
                    }
                }, healthCheckServiceConfiguration);
            }
            catch (TransactionFailure ex) {
                this.logger.log(Level.WARNING, "Exception during command ", ex);
                actionReport.setMessage(ex.getCause().getMessage());
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.dynamic.booleanValue()) {
            if (this.server.isDas()) {
                if (this.targetUtil.getConfig(this.target).isDas()) {
                    this.service.setEnabled(this.enabled);
                }
            } else {
                this.service.setEnabled(this.enabled);
            }
        }
    }
}

