/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.PoolStatus;
import fish.payara.nucleus.healthcheck.HealthCheckConnectionPoolExecutionOptions;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckResultEntry;
import fish.payara.nucleus.healthcheck.configuration.ConnectionPoolChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.jdbc.util.JdbcResourcesUtil;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-cpool")
@RunLevel(value=10)
public class ConnectionPoolHealthCheck
extends BaseThresholdHealthCheck<HealthCheckConnectionPoolExecutionOptions, ConnectionPoolChecker> {
    @Inject
    private Domain domain;
    @Inject
    private Applications applications;
    @Inject
    private PoolManager poolManager;

    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, ConnectionPoolChecker.class);
    }

    @Override
    public HealthCheckConnectionPoolExecutionOptions constructOptions(ConnectionPoolChecker checker) {
        return new HealthCheckConnectionPoolExecutionOptions(Boolean.valueOf(checker.getEnabled()), Long.parseLong(checker.getTime()), this.asTimeUnit(checker.getUnit()), checker.getPropertyValue("threshold-critical", "80"), checker.getPropertyValue("threshold-warning", "50"), checker.getPropertyValue("threshold-good", "0"), checker.getPoolName());
    }

    @Override
    public HealthCheckResult doCheck() {
        HealthCheckResult result = new HealthCheckResult();
        Collection<JdbcResource> allJdbcResources = this.getAllJdbcResources();
        for (JdbcResource resource : allJdbcResources) {
            ResourceInfo resourceInfo = ResourceUtil.getResourceInfo(resource);
            JdbcConnectionPool pool = JdbcResourcesUtil.createInstance().getJdbcConnectionPoolOfResource(resourceInfo);
            PoolInfo poolInfo = ResourceUtil.getPoolInfo(pool);
            if (((HealthCheckConnectionPoolExecutionOptions)this.getOptions()).getPoolName() != null) {
                if (!((HealthCheckConnectionPoolExecutionOptions)this.getOptions()).getPoolName().equals(poolInfo.getName())) continue;
                this.evaluatePoolUsage(result, poolInfo);
                continue;
            }
            this.evaluatePoolUsage(result, poolInfo);
        }
        return result;
    }

    private void evaluatePoolUsage(HealthCheckResult result, PoolInfo poolInfo) {
        long freeConnection;
        long usedConnection;
        long totalConnection;
        PoolStatus poolStatus = this.poolManager.getPoolStatus(poolInfo);
        if (poolStatus != null && (totalConnection = (usedConnection = (long)poolStatus.getNumConnUsed()) + (freeConnection = (long)poolStatus.getNumConnFree())) > 0L) {
            double usedPercentage = (double)usedConnection / (double)totalConnection * 100.0;
            result.add(new HealthCheckResultEntry(this.decideOnStatusWithRatio(usedPercentage), poolInfo.getName() + " Usage (%): " + new DecimalFormat("#.00").format(usedPercentage)));
        }
    }

    private Collection<JdbcResource> getAllJdbcResources() {
        ArrayList<JdbcResource> allResources = new ArrayList<JdbcResource>();
        Collection<JdbcResource> jdbcResources = this.domain.getResources().getResources(JdbcResource.class);
        allResources.addAll(jdbcResources);
        for (Application app : this.applications.getApplications()) {
            List<Module> modules;
            if (!ResourcesUtil.createInstance().isEnabled(app)) continue;
            Resources appScopedResources = app.getResources();
            if (appScopedResources != null && appScopedResources.getResources() != null) {
                allResources.addAll(appScopedResources.getResources(JdbcResource.class));
            }
            if ((modules = app.getModule()) == null) continue;
            for (Module module : modules) {
                Resources msr = module.getResources();
                if (msr == null || msr.getResources() == null) continue;
                allResources.addAll(msr.getResources(JdbcResource.class));
            }
        }
        return allResources;
    }
}

