/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckResultEntry;
import fish.payara.nucleus.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.HealthCheckWithThresholdExecutionOptions;
import fish.payara.nucleus.healthcheck.configuration.MachineMemoryUsageChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import javax.annotation.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-machinemem")
@RunLevel(value=10)
public class MachineMemoryUsageHealthCheck
extends BaseThresholdHealthCheck<HealthCheckWithThresholdExecutionOptions, MachineMemoryUsageChecker> {
    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, MachineMemoryUsageChecker.class);
    }

    @Override
    public HealthCheckWithThresholdExecutionOptions constructOptions(MachineMemoryUsageChecker checker) {
        return super.constructThresholdOptions(checker);
    }

    @Override
    public HealthCheckResult doCheck() {
        HealthCheckResult result = new HealthCheckResult();
        try {
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            Long totalPhysicalMemSize = this.invokeMethodFor(osBean, "getTotalPhysicalMemorySize");
            Long freePhysicalMemSize = this.invokeMethodFor(osBean, "getFreePhysicalMemorySize");
            double usedPercentage = (double)(totalPhysicalMemSize - freePhysicalMemSize) / (double)totalPhysicalMemSize.longValue() * 100.0;
            result.add(new HealthCheckResultEntry(this.decideOnStatusWithRatio(usedPercentage), "Physical Memory Used: " + this.prettyPrintBytes(totalPhysicalMemSize - freePhysicalMemSize) + " - " + "Total Physical Memory: " + this.prettyPrintBytes(totalPhysicalMemSize) + " - " + "Memory Used%: " + new DecimalFormat("#.00").format(usedPercentage) + "%"));
        }
        catch (Exception exception) {
            result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CHECK_ERROR, "Operating system methods cannot be invoked for retrieving physical memory usage values", exception));
        }
        return result;
    }

    private Long invokeMethodFor(OperatingSystemMXBean osBean, String methodName) throws Exception {
        Method m = osBean.getClass().getDeclaredMethod(methodName, new Class[0]);
        m.setAccessible(true);
        return (Long)m.invoke((Object)osBean, new Object[0]);
    }
}

