/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing;

import fish.payara.nucleus.requesttracing.RequestTrace;
import fish.payara.nucleus.requesttracing.domain.RequestEvent;
import java.util.UUID;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class RequestEventStore {
    private ThreadLocal<RequestTrace> eventStore = new ThreadLocal<RequestTrace>(){

        @Override
        protected RequestTrace initialValue() {
            return new RequestTrace();
        }
    };

    void storeEvent(RequestEvent requestEvent) {
        RequestTrace currentTrace = this.eventStore.get();
        currentTrace.addEvent(requestEvent);
    }

    long getElapsedTime() {
        return this.eventStore.get().getElapsedTime();
    }

    void flushStore() {
        this.eventStore.set(new RequestTrace());
    }

    String getTraceAsString() {
        return this.eventStore.get().toString();
    }

    RequestTrace getTrace() {
        return this.eventStore.get();
    }

    void setConverstationID(UUID newID) {
        RequestTrace rt = this.eventStore.get();
        rt.setConversationID(newID);
    }

    UUID getConversationID() {
        Object result = null;
        RequestTrace rt = this.eventStore.get();
        return rt.getConversationID();
    }

    boolean isTraceInProgress() {
        return this.eventStore.get().isStarted() && !this.eventStore.get().isCompleted();
    }
}

