/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import fish.payara.nucleus.notification.NotificationService;
import fish.payara.nucleus.notification.configuration.Notifier;
import fish.payara.nucleus.requesttracing.RequestEventStore;
import fish.payara.nucleus.requesttracing.RequestTracingNotificationEventFactory;
import fish.payara.nucleus.requesttracing.configuration.RequestTracingServiceConfiguration;
import fish.payara.nucleus.requesttracing.domain.EventType;
import fish.payara.nucleus.requesttracing.domain.RequestEvent;
import fish.payara.nucleus.requesttracing.domain.execoptions.NotifierExecutionOptions;
import fish.payara.nucleus.requesttracing.domain.execoptions.NotifierExecutionOptionsFactory;
import fish.payara.nucleus.requesttracing.domain.execoptions.RequestTracingExecutionOptions;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service(name="requesttracing-service")
@RunLevel(value=10)
public class RequestTracingService
implements EventListener {
    private static final Logger logger = Logger.getLogger(RequestTracingService.class.getCanonicalName());
    @Inject
    @Named(value="default-instance-name")
    @Optional
    RequestTracingServiceConfiguration configuration;
    @Inject
    private Events events;
    @Inject
    private Domain domain;
    @Inject
    private Server server;
    @Inject
    NotificationService notificationService;
    @Inject
    RequestEventStore requestEventStore;
    @Inject
    private RequestTracingNotificationEventFactory eventFactory;
    @Inject
    NotifierExecutionOptionsFactory executionOptionsFactory;
    private RequestTracingExecutionOptions executionOptions = new RequestTracingExecutionOptions();

    @PostConstruct
    void postConstruct() {
        if (this.configuration != null) {
            this.executionOptions.setEnabled(Boolean.parseBoolean(this.configuration.getEnabled()));
            this.executionOptions.setThresholdValue(Long.parseLong(this.configuration.getThresholdValue()));
            this.executionOptions.setThresholdUnit(TimeUnit.valueOf(this.configuration.getThresholdUnit()));
            for (Notifier notifier : this.configuration.getNotifierList()) {
                this.executionOptions.addNotifierExecutionOption(this.executionOptionsFactory.build(notifier));
            }
        }
        this.events.register(this);
    }

    @Override
    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.bootstrapRequestTracingService();
        }
    }

    private void bootstrapRequestTracingService() {
        if (this.executionOptions != null && this.executionOptions.isEnabled()) {
            logger.info("Payara Request Tracing Service Started with configuration: " + this.executionOptions);
        }
    }

    public UUID getConversationID() {
        return this.requestEventStore.getConversationID();
    }

    public void setConversationID(UUID newID) {
        this.requestEventStore.setConverstationID(newID);
    }

    public boolean isTraceInProgress() {
        return this.requestEventStore.isTraceInProgress();
    }

    public UUID startTrace() {
        if (!this.isRequestTracingEnabled()) {
            return null;
        }
        RequestEvent requestEvent = new RequestEvent(EventType.TRACE_START, "StartTrace");
        requestEvent.addProperty("Server", this.server.getName());
        requestEvent.addProperty("Domain", this.domain.getName());
        this.requestEventStore.storeEvent(requestEvent);
        return requestEvent.getId();
    }

    public void traceRequestEvent(RequestEvent requestEvent) {
        if (this.isRequestTracingEnabled()) {
            this.requestEventStore.storeEvent(requestEvent);
        }
    }

    public void endTrace() {
        if (!this.isRequestTracingEnabled()) {
            return;
        }
        this.requestEventStore.storeEvent(new RequestEvent(EventType.TRACE_END, "TraceEnd"));
        Long thresholdValueInNanos = this.getThresholdValueInNanos();
        long elapsedTime = this.requestEventStore.getElapsedTime();
        long elapsedTimeInNanos = TimeUnit.NANOSECONDS.convert(elapsedTime, TimeUnit.MILLISECONDS);
        if (elapsedTimeInNanos - thresholdValueInNanos > 0L) {
            for (NotifierExecutionOptions notifierExecutionOptions : this.getExecutionOptions().getNotifierExecutionOptionsList().values()) {
                if (!notifierExecutionOptions.isEnabled()) continue;
                this.notificationService.notify(this.eventFactory.build(elapsedTime, notifierExecutionOptions.getNotifierType()));
            }
        }
        this.requestEventStore.flushStore();
    }

    public Long getThresholdValueInNanos() {
        if (this.getExecutionOptions() != null) {
            return TimeUnit.NANOSECONDS.convert(this.getExecutionOptions().getThresholdValue(), this.getExecutionOptions().getThresholdUnit());
        }
        return null;
    }

    public boolean isRequestTracingEnabled() {
        return this.getExecutionOptions() != null && this.getExecutionOptions().isEnabled();
    }

    public RequestTracingExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }
}

