/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.api;

import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.nucleus.requesttracing.api.Traced;
import fish.payara.nucleus.requesttracing.domain.RequestEvent;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.glassfish.internal.api.Globals;

@Interceptor
@Traced
@Priority(value=4000)
public class RequestTracingCdiInterceptor
implements Serializable {
    @AroundInvoke
    public Object traceCdiCall(InvocationContext ctx) throws Exception {
        RequestTracingService requestTracing = Globals.getDefaultHabitat().getService(RequestTracingService.class, new Annotation[0]);
        if (requestTracing != null && requestTracing.isRequestTracingEnabled()) {
            RequestEvent requestEvent = new RequestEvent("InterceptedCdiRequest-ENTER");
            requestEvent.addProperty("TargetClass", ctx.getTarget().getClass().getName());
            requestEvent.addProperty("MethodName", ctx.getMethod().getName());
            requestTracing.traceRequestEvent(requestEvent);
        }
        Object proceed = ctx.proceed();
        if (requestTracing != null && requestTracing.isRequestTracingEnabled()) {
            RequestEvent requestEvent = new RequestEvent("InterceptedCdiRequest-EXIT");
            requestEvent.addProperty("TargetClass", ctx.getTarget().getClass().getName());
            requestEvent.addProperty("MethodName", ctx.getMethod().getName());
            requestTracing.traceRequestEvent(requestEvent);
        }
        return proceed;
    }
}

