/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.TransactionHandleImpl;
import org.glassfish.enterprise.concurrent.spi.TransactionHandle;
import org.glassfish.enterprise.concurrent.spi.TransactionSetupProvider;

public class TransactionSetupProviderImpl
implements TransactionSetupProvider {
    private transient JavaEETransactionManager transactionManager;
    static final long serialVersionUID = -856400645253308289L;

    public TransactionSetupProviderImpl(JavaEETransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public TransactionHandle beforeProxyMethod(String transactionExecutionProperty) {
        if (!"USE_TRANSACTION_OF_EXECUTION_THREAD".equals(transactionExecutionProperty)) {
            try {
                Transaction suspendedTxn = this.transactionManager.suspend();
                return new TransactionHandleImpl(suspendedTxn);
            }
            catch (SystemException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.toString());
            }
        }
        return null;
    }

    @Override
    public void afterProxyMethod(TransactionHandle handle, String transactionExecutionProperty) {
        Transaction suspendedTxn;
        if (handle instanceof TransactionHandleImpl && (suspendedTxn = ((TransactionHandleImpl)handle).getTransaction()) != null) {
            try {
                this.transactionManager.resume(suspendedTxn);
            }
            catch (InvalidTransactionException | SystemException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.toString());
            }
        }
    }

    private void writeObject(ObjectOutputStream out) {
    }

    private void readObject(ObjectInputStream in) {
        ConcurrentRuntime concurrentRuntime = ConcurrentRuntime.getRuntime();
        this.transactionManager = concurrentRuntime.getTransactionManager();
    }
}

