/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.http2.AggrCompletionHandler;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2FrameCodec;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.frames.DataFrame;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.utils.ChunkedCompletionHandler;

public class Http2ConnectionOutputSink {
    protected final Http2Connection http2Connection;
    private static final Logger LOGGER = Grizzly.logger(Http2ConnectionOutputSink.class);
    private static final Level LOGGER_LEVEL = Level.FINE;
    private static final int MAX_FRAME_PAYLOAD_SIZE = 16383;
    private static final int MAX_OUTPUT_QUEUE_SIZE = 65536;
    private final TaskQueue<OutputQueueRecord> outputQueue = TaskQueue.createTaskQueue(new TaskQueue.MutableMaxQueueSize(){

        @Override
        public int getMaxQueueSize() {
            return 65536;
        }
    });
    private final AtomicInteger availConnectionWindowSize;
    private final List<Http2Frame> tmpFramesList = new LinkedList<Http2Frame>();
    private final AtomicBoolean writerLock = new AtomicBoolean();

    public Http2ConnectionOutputSink(Http2Connection session) {
        this.http2Connection = session;
        this.availConnectionWindowSize = new AtomicInteger(this.http2Connection.getDefaultConnectionWindowSize());
    }

    protected Http2FrameCodec frameCodec() {
        return this.http2Connection.handlerFilter.frameCodec;
    }

    protected void writeDownStream(Http2Frame frame) {
        this.writeDownStream(frame, null);
    }

    protected void writeDownStream(Http2Frame frame, CompletionHandler<WriteResult> completionHandler) {
        this.http2Connection.getHttp2ConnectionChain().write(this.http2Connection.getConnection(), null, (Object)this.frameCodec().serializeAndRecycle(this.http2Connection, frame), completionHandler, (MessageCloner)null);
    }

    protected void writeDownStream(List<Http2Frame> frames) {
        this.writeDownStream(frames, null);
    }

    protected void writeDownStream(List<Http2Frame> frames, CompletionHandler<WriteResult> completionHandler) {
        this.http2Connection.getHttp2ConnectionChain().write(this.http2Connection.getConnection(), null, (Object)this.frameCodec().serializeAndRecycle(this.http2Connection, frames), completionHandler, (MessageCloner)null);
    }

    protected <K> void writeDownStream(K anyMessage, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner) {
        Object msg = anyMessage instanceof List ? this.frameCodec().serializeAndRecycle(this.http2Connection, (List)anyMessage) : (anyMessage instanceof Http2Frame ? this.frameCodec().serializeAndRecycle(this.http2Connection, (Http2Frame)anyMessage) : anyMessage);
        this.http2Connection.getHttp2ConnectionChain().write(this.http2Connection.getConnection(), null, msg, completionHandler, messageCloner);
    }

    protected int getAvailablePeerConnectionWindowSize() {
        return this.availConnectionWindowSize.get();
    }

    protected boolean canWrite() {
        return this.outputQueue.size() < 65536;
    }

    protected void notifyCanWrite(WriteHandler writeHandler) {
        this.outputQueue.notifyWritePossible(writeHandler, 65536);
    }

    protected void onPeerWindowUpdate(int delta) {
        int newWindowSize = this.availConnectionWindowSize.addAndGet(delta);
        if (LOGGER.isLoggable(LOGGER_LEVEL)) {
            LOGGER.log(LOGGER_LEVEL, "SpdySession. Expand connection window size by {0} bytes. Current connection window size is: {1}", new Object[]{delta, newWindowSize});
        }
        this.flushOutputQueue();
    }

    protected void writeDataDownStream(Http2Stream stream, List<Http2Frame> headerFrames, Buffer data, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner, boolean isLast) {
        if (data == null || !data.hasRemaining() && stream.getUnflushedWritesCount() == 1) {
            Object msg;
            if (data == null) {
                this.writeDownStream(headerFrames, completionHandler, messageCloner);
                return;
            }
            DataFrame dataFrame = ((DataFrame.DataFrameBuilder)DataFrame.builder().streamId(stream.getId())).data(data).endStream(isLast).build();
            if (headerFrames != null && !headerFrames.isEmpty()) {
                headerFrames.add(dataFrame);
                msg = headerFrames;
            } else {
                msg = dataFrame;
            }
            this.writeDownStream(msg, completionHandler, messageCloner);
            return;
        }
        if (headerFrames != null && !headerFrames.isEmpty()) {
            this.writeDownStream(headerFrames);
        }
        int dataSize = data.remaining();
        if (messageCloner != null) {
            data = messageCloner.clone(this.http2Connection.getConnection(), data);
        }
        OutputQueueRecord record = new OutputQueueRecord(stream.getId(), data, completionHandler, isLast);
        this.outputQueue.offer(record);
        this.outputQueue.reserveSpace(record.isZeroSizeData() ? 1 : dataSize);
        this.flushOutputQueue();
    }

    private void flushOutputQueue() {
        int backoffDelay = 0;
        boolean needToNotify = false;
        int tmpcnt = 0;
        while (this.availConnectionWindowSize.get() > 0 && !this.outputQueue.isEmpty() && this.writerLock.compareAndSet(false, true)) {
            int availWindowSize = this.availConnectionWindowSize.get();
            int queueSize = this.outputQueue.size();
            AggrCompletionHandler writeCompletionHandler = null;
            int writeCompletionHandlerBytes = 0;
            int bytesToTransfer = 0;
            int queueSizeToFree = 0;
            AggrCompletionHandler completionHandlers = null;
            while (availWindowSize > bytesToTransfer && queueSize > queueSizeToFree) {
                AggrCompletionHandler recordCompletionHandler;
                OutputQueueRecord record = this.outputQueue.poll();
                if (record == null) {
                    LOGGER.log(Level.WARNING, "UNEXPECTED NULL RECORD. Queue-size: {0} tmpcnt={1} byteToTransfer={2} queueSizeToFree={3} queueSize={4}", new Object[]{this.outputQueue.size(), tmpcnt, bytesToTransfer, queueSizeToFree, queueSize});
                }
                assert (record != null);
                int serializedBytes = record.serializeTo(this.tmpFramesList, Math.min(16383, availWindowSize - bytesToTransfer));
                bytesToTransfer += serializedBytes;
                queueSizeToFree += serializedBytes;
                if (record.isFinished()) {
                    if (record.isZeroSizeData()) {
                        ++queueSizeToFree;
                    }
                } else {
                    this.outputQueue.setCurrentElement(record);
                }
                if ((recordCompletionHandler = record.getCompletionHandler()) == null) continue;
                if (completionHandlers != null) {
                    completionHandlers.register(recordCompletionHandler, serializedBytes);
                    continue;
                }
                if (writeCompletionHandler == null) {
                    writeCompletionHandler = recordCompletionHandler;
                    writeCompletionHandlerBytes = serializedBytes;
                    continue;
                }
                completionHandlers = new AggrCompletionHandler();
                completionHandlers.register(writeCompletionHandler, writeCompletionHandlerBytes);
                completionHandlers.register(recordCompletionHandler, serializedBytes);
                writeCompletionHandler = completionHandlers;
            }
            if (queueSizeToFree > 0) {
                assert (!this.tmpFramesList.isEmpty());
                this.writeDownStream(this.tmpFramesList, writeCompletionHandler, null);
                int newWindowSize = this.availConnectionWindowSize.addAndGet(-bytesToTransfer);
                this.outputQueue.releaseSpace(queueSizeToFree);
                needToNotify = true;
                if (LOGGER.isLoggable(LOGGER_LEVEL)) {
                    LOGGER.log(LOGGER_LEVEL, "SpdySession. Shrink connection window size by {0} bytes. Current connection window size is: {1}", new Object[]{bytesToTransfer, newWindowSize});
                }
            }
            this.writerLock.set(false);
            LockSupport.parkNanos(backoffDelay++);
            ++tmpcnt;
        }
        if (needToNotify) {
            this.outputQueue.doNotify();
        }
    }

    public void close() {
        this.outputQueue.onClose();
    }

    private static class OutputQueueRecord
    extends AsyncQueueRecord<WriteResult> {
        private final int streamId;
        private ChunkedCompletionHandler chunkedCompletionHandler;
        private final CompletionHandler<WriteResult> originalCompletionHandler;
        private Buffer buffer;
        private final boolean isLast;
        private final boolean isZeroSizeData;

        public OutputQueueRecord(int streamId, Buffer buffer, CompletionHandler<WriteResult> completionHandler, boolean isLast) {
            super(null, null, null);
            this.streamId = streamId;
            this.buffer = buffer;
            this.isZeroSizeData = !buffer.hasRemaining();
            this.originalCompletionHandler = completionHandler;
            this.isLast = isLast;
        }

        public CompletionHandler<WriteResult> getCompletionHandler() {
            return this.chunkedCompletionHandler != null ? this.chunkedCompletionHandler : this.originalCompletionHandler;
        }

        @Override
        public void notifyFailure(Throwable e) {
            CompletionHandler<WriteResult> chLocal = this.getCompletionHandler();
            if (chLocal != null) {
                chLocal.failed(e);
            }
        }

        @Override
        public void recycle() {
        }

        @Override
        public WriteResult getCurrentResult() {
            return null;
        }

        private boolean isZeroSizeData() {
            return this.isZeroSizeData;
        }

        private boolean isFinished() {
            return this.buffer == null;
        }

        private int serializeTo(List<Http2Frame> frames, int maxDataSize) {
            int recordSize = this.buffer.remaining();
            if (recordSize <= maxDataSize) {
                DataFrame dataFrame = ((DataFrame.DataFrameBuilder)DataFrame.builder().streamId(this.streamId)).data(this.buffer).endStream(this.isLast).build();
                frames.add(dataFrame);
                this.buffer = null;
                return recordSize;
            }
            if (this.originalCompletionHandler != null && this.chunkedCompletionHandler == null) {
                this.chunkedCompletionHandler = new ChunkedCompletionHandler(this.originalCompletionHandler);
            }
            if (this.chunkedCompletionHandler != null) {
                this.chunkedCompletionHandler.incChunks();
            }
            Buffer remainder = this.buffer.split(this.buffer.position() + maxDataSize);
            DataFrame dataFrame = ((DataFrame.DataFrameBuilder)DataFrame.builder().streamId(this.streamId)).data(this.buffer).endStream(false).build();
            frames.add(dataFrame);
            this.buffer = remainder;
            return maxDataSize;
        }
    }
}

