/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.embedded;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.internal.embedded.EmbeddedDeployer;
import org.glassfish.internal.embedded.LifecycleException;
import org.glassfish.internal.embedded.Server;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class EmbeddedDeployerImpl
implements EmbeddedDeployer {
    @Inject
    Deployment deployment;
    @Inject
    Server server;
    @Inject
    CommandRunner commandRunner;
    @Inject
    ServiceLocator habitat;
    @Inject
    ArchiveFactory factory;
    @Inject
    SnifferManager snifferMgr;
    @Inject
    ServerEnvironment env;
    @Inject
    DasConfig config;
    Map<String, EmbeddedDeployedInfo> deployedApps = new HashMap<String, EmbeddedDeployedInfo>();
    static final Logger logger = KernelLoggerInfo.getLogger();

    @Override
    public File getApplicationsDir() {
        return this.env.getApplicationRepositoryPath();
    }

    @Override
    public File getAutoDeployDir() {
        return new File(this.env.getDomainRoot(), this.config.getAutodeployDir());
    }

    @Override
    public void setAutoDeploy(final boolean flag) {
        boolean active;
        String value = this.config.getAutodeployEnabled();
        boolean bl = active = value != null && Boolean.parseBoolean(this.config.getAutodeployEnabled());
        if (active != flag) {
            try {
                ConfigSupport.apply(new SingleConfigCode<DasConfig>(){

                    @Override
                    public Object run(DasConfig dasConfig) throws PropertyVetoException, TransactionFailure {
                        dasConfig.setAutodeployEnabled(Boolean.valueOf(flag).toString());
                        return null;
                    }
                }, this.config);
            }
            catch (TransactionFailure e) {
                logger.log(Level.SEVERE, "NCLS-CORE-00067", e);
            }
        }
    }

    @Override
    public String deploy(File archive, DeployCommandParameters params) {
        try {
            ReadableArchive r = this.factory.openArchive(archive);
            return this.deploy(r, params);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "NCLS-CORE-00039", e);
            return null;
        }
    }

    @Override
    public String deploy(ReadableArchive archive, DeployCommandParameters params) {
        try {
            this.server.start();
        }
        catch (LifecycleException e) {
            throw new RuntimeException(e);
        }
        PlainTextActionReporter report = new PlainTextActionReporter();
        if (params == null) {
            params = new DeployCommandParameters();
        }
        DeploymentContextImpl initialContext = new DeploymentContextImpl(report, archive, params, this.env);
        ArchiveHandler archiveHandler = null;
        try {
            archiveHandler = this.deployment.getArchiveHandler(archive);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (archiveHandler == null) {
            throw new RuntimeException("Cannot find archive handler for source archive");
        }
        if (params.name == null) {
            params.name = archiveHandler.getDefaultApplicationName(archive, initialContext);
        }
        ExtendedDeploymentContext context = null;
        try {
            context = this.deployment.getBuilder(logger, params, report).source(archive).archiveHandler(archiveHandler).build(initialContext);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (params.property != null) {
            context.getAppProps().putAll((Map<?, ?>)params.property);
        }
        if (params.properties != null) {
            context.getAppProps().putAll((Map<?, ?>)params.properties);
        }
        ApplicationInfo appInfo = null;
        try {
            appInfo = this.deployment.deploy(context);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "NCLS-CORE-00039", e);
        }
        if (appInfo != null) {
            boolean isDirectory = new File(archive.getURI().getPath()).isDirectory();
            EmbeddedDeployedInfo info = new EmbeddedDeployedInfo(appInfo, context.getModulePropsMap(), context.getAppProps(), isDirectory);
            this.deployedApps.put(appInfo.getName(), info);
            return appInfo.getName();
        }
        return null;
    }

    @Override
    public void undeploy(String name, UndeployCommandParameters params) {
        ExtendedDeploymentContext deploymentContext;
        ApplicationInfo appInfo;
        ActionReport report = this.habitat.getService(ActionReport.class, "plain", new Annotation[0]);
        EmbeddedDeployedInfo info = this.deployedApps.get(name);
        ApplicationInfo applicationInfo = appInfo = info != null ? info.appInfo : null;
        if (appInfo == null) {
            appInfo = this.deployment.get(name);
        }
        if (appInfo == null) {
            report.setMessage("Cannot find deployed application of name " + name);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ReadableArchive source = appInfo.getSource();
        if (source == null) {
            report.setMessage("Cannot get source archive for undeployment");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (params == null) {
            params = new UndeployCommandParameters(name);
        }
        params.origin = OpsParams.Origin.undeploy;
        try {
            deploymentContext = this.deployment.getBuilder(logger, params, report).source(source).build();
            if (info != null) {
                for (ModuleInfo module : appInfo.getModuleInfos()) {
                    info.map.put(module.getName(), module.getModuleProps());
                    deploymentContext.getModuleProps().putAll((Map<?, ?>)module.getModuleProps());
                }
                deploymentContext.setModulePropsMap(info.map);
                deploymentContext.getAppProps().putAll((Map<?, ?>)info.appProps);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cannot create context for undeployment ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.deployment.undeploy(name, deploymentContext);
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            if (params.keepreposdir == null) {
                params.keepreposdir = false;
            }
            if (!params.keepreposdir.booleanValue() && info != null && !info.isDirectory && source.exists()) {
                FileUtils.whack(new File(source.getURI()));
            }
            deploymentContext.clean();
        }
    }

    @Override
    public void undeployAll() {
        for (String appName : this.deployedApps.keySet()) {
            this.undeploy(appName, null);
        }
    }

    private static final class EmbeddedDeployedInfo {
        final ApplicationInfo appInfo;
        final Map<String, Properties> map;
        final boolean isDirectory;
        Properties appProps;

        public EmbeddedDeployedInfo(ApplicationInfo appInfo, Map<String, Properties> map, Properties appProps, boolean isDirectory) {
            this.appInfo = appInfo;
            this.map = map;
            this.appProps = appProps;
            this.isDirectory = isDirectory;
        }
    }
}

