/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.sse.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import org.glassfish.sse.api.ServerSentEvent;
import org.glassfish.sse.api.ServerSentEventContext;
import org.glassfish.sse.api.ServerSentEventHandler;
import org.glassfish.sse.api.ServerSentEventHandlerContext;
import org.glassfish.sse.impl.ServerSentEventApplication;

public class ServerSentEventCdiExtension
implements Extension {
    private final Logger LOGGER = Logger.getLogger(ServerSentEventCdiExtension.class.getName());
    private final Map<String, ServerSentEventApplication> applicationMap = new HashMap<String, ServerSentEventApplication>();

    public Map<String, ServerSentEventApplication> getApplicationMap() {
        return this.applicationMap;
    }

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        bbd.addQualifier(ServerSentEventContext.class);
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery bbd) {
        for (Map.Entry<String, ServerSentEventApplication> entry : this.applicationMap.entrySet()) {
            bbd.addBean(new ServerSentEventHandlerContextBean(entry.getKey(), entry.getValue().getHandlerContext(), entry.getValue().getHandlerClass()));
        }
    }

    <T> void processAnnotatedType(@Observes @WithAnnotations(value={ServerSentEvent.class}) ProcessAnnotatedType<T> pat, BeanManager beanManager) {
        if (this.LOGGER.isLoggable(Level.FINE)) {
            this.LOGGER.fine("scanning type: " + pat.getAnnotatedType().getJavaClass().getName());
        }
        for (Annotation an : pat.getAnnotatedType().getAnnotations()) {
            Class<T> clazz = pat.getAnnotatedType().getJavaClass();
            if (!(an instanceof ServerSentEvent)) continue;
            if (!ServerSentEventHandler.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("Invalid base class '" + clazz.getName() + "' for handler.");
            }
            ServerSentEvent wh = (ServerSentEvent)an;
            String path = this.normalizePath(wh.value());
            ServerSentEventApplication app = this.applicationMap.get(path);
            if (app != null) {
                throw new RuntimeException("Two ServerSentEvent handlers are mapped to same path=" + path);
            }
            app = new ServerSentEventApplication(clazz, path);
            this.applicationMap.put(path, app);
        }
    }

    private String normalizePath(String path) {
        return (path = path.trim()).startsWith("/") ? path : "/" + path;
    }

    static class ServerSentEventHandlerContextBean
    implements Bean<ServerSentEventHandlerContext> {
        private final String path;
        private final ServerSentEventHandlerContext instance;
        private final Class<?> handlerClass;

        ServerSentEventHandlerContextBean(String path, ServerSentEventHandlerContext instance, Class<?> handlerClass) {
            this.path = path;
            this.instance = instance;
            this.handlerClass = handlerClass;
        }

        @Override
        public Set<Type> getTypes() {
            HashSet<Type> types = new HashSet<Type>();
            types.add(new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{ServerSentEventHandlerContextBean.this.handlerClass};
                }

                @Override
                public Type getRawType() {
                    return ServerSentEventHandlerContext.class;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }
            });
            return types;
        }

        @Override
        public Set<Annotation> getQualifiers() {
            HashSet<Annotation> qualifiers = new HashSet<Annotation>();
            qualifiers.add(new WebHandlerContextAnnotationLiteral(this.path));
            return qualifiers;
        }

        @Override
        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        @Override
        public Class<?> getBeanClass() {
            return ServerSentEventHandlerContext.class;
        }

        @Override
        public boolean isAlternative() {
            return false;
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        @Override
        public ServerSentEventHandlerContext create(CreationalContext<ServerSentEventHandlerContext> context) {
            return this.instance;
        }

        @Override
        public void destroy(ServerSentEventHandlerContext instance, CreationalContext<ServerSentEventHandlerContext> context) {
        }
    }

    static class WebHandlerContextAnnotationLiteral
    extends AnnotationLiteral<ServerSentEventContext>
    implements ServerSentEventContext {
        private final String path;

        WebHandlerContextAnnotationLiteral(String path) {
            this.path = path;
        }

        @Override
        public String value() {
            return this.path;
        }
    }
}

