/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.admin.monitor.HttpServiceStatsProviderBootstrap;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-http")
@PerLookup
@I18n(value="delete.http")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Protocol.class, opType=RestEndpoint.OpType.DELETE, path="delete-http", description="Delete", params={@RestParam(name="protocol", value="$parent")})})
public class DeleteHttp
implements AdminCommand {
    private static final ResourceBundle rb = HttpServiceStatsProviderBootstrap.rb;
    @LogMessageInfo(message="{0} http-redirect doesn't exist.", level="INFO")
    protected static final String DELETE_HTTP_NOTEXISTS = "AS-WEB-ADMIN-00032";
    @LogMessageInfo(message="Deletion of http {0} failed.", level="INFO")
    protected static final String DELETE_HTTP_FAIL = "AS-WEB-ADMIN-00033";
    @LogMessageInfo(message="Deletion of http-redirect {0} failed.", level="INFO")
    protected static final String DELETE_HTTP_REDIRECT_FAIL = "AS-WEB-ADMIN-00034";
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    Protocol protocolToBeRemoved = null;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator services;

    @Override
    public void execute(AdminCommandContext context) {
        Target targetUtil = this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Protocols protocols = networkConfig.getProtocols();
        try {
            for (Protocol protocol : protocols.getProtocol()) {
                if (!this.protocolName.equalsIgnoreCase(protocol.getName())) continue;
                this.protocolToBeRemoved = protocol;
            }
            if (this.protocolToBeRemoved == null) {
                report.setMessage(MessageFormat.format(rb.getString(DELETE_HTTP_NOTEXISTS), this.protocolName));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            List<NetworkListener> nwlsnrList = this.protocolToBeRemoved.findNetworkListeners();
            for (NetworkListener nwlsnr : nwlsnrList) {
                if (!this.protocolToBeRemoved.getName().equals(nwlsnr.getProtocol())) continue;
                report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00036"), this.protocolName, nwlsnr.getName()));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply(new SingleConfigCode<Protocol>(){

                @Override
                public Object run(Protocol param) {
                    param.setHttp(null);
                    return null;
                }
            }, this.protocolToBeRemoved);
        }
        catch (TransactionFailure e) {
            report.setMessage(MessageFormat.format(rb.getString(DELETE_HTTP_REDIRECT_FAIL), this.protocolName) + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

