/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.util;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.web.MultipartConfig;
import org.glassfish.web.deployment.descriptor.ServletFilterDescriptor;
import org.glassfish.web.deployment.descriptor.SessionConfigDescriptor;
import org.glassfish.web.deployment.util.WebBundleVisitor;

public class WebBundleValidator
extends ApplicationValidator
implements WebBundleVisitor {
    @Override
    public void accept(BundleDescriptor descriptor) {
        if (descriptor instanceof WebBundleDescriptor) {
            WebBundleDescriptor webBundle = (WebBundleDescriptor)descriptor;
            this.accept(webBundle);
            for (InjectionCapable injectionCapable : webBundle.getInjectableResources(webBundle)) {
                this.accept(injectionCapable);
            }
            for (WebComponentDescriptor webComponentDescriptor : webBundle.getWebComponentDescriptors()) {
                this.accept(webComponentDescriptor);
            }
            for (WebService webService : webBundle.getWebServices().getWebServices()) {
                this.accept(webService);
            }
            super.accept(descriptor);
            for (ServletFilterDescriptor servletFilterDescriptor : webBundle.getServletFilterDescriptors()) {
                this.accept(servletFilterDescriptor);
            }
        }
    }

    @Override
    public void accept(WebBundleDescriptor descriptor) {
        this.bundleDescriptor = descriptor;
        this.application = descriptor.getApplication();
        if (descriptor.getSessionConfig() == null) {
            descriptor.setSessionConfig(new SessionConfigDescriptor());
        }
        if (descriptor.isDistributable() == null) {
            descriptor.setDistributable(Boolean.FALSE);
        }
    }

    protected void accept(WebComponentDescriptor descriptor) {
        MultipartConfig multipartConfig;
        if (descriptor.getLoadOnStartUp() == null) {
            descriptor.setLoadOnStartUp(-1);
        }
        if (descriptor.isAsyncSupported() == null) {
            descriptor.setAsyncSupported(false);
        }
        if ((multipartConfig = descriptor.getMultipartConfig()) != null) {
            if (multipartConfig.getMaxFileSize() == null) {
                multipartConfig.setMaxFileSize(-1L);
            }
            if (multipartConfig.getMaxRequestSize() == null) {
                multipartConfig.setMaxRequestSize(-1L);
            }
            if (multipartConfig.getFileSizeThreshold() == null) {
                multipartConfig.setFileSizeThreshold(0);
            }
        }
        this.computeRuntimeDefault(descriptor);
    }

    private void computeRuntimeDefault(WebComponentDescriptor webComp) {
        if (!webComp.getUsesCallerIdentity()) {
            this.computeRunAsPrincipalDefault(webComp.getRunAsIdentity(), webComp.getApplication());
        }
    }

    protected void accept(ServletFilterDescriptor descriptor) {
        if (descriptor.isAsyncSupported() == null) {
            descriptor.setAsyncSupported(false);
        }
    }
}

