/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeContext;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.enablement.GlobalEnablementBuilder;
import org.jboss.weld.bootstrap.events.AbstractAnnotatedTypeRegisteringEvent;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;

public class AfterTypeDiscoveryImpl
extends AbstractAnnotatedTypeRegisteringEvent
implements AfterTypeDiscovery {
    private final GlobalEnablementBuilder builder;
    private final ContainerLifecycleEvents events;
    private final ClassTransformer transformer;
    private final SlimAnnotatedTypeStore store;

    public static void fire(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        new AfterTypeDiscoveryImpl(beanManager, bdaMapping, deployment, contexts).fire();
    }

    protected AfterTypeDiscoveryImpl(BeanManagerImpl beanManager, BeanDeploymentArchiveMapping bdaMapping, Deployment deployment, Collection<ContextHolder<? extends Context>> contexts) {
        super(beanManager, (Type)((Object)AfterTypeDiscovery.class), bdaMapping, deployment, contexts);
        this.builder = beanManager.getServices().get(GlobalEnablementBuilder.class);
        this.events = beanManager.getServices().get(ContainerLifecycleEvents.class);
        this.transformer = beanManager.getServices().get(ClassTransformer.class);
        this.store = beanManager.getServices().get(SlimAnnotatedTypeStore.class);
    }

    @Override
    public List<Class<?>> getAlternatives() {
        this.checkWithinObserverNotification();
        return this.builder.getAlternativeList(this.getReceiver());
    }

    @Override
    public List<Class<?>> getInterceptors() {
        this.checkWithinObserverNotification();
        return this.builder.getInterceptorList(this.getReceiver());
    }

    @Override
    public List<Class<?>> getDecorators() {
        this.checkWithinObserverNotification();
        return this.builder.getDecoratorList(this.getReceiver());
    }

    @Override
    public void addAnnotatedType(AnnotatedType<?> type2, String id) {
        this.checkWithinObserverNotification();
        this.addSyntheticAnnotatedType(type2, id);
        BootstrapLogger.LOG.addAnnotatedTypeCalled(this.getReceiver(), type2);
    }

    @Override
    protected void storeSyntheticAnnotatedType(BeanDeployment deployment, AnnotatedType<?> type2, String id) {
        SlimAnnotatedType<?> annotatedType = this.transformer.getUnbackedAnnotatedType(type2, this.getBeanManager().getId(), id);
        Extension extension = this.getReceiver();
        SlimAnnotatedTypeContext<?> annotatedTypeContext = SlimAnnotatedTypeContext.of(annotatedType, this.transformer, extension);
        ProcessAnnotatedTypeImpl<?> event = this.events.fireProcessAnnotatedType(this.getBeanManager(), annotatedTypeContext);
        if (event == null) {
            ((BeanDeployerEnvironment)deployment.getBeanDeployer().getEnvironment()).addAnnotatedType(annotatedTypeContext);
            this.store.put(annotatedType);
        } else {
            if (event.isVeto()) {
                return;
            }
            annotatedType = event.getResultingAnnotatedType();
            ((BeanDeployerEnvironment)deployment.getBeanDeployer().getEnvironment()).addSyntheticAnnotatedType(annotatedType, extension);
            this.store.put(annotatedType);
        }
    }
}

