/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro;

import fish.payara.micro.BootstrapException;
import fish.payara.micro.PayaraMicroRuntime;
import fish.payara.micro.boot.PayaraMicroBoot;
import fish.payara.micro.boot.PayaraMicroLauncher;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PayaraMicro {
    private PayaraMicroBoot wrappee;
    private ClassLoader nestedLoader;
    private static PayaraMicro instance;

    public static PayaraMicro getInstance() {
        return PayaraMicro.getInstance(true);
    }

    public static PayaraMicroRuntime bootstrap() throws BootstrapException {
        return PayaraMicro.getInstance().bootStrap();
    }

    public static PayaraMicro getInstance(boolean create) {
        if (instance == null && create) {
            instance = new PayaraMicro();
        }
        return instance;
    }

    public PayaraMicro addDeployFromGAV(String GAV) {
        this.wrappee.addDeployFromGAV(GAV);
        return this;
    }

    public PayaraMicro addDeployment(String pathToWar) {
        this.wrappee.addDeployment(pathToWar);
        return this;
    }

    public PayaraMicro addDeploymentFile(File file) {
        this.wrappee.addDeploymentFile(file);
        return this;
    }

    public PayaraMicro addRepoUrl(String ... URLs) {
        this.wrappee.addRepoUrl(URLs);
        return this;
    }

    public PayaraMicroRuntime bootStrap() throws BootstrapException {
        if (this.wrappee == null) {
            throw new BootstrapException("Could not create Runtime instance");
        }
        return this.wrappee.bootStrap();
    }

    public File getAlternateDomainXML() {
        return this.wrappee.getAlternateDomainXML();
    }

    public int getAutoBindRange() {
        return this.wrappee.getAutoBindRange();
    }

    public String getClusterMulticastGroup() {
        return this.wrappee.getClusterMulticastGroup();
    }

    public int getClusterPort() {
        return this.wrappee.getClusterPort();
    }

    public int getClusterStartPort() {
        return this.wrappee.getClusterStartPort();
    }

    public File getDeploymentDir() {
        return this.wrappee.getDeploymentDir();
    }

    public boolean getHttpAutoBind() {
        return this.wrappee.getHttpAutoBind();
    }

    public int getHttpPort() {
        return this.wrappee.getHttpPort();
    }

    public String getHzClusterName() {
        return this.wrappee.getHzClusterName();
    }

    public String getHzClusterPassword() {
        return this.wrappee.getHzClusterPassword();
    }

    public String getInstanceName() {
        return this.wrappee.getInstanceName();
    }

    public int getMaxHttpThreads() {
        return this.wrappee.getMaxHttpThreads();
    }

    public int getMinHttpThreads() {
        return this.wrappee.getMinHttpThreads();
    }

    public File getRootDir() {
        return this.wrappee.getRootDir();
    }

    public PayaraMicroRuntime getRuntime() throws IllegalStateException {
        return this.wrappee.getRuntime();
    }

    public boolean getSslAutoBind() {
        return this.wrappee.getSslAutoBind();
    }

    public int getSslPort() {
        return this.wrappee.getSslPort();
    }

    public File getUberJar() {
        return this.wrappee.getUberJar();
    }

    public boolean isLite() {
        return this.wrappee.isLite();
    }

    public boolean isNoCluster() {
        return this.wrappee.isNoCluster();
    }

    public PayaraMicro setAccessLogDir(String filePath) {
        this.wrappee.setAccessLogDir(filePath);
        return this;
    }

    public PayaraMicro setAccessLogFormat(String format) {
        this.wrappee.setAccessLogFormat(format);
        return this;
    }

    public PayaraMicro setAlternateDomainXML(File alternateDomainXML) {
        this.wrappee.setAlternateDomainXML(alternateDomainXML);
        return this;
    }

    public PayaraMicro setApplicationDomainXML(String domainXml) {
        this.wrappee.setApplicationDomainXML(domainXml);
        return this;
    }

    public PayaraMicro setAutoBindRange(int autoBindRange) {
        this.wrappee.setAutoBindRange(autoBindRange);
        return this;
    }

    public PayaraMicro setClusterMulticastGroup(String hzMulticastGroup) {
        this.wrappee.setClusterMulticastGroup(hzMulticastGroup);
        return this;
    }

    public PayaraMicro setClusterPort(int hzPort) {
        this.wrappee.setClusterPort(hzPort);
        return this;
    }

    public PayaraMicro setClusterStartPort(int hzStartPort) {
        this.wrappee.setClusterStartPort(hzStartPort);
        return this;
    }

    public PayaraMicro setDeploymentDir(File deploymentRoot) {
        this.wrappee.setDeploymentDir(deploymentRoot);
        return this;
    }

    public PayaraMicro setHttpAutoBind(boolean httpAutoBind) {
        this.wrappee.setHttpAutoBind(httpAutoBind);
        return this;
    }

    public PayaraMicro setHttpPort(int httpPort) {
        this.wrappee.setHttpPort(httpPort);
        return this;
    }

    public PayaraMicro setHzClusterName(String hzClusterName) {
        this.wrappee.setHzClusterName(hzClusterName);
        return this;
    }

    public PayaraMicro setHzClusterPassword(String hzClusterPassword) {
        this.wrappee.setHzClusterPassword(hzClusterPassword);
        return this;
    }

    public String getInstanceGroup() {
        return this.wrappee.getInstanceGroup();
    }

    public PayaraMicro setInstanceGroup(String instanceGroup) {
        this.wrappee.setInstanceGroup(instanceGroup);
        return this;
    }

    public PayaraMicro setInstanceName(String instanceName) {
        this.wrappee.setInstanceName(instanceName);
        return this;
    }

    public PayaraMicro setLite(boolean liteMember) {
        this.wrappee.setLite(liteMember);
        return this;
    }

    public PayaraMicro setLogPropertiesFile(File fileName) {
        this.wrappee.setLogPropertiesFile(fileName);
        return this;
    }

    public PayaraMicro setLogoFile(String filePath) {
        this.wrappee.setLogoFile(filePath);
        return this;
    }

    public PayaraMicro setMaxHttpThreads(int maxHttpThreads) {
        this.wrappee.setMaxHttpThreads(maxHttpThreads);
        return this;
    }

    public PayaraMicro setMinHttpThreads(int minHttpThreads) {
        this.wrappee.setMinHttpThreads(minHttpThreads);
        return this;
    }

    public PayaraMicro setNoCluster(boolean noCluster) {
        this.wrappee.setNoCluster(noCluster);
        return this;
    }

    public PayaraMicro setPrintLogo(boolean generate) {
        this.wrappee.setPrintLogo(generate);
        return this;
    }

    public PayaraMicro setRootDir(File rootDir) {
        this.wrappee.setRootDir(rootDir);
        return this;
    }

    public PayaraMicro setSslAutoBind(boolean sslAutoBind) {
        this.wrappee.setSslAutoBind(sslAutoBind);
        return this;
    }

    public PayaraMicro setSslPort(int sslPort) {
        this.wrappee.setSslPort(sslPort);
        return this;
    }

    public PayaraMicro setUserLogFile(String fileName) {
        this.wrappee.setUserLogFile(fileName);
        return this;
    }

    public void shutdown() throws BootstrapException {
        this.wrappee.shutdown();
    }

    public ClassLoader setThreadBootstrapLoader() {
        ClassLoader result = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.nestedLoader);
        return result;
    }

    public static void main(String ... args) {
        try {
            PayaraMicroLauncher.main(args);
        }
        catch (Exception ex) {
            Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private PayaraMicro() {
        try {
            this.wrappee = PayaraMicroLauncher.getBootClass();
            this.nestedLoader = this.wrappee.getClass().getClassLoader();
        }
        catch (Exception ex) {
            Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, "Unable to create implementation class", ex);
        }
    }

    public void addLibrary(File lib) {
        this.wrappee.addLibrary(lib);
    }
}

