/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.boot.loader;

import fish.payara.micro.boot.loader.ExplodedURLClassloader;
import fish.payara.micro.boot.loader.LaunchedURLClassLoader;
import fish.payara.micro.boot.loader.MainMethodRunner;
import fish.payara.micro.boot.loader.archive.Archive;
import fish.payara.micro.boot.loader.archive.JarFileArchive;
import fish.payara.micro.boot.loader.jar.JarFile;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;

public abstract class Launcher {
    protected Object launch(String method, String[] args) throws Exception {
        ClassLoader classLoader;
        boolean explode = true;
        String unpackDir = null;
        for (int i = 0; i < args.length; ++i) {
            if ("--nested".equals(args[i].toLowerCase())) {
                explode = false;
                continue;
            }
            if (!"--unpackdir".equals(args[i].toLowerCase()) && !"--rootdir".equals(args[i].toLowerCase()) || args.length < i + 1) continue;
            unpackDir = args[i + 1];
        }
        if (!explode) {
            classLoader = this.createClassLoader(this.getClassPathArchives());
            JarFile.registerUrlProtocolHandler();
        } else {
            classLoader = unpackDir != null ? new ExplodedURLClassloader(new File(unpackDir)) : new ExplodedURLClassloader();
        }
        return this.launch(method, args, this.getMainClass(), classLoader);
    }

    protected ClassLoader createClassLoader(List<Archive> archives) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>(archives.size());
        for (Archive archive : archives) {
            urls.add(archive.getUrl());
        }
        return this.createClassLoader(urls.toArray(new URL[urls.size()]));
    }

    protected ClassLoader createClassLoader(URL[] urls) throws Exception {
        return new LaunchedURLClassLoader(urls, this.getClass().getClassLoader());
    }

    protected Object launch(String method, String[] args, String mainClass, ClassLoader classLoader) throws Exception {
        Thread.currentThread().setContextClassLoader(classLoader);
        return this.createMainMethodRunner(mainClass, method, args, classLoader).run();
    }

    protected MainMethodRunner createMainMethodRunner(String mainClass, String method, String[] args, ClassLoader classLoader) {
        return new MainMethodRunner(mainClass, args, method);
    }

    protected abstract String getMainClass() throws Exception;

    protected abstract List<Archive> getClassPathArchives() throws Exception;

    protected final Archive createArchive() throws Exception {
        String path;
        ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource == null ? null : codeSource.getLocation().toURI();
        String string = path = location == null ? null : location.getSchemeSpecificPart();
        if (path == null) {
            throw new IllegalStateException("Unable to determine code source archive");
        }
        File root = new File(path);
        if (!root.exists()) {
            throw new IllegalStateException("Unable to determine code source archive from " + root);
        }
        return new JarFileArchive(root);
    }
}

