/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.boot.loader;

import fish.payara.micro.boot.loader.OpenURLClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExplodedURLClassloader
extends OpenURLClassLoader {
    private final File explodedDir;
    private static final String JAR_DOMAIN_DIR = "MICRO-INF/runtime/";
    private static final String LIB_DOMAIN_DIR = "MICRO-INF/lib/";
    private List<File> filesForDeletion;

    public ExplodedURLClassloader(File explodeTo) throws IOException {
        super(new URL[0]);
        this.explodedDir = explodeTo;
        System.setProperty("fish.payara.micro.tmpdir", this.explodedDir.getAbsolutePath());
        this.explodeJars();
    }

    public ExplodedURLClassloader() throws IOException {
        super(new URL[0]);
        File directory = File.createTempFile("payaramicro-rt", "tmp");
        System.setProperty("fish.payara.micro.tmpdir", directory.getAbsolutePath());
        if (!directory.delete() || !directory.mkdir()) {
            throw new IOException("Unable to create temporary runtime directory");
        }
        this.filesForDeletion = new ArrayList<File>();
        this.registerForDeletion(directory);
        this.explodedDir = directory;
        this.explodeJars();
    }

    void registerDeleteOnExit() {
        if (!this.isDeleteOnExit()) {
            return;
        }
        try {
            Class<?> fileUtils = this.loadClass("com.sun.enterprise.util.io.FileUtils");
            Method deleteOnExitMethod = fileUtils.getDeclaredMethod("deleteOnExit", File.class);
            for (File f : this.filesForDeletion) {
                deleteOnExitMethod.invoke(null, f);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Logger.getLogger(ExplodedURLClassloader.class.getName()).log(Level.WARNING, "Unable to register temp directory " + this.explodedDir + " for deletion", e);
        }
        this.filesForDeletion = null;
    }

    private void explodeJars() throws IOException {
        File runtimeDir = new File(this.explodedDir, "runtime");
        runtimeDir.mkdirs();
        this.registerForDeletion(runtimeDir);
        File libDir = new File(this.explodedDir, "lib");
        libDir.mkdirs();
        this.registerForDeletion(libDir);
        System.setProperty("fish.payara.micro.UnpackDir", this.explodedDir.getAbsolutePath());
        CodeSource src = ExplodedURLClassloader.class.getProtectionDomain().getCodeSource();
        if (src != null) {
            try {
                String[] jars = src.getLocation().toURI().getSchemeSpecificPart().split("!");
                File file = new File(jars[0]);
                try (JarFile jar = new JarFile(file);){
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String fileName = null;
                        if (entry.getName().startsWith(JAR_DOMAIN_DIR)) {
                            fileName = entry.getName().substring(JAR_DOMAIN_DIR.length());
                        } else if (entry.getName().startsWith(LIB_DOMAIN_DIR)) {
                            fileName = entry.getName().substring(LIB_DOMAIN_DIR.length());
                        }
                        if (fileName == null) continue;
                        File outputFile = new File(runtimeDir, fileName);
                        this.registerForDeletion(outputFile);
                        super.addURL(outputFile.getAbsoluteFile().toURI().toURL());
                        if (entry.isDirectory()) {
                            outputFile.mkdirs();
                            continue;
                        }
                        InputStream is = jar.getInputStream(entry);
                        try {
                            Files.copy(is, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                }
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(ExplodedURLClassloader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void registerForDeletion(File file) {
        if (this.isDeleteOnExit()) {
            this.filesForDeletion.add(file);
        }
    }

    private boolean isDeleteOnExit() {
        return this.filesForDeletion != null;
    }
}

