// $ANTLR 2.7.7 (20060906): "CodeGeneration.g" -> "CodeGeneration.java"$

    package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;
    
    import java.util.*;
    import java.lang.reflect.Field;
    import java.lang.IllegalAccessException;

    import com.sun.jdo.api.persistence.support.JDOFatalUserException;
    import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
    import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
    import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
    import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;

    import org.glassfish.persistence.common.I18NHelper;
    import com.sun.jdo.spi.persistence.utility.FieldTypeEnumeration;
    import com.sun.jdo.spi.persistence.utility.logging.Logger;

    import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
    import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
    import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ClassType;
    import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.FieldInfo;
    import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumericType;
    import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumericWrapperClassType;
    import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumberType;
    import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.StringType;

import antlr.TreeParser;
import antlr.Token;
import antlr.collections.AST;
import antlr.RecognitionException;
import antlr.ANTLRException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.collections.impl.BitSet;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;


/**
 * This class defines the code generation pass of the JQL compiler.
 * Input of this pass is the typed and optimized AST as produced by optimizer.
 * The result is a RetrieveDesc.
 *
 * @author  Michael Bouschen
 * @author  Shing Wai Chan
 * @version 0.1
 */
public class CodeGeneration extends antlr.TreeParser       implements CodeGenerationTokenTypes
 {

    /** Name of the USE_IN property. */
    public static final String USE_IN_PROPERTY = 
        "com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.USE_IN";

    /** */
    private static final boolean USE_IN = Boolean.getBoolean(USE_IN_PROPERTY);

    /**
     * I18N support
     */
    protected final static ResourceBundle messages = 
      I18NHelper.loadBundle(CodeGeneration.class);

    /**
     * The persistence manager the query object is connected to.
     */
    protected PersistenceManager pm;
    
    /**
     * type table
     */
    protected TypeTable typetab;
    
    /**
     * query parameter table
     */
    protected ParameterTable paramtab;
    
    /**
     *
     */
    protected ErrorMsg errorMsg;
    
    /**
     * prefetchEnabled flag for RetrieveDesc.
     */
    protected boolean prefetchEnabled;
    
    /**
     * The RetrieveDesc for the candidate class. 
     * Code gen for the CLASS_DEF AST will initilaized this variable.
     * Code gen for the filter expression will add the constraints.
     */
    protected RetrieveDesc candidateRD;

    /**
     * rd2TagMap maps RetrieveDesc to tags. A tag is either the variable name or
     * the navigation path that used to create a new RetrieveDesc. This info is 
     * needed to identify whether two different RetrieveDescs denote the same 
     * variable or relationship.
     */
    protected Map rd2TagMap;

    /** 
     * Set of RetrieveDescs. CodeGeneration uses this set to prevent multiple 
     * addConstraint calls for the RetrieveDescs denoting a variable.
     */
    protected Set boundRetrieveDescs;

    /** The logger */
    private static Logger logger = LogHelperQueryCompilerJDO.getLogger();

    /**
     * Defines the SQL wildcard character to be used in wildcard pattern 
     * (string methods startsWith and endsWith).
     */
    protected static final String WILDCARD_PATTERN = "%"; //NOI18N
    
    /**
     *
     */
    public void init(PersistenceManager pm, TypeTable typetab, 
                     ParameterTable paramtab, ErrorMsg errorMsg,
                     boolean prefetchEnabled)
    {
        this.pm = pm;
        this.typetab = typetab;
        this.paramtab = paramtab;
        this.errorMsg = errorMsg;
        this.prefetchEnabled = prefetchEnabled;
        this.rd2TagMap = new HashMap();
        this.boundRetrieveDescs = new HashSet();
    }
    
    /**
     *
     */
    public void reportError(RecognitionException ex) {
        errorMsg.fatal("CodeGeneration error", ex); //NOI18N
    }

    /**
     *
     */
    public void reportError(String s) {
        errorMsg.fatal("CodeGeneration error: " + s); //NOI18N
    }
    
    /**
     * Returns the RetrieveDesc that represents the current query.
     */
    public RetrieveDesc getRetrieveDesc()
    {
        if (candidateRD instanceof DebugRetrieveDesc)
            return ((DebugRetrieveDesc)candidateRD).wrapped;
        return candidateRD;
    }

    /**
     * Helper method for checkRetrieveDesc handling operators & and &&.
     */
    protected void checkAndOpRetrieveDesc(JQLAST op, JQLAST left, 
        JQLAST right, Map usedRD) throws RecognitionException
    {
        if ((right.getType() == CONTAINS) || (right.getType() == NOT_CONTAINS))
        {
            // If right is a CONTAINS clause, start analysing the right expr.
            // This ensures that the lft expression can reuse the RD defined 
            // for the variable from the contains clause
            checkRetrieveDesc(right, usedRD);
            checkRetrieveDesc(left, usedRD);
        }
        else
        {
            checkRetrieveDesc(left, usedRD);
            checkRetrieveDesc(right, usedRD); 
        }
        op.setRetrieveDesc(getCommonRetrieveDesc(left, right)); 
    }
    
    /**
     * Check the attached RetrieveDesc of the specified binary operation and its operands.
     */
    protected RetrieveDesc getCommonRetrieveDesc(JQLAST left, JQLAST right)
    {
        RetrieveDesc rd = null;
        RetrieveDesc leftRD = left.getRetrieveDesc();
        RetrieveDesc rightRD = right.getRetrieveDesc();

        if ((leftRD == null) && (rightRD != null))
        {
            // case 1: no RetrieveDesc for left operand, but right operand returns RetrieveDesc
            // attach the right RetrieveDesc to all nodes of the left subtree
            propagateRetrieveDesc(left, rightRD);
            rd = rightRD;
        }

        else if ((leftRD != null) && (rightRD == null))
        {
            // case 2: no RetrieveDesc for right operand, but left operand returns RetrieveDesc
            // attach the left RetrieveDesc to all nodes of the right subtree
            propagateRetrieveDesc(right, leftRD);
            rd = leftRD;
        }
        else if ((leftRD != null) && (rightRD != null))
        {
            // case 3: both left and right operand have a RetrieveDesc attached
            if (leftRD == rightRD)
            {
                // case 3a: left and right RetrieveDesc are identical
                rd = leftRD;
            }
            else
            {
                // case 3b: left and right RetrieveDesc are NOT identical
                // check navigation:
                rd = getCommonRetrieveDescHelper(leftRD, findNavigationSource(left), 
                                                 rightRD, findNavigationSource(right));

                // use leftRD as default
                if (rd == null) 
                {
                    rd = leftRD;
                }
            }
        }
        return rd;
    }

    /** Helper method for getCommonRetrieveDesc used to check navigation. */
    protected RetrieveDesc getCommonRetrieveDescHelper(
        RetrieveDesc leftRD, JQLAST leftNavSrc, 
        RetrieveDesc rightRD, JQLAST rightNavSrc)
    {
        RetrieveDesc rd = null;
        String leftPath = (String)rd2TagMap.get(leftRD);
        String rightPath = (String)rd2TagMap.get(rightRD);
        RetrieveDesc leftNavSrcRD = 
            (leftNavSrc == null) ? null : leftNavSrc.getRetrieveDesc();
        String leftNavSrcPath = 
            (leftNavSrcRD == null ) ? null: (String)rd2TagMap.get(leftNavSrcRD);
        RetrieveDesc rightNavSrcRD = 
            (rightNavSrc == null) ? null : rightNavSrc.getRetrieveDesc();
        String rightNavSrcPath = 
            (rightNavSrcRD == null) ? null : (String)rd2TagMap.get(rightNavSrcRD);

        if ((leftNavSrcPath != null) && leftNavSrcPath.equals(rightPath))
        {
            // case I: left operand is a navigation and 
            //         the navigation source is equal to the right operand
            rd = rightRD;
        }
        else if ((rightNavSrcPath != null) && rightNavSrcPath.equals(leftPath))
        {
            // case II: right operand is a navigation and 
            //          the navigation source is equal to the left operand
            rd = leftRD;
        }
        else if ((leftNavSrcPath != null) && (rightNavSrcPath != null) &&  
            leftNavSrcPath.equals(rightNavSrcPath))
        {
            // case III: both operands are navigations and have the same source
            rd = leftNavSrcRD;
        }
        else {
            // case IV: check whether the navigation source is a bound variable.
            //          If yes, check the collection source
            JQLAST leftConstraint = findNavigationSourceOfBoundVariable(leftNavSrc);
            JQLAST rightConstraint = findNavigationSourceOfBoundVariable(rightNavSrc);
            if ((leftConstraint != null) && (rightConstraint != null))
            {
                rd = getCommonRetrieveDescHelper(leftRD, leftConstraint, 
                                                 rightRD, rightConstraint);
            }
            else if ((leftConstraint == null) && (rightConstraint != null))
            {
                rd = getCommonRetrieveDescHelper(leftRD, leftNavSrc, 
                                                 rightRD, rightConstraint);
            }
            else if ((leftConstraint != null) && (rightConstraint == null))
            {
                rd = getCommonRetrieveDescHelper(leftRD, leftConstraint, 
                                                 rightRD, rightNavSrc);
            }
        }
        return rd;
    }

    /**
     * Helper method to support getting the common RetrieveDesc for operands 
     * taking three arguments such as like with escape, substring, indexOf.
     */
    protected RetrieveDesc getCommonRetrieveDesc(JQLAST arg1, JQLAST arg2, JQLAST arg3)
    {
        RetrieveDesc rd = null;
        if (arg3 == null) {
            // Just call the regular method for binray ops, 
            // if the third argument is not specified.
            rd = getCommonRetrieveDesc(arg1, arg2);
        }
        else {
            // First check args two and three.
            getCommonRetrieveDesc(arg2, arg3);
            // Now check the first and the second arg.
            rd = getCommonRetrieveDesc(arg1, arg2);
            // Propagate the common RetrieveDesc to the third arg. 
            // This is important, if arg two and three are literals.
            // Then the first call checking arg2 and arg3 did not attach any 
            // RetrieveDesc. The second call checking arg1 and arg2 might have 
            // propagated a rd from arg1 to arg2. So this propagateRetrieveDesc
            // call propagates this rd to arg3, too.
            propagateRetrieveDesc(arg3, rd);
        }
        return rd;
    }

    /** 
     * Helper method to support getting the common RetrieveDesc for object 
     * comparison operators.
     */
    protected RetrieveDesc getObjectComparisonRetrieveDesc(JQLAST left, JQLAST right)
    {
        RetrieveDesc rd = null;
        if ((left.getType() == NAVIGATION) && 
            (right.getType() == VALUE) && (right.getValue() == null))
        {
            // case obj.relship == null
            // take the RetrieveDesc from the navigation source
            rd = ((JQLAST)left.getFirstChild()).getRetrieveDesc();
        }
        else if ((left.getType() == VALUE) && (left.getValue() == null) && 
            (right.getType() == NAVIGATION))
        {
            // case null == obj.relship
            // take the RetrieveDesc from the navigation source
            rd = ((JQLAST)right.getFirstChild()).getRetrieveDesc();
        }
        else
        {
            // use regular getCommonRetrieveDesc
            rd = getCommonRetrieveDesc(left, right);
        }
        return rd;
    }

    /**
     * Returns the source if a navigation or field access.
     */
    protected JQLAST findNavigationSource(JQLAST tree)
    {
        JQLAST child = (JQLAST)tree.getFirstChild();
        switch (tree.getType())
        {
        case NOT_IN:
        case FIELD_ACCESS:
        case NAVIGATION:
            return findNavigationSource(child);
        case THIS:
        case VARIABLE:
            return tree;
        case CONTAINS:
        case NOT_CONTAINS:
            return null;
        default:
            for (JQLAST node = child; node != null; node = (JQLAST)node.getNextSibling())
            {
                JQLAST tmp = findNavigationSource(node);
                if (tmp != null)
                    return tmp;
            }
        }
        return null;
    }

    /** 
     * If the specifid node is a bound variable return the navigation source of 
     * it's collection. 
     */
    protected JQLAST findNavigationSourceOfBoundVariable(JQLAST tree)
    {
        if ((tree.getType() == VARIABLE) && (tree.getFirstChild() != null))
            return findNavigationSource((JQLAST)tree.getFirstChild());
        return null;
    }
    
    /**
     * Attach the specified RetrieveDesc to all JQLAST node of the ast subtree,
     * that do not have a RetrieveDesc attached.
     */
    protected void propagateRetrieveDesc(JQLAST ast, RetrieveDesc rd)
    {
        if (ast.getRetrieveDesc() == null)
        {
            ast.setRetrieveDesc(rd);
        }
        for (JQLAST node = (JQLAST)ast.getFirstChild(); 
             node != null; 
             node = (JQLAST)node.getNextSibling())
        {
            propagateRetrieveDesc(node, rd);
        }
    }

    /**
     * Returns an Object representing 0 according to the specified type.
     */
    protected Object getZeroValue(Type type)
    {
        return (type instanceof NumberType) ? 
               ((NumberType)type).getValue(new Integer(0)) :
               null;
    }

    /**
     * Returns an Object representing -1 according to the specified type.
     */
    protected Object getMinusOneValue(Type type)
    {
        return (type instanceof NumberType) ? 
               ((NumberType)type).getValue(new Integer(-1)) :
               null;
    }
   
    /**
     * Returns -value. 
     * The method assumes that the passed argument is a numeric wrapper class object. 
     * If so it negates the wrapped numeric value and wraps the negated value into a 
     * numeric wrapper class object.
     */
    protected Object negate(Object value, Type type)
    {
        return (type instanceof NumberType) ? 
               ((NumberType)type).negate((Number)value) :
               null;
    }

    /**
     * Returns the boolean operation of the equivalent relational expression 
     * with swapped arguments.
     * expr1 > expr2 <=> expr2 < expr1
     */
    protected int getSwappedOp(int operation)
    {
        int ret = 0;
        switch (operation)
        {
        case RetrieveDesc.OP_EQ:
            ret = RetrieveDesc.OP_EQ;
            break;
        case RetrieveDesc.OP_NE:
            ret = RetrieveDesc.OP_NE;
            break;
        case RetrieveDesc.OP_LT:
            ret = RetrieveDesc.OP_GT;
            break;
        case RetrieveDesc.OP_LE:
            ret = RetrieveDesc.OP_GE;
            break;
        case RetrieveDesc.OP_GT:
            ret = RetrieveDesc.OP_LT;
            break;
        case RetrieveDesc.OP_GE:
            ret = RetrieveDesc.OP_LE;
            break;
        }
        return ret;
    }

    /**
     * Code generation for a comparison of the form field relop value, 
     * where field denotes a non relationship field
     * This method checks for null values and generates OP_NULL / OP_NOTNULL constraints 
     * in the case of field relop null
     */
    protected void generateSimpleFieldValueComparison(RetrieveDesc rd, String name, 
                                                      int operation, Object value)
    {
        if (value != null)
        {
            rd.addConstraint(name, operation, value);
        }   
        else if (operation == RetrieveDesc.OP_EQ)
        {
            rd.addConstraint(name, RetrieveDesc.OP_NULL, null);
        }
        else if (operation == RetrieveDesc.OP_NE)
        {
            rd.addConstraint(name, RetrieveDesc.OP_NOTNULL, null);
        }
        else
        {
            errorMsg.fatal(I18NHelper.getMessage(messages, "jqlc.codegeneration.generatesimplefieldvaluecomparison.invalidvalue")); //NOI18N
        }
    }

    /**
     * Code generation for a comparison of the form 
     *   dbvalue relop constant
     * where dbvalue denotes an object in the database such as 
     * - this
     * - the result of a relationship navigation
     * - variable access
     * and constant is a constant value at query compile time (e.g. a literal)
     */
    protected void generateDbValueConstantComparison(RetrieveDesc rd, ClassType objectType, 
                                                     int operation, Object value, Type valueType)
    {
        int booleanOp = getKeyFieldsComparisonBooleanOp(operation);

        List keyFieldNames = objectType.getKeyFieldNames();
        for (Iterator i = keyFieldNames.iterator(); i.hasNext();)
        {
            String keyFieldName = (String)i.next();
            Object keyFieldValue = null;
            if (value != null)
            {
                keyFieldValue = getFieldValue((ClassType)valueType, value, keyFieldName);
            }
            generateSimpleFieldValueComparison(rd, keyFieldName, operation, keyFieldValue);
            if (i.hasNext())
                rd.addConstraint(null, booleanOp, null);
        }
    }

    /**
     * Code generation for a comparison of the form 
     *   dbvalue relop dbvalue
     * where dbvalue denotes an object in the database such as 
     * - this
     * - the result of a relationship navigation
     * - variable access
     */
    protected void generateDbValueDbValueComparison(RetrieveDesc leftRD, ClassType leftType, int operation, 
                                                    RetrieveDesc rightRD, ClassType rightType)
    {
        int booleanOp = getKeyFieldsComparisonBooleanOp(operation);
        
        // Note, this code assumes that both operands are of class types that have 
        // the same key fields. Thus take the list of key field names of the left side.
        List leftKeyFieldNames = leftType.getKeyFieldNames();
        for (Iterator i = leftKeyFieldNames.iterator(); i.hasNext();)
        {
            String keyFieldName = (String)i.next();
            leftRD.addConstraint(keyFieldName, operation, rightRD, keyFieldName);
            if (i.hasNext())
                leftRD.addConstraint(null, booleanOp, null);
        }
    }

    /**
     * Code generation for a comparison of the form 
     *   parameter relop constantValue
     */
    protected void generateParameterValueComparison(RetrieveDesc rd,
                                                    String paramName, 
                                                    int operation, Object value)
    {
        if (value != null)
        {
            rd.addConstraint(null, RetrieveDesc.OP_VALUE, value);
            rd.addConstraint(null, RetrieveDesc.OP_PARAMETER,
                paramtab.getParameterInfoForParamName(paramName));
            rd.addConstraint(null, operation, null);
        }   
        else if (operation == RetrieveDesc.OP_EQ)
        {
            rd.addConstraint(null, RetrieveDesc.OP_PARAMETER,
                paramtab.getParameterInfoForParamName(paramName));
            rd.addConstraint(null, RetrieveDesc.OP_NULL, null);
        }
        else if (operation == RetrieveDesc.OP_NE)
        {
            rd.addConstraint(null, RetrieveDesc.OP_PARAMETER,
                paramtab.getParameterInfoForParamName(paramName));
            rd.addConstraint(null, RetrieveDesc.OP_NOTNULL, null);
        }
        else
        {
            errorMsg.fatal(I18NHelper.getMessage(messages, "jqlc.codegeneration.generateparametervaluecomparison.invalidvalue")); //NOI18N
        }
    }

    /**
     * Returns the boolean operation used to connect the key field comparison expressions:
     * l == r is mapped to l.pk1 == r.pk1 & ... & l.pkn == r.pkn => return &
     * l != r is mapped to l.pk1 != r.pk1 | ... | l.pkn != r.pkn => return |
     */
    protected int getKeyFieldsComparisonBooleanOp(int operation)
    {
        switch (operation)
        {
        case RetrieveDesc.OP_EQ:
            return RetrieveDesc.OP_AND;
        case RetrieveDesc.OP_NE:
            return RetrieveDesc.OP_OR;
        }
        errorMsg.fatal(I18NHelper.getMessage(messages,
            "jqlc.codegeneration.getkeyfieldscomparisonbooleanop.invalidobj", //NOI18N
            String.valueOf(operation)));
        return 0;
    }

    /**
     * Returns the value of the  field access object.field.
     * Uses jdoGetField for object of a persistence capable class and reflection otherwise.
     */
    protected static Object getFieldValue (ClassType classType, Object object, String fieldName)
    {
        Object value = null;
        FieldInfo fieldInfo = classType.getFieldInfo(fieldName);
        if (classType.isPersistenceCapable())
        {
            PersistenceCapable pc = (PersistenceCapable)object;
            int index = fieldInfo.getFieldNumber();
            StateManager stateManager = pc.jdoGetStateManager();
            
            if (stateManager != null)
            {
                // call stateManager.prepareGetField to allow the stateManager 
                // to mediate the field access
                stateManager.prepareGetField(index);
            }
            value = pc.jdoGetField(index);
        }
        else
        {
            // non persistence capable class => use reflection
            try
            {
                value = fieldInfo.getField().get(object);
            }
            catch (IllegalAccessException e) 
            {
                throw new JDOFatalUserException(
                    I18NHelper.getMessage(messages, "jqlc.codegeneration.fieldaccess.illegal",  //NOI18N
                        fieldName, (object==null ? "null" : object.toString())), e); //NOI18N
            }
        }
        return value;
    }
    
    /**
     * This method checks whether the result RetrieveDesc needs a DISTINCT clause or not. 
     * @param query the query AST
     */
    protected void handleDistinct(JQLAST query, boolean distinct)
    {
        // candidateRD is null in the case of false filter
        if (candidateRD == null)
            return;
        
        if (distinct)
            candidateRD.addResult(RetrieveDesc.OP_DISTINCT, FieldTypeEnumeration.NOT_ENUMERATED);
    }

    /**
     * This method returns true if the specified node is an AST that represensts a value.
     * It returns false for CONTAINS/NOT_CONTAINS nodes and boolean operations that include 
     * only CONTAINS nodes 
     */
    protected boolean pushesValueOnStack(JQLAST node)
    {
        switch(node.getType())
        {
        case CONTAINS:
        case NOT_CONTAINS:
            return false;
        case BAND:
        case BOR:
        case AND:
        case OR:
            JQLAST left = (JQLAST)node.getFirstChild();
            JQLAST right = (JQLAST)left.getNextSibling();
            return pushesValueOnStack(left) || pushesValueOnStack(right);
        default:
            return true;
        }
    }

    /**
     * Create a new RetrieveDesc for the specified classType and
     * store this RetrieveDesc in the cache with the specified path expression attached.
     * The method wraps the RetrieveDesc in a DebugRetrieveDesc, if debug mode is on.
     */
    protected RetrieveDesc createRetrieveDesc(String pathExpr, ClassType classType)
    {
        RetrieveDesc rd = pm.getRetrieveDesc(classType.getJavaClass());
        if (logger.isLoggable(Logger.FINEST)) 
        {
            rd = new DebugRetrieveDesc(rd);
            logger.finest("LOG_JQLCDumpRD", "create " + JQLAST.getRetrieveDescRepr(rd)); //NOI18N
        }        
        rd2TagMap.put(rd, pathExpr);
        rd.setNavigationalId(pathExpr);
        return rd;
    }

    /**
     * Wrapper that traces the RetrieveDesc calls
     */
    protected static class DebugRetrieveDesc implements RetrieveDesc
    {
        RetrieveDesc wrapped = null;

        DebugRetrieveDesc(RetrieveDesc wrapped)
        {
            this.wrapped = wrapped;
        }
        
        public RetrieveDesc unwrap(RetrieveDesc rd)
        {
            if (rd instanceof DebugRetrieveDesc)
                return ((DebugRetrieveDesc)rd).wrapped;
            return rd;
        }

        // methods from RetrieveDesc 
        public void addResult(String name, RetrieveDesc desc, boolean projection)
        {
            if (logger.isLoggable(Logger.FINEST))
                logger.finest("LOG_JQLCDumpRD", //NOI18N
                    JQLAST.getRetrieveDescRepr(this) + ".addResult(" +  //NOI18N
                    name + ", " + JQLAST.getRetrieveDescRepr(desc) + ", " + //NOI18N
                    projection + ")"); //NOI18N
            desc = unwrap(desc);
            wrapped.addResult(name, desc, projection);   
        }
        
        public void addResult(int opCode, int resultType)
        {
            if (logger.isLoggable(Logger.FINEST))
                logger.finest("LOG_JQLCDumpRD", //NOI18N
                    JQLAST.getRetrieveDescRepr(this) + ".addResult(" +  //NOI18N
                    opCode + ", " + resultType + ")"); //NOI18N
            wrapped.addResult(opCode, resultType);   
        }
        
        public void addConstraint(String name, int operation, Object value)
        {
            String thirdArgRepr = null;
            if (value instanceof RetrieveDesc)
            {
                RetrieveDesc foreignConstraint = (RetrieveDesc)value;
                thirdArgRepr = JQLAST.getRetrieveDescRepr(foreignConstraint);
                value = unwrap(foreignConstraint);
            }
            else
            {
                thirdArgRepr = (value == null) ? "null" : value.toString();
            }
            if (logger.isLoggable(Logger.FINEST))
                logger.finest("LOG_JQLCDumpRD", //NOI18N
                JQLAST.getRetrieveDescRepr(this) + ".addConstraint(" +  //NOI18N
                name + ", " + operation + ", " + thirdArgRepr + ")"); //NOI18N
            wrapped.addConstraint(name, operation, value);
        }

        public void addConstraint(String name, RetrieveDesc foreignConstraint)
        {
            if (logger.isLoggable(Logger.FINEST))
                logger.finest("LOG_JQLCDumpRD", //NOI18N
                    JQLAST.getRetrieveDescRepr(this) + ".addConstraint(" +  //NOI18N
                    name + ", " + JQLAST.getRetrieveDescRepr(foreignConstraint) + ")"); //NOI18N
            foreignConstraint = unwrap(foreignConstraint);
            wrapped.addConstraint(name, foreignConstraint);
        }

        public void addConstraint(String name, int operator, RetrieveDesc foreignConstraint, String foreignFieldName)
        {
            if (logger.isLoggable(Logger.FINEST))
                logger.finest("LOG_JQLCDumpRD", //NOI18N
                    JQLAST.getRetrieveDescRepr(this) + ".addConstraint(" +  //NOI18N
                    name + ", " + operator + ", " + JQLAST.getRetrieveDescRepr(foreignConstraint) + //NOI18N
                    ", " +  foreignFieldName + ")"); //NOI18N
            foreignConstraint = unwrap(foreignConstraint);
            wrapped.addConstraint(name, operator, foreignConstraint, foreignFieldName); 
        }
        
        public void setNavigationalId(Object navigationalId)
        { 
            if (logger.isLoggable(Logger.FINEST))
                logger.finest("LOG_JQLCDumpRD", //NOI18N
                    JQLAST.getRetrieveDescRepr(this) + 
                    ".setNavigationalId(" + navigationalId + ")"); //NOI18N
            wrapped.setNavigationalId(navigationalId); 
        }

        public void setPrefetchEnabled(boolean prefetchEnabled)
        {
            if (logger.isLoggable(Logger.FINEST))
                logger.finest("LOG_JQLCDumpRD", //NOI18N
                    JQLAST.getRetrieveDescRepr(this) +
                    ".setPrefetchEnabled(" + prefetchEnabled + ")"); //NOI18N
            wrapped.setPrefetchEnabled(prefetchEnabled);
        }

        // Methods from ActionDesc

        public Class getPersistenceCapableClass()
        { return wrapped.getPersistenceCapableClass(); }
    }
public CodeGeneration() {
	tokenNames = _tokenNames;
}

	public final void query(AST _t) throws RecognitionException {
		
		JQLAST query_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST q = null;
		
		try {      // for error handling
			q = (JQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				prepareRetrieveDescs(q);
				if (logger.isLoggable(Logger.FINEST)) 
				logger.finest("LOG_JQLCDumpTree", q.getTreeRepr("RD annotated AST")); //NOI18N
				doCodeGen(q);
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void doCodeGen(AST _t) throws RecognitionException {
		
		JQLAST doCodeGen_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST q = null;
		
		boolean distinct = false;
		
		
		try {      // for error handling
			AST __t3 = _t;
			q = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,QUERY);
			_t = _t.getFirstChild();
			candidateClass(_t);
			_t = _retTree;
			parameters(_t);
			_t = _retTree;
			variables(_t);
			_t = _retTree;
			ordering(_t);
			_t = _retTree;
			distinct=result(_t);
			_t = _retTree;
			filter(_t);
			_t = _retTree;
			_t = __t3;
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				handleDistinct(q, distinct);
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void candidateClass(AST _t) throws RecognitionException {
		
		JQLAST candidateClass_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST c = null;
		
		errorMsg.setContext("setCandidates"); //NOI18N
		
		
		try {      // for error handling
			c = (JQLAST)_t;
			match(_t,CLASS_DEF);
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void parameters(AST _t) throws RecognitionException {
		
		JQLAST parameters_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		errorMsg.setContext("declareParameters"); //NOI18N
		
		
		try {      // for error handling
			{
			_loop7:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==PARAMETER_DEF)) {
					declareParameter(_t);
					_t = _retTree;
				}
				else {
					break _loop7;
				}
				
			} while (true);
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void variables(AST _t) throws RecognitionException {
		
		JQLAST variables_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		errorMsg.setContext("declareVariables"); //NOI18N
		
		
		try {      // for error handling
			{
			_loop12:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==VARIABLE_DEF)) {
					declareVariable(_t);
					_t = _retTree;
				}
				else {
					break _loop12;
				}
				
			} while (true);
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void ordering(AST _t) throws RecognitionException {
		
		JQLAST ordering_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		errorMsg.setContext("setOrdering"); //NOI18N
		
		
		try {      // for error handling
			{
			_loop17:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==ORDERING_DEF)) {
					orderSpec(_t);
					_t = _retTree;
				}
				else {
					break _loop17;
				}
				
			} while (true);
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final boolean  result(AST _t) throws RecognitionException {
		boolean distinct;
		
		JQLAST result_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		errorMsg.setContext("setResult"); //NOI18N
		distinct = false;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case RESULT_DEF:
			{
				AST __t27 = _t;
				JQLAST tmp1_AST_in = (JQLAST)_t;
				match(_t,RESULT_DEF);
				_t = _t.getFirstChild();
				distinct=resultExpr(_t,true);
				_t = _retTree;
				_t = __t27;
				_t = _t.getNextSibling();
				break;
			}
			case FILTER_DEF:
			{
				if ( inputState.guessing==0 ) {
					
					// no result is equivalent to setResult("distinct this") =>
					// distinct is true
					distinct = true;
					
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
		return distinct;
	}
	
	public final void filter(AST _t) throws RecognitionException {
		
		JQLAST filter_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST expr = null;
		
		errorMsg.setContext("setFilter"); //NOI18N
		
		
		try {      // for error handling
			AST __t45 = _t;
			JQLAST tmp2_AST_in = (JQLAST)_t;
			match(_t,FILTER_DEF);
			_t = _t.getFirstChild();
			expr = (JQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			_t = __t45;
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				switch (expr.getType()) {
				case VALUE:
				// constant filter
				Object value = expr.getValue();
				if (value instanceof Boolean) 
				{
				// Note, in the case of a true filter do not add
				// any constraints to the candidateRD
				
				if (!((Boolean)value).booleanValue())
				{
				// false filter => unset candidateRD
				candidateRD = null;
				}
				}
				else
				{
				errorMsg.fatal(I18NHelper.getMessage(messages,
				"jqlc.codegeneration.filter.nonbooleanvalue", //NOI18N
				String.valueOf(value)));
				}
				break;
				case FIELD_ACCESS:
				// The entire filter consists of a boolean field only.
				// Map this to 'booleanField <> FALSE'. Note, the runtime will
				// create a JDBC parameter for the literal FALSE and call 
				// setBoolean to bind the value.
				RetrieveDesc rd = expr.getRetrieveDesc();
				rd.addConstraint(null, RetrieveDesc.OP_VALUE, Boolean.FALSE);
				expression(expr);
				rd.addConstraint(null, RetrieveDesc.OP_NE, null);
				break;
				default:
				expression(expr);
				break;
				}
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void declareParameter(AST _t) throws RecognitionException {
		
		JQLAST declareParameter_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		try {      // for error handling
			AST __t9 = _t;
			JQLAST tmp3_AST_in = (JQLAST)_t;
			match(_t,PARAMETER_DEF);
			_t = _t.getFirstChild();
			type(_t);
			_t = _retTree;
			JQLAST tmp4_AST_in = (JQLAST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			_t = __t9;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void type(AST _t) throws RecognitionException {
		
		JQLAST type_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPENAME:
			{
				JQLAST tmp5_AST_in = (JQLAST)_t;
				match(_t,TYPENAME);
				_t = _t.getNextSibling();
				break;
			}
			case BOOLEAN:
			case BYTE:
			case CHAR:
			case SHORT:
			case INT:
			case FLOAT:
			case LONG:
			case DOUBLE:
			{
				primitiveType(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void declareVariable(AST _t) throws RecognitionException {
		
		JQLAST declareVariable_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST i = null;
		
		try {      // for error handling
			AST __t14 = _t;
			JQLAST tmp6_AST_in = (JQLAST)_t;
			match(_t,VARIABLE_DEF);
			_t = _t.getFirstChild();
			type(_t);
			_t = _retTree;
			i = (JQLAST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			_t = __t14;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void orderSpec(AST _t) throws RecognitionException {
		
		JQLAST orderSpec_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		int op = 0;
		
		
		try {      // for error handling
			AST __t19 = _t;
			JQLAST tmp7_AST_in = (JQLAST)_t;
			match(_t,ORDERING_DEF);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case ASCENDING:
			{
				JQLAST tmp8_AST_in = (JQLAST)_t;
				match(_t,ASCENDING);
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op = RetrieveDesc.OP_ORDERBY;
				}
				break;
			}
			case DESCENDING:
			{
				JQLAST tmp9_AST_in = (JQLAST)_t;
				match(_t,DESCENDING);
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op = RetrieveDesc.OP_ORDERBY_DESC;
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			orderingExpr(_t,op);
			_t = _retTree;
			_t = __t19;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void orderingExpr(AST _t,
		int op
	) throws RecognitionException {
		
		JQLAST orderingExpr_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST f = null;
		JQLAST i = null;
		JQLAST e = null;
		
		try {      // for error handling
			boolean synPredMatched24 = false;
			if (_t==null) _t=ASTNULL;
			if (((_t.getType()==FIELD_ACCESS))) {
				AST __t24 = _t;
				synPredMatched24 = true;
				inputState.guessing++;
				try {
					{
					AST __t23 = _t;
					JQLAST tmp10_AST_in = (JQLAST)_t;
					match(_t,FIELD_ACCESS);
					_t = _t.getFirstChild();
					expression(_t);
					_t = _retTree;
					JQLAST tmp11_AST_in = (JQLAST)_t;
					match(_t,IDENT);
					_t = _t.getNextSibling();
					_t = __t23;
					_t = _t.getNextSibling();
					}
				}
				catch (RecognitionException pe) {
					synPredMatched24 = false;
				}
				_t = __t24;
inputState.guessing--;
			}
			if ( synPredMatched24 ) {
				AST __t25 = _t;
				f = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,FIELD_ACCESS);
				_t = _t.getFirstChild();
				expression(_t);
				_t = _retTree;
				i = (JQLAST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				_t = __t25;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					f.getRetrieveDesc().addConstraint(i.getText(), op, null);
					
				}
			}
			else if (((_t.getType() >= IMPORT && _t.getType() <= DOUBLE_LITERAL))) {
				e = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					errorMsg.unsupported(e.getLine(), e.getColumn(),
					I18NHelper.getMessage(messages, 
					"jqlc.codegeneration.generic.unsupportedop", // NOI18N
					e.getText()));
					
				}
			}
			else {
				throw new NoViableAltException(_t);
			}
			
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void expression(AST _t) throws RecognitionException {
		
		JQLAST expression_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case THIS:
			case TYPECAST:
			case FIELD_ACCESS:
			case CONTAINS:
			case NOT_CONTAINS:
			case NAVIGATION:
			case STARTS_WITH:
			case ENDS_WITH:
			case IS_EMPTY:
			case VARIABLE:
			case PARAMETER:
			case VALUE:
			case LIKE:
			case SUBSTRING:
			case INDEXOF:
			case LENGTH:
			case ABS:
			case SQRT:
			{
				primary(_t);
				_t = _retTree;
				break;
			}
			case BXOR:
			case BOR:
			case BAND:
			{
				bitwiseExpr(_t);
				_t = _retTree;
				break;
			}
			case OR:
			case AND:
			{
				conditionalExpr(_t);
				_t = _retTree;
				break;
			}
			case EQUAL:
			case NOT_EQUAL:
			case GE:
			case GT:
			case LE:
			case LT:
			case OBJECT_EQUAL:
			case OBJECT_NOT_EQUAL:
			case COLLECTION_EQUAL:
			case COLLECTION_NOT_EQUAL:
			{
				relationalExpr(_t);
				_t = _retTree;
				break;
			}
			case DIV:
			case PLUS:
			case MINUS:
			case STAR:
			case MOD:
			case CONCAT:
			{
				binaryArithmeticExpr(_t);
				_t = _retTree;
				break;
			}
			case UNARY_MINUS:
			case UNARY_PLUS:
			{
				unaryArithmeticExpr(_t);
				_t = _retTree;
				break;
			}
			case LNOT:
			case BNOT:
			{
				complementExpr(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final boolean  resultExpr(AST _t,
		boolean outer
	) throws RecognitionException {
		boolean distinct;
		
		JQLAST resultExpr_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST d = null;
		JQLAST avg = null;
		JQLAST max = null;
		JQLAST min = null;
		JQLAST sum = null;
		JQLAST count = null;
		JQLAST r = null;
		JQLAST op1 = null;
		JQLAST expr1 = null;
		JQLAST i1 = null;
		JQLAST op2 = null;
		JQLAST expr2 = null;
		JQLAST i2 = null;
		JQLAST op3 = null;
		JQLAST col3 = null;
		
		String name = null;
		// this should be take care at first level of recursion
		distinct = false;
		boolean tmp;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case DISTINCT:
			{
				AST __t29 = _t;
				d = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,DISTINCT);
				_t = _t.getFirstChild();
				tmp=resultExpr(_t,outer);
				_t = _retTree;
				_t = __t29;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					distinct = true;
					
				}
				break;
			}
			case AVG:
			{
				AST __t30 = _t;
				avg = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,AVG);
				_t = _t.getFirstChild();
				distinct=resultExpr(_t,true);
				_t = _retTree;
				_t = __t30;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					candidateRD.addResult(RetrieveDesc.OP_AVG,
					avg.getJQLType().getEnumType());
					
				}
				break;
			}
			case MAX:
			{
				AST __t31 = _t;
				max = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,MAX);
				_t = _t.getFirstChild();
				distinct=resultExpr(_t,true);
				_t = _retTree;
				_t = __t31;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					candidateRD.addResult(RetrieveDesc.OP_MAX,
					max.getJQLType().getEnumType());
					
				}
				break;
			}
			case MIN:
			{
				AST __t32 = _t;
				min = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,MIN);
				_t = _t.getFirstChild();
				distinct=resultExpr(_t,true);
				_t = _retTree;
				_t = __t32;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					candidateRD.addResult(RetrieveDesc.OP_MIN,
					min.getJQLType().getEnumType());
					
				}
				break;
			}
			case SUM:
			{
				AST __t33 = _t;
				sum = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,SUM);
				_t = _t.getFirstChild();
				distinct=resultExpr(_t,true);
				_t = _retTree;
				_t = __t33;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					candidateRD.addResult(RetrieveDesc.OP_SUM,
					sum.getJQLType().getEnumType());
					
				}
				break;
			}
			case COUNT:
			{
				AST __t34 = _t;
				count = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,COUNT);
				_t = _t.getFirstChild();
				r = _t==ASTNULL ? null : (JQLAST)_t;
				distinct=resultExpr(_t,true);
				_t = _retTree;
				_t = __t34;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					Type resultType = r.getJQLType();
					if (typetab.isPersistenceCapableType(resultType)) {
					List pkfields = ((ClassType)resultType).getKeyFieldNames();
					if (pkfields != null) {
					candidateRD.addResult(RetrieveDesc.OP_COUNT_PC,
					count.getJQLType().getEnumType());
					} else {
					errorMsg.unsupported(r.getLine(), r.getColumn(),
					I18NHelper.getMessage(messages,
					"jqlc.codegeneration.resultexpr.missingpkfields", // NOI18N
					resultType.getName()));
					}
					} else {
					candidateRD.addResult(RetrieveDesc.OP_COUNT,
					count.getJQLType().getEnumType());
					}
					
				}
				break;
			}
			case FIELD_ACCESS:
			{
				AST __t35 = _t;
				op1 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,FIELD_ACCESS);
				_t = _t.getFirstChild();
				expr1 = _t==ASTNULL ? null : (JQLAST)_t;
				tmp=resultExpr(_t,false);
				_t = _retTree;
				i1 = (JQLAST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				_t = __t35;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					op1.getRetrieveDesc().addResult(i1.getText(), null, true);
					
				}
				break;
			}
			case NAVIGATION:
			{
				AST __t36 = _t;
				op2 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,NAVIGATION);
				_t = _t.getFirstChild();
				expr2 = _t==ASTNULL ? null : (JQLAST)_t;
				tmp=resultExpr(_t,false);
				_t = _retTree;
				i2 = (JQLAST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				_t = __t36;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					RetrieveDesc from = expr2.getRetrieveDesc();
					RetrieveDesc to = op2.getRetrieveDesc();
					from.addResult(i2.getText(), to, outer);
					
				}
				break;
			}
			case VARIABLE:
			{
				AST __t37 = _t;
				op3 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,VARIABLE);
				_t = _t.getFirstChild();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case TYPECAST:
				case FIELD_ACCESS:
				case NAVIGATION:
				case NOT_IN:
				{
					col3 = _t==ASTNULL ? null : (JQLAST)_t;
					name=collectionExprResult(_t);
					_t = _retTree;
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				_t = __t37;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					if (col3 != null) {
					RetrieveDesc from = col3.getRetrieveDesc();
					RetrieveDesc to = op3.getRetrieveDesc();
					from.addResult(name, to, outer);
					}
					
				}
				break;
			}
			case THIS:
			{
				JQLAST tmp12_AST_in = (JQLAST)_t;
				match(_t,THIS);
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
		return distinct;
	}
	
	public final String  collectionExprResult(AST _t) throws RecognitionException {
		String fieldName;
		
		JQLAST collectionExprResult_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST name1 = null;
		JQLAST name2 = null;
		
		fieldName = null; 
		boolean tmp;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case FIELD_ACCESS:
			{
				AST __t40 = _t;
				JQLAST tmp13_AST_in = (JQLAST)_t;
				match(_t,FIELD_ACCESS);
				_t = _t.getFirstChild();
				tmp=resultExpr(_t,false);
				_t = _retTree;
				name1 = (JQLAST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				_t = __t40;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					fieldName = name1.getText();
				}
				break;
			}
			case NAVIGATION:
			{
				AST __t41 = _t;
				JQLAST tmp14_AST_in = (JQLAST)_t;
				match(_t,NAVIGATION);
				_t = _t.getFirstChild();
				tmp=resultExpr(_t,false);
				_t = _retTree;
				name2 = (JQLAST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				_t = __t41;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					fieldName = name2.getText();
				}
				break;
			}
			case TYPECAST:
			{
				AST __t42 = _t;
				JQLAST tmp15_AST_in = (JQLAST)_t;
				match(_t,TYPECAST);
				_t = _t.getFirstChild();
				JQLAST tmp16_AST_in = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				fieldName=collectionExprResult(_t);
				_t = _retTree;
				_t = __t42;
				_t = _t.getNextSibling();
				break;
			}
			case NOT_IN:
			{
				AST __t43 = _t;
				JQLAST tmp17_AST_in = (JQLAST)_t;
				match(_t,NOT_IN);
				_t = _t.getFirstChild();
				fieldName=collectionExprResult(_t);
				_t = _retTree;
				_t = __t43;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
		return fieldName;
	}
	
	public final void primary(AST _t) throws RecognitionException {
		
		JQLAST primary_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST v = null;
		JQLAST p = null;
		JQLAST f = null;
		
		Object value; 
		String name;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPECAST:
			{
				AST __t114 = _t;
				JQLAST tmp18_AST_in = (JQLAST)_t;
				match(_t,TYPECAST);
				_t = _t.getFirstChild();
				type(_t);
				_t = _retTree;
				expression(_t);
				_t = _retTree;
				_t = __t114;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					/* code gen for cast? */
				}
				break;
			}
			case VALUE:
			{
				v = _t==ASTNULL ? null : (JQLAST)_t;
				value=constantValue(_t);
				_t = _retTree;
				if ( inputState.guessing==0 ) {
					
					if (value == null)
					{
					errorMsg.fatal(I18NHelper.getMessage(messages, "jqlc.codegeneration.primary.null")); //NOI18N
					}
					else if (value instanceof Boolean)
					{
					boolean booleanValue = ((Boolean)value).booleanValue();
					RetrieveDesc rd = v.getRetrieveDesc();
					rd.addConstraint(null, RetrieveDesc.OP_VALUE, new Integer(0)); 
					rd.addConstraint(null, RetrieveDesc.OP_VALUE, new Integer(0)); 
					rd.addConstraint(null, (booleanValue?RetrieveDesc.OP_EQ:RetrieveDesc.OP_NE), null); 
					}
					else
					{
					v.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_VALUE, value); 
					}
					
				}
				break;
			}
			case PARAMETER:
			{
				p = (JQLAST)_t;
				match(_t,PARAMETER);
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					p.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_PARAMETER, 
					paramtab.getParameterInfoForParamName(p.getText()));
					
				}
				break;
			}
			case THIS:
			{
				JQLAST tmp19_AST_in = (JQLAST)_t;
				match(_t,THIS);
				_t = _t.getNextSibling();
				break;
			}
			case FIELD_ACCESS:
			{
				f = _t==ASTNULL ? null : (JQLAST)_t;
				name=fieldAccess(_t);
				_t = _retTree;
				if ( inputState.guessing==0 ) {
					
					f.getRetrieveDesc().addConstraint(name, RetrieveDesc.OP_FIELD, null);
					
				}
				break;
			}
			case NAVIGATION:
			{
				navigation(_t);
				_t = _retTree;
				break;
			}
			case VARIABLE:
			{
				variableAccess(_t);
				_t = _retTree;
				break;
			}
			case CONTAINS:
			{
				AST __t115 = _t;
				JQLAST tmp20_AST_in = (JQLAST)_t;
				match(_t,CONTAINS);
				_t = _t.getFirstChild();
				JQLAST tmp21_AST_in = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				JQLAST tmp22_AST_in = (JQLAST)_t;
				match(_t,VARIABLE);
				_t = _t.getNextSibling();
				_t = __t115;
				_t = _t.getNextSibling();
				break;
			}
			case NOT_CONTAINS:
			{
				AST __t116 = _t;
				JQLAST tmp23_AST_in = (JQLAST)_t;
				match(_t,NOT_CONTAINS);
				_t = _t.getFirstChild();
				JQLAST tmp24_AST_in = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				JQLAST tmp25_AST_in = (JQLAST)_t;
				match(_t,VARIABLE);
				_t = _t.getNextSibling();
				_t = __t116;
				_t = _t.getNextSibling();
				break;
			}
			case STARTS_WITH:
			{
				startsWith(_t);
				_t = _retTree;
				break;
			}
			case ENDS_WITH:
			{
				endsWith(_t);
				_t = _retTree;
				break;
			}
			case IS_EMPTY:
			{
				isEmpty(_t);
				_t = _retTree;
				break;
			}
			case LIKE:
			{
				like(_t);
				_t = _retTree;
				break;
			}
			case SUBSTRING:
			{
				substring(_t);
				_t = _retTree;
				break;
			}
			case INDEXOF:
			{
				indexOf(_t,0);
				_t = _retTree;
				break;
			}
			case LENGTH:
			{
				length(_t);
				_t = _retTree;
				break;
			}
			case ABS:
			{
				abs(_t);
				_t = _retTree;
				break;
			}
			case SQRT:
			{
				sqrt(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void bitwiseExpr(AST _t) throws RecognitionException {
		
		JQLAST bitwiseExpr_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op1 = null;
		JQLAST left1 = null;
		JQLAST right1 = null;
		JQLAST op2 = null;
		JQLAST left2 = null;
		JQLAST right2 = null;
		JQLAST op3 = null;
		JQLAST left3 = null;
		JQLAST right3 = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case BAND:
			{
				AST __t51 = _t;
				op1 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,BAND);
				_t = _t.getFirstChild();
				left1 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				right1 = _t==ASTNULL ? null : (JQLAST)_t;
				booleanOperationArgument(_t);
				_t = _retTree;
				_t = __t51;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					booleanOperationArgument(left1);
					// do not generate boolean operation if one of the operands is variable constraint
					if (pushesValueOnStack(left1) && pushesValueOnStack(right1))
					op1.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_AND, null); 
					
				}
				break;
			}
			case BOR:
			{
				AST __t52 = _t;
				op2 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,BOR);
				_t = _t.getFirstChild();
				left2 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				right2 = _t==ASTNULL ? null : (JQLAST)_t;
				booleanOperationArgument(_t);
				_t = _retTree;
				_t = __t52;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					booleanOperationArgument(left2);
					// do not generate boolean operation if one of the operands is variable constraint
					if (pushesValueOnStack(left2) && pushesValueOnStack(right2))
					op2.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_OR, null); 
					
				}
				break;
			}
			case BXOR:
			{
				AST __t53 = _t;
				op3 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,BXOR);
				_t = _t.getFirstChild();
				left3 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				right3 = _t==ASTNULL ? null : (JQLAST)_t;
				booleanOperationArgument(_t);
				_t = _retTree;
				_t = __t53;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					booleanOperationArgument(left3);
					errorMsg.unsupported(op3.getLine(), op3.getColumn(),
					I18NHelper.getMessage(messages, 
					"jqlc.codegeneration.generic.unsupportedop", // NOI18N
					op3.getText()));
					
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void conditionalExpr(AST _t) throws RecognitionException {
		
		JQLAST conditionalExpr_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op1 = null;
		JQLAST left1 = null;
		JQLAST right1 = null;
		JQLAST op2 = null;
		JQLAST left2 = null;
		JQLAST right2 = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case AND:
			{
				AST __t55 = _t;
				op1 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,AND);
				_t = _t.getFirstChild();
				left1 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				right1 = _t==ASTNULL ? null : (JQLAST)_t;
				booleanOperationArgument(_t);
				_t = _retTree;
				_t = __t55;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					booleanOperationArgument(left1);
					// do not generate boolean operation if one of the operands is variable constraint
					if (pushesValueOnStack(left1) && pushesValueOnStack(right1))
					op1.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_AND, null); 
					
				}
				break;
			}
			case OR:
			{
				AST __t56 = _t;
				op2 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,OR);
				_t = _t.getFirstChild();
				left2 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				right2 = _t==ASTNULL ? null : (JQLAST)_t;
				booleanOperationArgument(_t);
				_t = _retTree;
				_t = __t56;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					booleanOperationArgument(left2);
					// do not generate boolean operation if one of the operands is variable constraint
					if (pushesValueOnStack(left2) && pushesValueOnStack(right2))
					op2.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_OR, null); 
					
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void relationalExpr(AST _t) throws RecognitionException {
		
		JQLAST relationalExpr_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op1 = null;
		JQLAST left1 = null;
		JQLAST op2 = null;
		JQLAST left2 = null;
		JQLAST op3 = null;
		JQLAST left3 = null;
		JQLAST op4 = null;
		JQLAST left4 = null;
		JQLAST op5 = null;
		JQLAST left5 = null;
		JQLAST op6 = null;
		JQLAST left6 = null;
		
		try {      // for error handling
			boolean synPredMatched59 = false;
			if (_t==null) _t=ASTNULL;
			if (((_tokenSet_0.member(_t.getType())))) {
				AST __t59 = _t;
				synPredMatched59 = true;
				inputState.guessing++;
				try {
					{
					fieldComparison(_t);
					_t = _retTree;
					}
				}
				catch (RecognitionException pe) {
					synPredMatched59 = false;
				}
				_t = __t59;
inputState.guessing--;
			}
			if ( synPredMatched59 ) {
				fieldComparison(_t);
				_t = _retTree;
			}
			else {
				boolean synPredMatched61 = false;
				if (_t==null) _t=ASTNULL;
				if (((_t.getType()==OBJECT_EQUAL||_t.getType()==OBJECT_NOT_EQUAL))) {
					AST __t61 = _t;
					synPredMatched61 = true;
					inputState.guessing++;
					try {
						{
						objectComparison(_t);
						_t = _retTree;
						}
					}
					catch (RecognitionException pe) {
						synPredMatched61 = false;
					}
					_t = __t61;
inputState.guessing--;
				}
				if ( synPredMatched61 ) {
					objectComparison(_t);
					_t = _retTree;
				}
				else {
					boolean synPredMatched63 = false;
					if (_t==null) _t=ASTNULL;
					if (((_t.getType()==COLLECTION_EQUAL||_t.getType()==COLLECTION_NOT_EQUAL))) {
						AST __t63 = _t;
						synPredMatched63 = true;
						inputState.guessing++;
						try {
							{
							collectionComparison(_t);
							_t = _retTree;
							}
						}
						catch (RecognitionException pe) {
							synPredMatched63 = false;
						}
						_t = __t63;
inputState.guessing--;
					}
					if ( synPredMatched63 ) {
						collectionComparison(_t);
						_t = _retTree;
					}
					else {
						boolean synPredMatched65 = false;
						if (_t==null) _t=ASTNULL;
						if (((_tokenSet_1.member(_t.getType())))) {
							AST __t65 = _t;
							synPredMatched65 = true;
							inputState.guessing++;
							try {
								{
								parameterComparison(_t);
								_t = _retTree;
								}
							}
							catch (RecognitionException pe) {
								synPredMatched65 = false;
							}
							_t = __t65;
inputState.guessing--;
						}
						if ( synPredMatched65 ) {
							parameterComparison(_t);
							_t = _retTree;
						}
						else if ((_t.getType()==EQUAL)) {
							AST __t66 = _t;
							op1 = _t==ASTNULL ? null :(JQLAST)_t;
							match(_t,EQUAL);
							_t = _t.getFirstChild();
							left1 = (JQLAST)_t;
							if ( _t==null ) throw new MismatchedTokenException();
							_t = _t.getNextSibling();
							expression(_t);
							_t = _retTree;
							_t = __t66;
							_t = _t.getNextSibling();
							if ( inputState.guessing==0 ) {
								
								expression(left1);
								op1.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_EQ, null); 
								
							}
						}
						else if ((_t.getType()==NOT_EQUAL)) {
							AST __t67 = _t;
							op2 = _t==ASTNULL ? null :(JQLAST)_t;
							match(_t,NOT_EQUAL);
							_t = _t.getFirstChild();
							left2 = (JQLAST)_t;
							if ( _t==null ) throw new MismatchedTokenException();
							_t = _t.getNextSibling();
							expression(_t);
							_t = _retTree;
							_t = __t67;
							_t = _t.getNextSibling();
							if ( inputState.guessing==0 ) {
								
								expression(left2);
								op2.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_NE, null); 
								
							}
						}
						else if ((_t.getType()==LT)) {
							AST __t68 = _t;
							op3 = _t==ASTNULL ? null :(JQLAST)_t;
							match(_t,LT);
							_t = _t.getFirstChild();
							left3 = (JQLAST)_t;
							if ( _t==null ) throw new MismatchedTokenException();
							_t = _t.getNextSibling();
							expression(_t);
							_t = _retTree;
							_t = __t68;
							_t = _t.getNextSibling();
							if ( inputState.guessing==0 ) {
								
								expression(left3);
								op3.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_LT, null); 
								
							}
						}
						else if ((_t.getType()==GT)) {
							AST __t69 = _t;
							op4 = _t==ASTNULL ? null :(JQLAST)_t;
							match(_t,GT);
							_t = _t.getFirstChild();
							left4 = (JQLAST)_t;
							if ( _t==null ) throw new MismatchedTokenException();
							_t = _t.getNextSibling();
							expression(_t);
							_t = _retTree;
							_t = __t69;
							_t = _t.getNextSibling();
							if ( inputState.guessing==0 ) {
								
								expression(left4);
								op4.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_GT, null); 
								
							}
						}
						else if ((_t.getType()==LE)) {
							AST __t70 = _t;
							op5 = _t==ASTNULL ? null :(JQLAST)_t;
							match(_t,LE);
							_t = _t.getFirstChild();
							left5 = (JQLAST)_t;
							if ( _t==null ) throw new MismatchedTokenException();
							_t = _t.getNextSibling();
							expression(_t);
							_t = _retTree;
							_t = __t70;
							_t = _t.getNextSibling();
							if ( inputState.guessing==0 ) {
								
								expression(left5);
								op5.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_LE, null); 
								
							}
						}
						else if ((_t.getType()==GE)) {
							AST __t71 = _t;
							op6 = _t==ASTNULL ? null :(JQLAST)_t;
							match(_t,GE);
							_t = _t.getFirstChild();
							left6 = (JQLAST)_t;
							if ( _t==null ) throw new MismatchedTokenException();
							_t = _t.getNextSibling();
							expression(_t);
							_t = _retTree;
							_t = __t71;
							_t = _t.getNextSibling();
							if ( inputState.guessing==0 ) {
								
								expression(left6);
								op6.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_GE, null); 
								
							}
						}
						else {
							throw new NoViableAltException(_t);
						}
						}}}
					}
					catch (RecognitionException ex) {
						if (inputState.guessing==0) {
							reportError(ex);
							if (_t!=null) {_t = _t.getNextSibling();}
						} else {
						  throw ex;
						}
					}
					_retTree = _t;
				}
				
	public final void binaryArithmeticExpr(AST _t) throws RecognitionException {
		
		JQLAST binaryArithmeticExpr_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op1 = null;
		JQLAST left1 = null;
		JQLAST right1 = null;
		JQLAST op2 = null;
		JQLAST left2 = null;
		JQLAST op3 = null;
		JQLAST left3 = null;
		JQLAST right3 = null;
		JQLAST op4 = null;
		JQLAST left4 = null;
		JQLAST op5 = null;
		JQLAST left5 = null;
		JQLAST op6 = null;
		JQLAST left6 = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case PLUS:
			{
				AST __t98 = _t;
				op1 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,PLUS);
				_t = _t.getFirstChild();
				left1 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				right1 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				_t = __t98;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					// Optimize indexOf + <intValue>: 
					// The SQL database returns an index starting with 1, so we need 
					// to decrement the returned index. We can do the derement at compile
					// timeCombine, if the other operand is a constant int value.
					if ((left1.getType() == INDEXOF) && 
					(right1.getType() == VALUE) && 
					(right1.getValue() instanceof Integer))
					{
					// case: indexOf() + intValue
					indexOf(left1, ((Integer)right1.getValue()).intValue());
					}
					else if ((right1.getType() == INDEXOF) && 
					(left1.getType() == VALUE) && 
					(left1.getValue() instanceof Integer))
					{
					// case: intValue + indexOf()
					indexOf(right1, ((Integer)left1.getValue()).intValue());
					}
					else
					{
					expression(right1);
					expression(left1);
					op1.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_ADD, null); 
					}
					
				}
				break;
			}
			case CONCAT:
			{
				AST __t99 = _t;
				op2 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,CONCAT);
				_t = _t.getFirstChild();
				left2 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				expression(_t);
				_t = _retTree;
				_t = __t99;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					expression(left2);
					op2.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_CONCAT, null); 
					
				}
				break;
			}
			case MINUS:
			{
				AST __t100 = _t;
				op3 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,MINUS);
				_t = _t.getFirstChild();
				left3 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				right3 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				_t = __t100;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					// Optimize indexOf + <intValue>: 
					// The SQL database returns an index starting with 1, so we need 
					// to decrement the returned index. We can do the derement at compile
					// timeCombine, if the other operand is a constant int value.
					if ((left3.getType() == INDEXOF) && 
					(right3.getType() == VALUE) && 
					(right3.getValue() instanceof Integer))
					{
					// case: indexOf - intValue 
					// treated as indexOf + -intValue
					indexOf(left3, -((Integer)right3.getValue()).intValue());
					}
					else
					{
					expression(right3);
					expression(left3);
					op3.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_SUB, null); 
					}
					
				}
				break;
			}
			case STAR:
			{
				AST __t101 = _t;
				op4 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,STAR);
				_t = _t.getFirstChild();
				left4 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				expression(_t);
				_t = _retTree;
				_t = __t101;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					expression(left4);
					op4.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_MUL, null); 
					
				}
				break;
			}
			case DIV:
			{
				AST __t102 = _t;
				op5 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,DIV);
				_t = _t.getFirstChild();
				left5 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				expression(_t);
				_t = _retTree;
				_t = __t102;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					expression(left5);
					op5.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_DIV, null); 
					
				}
				break;
			}
			case MOD:
			{
				AST __t103 = _t;
				op6 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,MOD);
				_t = _t.getFirstChild();
				left6 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				expression(_t);
				_t = _retTree;
				_t = __t103;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					expression(left6);
					op6.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_MOD, null);
					
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void unaryArithmeticExpr(AST _t) throws RecognitionException {
		
		JQLAST unaryArithmeticExpr_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op2 = null;
		
		Object value = null; 
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case UNARY_PLUS:
			{
				AST __t105 = _t;
				JQLAST tmp26_AST_in = (JQLAST)_t;
				match(_t,UNARY_PLUS);
				_t = _t.getFirstChild();
				expression(_t);
				_t = _retTree;
				_t = __t105;
				_t = _t.getNextSibling();
				break;
			}
			case UNARY_MINUS:
			{
				AST __t106 = _t;
				op2 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,UNARY_MINUS);
				_t = _t.getFirstChild();
				{
				boolean synPredMatched109 = false;
				if (_t==null) _t=ASTNULL;
				if (((_t.getType()==VALUE))) {
					AST __t109 = _t;
					synPredMatched109 = true;
					inputState.guessing++;
					try {
						{
						constantValue(_t);
						_t = _retTree;
						}
					}
					catch (RecognitionException pe) {
						synPredMatched109 = false;
					}
					_t = __t109;
inputState.guessing--;
				}
				if ( synPredMatched109 ) {
					value=constantValue(_t);
					_t = _retTree;
					if ( inputState.guessing==0 ) {
						
						value = negate(value, op2.getJQLType());
						op2.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_VALUE, value);
						
					}
				}
				else if ((_tokenSet_2.member(_t.getType()))) {
					expression(_t);
					_t = _retTree;
					if ( inputState.guessing==0 ) {
						
						// map -value to 0 - value
						op2.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_VALUE, 
						getZeroValue(op2.getJQLType()));
						op2.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_SUB, null); 
						
					}
				}
				else {
					throw new NoViableAltException(_t);
				}
				
				}
				_t = __t106;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void complementExpr(AST _t) throws RecognitionException {
		
		JQLAST complementExpr_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op1 = null;
		JQLAST op2 = null;
		JQLAST expr = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case BNOT:
			{
				AST __t111 = _t;
				op1 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,BNOT);
				_t = _t.getFirstChild();
				expression(_t);
				_t = _retTree;
				_t = __t111;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					// map ~value to -1 - value (which is equivalent to (-value)-1)
					op1.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_VALUE, 
					getMinusOneValue(op1.getJQLType()));
					op1.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_SUB, null); 
					
				}
				break;
			}
			case LNOT:
			{
				AST __t112 = _t;
				op2 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,LNOT);
				_t = _t.getFirstChild();
				expr = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				_t = __t112;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					if (expr.getType() == FIELD_ACCESS) {
					// The NOT operand is a boolean field.
					// Map this to 'booleanField = FALSE'. Note, the runtime will
					// create a JDBC parameter for the literal FALSE and call 
					// setBoolean to bind the value.
					RetrieveDesc rd = op2.getRetrieveDesc();
					rd.addConstraint(null, RetrieveDesc.OP_VALUE, Boolean.FALSE); 
					expression(expr);
					rd.addConstraint(null, RetrieveDesc.OP_EQ, null);
					}
					else {
					expression(expr);
					op2.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_NOT, null); 
					}
					
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void booleanOperationArgument(AST _t) throws RecognitionException {
		
		JQLAST booleanOperationArgument_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST e = null;
		
		try {      // for error handling
			e = _t==ASTNULL ? null : (JQLAST)_t;
			expression(_t);
			_t = _retTree;
			if ( inputState.guessing==0 ) {
				
				if (e.getType() == FIELD_ACCESS) {
				RetrieveDesc rd = e.getRetrieveDesc();
				rd.addConstraint(null, RetrieveDesc.OP_VALUE, Boolean.TRUE);
				rd.addConstraint(null, RetrieveDesc.OP_EQ, null);
				}
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void fieldComparison(AST _t) throws RecognitionException {
		
		JQLAST fieldComparison_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case EQUAL:
			{
				AST __t73 = _t;
				JQLAST tmp27_AST_in = (JQLAST)_t;
				match(_t,EQUAL);
				_t = _t.getFirstChild();
				fieldComparisonOperands(_t,RetrieveDesc.OP_EQ);
				_t = _retTree;
				_t = __t73;
				_t = _t.getNextSibling();
				break;
			}
			case NOT_EQUAL:
			{
				AST __t74 = _t;
				JQLAST tmp28_AST_in = (JQLAST)_t;
				match(_t,NOT_EQUAL);
				_t = _t.getFirstChild();
				fieldComparisonOperands(_t,RetrieveDesc.OP_NE);
				_t = _retTree;
				_t = __t74;
				_t = _t.getNextSibling();
				break;
			}
			case LT:
			{
				AST __t75 = _t;
				JQLAST tmp29_AST_in = (JQLAST)_t;
				match(_t,LT);
				_t = _t.getFirstChild();
				fieldComparisonOperands(_t,RetrieveDesc.OP_LT);
				_t = _retTree;
				_t = __t75;
				_t = _t.getNextSibling();
				break;
			}
			case LE:
			{
				AST __t76 = _t;
				JQLAST tmp30_AST_in = (JQLAST)_t;
				match(_t,LE);
				_t = _t.getFirstChild();
				fieldComparisonOperands(_t,RetrieveDesc.OP_LE);
				_t = _retTree;
				_t = __t76;
				_t = _t.getNextSibling();
				break;
			}
			case GT:
			{
				AST __t77 = _t;
				JQLAST tmp31_AST_in = (JQLAST)_t;
				match(_t,GT);
				_t = _t.getFirstChild();
				fieldComparisonOperands(_t,RetrieveDesc.OP_GT);
				_t = _retTree;
				_t = __t77;
				_t = _t.getNextSibling();
				break;
			}
			case GE:
			{
				AST __t78 = _t;
				JQLAST tmp32_AST_in = (JQLAST)_t;
				match(_t,GE);
				_t = _t.getFirstChild();
				fieldComparisonOperands(_t,RetrieveDesc.OP_GE);
				_t = _retTree;
				_t = __t78;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void objectComparison(AST _t) throws RecognitionException {
		
		JQLAST objectComparison_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		Object value = null;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case OBJECT_EQUAL:
			{
				AST __t82 = _t;
				JQLAST tmp33_AST_in = (JQLAST)_t;
				match(_t,OBJECT_EQUAL);
				_t = _t.getFirstChild();
				objectComparisonOperands(_t,RetrieveDesc.OP_EQ);
				_t = _retTree;
				_t = __t82;
				_t = _t.getNextSibling();
				break;
			}
			case OBJECT_NOT_EQUAL:
			{
				AST __t83 = _t;
				JQLAST tmp34_AST_in = (JQLAST)_t;
				match(_t,OBJECT_NOT_EQUAL);
				_t = _t.getFirstChild();
				objectComparisonOperands(_t,RetrieveDesc.OP_NE);
				_t = _retTree;
				_t = __t83;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void collectionComparison(AST _t) throws RecognitionException {
		
		JQLAST collectionComparison_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST eq = null;
		JQLAST ne = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case COLLECTION_EQUAL:
			{
				AST __t95 = _t;
				eq = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,COLLECTION_EQUAL);
				_t = _t.getFirstChild();
				JQLAST tmp35_AST_in = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				JQLAST tmp36_AST_in = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				_t = __t95;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					errorMsg.unsupported(eq.getLine(), eq.getColumn(),
					I18NHelper.getMessage(messages, 
					"jqlc.codegeneration.collectioncomparison.nonnull")); // NOI18N
					
				}
				break;
			}
			case COLLECTION_NOT_EQUAL:
			{
				AST __t96 = _t;
				ne = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,COLLECTION_NOT_EQUAL);
				_t = _t.getFirstChild();
				JQLAST tmp37_AST_in = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				JQLAST tmp38_AST_in = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				_t = __t96;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					errorMsg.unsupported(ne.getLine(), ne.getColumn(),
					I18NHelper.getMessage(messages, 
					"jqlc.codegeneration.collectioncomparison.nonnull")); // NOI18N
					
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void parameterComparison(AST _t) throws RecognitionException {
		
		JQLAST parameterComparison_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case EQUAL:
			{
				AST __t87 = _t;
				JQLAST tmp39_AST_in = (JQLAST)_t;
				match(_t,EQUAL);
				_t = _t.getFirstChild();
				parameterComparisonOperands(_t,RetrieveDesc.OP_EQ);
				_t = _retTree;
				_t = __t87;
				_t = _t.getNextSibling();
				break;
			}
			case NOT_EQUAL:
			{
				AST __t88 = _t;
				JQLAST tmp40_AST_in = (JQLAST)_t;
				match(_t,NOT_EQUAL);
				_t = _t.getFirstChild();
				parameterComparisonOperands(_t,RetrieveDesc.OP_NE);
				_t = _retTree;
				_t = __t88;
				_t = _t.getNextSibling();
				break;
			}
			case OBJECT_EQUAL:
			{
				AST __t89 = _t;
				JQLAST tmp41_AST_in = (JQLAST)_t;
				match(_t,OBJECT_EQUAL);
				_t = _t.getFirstChild();
				parameterComparisonOperands(_t,RetrieveDesc.OP_EQ);
				_t = _retTree;
				_t = __t89;
				_t = _t.getNextSibling();
				break;
			}
			case OBJECT_NOT_EQUAL:
			{
				AST __t90 = _t;
				JQLAST tmp42_AST_in = (JQLAST)_t;
				match(_t,OBJECT_NOT_EQUAL);
				_t = _t.getFirstChild();
				parameterComparisonOperands(_t,RetrieveDesc.OP_NE);
				_t = _retTree;
				_t = __t90;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void fieldComparisonOperands(AST _t,
		int operation
	) throws RecognitionException {
		
		JQLAST fieldComparisonOperands_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST f1 = null;
		JQLAST p1 = null;
		JQLAST f2 = null;
		JQLAST f3 = null;
		JQLAST f4 = null;
		JQLAST p2 = null;
		
		String leftName = null;
		String rightName = null;
		Object value = null;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case VALUE:
			{
				value=constantValue(_t);
				_t = _retTree;
				f1 = _t==ASTNULL ? null : (JQLAST)_t;
				rightName=fieldAccess(_t);
				_t = _retTree;
				if ( inputState.guessing==0 ) {
					
					// case constant relop field
					generateSimpleFieldValueComparison(f1.getRetrieveDesc(), rightName, 
					getSwappedOp(operation), value);
					
				}
				break;
			}
			case PARAMETER:
			{
				p1 = (JQLAST)_t;
				match(_t,PARAMETER);
				_t = _t.getNextSibling();
				f2 = _t==ASTNULL ? null : (JQLAST)_t;
				rightName=fieldAccess(_t);
				_t = _retTree;
				if ( inputState.guessing==0 ) {
					
					// case parameter relop field
					// Support for fixed-width char pk columns
					f2.getRetrieveDesc().addConstraint(rightName, RetrieveDesc.OP_FIELD, null); 
					f2.getRetrieveDesc().addConstraint(null,
					RetrieveDesc.OP_PARAMETER, 
					paramtab.getParameterInfoForParamName(p1.getText(), rightName));
					f2.getRetrieveDesc().addConstraint(null, operation, null);
					
				}
				break;
			}
			case FIELD_ACCESS:
			{
				f3 = _t==ASTNULL ? null : (JQLAST)_t;
				leftName=fieldAccess(_t);
				_t = _retTree;
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case VALUE:
				{
					value=constantValue(_t);
					_t = _retTree;
					if ( inputState.guessing==0 ) {
						
						// case field relop constant
						generateSimpleFieldValueComparison(f3.getRetrieveDesc(), leftName, 
						operation, value);
						
					}
					break;
				}
				case FIELD_ACCESS:
				{
					f4 = _t==ASTNULL ? null : (JQLAST)_t;
					rightName=fieldAccess(_t);
					_t = _retTree;
					if ( inputState.guessing==0 ) {
						
						// case field relop field
						f3.getRetrieveDesc().addConstraint(leftName, operation, 
						f4.getRetrieveDesc(), rightName);
						
					}
					break;
				}
				case PARAMETER:
				{
					p2 = (JQLAST)_t;
					match(_t,PARAMETER);
					_t = _t.getNextSibling();
					if ( inputState.guessing==0 ) {
						
						// case field relop parameter
						// Support for fixed-width char pk columns
						f3.getRetrieveDesc().addConstraint(null,
						RetrieveDesc.OP_PARAMETER, 
						paramtab.getParameterInfoForParamName(p2.getText(), leftName));
						f3.getRetrieveDesc().addConstraint(leftName, RetrieveDesc.OP_FIELD, null);
						f3.getRetrieveDesc().addConstraint(null, operation, null);
						
					}
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final Object  constantValue(AST _t) throws RecognitionException {
		Object value;
		
		JQLAST constantValue_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST v = null;
		
		value = null; 
		
		
		try {      // for error handling
			v = (JQLAST)_t;
			match(_t,VALUE);
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				value = v.getValue();
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
		return value;
	}
	
	public final String  fieldAccess(AST _t) throws RecognitionException {
		String fieldName;
		
		JQLAST fieldAccess_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST name = null;
		
		fieldName = null; 
		
		
		try {      // for error handling
			AST __t119 = _t;
			JQLAST tmp43_AST_in = (JQLAST)_t;
			match(_t,FIELD_ACCESS);
			_t = _t.getFirstChild();
			expression(_t);
			_t = _retTree;
			name = (JQLAST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			_t = __t119;
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				fieldName = name.getText();
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
		return fieldName;
	}
	
	public final void objectComparisonOperands(AST _t,
		int operation
	) throws RecognitionException {
		
		JQLAST objectComparisonOperands_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST v1 = null;
		JQLAST d1 = null;
		JQLAST d2 = null;
		JQLAST v2 = null;
		JQLAST d3 = null;
		
		Object value = null;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case VALUE:
			{
				v1 = _t==ASTNULL ? null : (JQLAST)_t;
				value=constantValue(_t);
				_t = _retTree;
				d1 = _t==ASTNULL ? null : (JQLAST)_t;
				dbValue(_t);
				_t = _retTree;
				if ( inputState.guessing==0 ) {
					
					if ((value == null) && (d1.getType() == NAVIGATION))
					{
					JQLAST expr = (JQLAST)d1.getFirstChild();
					JQLAST ident = (JQLAST)expr.getNextSibling();
					// now handle navigation source
					expression(expr);
					// now generate IS NULL constraint
					generateSimpleFieldValueComparison(expr.getRetrieveDesc(), ident.getText(), 
					getSwappedOp(operation), value);
					}
					else
					{
					if (d1.getType() == NAVIGATION) navigation(d1);
					generateDbValueConstantComparison(d1.getRetrieveDesc(), (ClassType)d1.getJQLType(), 
					getSwappedOp(operation), value, v1.getJQLType());
					}
					
				}
				break;
			}
			case THIS:
			case NAVIGATION:
			case VARIABLE:
			{
				d2 = _t==ASTNULL ? null : (JQLAST)_t;
				dbValue(_t);
				_t = _retTree;
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case VALUE:
				{
					v2 = _t==ASTNULL ? null : (JQLAST)_t;
					value=constantValue(_t);
					_t = _retTree;
					if ( inputState.guessing==0 ) {
						
						if ((value == null) && (d2.getType() == NAVIGATION))
						{
						JQLAST expr = (JQLAST)d2.getFirstChild();
						JQLAST ident = (JQLAST)expr.getNextSibling();
						// now handle navigation source
						expression(expr);
						// now generate IS NULL constraint
						generateSimpleFieldValueComparison(expr.getRetrieveDesc(), ident.getText(), 
						operation, value);
						}
						else
						{
						if (d2.getType() == NAVIGATION) navigation(d2);
						generateDbValueConstantComparison(d2.getRetrieveDesc(), 
						(ClassType)d2.getJQLType(), 
						operation, value, v2.getJQLType());
						}
						
					}
					break;
				}
				case THIS:
				case NAVIGATION:
				case VARIABLE:
				{
					d3 = _t==ASTNULL ? null : (JQLAST)_t;
					dbValue(_t);
					_t = _retTree;
					if ( inputState.guessing==0 ) {
						
						if (d2.getType() == NAVIGATION) navigation(d2);
						if (d3.getType() == NAVIGATION) navigation(d3);
						generateDbValueDbValueComparison(d2.getRetrieveDesc(), 
						(ClassType)d2.getJQLType(), 
						operation, 
						d3.getRetrieveDesc(), 
						(ClassType)d3.getJQLType());
						
					}
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void dbValue(AST _t) throws RecognitionException {
		
		JQLAST dbValue_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		String name = null;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case THIS:
			{
				JQLAST tmp44_AST_in = (JQLAST)_t;
				match(_t,THIS);
				_t = _t.getNextSibling();
				break;
			}
			case VARIABLE:
			{
				variableAccess(_t);
				_t = _retTree;
				break;
			}
			case NAVIGATION:
			{
				AST __t93 = _t;
				JQLAST tmp45_AST_in = (JQLAST)_t;
				match(_t,NAVIGATION);
				_t = _t.getFirstChild();
				JQLAST tmp46_AST_in = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				JQLAST tmp47_AST_in = (JQLAST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				_t = __t93;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void parameterComparisonOperands(AST _t,
		int operation
	) throws RecognitionException {
		
		JQLAST parameterComparisonOperands_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST p1 = null;
		JQLAST v1 = null;
		JQLAST v2 = null;
		JQLAST p2 = null;
		
		Object value = null;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case PARAMETER:
			{
				p1 = (JQLAST)_t;
				match(_t,PARAMETER);
				_t = _t.getNextSibling();
				v1 = _t==ASTNULL ? null : (JQLAST)_t;
				value=constantValue(_t);
				_t = _retTree;
				if ( inputState.guessing==0 ) {
					
					generateParameterValueComparison(v1.getRetrieveDesc(), p1.getText(),
					operation, value);
					
				}
				break;
			}
			case VALUE:
			{
				v2 = _t==ASTNULL ? null : (JQLAST)_t;
				value=constantValue(_t);
				_t = _retTree;
				p2 = (JQLAST)_t;
				match(_t,PARAMETER);
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					generateParameterValueComparison(v2.getRetrieveDesc(), p2.getText(),
					operation, value);
					
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void variableAccess(AST _t) throws RecognitionException {
		
		JQLAST variableAccess_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST var = null;
		JQLAST col = null;
		
		String name = null;
		
		
		try {      // for error handling
			AST __t123 = _t;
			var = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,VARIABLE);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPECAST:
			case FIELD_ACCESS:
			case NAVIGATION:
			case NOT_IN:
			{
				col = _t==ASTNULL ? null : (JQLAST)_t;
				name=collectionExpr(_t);
				_t = _retTree;
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			_t = __t123;
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				
				RetrieveDesc varRD = var.getRetrieveDesc();
				if (!boundRetrieveDescs.contains(varRD))
				{
				if (col != null) 
				{
				if (col.getType() == NOT_IN)
				col.getRetrieveDesc().addConstraint(name, RetrieveDesc.OP_NOTIN, varRD);
				else if (USE_IN)
				// generate OP_IN if USE_IN property is set
				col.getRetrieveDesc().addConstraint(name, RetrieveDesc.OP_IN, varRD);
				else
				// otherwise generate regular join
				col.getRetrieveDesc().addConstraint(name, varRD);
				}
				else
				{
				candidateRD.addConstraint(null, varRD);
				}
				boundRetrieveDescs.add(varRD);
				}
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void navigation(AST _t) throws RecognitionException {
		
		JQLAST navigation_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST n = null;
		JQLAST expr = null;
		JQLAST i = null;
		
		try {      // for error handling
			AST __t121 = _t;
			n = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,NAVIGATION);
			_t = _t.getFirstChild();
			expr = _t==ASTNULL ? null : (JQLAST)_t;
			expression(_t);
			_t = _retTree;
			i = (JQLAST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			_t = __t121;
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				RetrieveDesc from = expr.getRetrieveDesc();
				RetrieveDesc to = n.getRetrieveDesc();
				from.addConstraint(i.getText(), to);
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void startsWith(AST _t) throws RecognitionException {
		
		JQLAST startsWith_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op1 = null;
		JQLAST string = null;
		
		Object value = null;
		JQLAST pattern = null;
		
		
		try {      // for error handling
			AST __t131 = _t;
			op1 = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,STARTS_WITH);
			_t = _t.getFirstChild();
			string = (JQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				// I need to store a pointer to the second operand of startsWith here.
				// See second alternative below.
				pattern = (JQLAST)string.getNextSibling();
				
			}
			{
			boolean synPredMatched134 = false;
			if (_t==null) _t=ASTNULL;
			if (((_t.getType()==VALUE))) {
				AST __t134 = _t;
				synPredMatched134 = true;
				inputState.guessing++;
				try {
					{
					constantValue(_t);
					_t = _retTree;
					}
				}
				catch (RecognitionException pe) {
					synPredMatched134 = false;
				}
				_t = __t134;
inputState.guessing--;
			}
			if ( synPredMatched134 ) {
				value=constantValue(_t);
				_t = _retTree;
				if ( inputState.guessing==0 ) {
					
					if (string.getType() == FIELD_ACCESS)
					{
					// case 1 fieldAccess constantValue
					String fieldName = fieldAccess(string);
					op1.getRetrieveDesc().addConstraint(fieldName, RetrieveDesc.OP_LIKE, 
					((String)value) + WILDCARD_PATTERN);
					}
					else
					{
					// case 2 expression constantValue
					op1.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_VALUE, 
					((String)value) + WILDCARD_PATTERN);
					expression(string);
					op1.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_LIKE, null);
					}
					
				}
			}
			else if ((_tokenSet_2.member(_t.getType()))) {
				if ( inputState.guessing==0 ) {
					
					// I have to access the tree matched by rule expression before 
					// the rule is entered. Variable pattern points to that tree and 
					// needs to be initilaized before!
					pattern.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_VALUE, 
					WILDCARD_PATTERN);
					
				}
				expression(_t);
				_t = _retTree;
				if ( inputState.guessing==0 ) {
					
					// case 3 expression expression
					pattern.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_CONCAT, null);
					expression(string);
					op1.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_LIKE, null);
					
				}
			}
			else {
				throw new NoViableAltException(_t);
			}
			
			}
			_t = __t131;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void endsWith(AST _t) throws RecognitionException {
		
		JQLAST endsWith_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op1 = null;
		JQLAST string = null;
		JQLAST pattern = null;
		
		Object value = null;
		
		
		try {      // for error handling
			AST __t136 = _t;
			op1 = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,ENDS_WITH);
			_t = _t.getFirstChild();
			string = (JQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			{
			boolean synPredMatched139 = false;
			if (_t==null) _t=ASTNULL;
			if (((_t.getType()==VALUE))) {
				AST __t139 = _t;
				synPredMatched139 = true;
				inputState.guessing++;
				try {
					{
					constantValue(_t);
					_t = _retTree;
					}
				}
				catch (RecognitionException pe) {
					synPredMatched139 = false;
				}
				_t = __t139;
inputState.guessing--;
			}
			if ( synPredMatched139 ) {
				value=constantValue(_t);
				_t = _retTree;
				if ( inputState.guessing==0 ) {
					
					if (string.getType() == FIELD_ACCESS)
					{
					// case 1 fieldAccess constantValue
					String fieldName = fieldAccess(string);
					op1.getRetrieveDesc().addConstraint(fieldName, RetrieveDesc.OP_LIKE, 
					WILDCARD_PATTERN + ((String)value));
					}
					else
					{
					// case 2 expression constantValue
					op1.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_VALUE, 
					WILDCARD_PATTERN + ((String)value));
					expression(string);
					op1.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_LIKE, null);
					}
					
				}
			}
			else if ((_tokenSet_2.member(_t.getType()))) {
				pattern = _t==ASTNULL ? null : (JQLAST)_t;
				expression(_t);
				_t = _retTree;
				if ( inputState.guessing==0 ) {
					
					// case 3 expression expression
					pattern.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_VALUE,
					WILDCARD_PATTERN);
					pattern.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_CONCAT, null);
					expression(string);
					op1.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_LIKE, null);
					
				}
			}
			else {
				throw new NoViableAltException(_t);
			}
			
			}
			_t = __t136;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void isEmpty(AST _t) throws RecognitionException {
		
		JQLAST isEmpty_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op = null;
		
		String name = null;
		
		
		try {      // for error handling
			AST __t141 = _t;
			op = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,IS_EMPTY);
			_t = _t.getFirstChild();
			name=collectionExpr(_t);
			_t = _retTree;
			_t = __t141;
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				op.getRetrieveDesc().addConstraint(name, RetrieveDesc.OP_NULL, null);
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void like(AST _t) throws RecognitionException {
		
		JQLAST like_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op = null;
		JQLAST string = null;
		JQLAST pattern = null;
		
		int opCode = RetrieveDesc.OP_LIKE;
		
		
		try {      // for error handling
			AST __t143 = _t;
			op = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,LIKE);
			_t = _t.getFirstChild();
			string = (JQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			pattern = (JQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			opCode=escape(_t);
			_t = _retTree;
			_t = __t143;
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				expression(pattern);
				expression(string);
				op.getRetrieveDesc().addConstraint(null, opCode, null);
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void substring(AST _t) throws RecognitionException {
		
		JQLAST substring_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op = null;
		JQLAST string = null;
		JQLAST begin = null;
		JQLAST end = null;
		
		try {      // for error handling
			AST __t146 = _t;
			op = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,SUBSTRING);
			_t = _t.getFirstChild();
			string = (JQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			begin = (JQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			end = (JQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			_t = __t146;
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				RetrieveDesc rd = op.getRetrieveDesc();
				if ((begin.getType() == VALUE) && (end.getType() == VALUE))
				{
				// Optimization: begin and end are constant values =>
				// calculate start and length of SQL SUBSTRING function 
				// at compile time.
				// Note, Semantic ensures begin and end are int or Integer values.
				int beginValue = (begin.getValue() != null) ? 
				((Integer)begin.getValue()).intValue() : 0;
				int endValue = (end.getValue() != null) ? 
				((Integer)end.getValue()).intValue() : 0;
				if (beginValue < 0) 
				{
				errorMsg.error(begin.getLine(), begin.getColumn(),
				I18NHelper.getMessage(messages, 
				"jqlc.codegeneration.substring.beginnegative", // NOI18N
				String.valueOf(beginValue)));
				}
				else if (endValue < beginValue) 
				{
				errorMsg.error(op.getLine(), op.getColumn(),
				I18NHelper.getMessage(messages, 
				"jqlc.codegeneration.substring.beginlargerend", // NOI18N
				String.valueOf(beginValue), String.valueOf(endValue)));
				}
				// SQL length = end - begin
				rd.addConstraint(null, RetrieveDesc.OP_VALUE, 
				new Integer(endValue-beginValue));
				// SQL start index = begin + 1 
				rd.addConstraint(null, RetrieveDesc.OP_VALUE, 
				new Integer(beginValue+1));
				}
				else
				{
				// At least one of begin or end is a non constant value =>
				// generate the arguments start and length of the SQL SUBSTRING 
				// function as binary plus/minus expressions.
				// The next 3 line denote the SQL length = end - begin
				expression(begin);
				expression(end);
				rd.addConstraint(null, RetrieveDesc.OP_SUB, null);
				// The next 3 lines denote the SQL start index = begin + 1 
				rd.addConstraint(null, RetrieveDesc.OP_VALUE, new Integer(1));
				expression(begin);
				rd.addConstraint(null, RetrieveDesc.OP_ADD, null);
				}
				// now push the string on the constraint stack
				expression(string);
				rd.addConstraint(null, RetrieveDesc.OP_SUBSTRING, null);
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void indexOf(AST _t,
		int incr
	) throws RecognitionException {
		
		JQLAST indexOf_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op = null;
		JQLAST string = null;
		JQLAST pattern = null;
		
		int opCode = RetrieveDesc.OP_POSITION;
		
		
		try {      // for error handling
			AST __t148 = _t;
			op = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,INDEXOF);
			_t = _t.getFirstChild();
			string = (JQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			pattern = (JQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			opCode=fromIndex(_t);
			_t = _retTree;
			_t = __t148;
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				RetrieveDesc rd = op.getRetrieveDesc();
				// the 3 lines denote the SQL function POSITION OR POSITION_START
				expression(pattern);
				expression(string);
				rd.addConstraint(null, opCode, null);
				// SQL handles indexes starting from 1 =>
				// decrement the returned value to make it Java like!
				incr--;
				if (incr != 0)
				{
				rd.addConstraint(null, RetrieveDesc.OP_VALUE, new Integer(incr));
				rd.addConstraint(null, RetrieveDesc.OP_ADD, null);
				}
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void length(AST _t) throws RecognitionException {
		
		JQLAST length_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op = null;
		
		try {      // for error handling
			AST __t151 = _t;
			op = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,LENGTH);
			_t = _t.getFirstChild();
			expression(_t);
			_t = _retTree;
			_t = __t151;
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				op.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_LENGTH, null);
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void abs(AST _t) throws RecognitionException {
		
		JQLAST abs_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op = null;
		
		try {      // for error handling
			AST __t153 = _t;
			op = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,ABS);
			_t = _t.getFirstChild();
			expression(_t);
			_t = _retTree;
			_t = __t153;
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				op.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_ABS, null);
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void sqrt(AST _t) throws RecognitionException {
		
		JQLAST sqrt_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST op = null;
		
		try {      // for error handling
			AST __t155 = _t;
			op = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,SQRT);
			_t = _t.getFirstChild();
			expression(_t);
			_t = _retTree;
			_t = __t155;
			_t = _t.getNextSibling();
			if ( inputState.guessing==0 ) {
				
				op.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_SQRT, null);
				
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final String  collectionExpr(AST _t) throws RecognitionException {
		String fieldName;
		
		JQLAST collectionExpr_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST name1 = null;
		JQLAST name2 = null;
		
		fieldName = null; 
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case FIELD_ACCESS:
			{
				AST __t126 = _t;
				JQLAST tmp48_AST_in = (JQLAST)_t;
				match(_t,FIELD_ACCESS);
				_t = _t.getFirstChild();
				expression(_t);
				_t = _retTree;
				name1 = (JQLAST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				_t = __t126;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					fieldName = name1.getText();
				}
				break;
			}
			case NAVIGATION:
			{
				AST __t127 = _t;
				JQLAST tmp49_AST_in = (JQLAST)_t;
				match(_t,NAVIGATION);
				_t = _t.getFirstChild();
				expression(_t);
				_t = _retTree;
				name2 = (JQLAST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				_t = __t127;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					fieldName = name2.getText();
				}
				break;
			}
			case TYPECAST:
			{
				AST __t128 = _t;
				JQLAST tmp50_AST_in = (JQLAST)_t;
				match(_t,TYPECAST);
				_t = _t.getFirstChild();
				JQLAST tmp51_AST_in = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				fieldName=collectionExpr(_t);
				_t = _retTree;
				_t = __t128;
				_t = _t.getNextSibling();
				break;
			}
			case NOT_IN:
			{
				AST __t129 = _t;
				JQLAST tmp52_AST_in = (JQLAST)_t;
				match(_t,NOT_IN);
				_t = _t.getFirstChild();
				fieldName=collectionExpr(_t);
				_t = _retTree;
				_t = __t129;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
		return fieldName;
	}
	
	public final int  escape(AST _t) throws RecognitionException {
		int opCode;
		
		JQLAST escape_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		// The default is no ESCAPE definition => OP_LIKE
		opCode = RetrieveDesc.OP_LIKE;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case THIS:
			case EQUAL:
			case LNOT:
			case BNOT:
			case NOT_EQUAL:
			case DIV:
			case PLUS:
			case MINUS:
			case STAR:
			case MOD:
			case GE:
			case GT:
			case LE:
			case LT:
			case BXOR:
			case BOR:
			case OR:
			case BAND:
			case AND:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case TYPECAST:
			case OBJECT_EQUAL:
			case OBJECT_NOT_EQUAL:
			case COLLECTION_EQUAL:
			case COLLECTION_NOT_EQUAL:
			case CONCAT:
			case FIELD_ACCESS:
			case CONTAINS:
			case NOT_CONTAINS:
			case NAVIGATION:
			case STARTS_WITH:
			case ENDS_WITH:
			case IS_EMPTY:
			case VARIABLE:
			case PARAMETER:
			case VALUE:
			case LIKE:
			case SUBSTRING:
			case INDEXOF:
			case LENGTH:
			case ABS:
			case SQRT:
			{
				expression(_t);
				_t = _retTree;
				if ( inputState.guessing==0 ) {
					
					opCode = RetrieveDesc.OP_LIKE_ESCAPE;
					
				}
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
		return opCode;
	}
	
	public final int  fromIndex(AST _t) throws RecognitionException {
		int opCode;
		
		JQLAST fromIndex_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST e = null;
		
		// The default is no start definition => OP_POSITION
		opCode = RetrieveDesc.OP_POSITION;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IMPORT:
			case THIS:
			case ASCENDING:
			case DESCENDING:
			case DISTINCT:
			case BOOLEAN:
			case BYTE:
			case CHAR:
			case SHORT:
			case INT:
			case FLOAT:
			case LONG:
			case DOUBLE:
			case NULL:
			case TRUE:
			case FALSE:
			case AVG:
			case MAX:
			case MIN:
			case SUM:
			case COUNT:
			case LPAREN:
			case RPAREN:
			case COMMA:
			case EQUAL:
			case LNOT:
			case BNOT:
			case NOT_EQUAL:
			case DIV:
			case PLUS:
			case MINUS:
			case STAR:
			case MOD:
			case GE:
			case GT:
			case LE:
			case LT:
			case BXOR:
			case BOR:
			case OR:
			case BAND:
			case AND:
			case SEMI:
			case WS:
			case NEWLINE:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case ESC:
			case HEX_DIGIT:
			case INT_LITERAL:
			case EXPONENT:
			case FLOATINGPOINT_SUFFIX:
			case IDENT:
			case UNICODE_ESCAPE:
			case QUERY:
			case CLASS_DEF:
			case IMPORT_DEF:
			case PARAMETER_DEF:
			case VARIABLE_DEF:
			case ORDERING_DEF:
			case FILTER_DEF:
			case ARG_LIST:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case TYPECAST:
			case OBJECT_EQUAL:
			case OBJECT_NOT_EQUAL:
			case COLLECTION_EQUAL:
			case COLLECTION_NOT_EQUAL:
			case CONCAT:
			case FIELD_ACCESS:
			case STATIC_FIELD_ACCESS:
			case CONTAINS:
			case NOT_CONTAINS:
			case NAVIGATION:
			case STARTS_WITH:
			case ENDS_WITH:
			case IS_EMPTY:
			case VARIABLE:
			case PARAMETER:
			case TYPENAME:
			case VALUE:
			case RESULT_DEF:
			case LIKE:
			case SUBSTRING:
			case INDEXOF:
			case LENGTH:
			case ABS:
			case SQRT:
			case NOT_IN:
			case DOT:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			{
				e = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					opCode = RetrieveDesc.OP_POSITION_START;
					// Java indexOf method use indexes starting with 0, 
					// where SQL starts with 1, so we need to add 1
					if (e.getType() == VALUE)
					{
					// Optimization: calulate index at compile time, 
					// if start is a constant value.
					// Note, Semantic ensures begin and end are int or Integer values.
					int value = (e.getValue() != null) ? 
					((Integer)e.getValue()).intValue() : 0;
					e.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_VALUE, 
					new Integer(value + 1));
					}
					else
					{
					e.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_VALUE, 
					new Integer(1));
					expression(e);
					e.getRetrieveDesc().addConstraint(null, RetrieveDesc.OP_ADD, null);
					}
					
				}
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
		return opCode;
	}
	
	public final void primitiveType(AST _t) throws RecognitionException {
		
		JQLAST primitiveType_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case BOOLEAN:
			{
				JQLAST tmp53_AST_in = (JQLAST)_t;
				match(_t,BOOLEAN);
				_t = _t.getNextSibling();
				break;
			}
			case BYTE:
			{
				JQLAST tmp54_AST_in = (JQLAST)_t;
				match(_t,BYTE);
				_t = _t.getNextSibling();
				break;
			}
			case CHAR:
			{
				JQLAST tmp55_AST_in = (JQLAST)_t;
				match(_t,CHAR);
				_t = _t.getNextSibling();
				break;
			}
			case SHORT:
			{
				JQLAST tmp56_AST_in = (JQLAST)_t;
				match(_t,SHORT);
				_t = _t.getNextSibling();
				break;
			}
			case INT:
			{
				JQLAST tmp57_AST_in = (JQLAST)_t;
				match(_t,INT);
				_t = _t.getNextSibling();
				break;
			}
			case FLOAT:
			{
				JQLAST tmp58_AST_in = (JQLAST)_t;
				match(_t,FLOAT);
				_t = _t.getNextSibling();
				break;
			}
			case LONG:
			{
				JQLAST tmp59_AST_in = (JQLAST)_t;
				match(_t,LONG);
				_t = _t.getNextSibling();
				break;
			}
			case DOUBLE:
			{
				JQLAST tmp60_AST_in = (JQLAST)_t;
				match(_t,DOUBLE);
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void prepareRetrieveDescs(AST _t) throws RecognitionException {
		
		JQLAST prepareRetrieveDescs_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST q = null;
		JQLAST ordering = null;
		JQLAST result = null;
		JQLAST filter = null;
		
		Map usedRD = new HashMap();
		
		
		try {      // for error handling
			AST __t159 = _t;
			q = _t==ASTNULL ? null :(JQLAST)_t;
			match(_t,QUERY);
			_t = _t.getFirstChild();
			checkRetrieveDesc(_t,usedRD);
			_t = _retTree;
			{
			_loop162:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==PARAMETER_DEF)) {
					AST __t161 = _t;
					JQLAST tmp61_AST_in = (JQLAST)_t;
					match(_t,PARAMETER_DEF);
					_t = _t.getFirstChild();
					JQLAST tmp62_AST_in = (JQLAST)_t;
					if ( _t==null ) throw new MismatchedTokenException();
					_t = _t.getNextSibling();
					JQLAST tmp63_AST_in = (JQLAST)_t;
					if ( _t==null ) throw new MismatchedTokenException();
					_t = _t.getNextSibling();
					_t = __t161;
					_t = _t.getNextSibling();
				}
				else {
					break _loop162;
				}
				
			} while (true);
			}
			{
			_loop165:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==VARIABLE_DEF)) {
					AST __t164 = _t;
					JQLAST tmp64_AST_in = (JQLAST)_t;
					match(_t,VARIABLE_DEF);
					_t = _t.getFirstChild();
					JQLAST tmp65_AST_in = (JQLAST)_t;
					if ( _t==null ) throw new MismatchedTokenException();
					_t = _t.getNextSibling();
					JQLAST tmp66_AST_in = (JQLAST)_t;
					if ( _t==null ) throw new MismatchedTokenException();
					_t = _t.getNextSibling();
					_t = __t164;
					_t = _t.getNextSibling();
				}
				else {
					break _loop165;
				}
				
			} while (true);
			}
			{
			_loop169:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==ORDERING_DEF)) {
					AST __t167 = _t;
					JQLAST tmp67_AST_in = (JQLAST)_t;
					match(_t,ORDERING_DEF);
					_t = _t.getFirstChild();
					{
					if (_t==null) _t=ASTNULL;
					switch ( _t.getType()) {
					case ASCENDING:
					{
						JQLAST tmp68_AST_in = (JQLAST)_t;
						match(_t,ASCENDING);
						_t = _t.getNextSibling();
						break;
					}
					case DESCENDING:
					{
						JQLAST tmp69_AST_in = (JQLAST)_t;
						match(_t,DESCENDING);
						_t = _t.getNextSibling();
						break;
					}
					default:
					{
						throw new NoViableAltException(_t);
					}
					}
					}
					ordering = _t==ASTNULL ? null : (JQLAST)_t;
					checkRetrieveDesc(_t,usedRD);
					_t = _retTree;
					if ( inputState.guessing==0 ) {
						propagateRetrieveDesc(ordering, candidateRD);
					}
					_t = __t167;
					_t = _t.getNextSibling();
				}
				else {
					break _loop169;
				}
				
			} while (true);
			}
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case RESULT_DEF:
			{
				AST __t171 = _t;
				JQLAST tmp70_AST_in = (JQLAST)_t;
				match(_t,RESULT_DEF);
				_t = _t.getFirstChild();
				result = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				if ( inputState.guessing==0 ) {
					propagateRetrieveDesc(result, candidateRD);
				}
				_t = __t171;
				_t = _t.getNextSibling();
				break;
			}
			case FILTER_DEF:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			AST __t172 = _t;
			JQLAST tmp71_AST_in = (JQLAST)_t;
			match(_t,FILTER_DEF);
			_t = _t.getFirstChild();
			filter = _t==ASTNULL ? null : (JQLAST)_t;
			checkRetrieveDesc(_t,usedRD);
			_t = _retTree;
			if ( inputState.guessing==0 ) {
				propagateRetrieveDesc(filter, candidateRD);
			}
			_t = __t172;
			_t = _t.getNextSibling();
			_t = __t159;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	public final void checkRetrieveDesc(AST _t,
		Map usedRD
	) throws RecognitionException {
		
		JQLAST checkRetrieveDesc_AST_in = (_t == ASTNULL) ? null : (JQLAST)_t;
		JQLAST c = null;
		JQLAST cast = null;
		JQLAST expr1 = null;
		JQLAST t = null;
		JQLAST var = null;
		JQLAST notIn = null;
		JQLAST notInArg = null;
		JQLAST fa = null;
		JQLAST expr4 = null;
		JQLAST i = null;
		JQLAST n = null;
		JQLAST sw = null;
		JQLAST expr7 = null;
		JQLAST ew = null;
		JQLAST expr8 = null;
		JQLAST ie = null;
		JQLAST expr9 = null;
		JQLAST like = null;
		JQLAST string10 = null;
		JQLAST pattern10 = null;
		JQLAST escape10 = null;
		JQLAST substr = null;
		JQLAST string11 = null;
		JQLAST lower11 = null;
		JQLAST upper11 = null;
		JQLAST indexOf = null;
		JQLAST string12 = null;
		JQLAST pattern12 = null;
		JQLAST start12 = null;
		JQLAST len = null;
		JQLAST expr13 = null;
		JQLAST abs = null;
		JQLAST expr14 = null;
		JQLAST sqrt = null;
		JQLAST expr15 = null;
		JQLAST op1 = null;
		JQLAST left1 = null;
		JQLAST right1 = null;
		JQLAST op2 = null;
		JQLAST left2 = null;
		JQLAST right2 = null;
		JQLAST op3 = null;
		JQLAST left3 = null;
		JQLAST right3 = null;
		JQLAST op4 = null;
		JQLAST left4 = null;
		JQLAST right4 = null;
		JQLAST op5 = null;
		JQLAST left5 = null;
		JQLAST right5 = null;
		JQLAST op6 = null;
		JQLAST left6 = null;
		JQLAST right6 = null;
		JQLAST op7 = null;
		JQLAST left7 = null;
		JQLAST right7 = null;
		JQLAST op8 = null;
		JQLAST left8 = null;
		JQLAST right8 = null;
		JQLAST op9 = null;
		JQLAST left9 = null;
		JQLAST right9 = null;
		JQLAST op10 = null;
		JQLAST left10 = null;
		JQLAST right10 = null;
		JQLAST op11 = null;
		JQLAST left11 = null;
		JQLAST right11 = null;
		JQLAST op12 = null;
		JQLAST left12 = null;
		JQLAST right12 = null;
		JQLAST op13 = null;
		JQLAST left13 = null;
		JQLAST right13 = null;
		JQLAST op14 = null;
		JQLAST left14 = null;
		JQLAST right14 = null;
		JQLAST op15 = null;
		JQLAST left15 = null;
		JQLAST right15 = null;
		JQLAST op16 = null;
		JQLAST left16 = null;
		JQLAST right16 = null;
		JQLAST op17 = null;
		JQLAST left17 = null;
		JQLAST right17 = null;
		JQLAST op18 = null;
		JQLAST left18 = null;
		JQLAST right18 = null;
		JQLAST op19 = null;
		JQLAST left19 = null;
		JQLAST right19 = null;
		JQLAST op20 = null;
		JQLAST left20 = null;
		JQLAST right20 = null;
		JQLAST op21 = null;
		JQLAST left21 = null;
		JQLAST right21 = null;
		JQLAST uop1 = null;
		JQLAST arg1 = null;
		JQLAST uop2 = null;
		JQLAST arg2 = null;
		JQLAST uop3 = null;
		JQLAST arg3 = null;
		JQLAST uop4 = null;
		JQLAST arg4 = null;
		JQLAST d = null;
		JQLAST arg5 = null;
		JQLAST avg = null;
		JQLAST arg6 = null;
		JQLAST max = null;
		JQLAST arg7 = null;
		JQLAST min = null;
		JQLAST arg8 = null;
		JQLAST sum = null;
		JQLAST arg9 = null;
		JQLAST count = null;
		JQLAST arg10 = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			if ((_t.getType()==CLASS_DEF)) {
				c = (JQLAST)_t;
				match(_t,CLASS_DEF);
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					// check persistence capable
					ClassType candidateClass = (ClassType)c.getJQLType();
					candidateRD = createRetrieveDesc("this", candidateClass); //NOI18N
					candidateRD.setPrefetchEnabled(prefetchEnabled);
					
				}
			}
			else if ((_t.getType()==TYPECAST)) {
				AST __t174 = _t;
				cast = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,TYPECAST);
				_t = _t.getFirstChild();
				type(_t);
				_t = _retTree;
				expr1 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t174;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					cast.setRetrieveDesc(expr1.getRetrieveDesc());
					
				}
			}
			else if ((_t.getType()==THIS)) {
				t = (JQLAST)_t;
				match(_t,THIS);
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					t.setRetrieveDesc(candidateRD); 
					
				}
			}
			else if ((_t.getType()==VARIABLE)) {
				AST __t175 = _t;
				var = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,VARIABLE);
				_t = _t.getFirstChild();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case IMPORT:
				case THIS:
				case ASCENDING:
				case DESCENDING:
				case DISTINCT:
				case BOOLEAN:
				case BYTE:
				case CHAR:
				case SHORT:
				case INT:
				case FLOAT:
				case LONG:
				case DOUBLE:
				case NULL:
				case TRUE:
				case FALSE:
				case AVG:
				case MAX:
				case MIN:
				case SUM:
				case COUNT:
				case LPAREN:
				case RPAREN:
				case COMMA:
				case EQUAL:
				case LNOT:
				case BNOT:
				case NOT_EQUAL:
				case DIV:
				case PLUS:
				case MINUS:
				case STAR:
				case MOD:
				case GE:
				case GT:
				case LE:
				case LT:
				case BXOR:
				case BOR:
				case OR:
				case BAND:
				case AND:
				case SEMI:
				case WS:
				case NEWLINE:
				case CHAR_LITERAL:
				case STRING_LITERAL:
				case ESC:
				case HEX_DIGIT:
				case INT_LITERAL:
				case EXPONENT:
				case FLOATINGPOINT_SUFFIX:
				case IDENT:
				case UNICODE_ESCAPE:
				case QUERY:
				case CLASS_DEF:
				case IMPORT_DEF:
				case PARAMETER_DEF:
				case VARIABLE_DEF:
				case ORDERING_DEF:
				case FILTER_DEF:
				case ARG_LIST:
				case UNARY_MINUS:
				case UNARY_PLUS:
				case TYPECAST:
				case OBJECT_EQUAL:
				case OBJECT_NOT_EQUAL:
				case COLLECTION_EQUAL:
				case COLLECTION_NOT_EQUAL:
				case CONCAT:
				case FIELD_ACCESS:
				case STATIC_FIELD_ACCESS:
				case CONTAINS:
				case NOT_CONTAINS:
				case NAVIGATION:
				case STARTS_WITH:
				case ENDS_WITH:
				case IS_EMPTY:
				case VARIABLE:
				case PARAMETER:
				case TYPENAME:
				case VALUE:
				case RESULT_DEF:
				case LIKE:
				case SUBSTRING:
				case INDEXOF:
				case LENGTH:
				case ABS:
				case SQRT:
				case NOT_IN:
				case DOT:
				case LONG_LITERAL:
				case FLOAT_LITERAL:
				case DOUBLE_LITERAL:
				{
					checkRetrieveDesc(_t,usedRD);
					_t = _retTree;
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				_t = __t175;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					RetrieveDesc to = (RetrieveDesc)usedRD.get(var.getText());
					if (to == null)
					{
					to = createRetrieveDesc(var.getText(), (ClassType)var.getJQLType());
					usedRD.put(var.getText(), to);
					}
					var.setRetrieveDesc(to);
					
				}
			}
			else if ((_t.getType()==NOT_IN)) {
				AST __t177 = _t;
				notIn = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,NOT_IN);
				_t = _t.getFirstChild();
				notInArg = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t177;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					notIn.setRetrieveDesc(notInArg.getRetrieveDesc());
					
				}
			}
			else if ((_t.getType()==FIELD_ACCESS)) {
				AST __t178 = _t;
				fa = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,FIELD_ACCESS);
				_t = _t.getFirstChild();
				expr4 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				i = (JQLAST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				_t = __t178;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					fa.setRetrieveDesc(expr4.getRetrieveDesc());
					i.setRetrieveDesc(expr4.getRetrieveDesc());
					
				}
			}
			else if ((_t.getType()==NAVIGATION)) {
				AST __t179 = _t;
				n = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,NAVIGATION);
				_t = _t.getFirstChild();
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				JQLAST tmp72_AST_in = (JQLAST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				_t = __t179;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					RetrieveDesc to = (RetrieveDesc)usedRD.get(n.getText());
					if (to == null)
					{
					to = createRetrieveDesc(n.getText(), (ClassType)n.getJQLType());
					usedRD.put(n.getText(), to);
					}
					n.setRetrieveDesc(to);
					
				}
			}
			else if ((_t.getType()==CONTAINS)) {
				AST __t180 = _t;
				JQLAST tmp73_AST_in = (JQLAST)_t;
				match(_t,CONTAINS);
				_t = _t.getFirstChild();
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t180;
				_t = _t.getNextSibling();
			}
			else if ((_t.getType()==NOT_CONTAINS)) {
				AST __t181 = _t;
				JQLAST tmp74_AST_in = (JQLAST)_t;
				match(_t,NOT_CONTAINS);
				_t = _t.getFirstChild();
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t181;
				_t = _t.getNextSibling();
			}
			else if ((_t.getType()==STARTS_WITH)) {
				AST __t182 = _t;
				sw = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,STARTS_WITH);
				_t = _t.getFirstChild();
				expr7 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t182;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					sw.setRetrieveDesc(expr7.getRetrieveDesc());
					
				}
			}
			else if ((_t.getType()==ENDS_WITH)) {
				AST __t183 = _t;
				ew = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,ENDS_WITH);
				_t = _t.getFirstChild();
				expr8 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t183;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					ew.setRetrieveDesc(expr8.getRetrieveDesc());
					
				}
			}
			else if ((_t.getType()==IS_EMPTY)) {
				AST __t184 = _t;
				ie = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,IS_EMPTY);
				_t = _t.getFirstChild();
				expr9 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t184;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					ie.setRetrieveDesc(expr9.getRetrieveDesc());
					
				}
			}
			else if ((_t.getType()==LIKE)) {
				AST __t185 = _t;
				like = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,LIKE);
				_t = _t.getFirstChild();
				string10 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				pattern10 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case IMPORT:
				case THIS:
				case ASCENDING:
				case DESCENDING:
				case DISTINCT:
				case BOOLEAN:
				case BYTE:
				case CHAR:
				case SHORT:
				case INT:
				case FLOAT:
				case LONG:
				case DOUBLE:
				case NULL:
				case TRUE:
				case FALSE:
				case AVG:
				case MAX:
				case MIN:
				case SUM:
				case COUNT:
				case LPAREN:
				case RPAREN:
				case COMMA:
				case EQUAL:
				case LNOT:
				case BNOT:
				case NOT_EQUAL:
				case DIV:
				case PLUS:
				case MINUS:
				case STAR:
				case MOD:
				case GE:
				case GT:
				case LE:
				case LT:
				case BXOR:
				case BOR:
				case OR:
				case BAND:
				case AND:
				case SEMI:
				case WS:
				case NEWLINE:
				case CHAR_LITERAL:
				case STRING_LITERAL:
				case ESC:
				case HEX_DIGIT:
				case INT_LITERAL:
				case EXPONENT:
				case FLOATINGPOINT_SUFFIX:
				case IDENT:
				case UNICODE_ESCAPE:
				case QUERY:
				case CLASS_DEF:
				case IMPORT_DEF:
				case PARAMETER_DEF:
				case VARIABLE_DEF:
				case ORDERING_DEF:
				case FILTER_DEF:
				case ARG_LIST:
				case UNARY_MINUS:
				case UNARY_PLUS:
				case TYPECAST:
				case OBJECT_EQUAL:
				case OBJECT_NOT_EQUAL:
				case COLLECTION_EQUAL:
				case COLLECTION_NOT_EQUAL:
				case CONCAT:
				case FIELD_ACCESS:
				case STATIC_FIELD_ACCESS:
				case CONTAINS:
				case NOT_CONTAINS:
				case NAVIGATION:
				case STARTS_WITH:
				case ENDS_WITH:
				case IS_EMPTY:
				case VARIABLE:
				case PARAMETER:
				case TYPENAME:
				case VALUE:
				case RESULT_DEF:
				case LIKE:
				case SUBSTRING:
				case INDEXOF:
				case LENGTH:
				case ABS:
				case SQRT:
				case NOT_IN:
				case DOT:
				case LONG_LITERAL:
				case FLOAT_LITERAL:
				case DOUBLE_LITERAL:
				{
					escape10 = _t==ASTNULL ? null : (JQLAST)_t;
					checkRetrieveDesc(_t,usedRD);
					_t = _retTree;
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				_t = __t185;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					like.setRetrieveDesc(getCommonRetrieveDesc(string10, pattern10, escape10));
					
				}
			}
			else if ((_t.getType()==SUBSTRING)) {
				AST __t187 = _t;
				substr = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,SUBSTRING);
				_t = _t.getFirstChild();
				string11 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				lower11 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				upper11 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t187;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					substr.setRetrieveDesc(getCommonRetrieveDesc(string11, lower11, upper11));
					
				}
			}
			else if ((_t.getType()==INDEXOF)) {
				AST __t188 = _t;
				indexOf = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,INDEXOF);
				_t = _t.getFirstChild();
				string12 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				pattern12 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case IMPORT:
				case THIS:
				case ASCENDING:
				case DESCENDING:
				case DISTINCT:
				case BOOLEAN:
				case BYTE:
				case CHAR:
				case SHORT:
				case INT:
				case FLOAT:
				case LONG:
				case DOUBLE:
				case NULL:
				case TRUE:
				case FALSE:
				case AVG:
				case MAX:
				case MIN:
				case SUM:
				case COUNT:
				case LPAREN:
				case RPAREN:
				case COMMA:
				case EQUAL:
				case LNOT:
				case BNOT:
				case NOT_EQUAL:
				case DIV:
				case PLUS:
				case MINUS:
				case STAR:
				case MOD:
				case GE:
				case GT:
				case LE:
				case LT:
				case BXOR:
				case BOR:
				case OR:
				case BAND:
				case AND:
				case SEMI:
				case WS:
				case NEWLINE:
				case CHAR_LITERAL:
				case STRING_LITERAL:
				case ESC:
				case HEX_DIGIT:
				case INT_LITERAL:
				case EXPONENT:
				case FLOATINGPOINT_SUFFIX:
				case IDENT:
				case UNICODE_ESCAPE:
				case QUERY:
				case CLASS_DEF:
				case IMPORT_DEF:
				case PARAMETER_DEF:
				case VARIABLE_DEF:
				case ORDERING_DEF:
				case FILTER_DEF:
				case ARG_LIST:
				case UNARY_MINUS:
				case UNARY_PLUS:
				case TYPECAST:
				case OBJECT_EQUAL:
				case OBJECT_NOT_EQUAL:
				case COLLECTION_EQUAL:
				case COLLECTION_NOT_EQUAL:
				case CONCAT:
				case FIELD_ACCESS:
				case STATIC_FIELD_ACCESS:
				case CONTAINS:
				case NOT_CONTAINS:
				case NAVIGATION:
				case STARTS_WITH:
				case ENDS_WITH:
				case IS_EMPTY:
				case VARIABLE:
				case PARAMETER:
				case TYPENAME:
				case VALUE:
				case RESULT_DEF:
				case LIKE:
				case SUBSTRING:
				case INDEXOF:
				case LENGTH:
				case ABS:
				case SQRT:
				case NOT_IN:
				case DOT:
				case LONG_LITERAL:
				case FLOAT_LITERAL:
				case DOUBLE_LITERAL:
				{
					start12 = _t==ASTNULL ? null : (JQLAST)_t;
					checkRetrieveDesc(_t,usedRD);
					_t = _retTree;
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				_t = __t188;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					indexOf.setRetrieveDesc(getCommonRetrieveDesc(string12, pattern12, start12));
					
				}
			}
			else if ((_t.getType()==LENGTH)) {
				AST __t190 = _t;
				len = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,LENGTH);
				_t = _t.getFirstChild();
				expr13 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t190;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					len.setRetrieveDesc(expr13.getRetrieveDesc());
					
				}
			}
			else if ((_t.getType()==ABS)) {
				AST __t191 = _t;
				abs = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,ABS);
				_t = _t.getFirstChild();
				expr14 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t191;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					abs.setRetrieveDesc(expr14.getRetrieveDesc());
					
				}
			}
			else if ((_t.getType()==SQRT)) {
				AST __t192 = _t;
				sqrt = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,SQRT);
				_t = _t.getFirstChild();
				expr15 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t192;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					
					sqrt.setRetrieveDesc(expr15.getRetrieveDesc());
					
				}
			}
			else if ((_t.getType()==BAND)) {
				AST __t193 = _t;
				op1 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,BAND);
				_t = _t.getFirstChild();
				left1 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				right1 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				_t = __t193;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					checkAndOpRetrieveDesc(op1, left1, right1, usedRD);
				}
			}
			else if ((_t.getType()==BOR)) {
				AST __t194 = _t;
				op2 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,BOR);
				_t = _t.getFirstChild();
				left2 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,new HashMap(usedRD));
				_t = _retTree;
				right2 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,new HashMap(usedRD));
				_t = _retTree;
				_t = __t194;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op2.setRetrieveDesc(getCommonRetrieveDesc(left2, right2));
				}
			}
			else if ((_t.getType()==BXOR)) {
				AST __t195 = _t;
				op3 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,BXOR);
				_t = _t.getFirstChild();
				left3 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,new HashMap());
				_t = _retTree;
				right3 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,new HashMap());
				_t = _retTree;
				_t = __t195;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op3.setRetrieveDesc(getCommonRetrieveDesc(left3, right3));
				}
			}
			else if ((_t.getType()==AND)) {
				AST __t196 = _t;
				op4 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,AND);
				_t = _t.getFirstChild();
				left4 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				right4 = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
				_t = __t196;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					checkAndOpRetrieveDesc(op4, left4, right4, usedRD);
				}
			}
			else if ((_t.getType()==OR)) {
				AST __t197 = _t;
				op5 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,OR);
				_t = _t.getFirstChild();
				left5 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,new HashMap(usedRD));
				_t = _retTree;
				right5 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,new HashMap(usedRD));
				_t = _retTree;
				_t = __t197;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op5.setRetrieveDesc(getCommonRetrieveDesc(left5, right5));
				}
			}
			else if ((_t.getType()==EQUAL)) {
				AST __t198 = _t;
				op6 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,EQUAL);
				_t = _t.getFirstChild();
				left6 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right6 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t198;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op6.setRetrieveDesc(getCommonRetrieveDesc(left6, right6));
				}
			}
			else if ((_t.getType()==NOT_EQUAL)) {
				AST __t199 = _t;
				op7 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,NOT_EQUAL);
				_t = _t.getFirstChild();
				left7 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right7 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t199;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op7.setRetrieveDesc(getCommonRetrieveDesc(left7, right7));
				}
			}
			else if ((_t.getType()==LT)) {
				AST __t200 = _t;
				op8 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,LT);
				_t = _t.getFirstChild();
				left8 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right8 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t200;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op8.setRetrieveDesc(getCommonRetrieveDesc(left8, right8));
				}
			}
			else if ((_t.getType()==GT)) {
				AST __t201 = _t;
				op9 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,GT);
				_t = _t.getFirstChild();
				left9 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right9 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t201;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op9.setRetrieveDesc(getCommonRetrieveDesc(left9, right9));
				}
			}
			else if ((_t.getType()==LE)) {
				AST __t202 = _t;
				op10 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,LE);
				_t = _t.getFirstChild();
				left10 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right10 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t202;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op10.setRetrieveDesc(getCommonRetrieveDesc(left10, right10));
				}
			}
			else if ((_t.getType()==GE)) {
				AST __t203 = _t;
				op11 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,GE);
				_t = _t.getFirstChild();
				left11 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right11 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t203;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op11.setRetrieveDesc(getCommonRetrieveDesc(left11, right11));
				}
			}
			else if ((_t.getType()==OBJECT_EQUAL)) {
				AST __t204 = _t;
				op12 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,OBJECT_EQUAL);
				_t = _t.getFirstChild();
				left12 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right12 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t204;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op12.setRetrieveDesc(getObjectComparisonRetrieveDesc(left12, right12));
				}
			}
			else if ((_t.getType()==OBJECT_NOT_EQUAL)) {
				AST __t205 = _t;
				op13 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,OBJECT_NOT_EQUAL);
				_t = _t.getFirstChild();
				left13 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right13 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t205;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op13.setRetrieveDesc(getObjectComparisonRetrieveDesc(left13, right13));
				}
			}
			else if ((_t.getType()==COLLECTION_EQUAL)) {
				AST __t206 = _t;
				op14 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,COLLECTION_EQUAL);
				_t = _t.getFirstChild();
				left14 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right14 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t206;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op14.setRetrieveDesc(getCommonRetrieveDesc(left14, right14));
				}
			}
			else if ((_t.getType()==COLLECTION_NOT_EQUAL)) {
				AST __t207 = _t;
				op15 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,COLLECTION_NOT_EQUAL);
				_t = _t.getFirstChild();
				left15 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right15 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t207;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op15.setRetrieveDesc(getCommonRetrieveDesc(left15, right15));
				}
			}
			else if ((_t.getType()==PLUS)) {
				AST __t208 = _t;
				op16 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,PLUS);
				_t = _t.getFirstChild();
				left16 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right16 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t208;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op16.setRetrieveDesc(getCommonRetrieveDesc(left16, right16));
				}
			}
			else if ((_t.getType()==CONCAT)) {
				AST __t209 = _t;
				op17 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,CONCAT);
				_t = _t.getFirstChild();
				left17 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right17 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t209;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op17.setRetrieveDesc(getCommonRetrieveDesc(left17, right17));
				}
			}
			else if ((_t.getType()==MINUS)) {
				AST __t210 = _t;
				op18 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,MINUS);
				_t = _t.getFirstChild();
				left18 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right18 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t210;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op18.setRetrieveDesc(getCommonRetrieveDesc(left18, right18));
				}
			}
			else if ((_t.getType()==STAR)) {
				AST __t211 = _t;
				op19 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,STAR);
				_t = _t.getFirstChild();
				left19 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right19 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t211;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op19.setRetrieveDesc(getCommonRetrieveDesc(left19, right19));
				}
			}
			else if ((_t.getType()==DIV)) {
				AST __t212 = _t;
				op20 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,DIV);
				_t = _t.getFirstChild();
				left20 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right20 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t212;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op20.setRetrieveDesc(getCommonRetrieveDesc(left20, right20));
				}
			}
			else if ((_t.getType()==MOD)) {
				AST __t213 = _t;
				op21 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,MOD);
				_t = _t.getFirstChild();
				left21 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				right21 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t213;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					op21.setRetrieveDesc(getCommonRetrieveDesc(left21, right21));
				}
			}
			else if ((_t.getType()==UNARY_PLUS)) {
				AST __t214 = _t;
				uop1 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,UNARY_PLUS);
				_t = _t.getFirstChild();
				arg1 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t214;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					uop1.setRetrieveDesc(arg1.getRetrieveDesc());
				}
			}
			else if ((_t.getType()==UNARY_MINUS)) {
				AST __t215 = _t;
				uop2 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,UNARY_MINUS);
				_t = _t.getFirstChild();
				arg2 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t215;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					uop2.setRetrieveDesc(arg2.getRetrieveDesc());
				}
			}
			else if ((_t.getType()==BNOT)) {
				AST __t216 = _t;
				uop3 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,BNOT);
				_t = _t.getFirstChild();
				arg3 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t216;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					uop3.setRetrieveDesc(arg3.getRetrieveDesc());
				}
			}
			else if ((_t.getType()==LNOT)) {
				AST __t217 = _t;
				uop4 = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,LNOT);
				_t = _t.getFirstChild();
				arg4 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t217;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					uop4.setRetrieveDesc(arg4.getRetrieveDesc());
				}
			}
			else if ((_t.getType()==DISTINCT)) {
				AST __t218 = _t;
				d = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,DISTINCT);
				_t = _t.getFirstChild();
				arg5 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t218;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					d.setRetrieveDesc(arg5.getRetrieveDesc());
				}
			}
			else if ((_t.getType()==AVG)) {
				AST __t219 = _t;
				avg = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,AVG);
				_t = _t.getFirstChild();
				arg6 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t219;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					avg.setRetrieveDesc(arg6.getRetrieveDesc());
				}
			}
			else if ((_t.getType()==MAX)) {
				AST __t220 = _t;
				max = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,MAX);
				_t = _t.getFirstChild();
				arg7 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t220;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					max.setRetrieveDesc(arg7.getRetrieveDesc());
				}
			}
			else if ((_t.getType()==MIN)) {
				AST __t221 = _t;
				min = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,MIN);
				_t = _t.getFirstChild();
				arg8 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t221;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					min.setRetrieveDesc(arg8.getRetrieveDesc());
				}
			}
			else if ((_t.getType()==SUM)) {
				AST __t222 = _t;
				sum = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,SUM);
				_t = _t.getFirstChild();
				arg9 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t222;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					sum.setRetrieveDesc(arg9.getRetrieveDesc());
				}
			}
			else if ((_t.getType()==COUNT)) {
				AST __t223 = _t;
				count = _t==ASTNULL ? null :(JQLAST)_t;
				match(_t,COUNT);
				_t = _t.getFirstChild();
				arg10 = _t==ASTNULL ? null : (JQLAST)_t;
				checkRetrieveDesc(_t,usedRD);
				_t = _retTree;
				_t = __t223;
				_t = _t.getNextSibling();
				if ( inputState.guessing==0 ) {
					count.setRetrieveDesc(arg10.getRetrieveDesc());
				}
			}
			else if (((_t.getType() >= IMPORT && _t.getType() <= DOUBLE_LITERAL))) {
				JQLAST tmp75_AST_in = (JQLAST)_t;
				if ( _t==null ) throw new MismatchedTokenException();
				_t = _t.getNextSibling();
			}
			else {
				throw new NoViableAltException(_t);
			}
			
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				if (_t!=null) {_t = _t.getNextSibling();}
			} else {
			  throw ex;
			}
		}
		_retTree = _t;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"\"import\"",
		"\"this\"",
		"\"ascending\"",
		"\"descending\"",
		"\"distinct\"",
		"\"boolean\"",
		"\"byte\"",
		"\"char\"",
		"\"short\"",
		"\"int\"",
		"\"float\"",
		"\"long\"",
		"\"double\"",
		"\"null\"",
		"\"true\"",
		"\"false\"",
		"\"avg\"",
		"\"max\"",
		"\"min\"",
		"\"sum\"",
		"\"count\"",
		"LPAREN",
		"RPAREN",
		"COMMA",
		"EQUAL",
		"LNOT",
		"BNOT",
		"NOT_EQUAL",
		"DIV",
		"PLUS",
		"MINUS",
		"STAR",
		"MOD",
		"GE",
		"GT",
		"LE",
		"LT",
		"BXOR",
		"BOR",
		"OR",
		"BAND",
		"AND",
		"SEMI",
		"WS",
		"NEWLINE",
		"CHAR_LITERAL",
		"STRING_LITERAL",
		"ESC",
		"HEX_DIGIT",
		"INT_LITERAL",
		"EXPONENT",
		"FLOATINGPOINT_SUFFIX",
		"an identifier",
		"UNICODE_ESCAPE",
		"QUERY",
		"CLASS_DEF",
		"IMPORT_DEF",
		"PARAMETER_DEF",
		"VARIABLE_DEF",
		"ORDERING_DEF",
		"FILTER_DEF",
		"ARG_LIST",
		"UNARY_MINUS",
		"UNARY_PLUS",
		"TYPECAST",
		"OBJECT_EQUAL",
		"OBJECT_NOT_EQUAL",
		"COLLECTION_EQUAL",
		"COLLECTION_NOT_EQUAL",
		"CONCAT",
		"FIELD_ACCESS",
		"STATIC_FIELD_ACCESS",
		"CONTAINS",
		"NOT_CONTAINS",
		"NAVIGATION",
		"STARTS_WITH",
		"ENDS_WITH",
		"IS_EMPTY",
		"VARIABLE",
		"PARAMETER",
		"TYPENAME",
		"VALUE",
		"RESULT_DEF",
		"LIKE",
		"SUBSTRING",
		"INDEXOF",
		"LENGTH",
		"ABS",
		"SQRT",
		"NOT_IN",
		"DOT",
		"LONG_LITERAL",
		"FLOAT_LITERAL",
		"DOUBLE_LITERAL"
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 2064000221184L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 2415919104L, 96L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = { 70368475742240L, 531625980L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	}
	
