/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins;

import fish.payara.maven.plugins.InvokerLoggerImpl;
import fish.payara.maven.plugins.Source;
import fish.payara.maven.plugins.StartTask;
import fish.payara.maven.plugins.WebDriverFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenInvocationException;

public abstract class AutoDeployHandler
implements Runnable {
    private final StartTask start;
    protected final MavenProject project;
    private final File webappDirectory;
    protected final Log log;
    private final ExecutorService executorService;
    private WatchService watchService;
    private Future<?> buildReloadTask;
    private long buildReloadTaskStartTime;
    private final AtomicBoolean cleanPending = new AtomicBoolean(false);
    protected final ConcurrentSkipListSet<Source> sourceUpdatedPending = new ConcurrentSkipListSet();
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private final Path buildPath;
    private final Path ideaPath;
    private final Path eclipsePath;
    private final Path eclipseClasspathPath;
    private final Path eclipseProjectPath;
    private final Path vscodePath;
    private final Path nbPath;
    protected static final String RELOADING = "Reloading";

    public AutoDeployHandler(StartTask start, File webappDirectory) {
        this.start = start;
        this.project = start.getProject();
        this.webappDirectory = webappDirectory;
        this.log = start.getLog();
        this.executorService = Executors.newSingleThreadExecutor();
        this.buildPath = this.project.getBasedir().toPath().resolve("target");
        this.ideaPath = this.project.getBasedir().toPath().resolve(".idea");
        this.eclipsePath = this.project.getBasedir().toPath().resolve(".settings");
        this.vscodePath = this.project.getBasedir().toPath().resolve(".vscode");
        this.eclipseClasspathPath = this.project.getBasedir().toPath().resolve(".classpath");
        this.eclipseProjectPath = this.project.getBasedir().toPath().resolve(".project");
        this.nbPath = this.project.getBasedir().toPath().resolve("nb-configuration.xml");
    }

    public void stop() {
        this.stopRequested.set(true);
    }

    public boolean isAlive() {
        return !this.stopRequested.get();
    }

    @Override
    public void run() {
        block17: {
            try {
                Path rootPath = this.project.getBasedir().toPath();
                this.watchService = FileSystems.getDefault().newWatchService();
                rootPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                this.registerAllDirectories(rootPath);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        if (this.buildReloadTask != null && !this.buildReloadTask.isDone()) {
                            this.buildReloadTask.cancel(true);
                        }
                        this.executorService.shutdown();
                    }
                    catch (Exception ex) {
                        this.log.error((Throwable)ex);
                    }
                }));
                Set<Path> ignoredDirectories = Set.of(this.buildPath, this.ideaPath, this.eclipsePath, this.vscodePath);
                Set<Path> ignoredFiles = Set.of(this.eclipseClasspathPath, this.eclipseProjectPath, this.nbPath);
                while (this.isAlive()) {
                    WatchKey key = this.watchService.poll(60L, TimeUnit.SECONDS);
                    if (key == null) continue;
                    ArrayList filteredEvents = new ArrayList();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path changed = (Path)event.context();
                        Path fullPath = ((Path)key.watchable()).resolve(changed);
                        boolean isInIgnoredDirectory = ignoredDirectories.stream().anyMatch(fullPath::startsWith);
                        boolean isIgnoredFile = ignoredFiles.contains(fullPath);
                        boolean isTemporaryFile = fullPath.toString().endsWith("~");
                        boolean bl = Files.isDirectory(fullPath, new LinkOption[0]);
                        if (isInIgnoredDirectory || isIgnoredFile || isTemporaryFile || bl) continue;
                        filteredEvents.add(event);
                    }
                    if (!filteredEvents.isEmpty()) {
                        boolean skip = false;
                        if (this.buildReloadTask != null && !this.buildReloadTask.isDone()) {
                            long duration = System.currentTimeMillis() - this.buildReloadTaskStartTime;
                            if (duration < 1000L && this.sourceUpdatedPending.size() == filteredEvents.size()) {
                                skip = true;
                            }
                            this.log.debug((CharSequence)("Duration : " + duration + ", skip : " + skip));
                            if (!skip) {
                                this.buildReloadTask.cancel(true);
                            }
                        }
                        if (!skip) {
                            boolean resourceModified = false;
                            boolean testClassesModified = false;
                            boolean testResourcesModified = false;
                            boolean classesModified = false;
                            boolean rebootRequired = false;
                            for (WatchEvent watchEvent : filteredEvents) {
                                WatchEvent.Kind kind = watchEvent.kind();
                                Path changed = (Path)watchEvent.context();
                                Path fullPath = ((Path)key.watchable()).resolve(changed);
                                this.log.debug((CharSequence)("Source modified: " + changed + " - " + kind));
                                Path projectRoot = Paths.get(this.project.getBasedir().toURI());
                                Path sourceRoot = projectRoot.resolve("src");
                                Path mainDirectory = sourceRoot.resolve("main");
                                Path javaDirectory = mainDirectory.resolve("java");
                                Path resourcesDirectory = mainDirectory.resolve("resources");
                                Path testDirectory = sourceRoot.resolve("test");
                                Path javaTestDirectory = testDirectory.resolve("java");
                                Path resourcesTestDirectory = testDirectory.resolve("resources");
                                this.sourceUpdatedPending.add(new Source(fullPath, kind, fullPath.startsWith(javaDirectory)));
                                if (fullPath.startsWith(resourcesDirectory)) {
                                    resourceModified = true;
                                }
                                if (fullPath.startsWith(resourcesTestDirectory)) {
                                    testResourcesModified = true;
                                }
                                if (fullPath.startsWith(javaTestDirectory)) {
                                    testClassesModified = true;
                                }
                                if (fullPath.startsWith(javaDirectory)) {
                                    classesModified = true;
                                }
                                if (kind == StandardWatchEventKinds.ENTRY_CREATE && Files.isDirectory(fullPath, LinkOption.NOFOLLOW_LINKS)) {
                                    this.register(fullPath);
                                }
                                if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                                    this.cleanPending.set(true);
                                }
                                if (!this.start.getRebootOnChange().contains(changed.toString())) continue;
                                rebootRequired = true;
                                this.cleanPending.set(true);
                                break;
                            }
                            this.log.debug((CharSequence)("sourceUpdatedPending: " + this.sourceUpdatedPending));
                            if (!this.sourceUpdatedPending.isEmpty()) {
                                WebDriverFactory.updateTitle("Building", this.project, this.start.getDriver(), this.log);
                                List<String> goalsList = this.updateGoalsList(classesModified, resourceModified, testClassesModified, testResourcesModified);
                                this.executeBuildReloadTask(goalsList, rebootRequired);
                            }
                        }
                    }
                    key.reset();
                }
            }
            catch (Exception ex) {
                this.log.error((Throwable)ex);
                if (!this.hasInotifyLimitReachedException(ex)) break block17;
                this.log.error((CharSequence)"Error starting WatchService. User limit of inotify instances reached or too many open files. Please increase the max_user_watches configuration.");
            }
        }
    }

    private boolean hasInotifyLimitReachedException(Throwable ex) {
        while (ex != null) {
            if (ex instanceof IOException && ex.getMessage().contains("User limit of inotify instances reached")) {
                return true;
            }
            ex = ex.getCause();
        }
        return false;
    }

    private void registerAllDirectories(Path path) throws IOException {
        Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(this::register);
    }

    private void register(Path path) {
        boolean isChild = path.startsWith(this.buildPath) && (path.equals(this.buildPath) || !this.buildPath.relativize(path).equals(path));
        try {
            if (!isChild) {
                this.log.debug((CharSequence)("register watch service for " + path));
                path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
        }
        catch (IOException ex) {
            this.log.error((CharSequence)"Error registering directories", (Throwable)ex);
        }
    }

    private List<String> updateGoalsList(boolean classesModified, boolean resourceModified, boolean testClassesModified, boolean testResourcesModified) {
        boolean onlyJavaFilesUpdated = this.sourceUpdatedPending.stream().allMatch(k -> k.getPath().toString().endsWith(".java") && k.getKind() == StandardWatchEventKinds.ENTRY_MODIFY && k.isJavaClass());
        ArrayList<String> goalsList = new ArrayList<String>();
        boolean clean = this.cleanPending.get();
        if (clean) {
            goalsList.add(0, "clean");
        }
        if (clean || resourceModified) {
            goalsList.add("process-resources");
        }
        if (clean || classesModified) {
            goalsList.add("org.apache.maven.plugins:maven-compiler-plugin:3.12.1:compile");
            if (onlyJavaFilesUpdated) {
                goalsList.add("-Dmaven.compiler.useIncrementalCompilation=false");
            }
        }
        if (!clean && this.start.isLocal() && onlyJavaFilesUpdated) {
            Path outputDirectory = Paths.get(this.webappDirectory.toPath().toString(), "WEB-INF", "classes");
            goalsList.add("-Dmaven.compiler.outputDirectory=\"" + outputDirectory.toString() + "\"");
        } else {
            goalsList.add("war:" + (this.start.isLocal() ? "exploded" : "war"));
        }
        if (!testClassesModified && !testResourcesModified) {
            goalsList.add("-Dmaven.test.skip=true");
        } else {
            goalsList.add("-DskipTests");
        }
        for (Profile profile : this.project.getActiveProfiles()) {
            if (!"pom".equalsIgnoreCase(profile.getSource())) continue;
            goalsList.add("-P" + profile.getId() + " ");
        }
        return goalsList;
    }

    private void executeBuildReloadTask(List<String> goalsList, boolean rebootRequired) {
        this.buildReloadTaskStartTime = System.currentTimeMillis();
        this.buildReloadTask = this.executorService.submit(() -> {
            String message = "Auto-build started for " + this.project.getName() + " with goals: " + goalsList;
            DefaultInvoker invoker = new DefaultInvoker();
            invoker.setLogger((InvokerLogger)new InvokerLoggerImpl(this.log));
            invoker.setInputStream(InputStream.nullInputStream());
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setPomFile(new File(this.project.getBasedir(), "pom.xml"));
            System.setProperty("maven.multiModuleProjectDirectory", this.project.getBasedir().toString());
            if (((String)goalsList.get(0)).equals("clean")) {
                this.deleteBuildDir(this.project.getBuild().getDirectory());
                goalsList.remove(0);
            }
            request.setGoals(goalsList);
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            this.log.info((CharSequence)message);
            try {
                InvocationResult result = invoker.execute((InvocationRequest)request);
                if (result.getExitCode() != 0) {
                    if (!this.buildReloadTask.isCancelled()) {
                        this.log.info((CharSequence)("Auto-build failed with exit code: " + result.getExitCode()));
                        WebDriverFactory.updateTitle("Build failed", this.project, this.start.getDriver(), this.log);
                    }
                } else {
                    this.log.info((CharSequence)("Auto-build successful for " + this.project.getName()));
                    this.cleanPending.set(false);
                    this.sourceUpdatedPending.clear();
                    this.reload(rebootRequired);
                    this.cleanPending.set(false);
                    this.sourceUpdatedPending.clear();
                }
            }
            catch (MavenInvocationException ex) {
                this.log.error((CharSequence)"Error invoking Maven", (Throwable)ex);
            }
            catch (Throwable ex) {
                this.log.error((CharSequence)"Error invoking Maven", ex);
            }
        });
    }

    public abstract void reload(boolean var1);

    public void deleteBuildDir(String filePath) {
        try {
            Path fileToDelete = Paths.get(filePath, new String[0]);
            Files.walkFileTree(fileToDelete, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new DeleteFileVisitor());
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Error occurred while deleting the file: ", (Throwable)e);
        }
    }

    class DeleteFileVisitor
    extends SimpleFileVisitor<Path> {
        DeleteFileVisitor() {
        }

        private boolean hasJarExtension(Path file) {
            return file.getFileName().toString().toLowerCase().endsWith(".jar");
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                if (this.hasJarExtension(path)) {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        AutoDeployHandler.this.log.error((CharSequence)"Error occurred while deleting the file: ", (Throwable)e);
                    }
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            try {
                Files.delete(file);
            }
            catch (NoSuchFileException e) {
                AutoDeployHandler.this.log.debug((CharSequence)"Error occurred while deleting the file: ", (Throwable)e);
            }
            catch (IOException e) {
                AutoDeployHandler.this.log.error((CharSequence)"Error occurred while deleting the file: ", (Throwable)e);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            try {
                Files.delete(dir);
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
            }
            catch (IOException e) {
                AutoDeployHandler.this.log.error((CharSequence)"Error occurred while deleting the directory: ", (Throwable)e);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

