/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class PropertiesUtils {
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String FILE_PATH = TEMP_DIR + File.separator + "payara-maven-config.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(String key, String value) {
        Properties prop = new Properties();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(FILE_PATH);
            prop.setProperty(key, value);
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String key, String defaultValue) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        Properties prop = new Properties();
        InputStream input = null;
        String value = null;
        try {
            File file = new File(FILE_PATH);
            if (!file.exists()) {
                PropertiesUtils.saveProperties(key, key);
            }
            input = new FileInputStream(FILE_PATH);
            prop.load(input);
            value = prop.getProperty(key);
            if (value == null) {
                value = defaultValue;
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }
}

