/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins;

import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.safari.SafariDriver;

public class WebDriverFactory {
    public static WebDriver createWebDriver(String browser, Log log) {
        SafariDriver driver = null;
        if (browser == null) {
            browser = WebDriverFactory.getDefaultBrowser(log);
        }
        switch (browser.toLowerCase()) {
            case "chrome": {
                ChromeOptions options = new ChromeOptions();
                options.addArguments(new String[]{"--enable-notifications"});
                WebDriverManager.chromedriver().setup();
                driver = new ChromeDriver(options);
                break;
            }
            case "firefox": {
                FirefoxOptions options = new FirefoxOptions();
                WebDriverManager.firefoxdriver().setup();
                driver = new FirefoxDriver(options);
                break;
            }
            case "edge": {
                WebDriverManager.edgedriver().setup();
                driver = new EdgeDriver();
                break;
            }
            case "ie": {
                InternetExplorerOptions options = new InternetExplorerOptions();
                WebDriverManager.iedriver().setup();
                driver = new InternetExplorerDriver(options);
                break;
            }
            case "safari": {
                driver = new SafariDriver();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported browser: " + browser);
            }
        }
        return driver;
    }

    public static String getDefaultBrowser(Log log) {
        if (WebDriverFactory.isChromeBrowserInstalled()) {
            log.debug((CharSequence)"Chrome browser found");
            return "chrome";
        }
        if (WebDriverFactory.isFirefoxBrowserInstalled()) {
            log.debug((CharSequence)"Firefox browser found");
            return "firefox";
        }
        String os = System.getProperty("os.name").toLowerCase();
        boolean isWindows = os.contains("win");
        boolean isMac = os.contains("mac");
        String defaultBrowser = isWindows ? "edge" : (isMac ? "safari" : "firefox");
        log.debug((CharSequence)("Setting default browser: " + defaultBrowser));
        return defaultBrowser;
    }

    public static boolean isFirefoxBrowserInstalled() {
        String[] searchPaths;
        String os = System.getProperty("os.name").toLowerCase();
        boolean isWindows = os.contains("win");
        boolean isMac = os.contains("mac");
        if (isWindows) {
            String programFiles = System.getenv("ProgramFiles");
            String firefoxPath = programFiles + "\\Mozilla Firefox\\firefox.exe";
            return new File(firefoxPath).exists();
        }
        if (isMac) {
            String macFirefoxPath = "/Applications/Firefox.app/Contents/MacOS/firefox";
            return new File(macFirefoxPath).exists();
        }
        for (String path : searchPaths = new String[]{"/usr/bin/firefox", "/usr/bin/firefox-esr", "/usr/bin/firefox-bin"}) {
            if (!new File(path).exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean isChromeBrowserInstalled() {
        String[] searchPaths;
        String os = System.getProperty("os.name").toLowerCase();
        boolean isWindows = os.contains("win");
        boolean isMac = os.contains("mac");
        if (isWindows) {
            String programFiles = System.getenv("ProgramFiles");
            String chromePath = programFiles + "\\Google\\Chrome\\Application\\chrome.exe";
            return new File(chromePath).exists();
        }
        if (isMac) {
            String macChromePath = "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome";
            return new File(macChromePath).exists();
        }
        for (String path : searchPaths = new String[]{"/usr/bin/google-chrome", "/usr/bin/chromium", "/usr/bin/chromium-browser"}) {
            if (!new File(path).exists()) continue;
            return true;
        }
        return false;
    }

    public static void executeScript(String script, WebDriver driver, Log log) {
        if (driver != null && driver instanceof JavascriptExecutor) {
            try {
                ((JavascriptExecutor)driver).executeScript(script, new Object[0]);
            }
            catch (WebDriverException ex) {
                log.debug((Throwable)ex);
            }
        }
    }

    public static void updateTitle(String state, MavenProject project, WebDriver driver, Log log) {
        WebDriverFactory.executeScript(String.format("document.title = '%s %s';", state, project.getName()), driver, log);
    }

    public static String getCurrentTitle(WebDriver driver) {
        if (driver != null && driver instanceof JavascriptExecutor) {
            return (String)((JavascriptExecutor)driver).executeScript("return document.title;", new Object[0]);
        }
        return null;
    }
}

