/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import fish.payara.maven.plugins.micro.BasePayaraMojo;
import fish.payara.maven.plugins.micro.processor.ArtifactDeployProcessor;
import fish.payara.maven.plugins.micro.processor.BaseProcessor;
import fish.payara.maven.plugins.micro.processor.BootCommandFileCopyProcessor;
import fish.payara.maven.plugins.micro.processor.CustomFileCopyProcessor;
import fish.payara.maven.plugins.micro.processor.CustomJarCopyProcessor;
import fish.payara.maven.plugins.micro.processor.DefinedArtifactDeployProcessor;
import fish.payara.maven.plugins.micro.processor.MicroJarBundleProcessor;
import fish.payara.maven.plugins.micro.processor.MicroUnpackProcessor;
import fish.payara.maven.plugins.micro.processor.StartClassReplaceProcessor;
import fish.payara.maven.plugins.micro.processor.SystemPropAppendProcessor;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="bundle", defaultPhase=LifecyclePhase.INSTALL)
public class BundleMojo
extends BasePayaraMojo {
    @Parameter(property="payaraVersion", defaultValue="5.182")
    private String payaraVersion;
    @Parameter
    private List<ArtifactItem> customJars;
    @Parameter
    private List<ArtifactItem> deployArtifacts;
    @Parameter(property="autoDeployArtifact", defaultValue="true")
    private Boolean autoDeployArtifact;
    @Parameter(property="startClass")
    private String startClass;
    @Parameter(property="autoDeployEmptyContextRoot", defaultValue="true")
    private Boolean autoDeployEmptyContextRoot;
    @Parameter(property="autoDeployContextRoot", defaultValue="")
    private String autoDeployContextRoot;
    @Parameter(property="appendSystemProperties", defaultValue="true")
    private Boolean appendSystemProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"Bundle mojo execution is skipped");
            return;
        }
        MojoExecutor.ExecutionEnvironment environment = this.getEnvironment();
        BaseProcessor processor = this.constructProcessorChain();
        processor.handle(environment);
    }

    private BaseProcessor constructProcessorChain() throws MojoExecutionException {
        MicroUnpackProcessor microUnpackProcessor = new MicroUnpackProcessor();
        CustomJarCopyProcessor customJarCopyProcessor = new CustomJarCopyProcessor();
        CustomFileCopyProcessor customFileCopyProcessor = new CustomFileCopyProcessor();
        BootCommandFileCopyProcessor bootCommandFileCopyProcessor = new BootCommandFileCopyProcessor();
        DefinedArtifactDeployProcessor definedArtifactDeployProcessor = new DefinedArtifactDeployProcessor();
        ArtifactDeployProcessor artifactDeployProcessor = new ArtifactDeployProcessor();
        StartClassReplaceProcessor startClassReplaceProcessor = new StartClassReplaceProcessor();
        SystemPropAppendProcessor systemPropAppendProcessor = new SystemPropAppendProcessor();
        MicroJarBundleProcessor microJarBundleProcessor = new MicroJarBundleProcessor();
        microUnpackProcessor.set(this.payaraVersion).next(customJarCopyProcessor);
        customJarCopyProcessor.set(this.customJars).next(customFileCopyProcessor);
        customFileCopyProcessor.next(bootCommandFileCopyProcessor);
        bootCommandFileCopyProcessor.next(definedArtifactDeployProcessor);
        definedArtifactDeployProcessor.set(this.deployArtifacts).next(artifactDeployProcessor);
        artifactDeployProcessor.set(this.autoDeployArtifact, this.autoDeployContextRoot, this.autoDeployEmptyContextRoot, this.mavenProject.getPackaging()).next(startClassReplaceProcessor);
        startClassReplaceProcessor.set(this.startClass).next(systemPropAppendProcessor);
        systemPropAppendProcessor.set(this.appendSystemProperties).next(microJarBundleProcessor);
        return microUnpackProcessor;
    }
}

