/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import fish.payara.maven.plugins.micro.BasePayaraMojo;
import fish.payara.maven.plugins.micro.Option;
import fish.payara.maven.plugins.micro.processor.MicroFetchProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="start")
public class StartMojo
extends BasePayaraMojo {
    String ERROR_MESSAGE = "Errors occurred while executing payara-micro.";
    @Parameter(property="javaPath", defaultValue="java")
    private String javaPath;
    @Parameter(property="payaraVersion", defaultValue="5.182")
    private String payaraVersion;
    @Parameter(property="payaraMicroAbsolutePath")
    private String payaraMicroAbsolutePath;
    @Parameter(property="daemon", defaultValue="false")
    private Boolean daemon;
    @Parameter(property="immediateExit", defaultValue="false")
    private Boolean immediateExit;
    @Parameter(property="artifactItem")
    private ArtifactItem artifactItem;
    @Parameter(property="useUberJar", defaultValue="false")
    private Boolean useUberJar;
    @Parameter(property="deployWar", defaultValue="false")
    private Boolean deployWar;
    @Parameter(property="copySystemProperties", defaultValue="false")
    private Boolean copySystemProperties;
    @Parameter(property="commandLineOptions")
    private List<Option> commandLineOptions;
    @Parameter(property="javaCommandLineOptions")
    private List<Option> javaCommandLineOptions;
    private Process microProcess;
    private Thread microProcessorThread;
    private ThreadGroup threadGroup = new ThreadGroup("PayaraMicroThread");

    StartMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"Start mojo execution is skipped");
            return;
        }
        final String path = this.decideOnWhichMicroToUse();
        this.microProcessorThread = new Thread(this.threadGroup, new Runnable(){

            @Override
            public void run() {
                String execArgs;
                ArrayList<String> systemProps = new ArrayList<String>();
                if (StartMojo.this.copySystemProperties.booleanValue()) {
                    for (String property : StartMojo.this.mavenSession.getSystemProperties().stringPropertyNames()) {
                        String value = System.getProperty(property);
                        if (value == null) continue;
                        String prop = String.format("%s=%s", property, value);
                        systemProps.add(prop);
                    }
                }
                ArrayList<String> actualArgs = new ArrayList<String>();
                StartMojo.this.getLog().info((CharSequence)("Starting payara-micro from path: " + path));
                int indice = 0;
                actualArgs.add(indice++, StartMojo.this.javaPath);
                if (StartMojo.this.javaCommandLineOptions != null) {
                    for (Object option : StartMojo.this.javaCommandLineOptions) {
                        if (((Option)option).getKey() != null && ((Option)option).getValue() != null) {
                            String systemProperty = String.format("%s=%s", ((Option)option).getKey(), ((Option)option).getValue());
                            actualArgs.add(indice++, systemProperty);
                            continue;
                        }
                        if (((Option)option).getValue() == null) continue;
                        actualArgs.add(indice++, ((Option)option).getValue());
                    }
                }
                if ((execArgs = StartMojo.this.mavenSession.getRequest().getUserProperties().getProperty("exec.args")) != null && !execArgs.trim().isEmpty()) {
                    for (String execArg : execArgs.split("\\s+")) {
                        actualArgs.add(indice++, execArg);
                    }
                }
                actualArgs.add(indice++, "-Dgav=" + StartMojo.this.getProjectGAV());
                actualArgs.add(indice++, "-jar");
                actualArgs.add(indice++, path);
                if (StartMojo.this.deployWar.booleanValue() && "war".equalsIgnoreCase(StartMojo.this.mavenProject.getPackaging())) {
                    actualArgs.add(indice++, "--deploy");
                    actualArgs.add(indice++, StartMojo.this.evaluateProjectArtifactAbsolutePath(false));
                }
                if (StartMojo.this.commandLineOptions != null) {
                    for (Option option : StartMojo.this.commandLineOptions) {
                        if (option.getKey() != null) {
                            actualArgs.add(indice++, option.getKey());
                        }
                        if (option.getValue() == null) continue;
                        actualArgs.add(indice++, option.getValue());
                    }
                }
                try {
                    Runtime re = Runtime.getRuntime();
                    StartMojo.this.microProcess = re.exec(actualArgs.toArray(new String[actualArgs.size()]), systemProps.isEmpty() ? null : systemProps.toArray(new String[systemProps.size()]));
                    if (StartMojo.this.daemon.booleanValue()) {
                        StartMojo.this.redirectStream(StartMojo.this.microProcess.getInputStream(), System.out);
                        StartMojo.this.redirectStream(StartMojo.this.microProcess.getErrorStream(), System.err);
                    } else {
                        StartMojo.this.redirectStreamToGivenOutputStream(StartMojo.this.microProcess.getInputStream(), System.out);
                        StartMojo.this.redirectStreamToGivenOutputStream(StartMojo.this.microProcess.getErrorStream(), System.err);
                    }
                    int exitCode = StartMojo.this.microProcess.waitFor();
                    if (exitCode != 0) {
                        throw new MojoFailureException(StartMojo.this.ERROR_MESSAGE);
                    }
                }
                catch (InterruptedException re) {
                }
                catch (Exception e) {
                    throw new RuntimeException(StartMojo.this.ERROR_MESSAGE, e);
                }
                finally {
                    if (!StartMojo.this.daemon.booleanValue()) {
                        StartMojo.this.closeMicroProcess();
                    }
                }
            }
        });
        Thread shutdownHook = new Thread(this.threadGroup, new Runnable(){

            @Override
            public void run() {
                if (StartMojo.this.microProcess != null && StartMojo.this.microProcess.isAlive()) {
                    try {
                        StartMojo.this.microProcess.destroy();
                        StartMojo.this.microProcess.waitFor(1L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        StartMojo.this.microProcess.destroyForcibly();
                    }
                }
            }
        });
        if (this.daemon.booleanValue()) {
            this.microProcessorThread.setDaemon(true);
            this.microProcessorThread.start();
            if (!this.immediateExit.booleanValue()) {
                try {
                    this.microProcessorThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            this.microProcessorThread.run();
        }
    }

    private String decideOnWhichMicroToUse() throws MojoExecutionException {
        if (this.useUberJar.booleanValue()) {
            String path = this.evaluateProjectArtifactAbsolutePath(true);
            if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                throw new MojoExecutionException("\"useUberJar\" option was set to \"true\" but detected path " + path + " does not exist. You need to execute the \"bundle\" goal before using this option.");
            }
            return path;
        }
        if (this.payaraMicroAbsolutePath != null) {
            return this.payaraMicroAbsolutePath;
        }
        if (this.payaraVersion != null) {
            MojoExecutor.ExecutionEnvironment environment = this.getEnvironment();
            MicroFetchProcessor microFetchProcessor = new MicroFetchProcessor();
            microFetchProcessor.set(this.payaraVersion).handle(environment);
            DefaultArtifact artifact = new DefaultArtifact("fish.payara.extras", "payara-micro", this.payaraVersion, null, "jar", null, (ArtifactHandler)new DefaultArtifactHandler("jar"));
            return this.findLocalPathOfArtifact(artifact);
        }
        if (this.artifactItem.getGroupId() != null) {
            DefaultArtifact artifact = new DefaultArtifact(this.artifactItem.getGroupId(), this.artifactItem.getArtifactId(), this.artifactItem.getVersion(), null, this.artifactItem.getType(), this.artifactItem.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler("jar"));
            return this.findLocalPathOfArtifact(artifact);
        }
        throw new MojoExecutionException("Could not determine Payara Micro path. Please set it by defining either \"useUberJar\", \"payaraMicroAbsolutePath\" or \"artifactItem\" configuration options.");
    }

    private String findLocalPathOfArtifact(DefaultArtifact artifact) {
        Artifact payaraMicroArtifact = this.mavenSession.getLocalRepository().find((Artifact)artifact);
        return payaraMicroArtifact.getFile().getAbsolutePath();
    }

    private String evaluateProjectArtifactAbsolutePath(Boolean withExtension) {
        String projectJarAbsolutePath = this.mavenProject.getBuild().getDirectory() + "/";
        projectJarAbsolutePath = projectJarAbsolutePath + this.evaluateExecutorName(withExtension);
        return projectJarAbsolutePath;
    }

    private String evaluateExecutorName(Boolean withExtension) {
        String extension = withExtension != false ? "-microbundle.jar" : "." + this.mavenProject.getPackaging();
        if (StringUtils.isNotEmpty((String)this.mavenProject.getBuild().getFinalName())) {
            return this.mavenProject.getBuild().getFinalName() + extension;
        }
        return this.mavenProject.getArtifact().getArtifactId() + this.mavenProject.getVersion() + extension;
    }

    private void closeMicroProcess() {
        if (this.microProcess != null) {
            try {
                this.microProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                this.microProcess.destroy();
                this.getLog().info((CharSequence)"Terminated payara-micro.");
            }
        }
    }

    private void redirectStream(final InputStream inputStream, final PrintStream printStream) {
        Thread thread = new Thread(this.threadGroup, new Runnable(){

            @Override
            public void run() {
                StringBuilder sb = new StringBuilder();
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                        printStream.println(line);
                        if (StartMojo.this.immediateExit.booleanValue() || !sb.toString().contains("ready in")) continue;
                        StartMojo.this.microProcessorThread.interrupt();
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setDaemon(false);
        thread.start();
    }

    private void redirectStreamToGivenOutputStream(final InputStream inputStream, final OutputStream outputStream) {
        Thread thread = new Thread(this.threadGroup, new Runnable(){

            @Override
            public void run() {
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                catch (IOException e) {
                    StartMojo.this.getLog().error((CharSequence)"Error occurred while reading stream", (Throwable)e);
                }
            }
        });
        thread.setDaemon(false);
        thread.start();
    }
}

