/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro.processor;

import fish.payara.maven.plugins.micro.processor.BaseProcessor;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class ArtifactDeployProcessor
extends BaseProcessor {
    private Boolean autoDeployArtifact;
    private String autoDeployContextRoot;
    private Boolean autoDeployEmptyContextRoot;
    private String packaging;

    @Override
    public void handle(MojoExecutor.ExecutionEnvironment environment) throws MojoExecutionException {
        Build build = environment.getMavenProject().getBuild();
        String finalName = build != null ? (build.getFinalName() != null ? (!build.getFinalName().isEmpty() ? build.getFinalName() : null) : null) : null;
        String contextRoot = this.autoDeployContextRoot;
        if (contextRoot == null || contextRoot.isEmpty()) {
            contextRoot = this.autoDeployEmptyContextRoot != false ? "ROOT" : finalName;
        }
        if (this.autoDeployArtifact.booleanValue() && "war".equalsIgnoreCase(this.packaging)) {
            ArrayList<MojoExecutor.Element> elements = new ArrayList<MojoExecutor.Element>();
            elements.add(MojoExecutor.element((String)"groupId", (String)"${project.groupId}"));
            elements.add(MojoExecutor.element((String)"artifactId", (String)"${project.artifactId}"));
            elements.add(MojoExecutor.element((String)"version", (String)"${project.version}"));
            elements.add(MojoExecutor.element((String)"type", (String)"${project.packaging}"));
            if (contextRoot != null) {
                elements.add(MojoExecutor.element((String)"destFileName", (String)(contextRoot + "." + "war")));
            }
            MojoExecutor.executeMojo((Plugin)this.dependencyPlugin, (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItem"), (MojoExecutor.Element[])elements.toArray(new MojoExecutor.Element[0]))}), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(OUTPUT_FOLDER + MICROINF_DEPLOY_FOLDER))}), (MojoExecutor.ExecutionEnvironment)environment);
            File copiedFile = new File(OUTPUT_FOLDER + MICROINF_DEPLOY_FOLDER + environment.getMavenProject().getArtifact().getFile().getName());
            if (copiedFile.exists()) {
                copiedFile.setLastModified(System.currentTimeMillis());
            }
        }
        this.gotoNext(environment);
    }

    public BaseProcessor set(Boolean autoDeployArtifact, String autoDeployContextRoot, Boolean autoDeployEmptyContextRoot, String packaging) {
        this.autoDeployArtifact = autoDeployArtifact;
        this.autoDeployContextRoot = autoDeployContextRoot;
        this.autoDeployEmptyContextRoot = autoDeployEmptyContextRoot;
        this.packaging = packaging;
        return this;
    }
}

