/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import fish.payara.maven.plugins.micro.BasePayaraMojo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.toolchain.Toolchain;

@Mojo(name="stop")
public class StopMojo
extends BasePayaraMojo {
    private static final String ERROR_MESSAGE = "Error occurred while terminating payara-micro";
    @Parameter(property="artifactItem")
    private ArtifactItem artifactItem;
    @Parameter(property="processId")
    private String processId;
    @Parameter(property="useUberJar", defaultValue="false")
    private Boolean useUberJar;
    private Toolchain toolchain;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"Stop mojo execution is skipped");
            return;
        }
        this.toolchain = this.getToolchain();
        Runtime re = Runtime.getRuntime();
        if (this.processId != null) {
            this.killProcess(this.processId);
            try {
                this.waitForProcessToStop(this.processId, re);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)ERROR_MESSAGE, (Throwable)e);
            }
        }
        String executorName = this.artifactItem.getGroupId() != null ? this.artifactItem.getArtifactId() : (this.useUberJar != false ? this.evaluateExecutorName(true) : "-Dgav=" + this.getProjectGAV());
        try {
            String pid = this.getProcessIdToKill(executorName, re);
            if (StringUtils.isNotEmpty((String)pid)) {
                this.killProcess(pid);
                this.waitForProcessToStop(pid, re);
            } else {
                this.getLog().warn((CharSequence)"Could not find process of running payara-micro?");
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)ERROR_MESSAGE, (Throwable)e);
        }
    }

    private String getProcessIdToKill(String executorName, Runtime re) throws IOException {
        String lineWithPid = this.getLineFromJpsOutput(re, line -> line.contains(executorName));
        if (lineWithPid != null) {
            String[] split = lineWithPid.split(" ");
            String pid = split[0];
            return pid;
        }
        return null;
    }

    private boolean isProcessRunning(String pid, Runtime re) throws IOException {
        String lineWithPid = this.getLineFromJpsOutput(re, line -> {
            String[] split = line.split(" ");
            return split[0].equals(pid);
        });
        return lineWithPid != null;
    }

    private String getLineFromJpsOutput(Runtime re, Predicate<String> linePredicate) throws IOException {
        String jpsPath = "jps";
        if (this.toolchain != null) {
            jpsPath = this.toolchain.findTool("jps");
        }
        Process jpsProcess = re.exec(jpsPath + " -v");
        InputStream inputStream = jpsProcess.getInputStream();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = in.readLine()) != null) {
                if (!linePredicate.test(line)) continue;
                String string = line;
                return string;
            }
            String string = null;
            return string;
        }
    }

    private void waitForProcessToStop(String processId, Runtime re) throws RuntimeException, IOException {
        boolean processRunning;
        long startedWaitingAtMillis = System.currentTimeMillis();
        do {
            if (!(processRunning = this.isProcessRunning(processId, re))) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        } while (processRunning && System.currentTimeMillis() < startedWaitingAtMillis + 5000L);
        if (processRunning) {
            this.getLog().warn((CharSequence)("Could not stop previously started payara-micro with process ID " + processId + " or waiting too long, proceeding further"));
        }
    }

    private void killProcess(String processId) throws MojoExecutionException {
        String command = null;
        try {
            Runtime re = Runtime.getRuntime();
            if (this.isUnix()) {
                command = "kill " + processId;
            } else if (this.isWindows()) {
                command = "taskkill /PID " + processId + " /F";
            }
            if (command == null) {
                throw new MojoExecutionException("Operation system not supported!");
            }
            Process killProcess = re.exec(command);
            int result = killProcess.waitFor();
            if (result != 0) {
                this.getLog().error((CharSequence)ERROR_MESSAGE);
            }
        }
        catch (IOException | InterruptedException e) {
            this.getLog().error((CharSequence)ERROR_MESSAGE, (Throwable)e);
        }
    }

    private String evaluateExecutorName(Boolean withExtension) {
        String extension = withExtension != false ? "-microbundle.jar" : "." + this.mavenProject.getPackaging();
        if (StringUtils.isNotEmpty((String)this.mavenProject.getBuild().getFinalName())) {
            return this.mavenProject.getBuild().getFinalName() + extension;
        }
        return this.mavenProject.getArtifact().getArtifactId() + this.mavenProject.getVersion() + extension;
    }

    private boolean isUnix() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Linux") || osName.startsWith("FreeBSD") || osName.startsWith("OpenBSD") || osName.startsWith("gnu") || osName.startsWith("gnu/kfreebsd") || osName.startsWith("netbsd") || osName.startsWith("Mac OS");
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Windows CE") || osName.startsWith("Windows");
    }
}

