/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro.processor;

import com.google.common.io.Files;
import fish.payara.maven.plugins.micro.processor.BaseProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class ArtifactDeployProcessor
extends BaseProcessor {
    private static final String CONTEXT_ROOT = "ROOT";
    private Boolean autoDeployArtifact;
    private String autoDeployContextRoot;
    private Boolean autoDeployEmptyContextRoot;
    private String packaging;
    private Log log;

    public ArtifactDeployProcessor(Log log) {
        this.log = log;
    }

    @Override
    public void handle(MojoExecutor.ExecutionEnvironment environment) throws MojoExecutionException {
        String finalName = environment.getMavenProject().getBuild().getFinalName();
        if (this.autoDeployArtifact.booleanValue() && "war".equalsIgnoreCase(this.packaging)) {
            boolean contextRootSetButEmpty;
            String contextRoot = this.autoDeployContextRoot;
            boolean contextRootSet = contextRoot != null;
            boolean bl = contextRootSetButEmpty = contextRootSet && contextRoot.isEmpty();
            if (!contextRootSet || contextRootSetButEmpty) {
                contextRoot = this.autoDeployEmptyContextRoot != false || contextRootSetButEmpty || finalName.isEmpty() ? CONTEXT_ROOT : finalName;
            }
            String projectArtifactName = contextRoot + "." + "war";
            File artifactFile = environment.getMavenProject().getArtifact().getFile();
            if (artifactFile == null) {
                artifactFile = this.getArtifactFromConfig(environment);
            }
            if (artifactFile.exists()) {
                this.deployFile(artifactFile, projectArtifactName, environment);
            } else {
                this.deployMainArtifactFromLocalRepo(projectArtifactName, environment);
            }
            if (projectArtifactName != null) {
                String copiedFileName = OUTPUT_FOLDER + MICROINF_DEPLOY_FOLDER + File.separator + projectArtifactName;
                File copiedFile = new File(copiedFileName = ArtifactDeployProcessor.replaceBuildDirectory(copiedFileName, environment));
                if (copiedFile.exists()) {
                    copiedFile.setLastModified(System.currentTimeMillis());
                    this.log.info((CharSequence)("Updated timestamp of deployment file [" + copiedFile.getAbsolutePath() + "]"));
                } else {
                    this.log.warn((CharSequence)("Deployment file [" + copiedFile.getAbsolutePath() + "] doesn't exist, won't update its timestamp"));
                }
            }
        }
        this.gotoNext(environment);
    }

    private static String replaceBuildDirectory(String copiedFileName, MojoExecutor.ExecutionEnvironment environment) {
        return copiedFileName.replace("${project.build.directory}", environment.getMavenProject().getBuild().getDirectory());
    }

    private void deployMainArtifactFromLocalRepo(String projectArtifactName, MojoExecutor.ExecutionEnvironment environment) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> elements = new ArrayList<MojoExecutor.Element>();
        elements.add(MojoExecutor.element((String)"groupId", (String)"${project.groupId}"));
        elements.add(MojoExecutor.element((String)"artifactId", (String)"${project.artifactId}"));
        elements.add(MojoExecutor.element((String)"version", (String)"${project.version}"));
        elements.add(MojoExecutor.element((String)"type", (String)"${project.packaging}"));
        elements.add(MojoExecutor.element((String)"destFileName", (String)projectArtifactName));
        MojoExecutor.executeMojo((Plugin)this.dependencyPlugin, (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItem"), (MojoExecutor.Element[])elements.toArray(new MojoExecutor.Element[0]))}), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(OUTPUT_FOLDER + MICROINF_DEPLOY_FOLDER))}), (MojoExecutor.ExecutionEnvironment)environment);
    }

    public BaseProcessor set(Boolean autoDeployArtifact, String autoDeployContextRoot, Boolean autoDeployEmptyContextRoot, String packaging) {
        this.autoDeployArtifact = autoDeployArtifact;
        this.autoDeployContextRoot = autoDeployContextRoot;
        this.autoDeployEmptyContextRoot = autoDeployEmptyContextRoot;
        this.packaging = packaging;
        return this;
    }

    private File getArtifactFromConfig(MojoExecutor.ExecutionEnvironment environment) {
        Build build = environment.getMavenProject().getModel().getBuild();
        String artifactType = environment.getMavenProject().getArtifact().getType();
        return new File(build.getDirectory(), build.getFinalName() + "." + artifactType);
    }

    private void deployFile(File artifactFile, String projectArtifactName, MojoExecutor.ExecutionEnvironment environment) {
        try {
            File targetFile = new File(ArtifactDeployProcessor.replaceBuildDirectory(OUTPUT_FOLDER + MICROINF_DEPLOY_FOLDER, environment), projectArtifactName);
            this.log.info((CharSequence)("Copying application file [" + artifactFile.getAbsolutePath() + "] to [" + targetFile + "]"));
            Files.copy((File)artifactFile, (File)targetFile);
        }
        catch (IOException ex) {
            this.log.debug((CharSequence)("Cannot copy artifact file [" + artifactFile.getAbsolutePath() + "] into the bundle: " + ex.getMessage()), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

