/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro.processor;

import fish.payara.maven.plugins.micro.processor.BaseProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class BaseSystemPropProcessor
extends BaseProcessor {
    private static final boolean APPEND = true;
    private static final String PAYARA_BOOT_PROP_FILE = "payara-boot.properties";
    private MavenProject mavenProject;

    protected void addSystemPropertiesForPayaraMicro(Properties properties, String comment, MojoExecutor.ExecutionEnvironment environment) throws MojoExecutionException {
        Properties existingProperties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(this.mavenProject.getBuild().getDirectory() + EXTRACTED_PAYARAMICRO_FOLDER + MICROINF_FOLDER + File.separator + PAYARA_BOOT_PROP_FILE);){
            existingProperties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MojoExecutor.executeMojo((Plugin)this.plainTextPlugin, (String)MojoExecutor.goal((String)"write"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(OUTPUT_FOLDER + MICROINF_FOLDER)), MojoExecutor.element((String)MojoExecutor.name((String)"files"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"file"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"name"), (String)PAYARA_BOOT_PROP_FILE), MojoExecutor.element((String)MojoExecutor.name((String)"append"), (String)String.valueOf(true)), MojoExecutor.element((String)MojoExecutor.name((String)"lines"), (MojoExecutor.Element[])this.constructElementsForProperties(properties, existingProperties, comment))})})}), (MojoExecutor.ExecutionEnvironment)environment);
    }

    private MojoExecutor.Element[] constructElementsForProperties(Properties properties, Properties existingProperties, String comment) {
        ArrayList<MojoExecutor.Element> elements = new ArrayList<MojoExecutor.Element>();
        String commentLine = "\n# " + (comment != null ? comment : "Additional properties");
        MojoExecutor.Element emptyLine = MojoExecutor.element((String)MojoExecutor.name((String)"line"), (String)commentLine);
        elements.add(emptyLine);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            MojoExecutor.Element element = MojoExecutor.element((String)MojoExecutor.name((String)"line"), (String)((existingProperties.containsKey(entry.getKey()) ? "#" : "") + StringEscapeUtils.escapeJava((String)(entry.getKey() + "=" + entry.getValue()))));
            elements.add(element);
        }
        return elements.toArray(new MojoExecutor.Element[elements.size()]);
    }

    public BaseSystemPropProcessor set(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        return this;
    }
}

