/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import fish.payara.maven.plugins.micro.BasePayaraMojo;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="reload")
public class ReloadMojo
extends BasePayaraMojo {
    private static final String RELOAD_FILE = ".reload";

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Reload mojo execution is skipped");
            return;
        }
        Build build = this.mavenProject.getBuild();
        String finalName = StringUtils.isNotEmpty((String)build.getFinalName()) ? build.getFinalName() : this.mavenProject.getArtifact().getArtifactId() + '-' + this.mavenProject.getVersion();
        String explodedDirPath = build.getDirectory() + File.separator + finalName;
        File explodedDir = new File(explodedDirPath);
        if (!explodedDir.exists()) {
            throw new MojoExecutionException(String.format("explodedDir[%s] not found", explodedDirPath));
        }
        File reloadFile = new File(explodedDir, RELOAD_FILE);
        if (reloadFile.exists()) {
            reloadFile.setLastModified(System.currentTimeMillis());
        } else {
            try {
                reloadFile.createNewFile();
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Unable to create .reload file " + ex.toString());
            }
        }
    }
}

